/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.designer.datasource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.entity.DesignEntityMeta;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.businessfield.AbstractBasedataField;
import kd.bos.metadata.entity.businessfield.AmountField;
import kd.bos.metadata.entity.businessfield.AssistantField;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.BasedataPropField;
import kd.bos.metadata.entity.businessfield.BillTypeField;
import kd.bos.metadata.entity.businessfield.CreaterField;
import kd.bos.metadata.entity.businessfield.CurrencyField;
import kd.bos.metadata.entity.businessfield.ItemClassField;
import kd.bos.metadata.entity.businessfield.ItemClassTypeField;
import kd.bos.metadata.entity.businessfield.MasterIdField;
import kd.bos.metadata.entity.businessfield.MaterielField;
import kd.bos.metadata.entity.businessfield.ModifierField;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.businessfield.OrgField;
import kd.bos.metadata.entity.businessfield.PeriodField;
import kd.bos.metadata.entity.businessfield.PriceField;
import kd.bos.metadata.entity.businessfield.UserField;
import kd.bos.metadata.entity.commonfield.AdminDivisionField;
import kd.bos.metadata.entity.commonfield.DateField;
import kd.bos.metadata.entity.commonfield.DateRangeField;
import kd.bos.metadata.entity.commonfield.DateTimeField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.PictureField;
import kd.bos.metadata.entity.commonfield.RadioField;
import kd.bos.metadata.entity.commonfield.TimeField;
import kd.bos.metadata.entity.commonfield.TimeRangeField;
import kd.bos.print.business.designer.datasource.BaseDsBuilder;
import kd.bos.print.business.designer.datasource.FieldType;

public abstract class FormDsBuilder
extends BaseDsBuilder {
    protected List<Class<? extends Field<?>>> showFields;
    protected static final Set<Class<?>> NO_SUPPORT_FIELDS = new HashSet();
    protected boolean isCheckDBField = true;
    protected MetadataReader metadataReader = new MetadataReader();
    private static final String PROJECT_NAME = "bos-print-business";
    private String numberKey = "number";
    private String numberAlias = ResManager.loadKDString((String)"\u7f16\u7801", (String)"FormDsBuilder_0", (String)"bos-print-business", (Object[])new Object[0]);
    private String nameKey = "name";
    private String nameAlias = ResManager.loadKDString((String)"\u540d\u79f0", (String)"FormDsBuilder_1", (String)"bos-print-business", (Object[])new Object[0]);

    public FormDsBuilder setShowFields(List<Class<? extends Field<?>>> showFields) {
        this.showFields = showFields;
        return this;
    }

    public FormDsBuilder setCheckDBField(boolean checkDBField) {
        this.isCheckDBField = checkDBField;
        return this;
    }

    private boolean isShowField(EntityItem<?> element, AbstractBasedataField basedataField) {
        if (basedataField instanceof MaterielField && element instanceof MasterIdField) {
            return true;
        }
        return this.isShowField(element);
    }

    protected boolean isShowField(EntityItem<?> element) {
        if (this.showFields != null && !this.showFields.isEmpty() && this.showFields.stream().noneMatch(clazz -> clazz.equals(element.getClass()))) {
            return false;
        }
        return !(element instanceof MasterIdField) && !(element instanceof RadioField) && !(element instanceof BasedataPropField);
    }

    protected boolean isSupportInPrint(EntityItem<?> field) {
        return !NO_SUPPORT_FIELDS.contains(field.getClass());
    }

    protected Map<String, Object> createFieldNode(String key, String name, EntityItem<?> field) {
        return this.createFieldNode(key, name, null, field);
    }

    protected Map<String, Object> createFieldNode(String key, String name, String viewName, EntityItem<?> field) {
        HashMap<String, Object> node = new HashMap<String, Object>();
        node.put("Key", key);
        node.put("Type", FormDsBuilder.getControlType(field));
        node.put("Name", name);
        if (StringUtils.isNotBlank((CharSequence)viewName)) {
            node.put("ViewName", viewName);
        }
        node.put("IsField", Boolean.TRUE);
        FormDsBuilder.setAttr(node, field);
        return node;
    }

    protected Map<String, Object> createContainNode(AbstractBasedataField basedataField, List<Object> itemsList) {
        String key = basedataField.getKey();
        String name = basedataField.getName().toString();
        Map<String, Object> node = this.createContainNode(key, name, itemsList);
        if (basedataField instanceof CreaterField) {
            node.put("Icon", "chuangjianren");
        } else if (basedataField instanceof ModifierField) {
            node.put("Icon", "xiugairen");
        } else if (basedataField instanceof MaterielField) {
            node.put("Icon", "wuliao");
        }
        return node;
    }

    protected Map<String, Object> basedataEntityNode(AbstractBasedataField basedataField, String headKey, String headName, int treeHeight) {
        Map<String, Object> eleNode = null;
        String baseEntityId = basedataField.getBaseEntityId();
        if (basedataField instanceof ItemClassField) {
            ArrayList<Object> itemsList = new ArrayList<Object>();
            itemsList.add(this.createFieldNode(this.numberKey, this.numberAlias, headName + "." + this.numberAlias, (EntityItem<?>)basedataField));
            itemsList.add(this.createFieldNode(this.nameKey, this.nameAlias, headName + "." + this.nameAlias, (EntityItem<?>)basedataField));
            eleNode = this.createContainNode(basedataField.getKey(), basedataField.getName().toString(), itemsList);
            return eleNode;
        }
        if (StringUtils.isNotBlank((CharSequence)baseEntityId) && StringUtils.isNotBlank((CharSequence)basedataField.getFieldName())) {
            EntityMetadata baseMetadata = (EntityMetadata)this.localCache.get(baseEntityId);
            if (baseMetadata == null) {
                baseMetadata = (EntityMetadata)this.metadataReader.readMeta(baseEntityId, OrmUtils.getDataEntityType(DesignEntityMeta.class), true);
                this.localCache.put(baseEntityId, (Object)baseMetadata);
            }
            String number = baseMetadata.getKey();
            boolean isControlShowfield = this.showFields != null && !this.showFields.isEmpty();
            ArrayList<Object> itemsList = new ArrayList<Object>();
            if (treeHeight >= 3 || basedataField instanceof UserField || basedataField instanceof BillTypeField || basedataField instanceof AssistantField) {
                if (!isControlShowfield) {
                    BasedataEntityType dt = (BasedataEntityType)EntityMetadataCache.getSubDataEntityType((String)number, (Collection)basedataField.getRuntimeRefProps());
                    String nameProperty = dt.getNameProperty();
                    String numberProperty = dt.getNumberProperty();
                    for (EntityItem element : baseMetadata.getItems()) {
                        if (!element.getKey().equals(nameProperty) && !element.getKey().equals(numberProperty)) continue;
                        String nodeName = element.getName().toString();
                        itemsList.add(this.createFieldNode(element.getKey(), nodeName, headName + "." + nodeName, (EntityItem<?>)basedataField));
                    }
                }
            } else if (basedataField instanceof OrgField) {
                if (!isControlShowfield) {
                    BasedataEntityType dt = (BasedataEntityType)EntityMetadataCache.getSubDataEntityType((String)number, (Collection)basedataField.getRuntimeRefProps());
                    Map allFields = dt.getAllFields();
                    Set properties = allFields.keySet();
                    for (EntityItem element : baseMetadata.getItems()) {
                        if (!properties.contains(element.getKey())) continue;
                        if (element instanceof BasedataField) {
                            ArrayList<Object> eleList = new ArrayList<Object>();
                            BasedataEntityType subEType = (BasedataEntityType)EntityMetadataCache.getSubDataEntityType((String)number, (Collection)basedataField.getRuntimeRefProps());
                            String nameProperty = subEType.getNameProperty();
                            String numberProperty = subEType.getNumberProperty();
                            for (EntityItem item : baseMetadata.getItems()) {
                                if (!item.getKey().equals(nameProperty) && !item.getKey().equals(numberProperty)) continue;
                                String nodeName = element.getName().toString();
                                eleList.add(this.createFieldNode(item.getKey(), nodeName, headName + "." + nodeName, item));
                            }
                            itemsList.add(this.createContainNode(element.getKey(), element.getName().toString(), eleList));
                            continue;
                        }
                        String nodeName = element.getName().toString();
                        itemsList.add(this.createFieldNode(element.getKey(), nodeName, headName + "." + nodeName, element));
                    }
                }
            } else {
                for (EntityItem element : baseMetadata.getRootEntity().getItems()) {
                    Map<String, Object> node;
                    if (element instanceof DateRangeField) {
                        String newname;
                        String newKey;
                        DateRangeField dateRange = (DateRangeField)element;
                        if (StringUtils.isNotBlank((CharSequence)dateRange.getStartDateFieldName())) {
                            newKey = headKey + "." + dateRange.getStartDateFieldKey();
                            newname = String.format(ResManager.loadKDString((String)"%s-\u5f00\u59cb", (String)"FormDsBuilder_2", (String)PROJECT_NAME, (Object[])new Object[0]), element.getName() + headName);
                            itemsList.add(this.createFieldNode(newKey, newname, element));
                        }
                        if (StringUtils.isNotBlank((CharSequence)dateRange.getEndDateFieldName())) {
                            newKey = headKey + "." + dateRange.getEndDateFieldKey();
                            newname = String.format(ResManager.loadKDString((String)"%s-\u7ed3\u675f", (String)"FormDsBuilder_3", (String)PROJECT_NAME, (Object[])new Object[0]), element.getName() + headName);
                            itemsList.add(this.createFieldNode(newKey, newname, element));
                        }
                    }
                    if (!(element instanceof MulBasedataField) && element instanceof Field && StringUtils.isBlank((CharSequence)((Field)element).getFieldName()) || !this.isShowField(element, basedataField) || element instanceof AssistantField || element instanceof ItemClassTypeField || element instanceof ItemClassField || element instanceof EntryEntity) continue;
                    boolean isLoadMateriel = false;
                    isLoadMateriel = basedataField instanceof BasedataField && ((BasedataField)basedataField).isBizBasedata() && element instanceof MasterIdField;
                    String nodeName = headName + "." + element.getName();
                    if (isLoadMateriel) {
                        node = this.basedataEntityNode((AbstractBasedataField)element, element.getKey(), nodeName, treeHeight);
                        if (node == null) continue;
                        itemsList.add(node);
                        continue;
                    }
                    if (element instanceof BasedataField) {
                        node = this.basedataEntityNode((AbstractBasedataField)((BasedataField)element), element.getKey(), nodeName, treeHeight + 1);
                        if (node == null) continue;
                        itemsList.add(node);
                        continue;
                    }
                    if (!(element instanceof Field)) continue;
                    itemsList.add(this.createFieldNode(element.getKey(), nodeName, nodeName, element));
                }
            }
            eleNode = this.createContainNode(basedataField, itemsList);
            return eleNode;
        }
        return null;
    }

    private static String getControlType(EntityItem<?> element) {
        if (element instanceof PictureField) {
            return FieldType.Image.getCode();
        }
        return FieldType.Text.getCode();
    }

    private static Map setAttr(Map<String, Object> node, EntityItem<?> element) {
        PriceField priceField;
        Field controlField;
        HashMap<String, String> intiAttr = new HashMap<String, String>();
        FieldType fieldType = FormDsBuilder.getFieldType(element);
        String textFormat = fieldType.getCode();
        if (fieldType == FieldType.Image) {
            textFormat = FieldType.Text.getCode();
        }
        intiAttr.put("TextFormat", textFormat);
        if (element instanceof AmountField) {
            AmountField amountField = (AmountField)element;
            Field controlField2 = amountField.getControlField();
            if (controlField2 instanceof CurrencyField) {
                intiAttr.put("CurrencyCode", "FROM_CURRENCY");
            }
        } else if (element instanceof PriceField && (controlField = (priceField = (PriceField)element).getControlField()) instanceof CurrencyField) {
            intiAttr.put("CurrencyCode", "FROM_CURRENCY");
        }
        node.put("Icon", fieldType.getIcon());
        node.put("InitAttr", intiAttr);
        return intiAttr;
    }

    private static FieldType getFieldType(EntityItem<?> element) {
        if (element instanceof DateField || element instanceof DateRangeField || element instanceof DateTimeField) {
            return FieldType.Date;
        }
        if (element instanceof TimeField || element instanceof TimeRangeField) {
            return FieldType.Time;
        }
        if (element instanceof AmountField || element instanceof PriceField) {
            return FieldType.Amount;
        }
        if (element instanceof DecimalField) {
            return FieldType.Number;
        }
        if (element instanceof PictureField) {
            return FieldType.Image;
        }
        return FieldType.Text;
    }

    static {
        NO_SUPPORT_FIELDS.add(PeriodField.class);
        NO_SUPPORT_FIELDS.add(AdminDivisionField.class);
    }
}

