/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.designer.datasource;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.entity.SubEntryEntity;
import kd.bos.metadata.entity.businessfield.AbstractBasedataField;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.BasedataPropField;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.commonfield.DateRangeField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.LargeTextField;
import kd.bos.print.business.designer.datasource.DsType;
import kd.bos.print.business.designer.datasource.FormDsBuilder;
import kd.bos.print.business.designer.datasource.PrintDataSourceUtil;
import kd.bos.print.business.designer.datasource.simple.EntryDsBuilder;

public class MainDsBuilder
extends FormDsBuilder {
    private static final String PROJECT_NAME = "bos-print-business";
    private EntityMetadata entityMetadata;
    private String tagName;
    private String tagColor;

    @Override
    public void init() {
        List entitys = this.entityMetadata.getEntitys();
        for (Entity entity : entitys) {
            if (!(entity instanceof MainEntity)) continue;
            this.entity = entity;
            break;
        }
        this.key = this.entity.getKey();
        this.name = this.entity.getName().toString();
        if (this.dsType == DsType.Ref) {
            this.tagName = ResManager.loadKDString((String)"\u5173\u8054", (String)"PrintDataSourceUtil_1", (String)PROJECT_NAME, (Object[])new Object[0]);
            this.tagColor = "#16B0F1";
        } else {
            this.dsType = DsType.Main;
            this.tagName = ResManager.loadKDString((String)"\u4e3b\u8868", (String)"PrintDataSourceUtil_0", (String)PROJECT_NAME, (Object[])new Object[0]);
            this.tagColor = "#FF991C";
        }
    }

    public MainDsBuilder setDsType(DsType dsType) {
        this.dsType = dsType;
        return this;
    }

    @Override
    public Map<String, Object> build() {
        this.init();
        HashMap<String, Object> mainDs = new HashMap<String, Object>();
        mainDs.put("Key", this.key);
        mainDs.put("Name", this.name);
        mainDs.put("IsDs", Boolean.TRUE);
        mainDs.put("DsType", (Object)this.dsType);
        mainDs.put("Icon", "zhushujuyuan");
        HashMap<String, String> tag = new HashMap<String, String>();
        if (this.dsType == DsType.Ref) {
            mainDs.put("IsDataGridDs", Boolean.TRUE);
        }
        tag.put("Name", this.tagName);
        tag.put("Color", this.tagColor);
        mainDs.put("Tag", tag);
        List mainItems = this.buildItems();
        mainDs.put("Items", mainItems);
        List entitys = this.entityMetadata.getEntitys();
        ArrayList<Map<String, Object>> entryNodes = new ArrayList<Map<String, Object>>(entitys.size());
        for (Entity entity : entitys) {
            if (entity instanceof SubEntryEntity) {
                EntryDsBuilder entryDsBuilder = new EntryDsBuilder();
                entryDsBuilder.setEntityNum(this.entityNum);
                entryDsBuilder.setEntityType((EntityType)this.mainEntityType.getAllEntities().get(entity.getKey()));
                entryNodes.add(entryDsBuilder.build());
                continue;
            }
            if (!(entity instanceof EntryEntity)) continue;
            DsType dsType = DsType.Entry;
            FormDsBuilder builder = (FormDsBuilder)PrintDataSourceUtil.getBuilder(dsType);
            builder.setEntityId(this.entityId);
            builder.setEntityNum(this.entityNum);
            builder.setCheckDBField(this.isCheckDBField);
            Map<String, Object> node = builder.setEntity(entity).build();
            entryNodes.add(node);
        }
        mainItems.addAll(0, entryNodes);
        return mainDs;
    }

    @Override
    public List buildItems() {
        ArrayList<Map<String, Object>> nodes = new ArrayList<Map<String, Object>>();
        for (EntityItem element : this.entity.getItems()) {
            String newKey;
            if (element instanceof EntryEntity) continue;
            if (element instanceof BasedataField) {
                Map<String, Object> basedataNode;
                if (StringUtils.isEmpty((CharSequence)((BasedataField)element).getFieldName()) || (basedataNode = this.basedataEntityNode((AbstractBasedataField)((BasedataField)element), element.getKey(), element.getName().toString(), 2)) == null) continue;
                nodes.add(basedataNode);
                continue;
            }
            if (!(element instanceof Field) || !this.isShowField(element)) continue;
            if (element instanceof BasedataPropField) {
                BasedataPropField basdataProp = (BasedataPropField)element;
                newKey = basdataProp.getControlField().getKey() + "." + basdataProp.getRefDisplayProp();
                nodes.add(this.createFieldNode(newKey, basdataProp.getName().getLocaleValue(), element));
                continue;
            }
            if (element instanceof MulBasedataField) {
                nodes.add(this.createFieldNode(element.getKey(), element.getName().toString(), element));
                continue;
            }
            if (element instanceof LargeTextField) {
                nodes.add(this.createFieldNode(element.getKey(), String.format(ResManager.loadKDString((String)"%s-\u6807\u9898", (String)"MainDsBuilder_1", (String)PROJECT_NAME, (Object[])new Object[0]), element.getName().toString()), element));
                nodes.add(this.createFieldNode(element.getKey() + "_tag", String.format(ResManager.loadKDString((String)"%s-\u5185\u5bb9", (String)"MainDsBuilder_2", (String)PROJECT_NAME, (Object[])new Object[0]), element.getName().toString()), element));
                continue;
            }
            if (element instanceof DateRangeField) {
                String newname;
                DateRangeField dateRange = (DateRangeField)element;
                if (StringUtils.isNotBlank((CharSequence)dateRange.getStartDateFieldName())) {
                    newKey = dateRange.getStartDateFieldKey();
                    newname = String.format(ResManager.loadKDString((String)"%s-\u5f00\u59cb", (String)"MainDsBuilder_3", (String)PROJECT_NAME, (Object[])new Object[0]), element.getName());
                    nodes.add(this.createFieldNode(newKey, newname, element));
                }
                if (!StringUtils.isNotBlank((CharSequence)dateRange.getEndDateFieldName())) continue;
                newKey = dateRange.getEndDateFieldKey();
                newname = String.format(ResManager.loadKDString((String)"%s-\u7ed3\u675f", (String)"MainDsBuilder_4", (String)PROJECT_NAME, (Object[])new Object[0]), element.getName());
                nodes.add(this.createFieldNode(newKey, newname, element));
                continue;
            }
            if (this.isCheckDBField && StringUtils.isEmpty((CharSequence)((Field)element).getFieldName())) continue;
            nodes.add(this.createFieldNode(element.getKey(), element.getName().toString(), element));
        }
        return nodes;
    }

    public EntityMetadata getEntityMetadata() {
        return this.entityMetadata;
    }

    public MainDsBuilder setEntityMetadata(EntityMetadata entityMetadata) {
        this.entityMetadata = entityMetadata;
        return this;
    }
}

