/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.designer.datasource;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.entity.DesignEntityMeta;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.print.api.utils.SerializeUtils;
import kd.bos.print.business.designer.datasource.AttachDsBuilder;
import kd.bos.print.business.designer.datasource.BaseDsBuilder;
import kd.bos.print.business.designer.datasource.CustomDsBuilder;
import kd.bos.print.business.designer.datasource.DataSourceInfo;
import kd.bos.print.business.designer.datasource.DsType;
import kd.bos.print.business.designer.datasource.EntryDsBuilder;
import kd.bos.print.business.designer.datasource.IDsBuilder;
import kd.bos.print.business.designer.datasource.MainDsBuilder;
import kd.bos.print.business.designer.datasource.SystemDsBuilder;
import kd.bos.print.business.designer.datasource.WorkflowDsBuilder;
import kd.bos.print.business.designer.datasource.simple.ReportDsBuilder;
import kd.bos.svc.acl.AclAdapter;

public class PrintDataSourceUtil {
    private static Map<String, IDsBuilder> builderCache = new HashMap<String, IDsBuilder>(16);
    private static final String PROJECT_NAME = "bos-print-business";
    private static final DistributeSessionlessCache cache = AclAdapter.getCacheService().getDistributeSessionlessCache("CachePrtRegion");
    private static final String dsVer = "1.0.09";
    private static final Log log = LogFactory.getLog(PrintDataSourceUtil.class);

    public static IDsBuilder getBuilder(DsType dsType) {
        String dsKey = dsType.toString();
        IDsBuilder builder = builderCache.get(dsKey);
        if (builder != null) {
            return builder;
        }
        if (dsType == DsType.Sys) {
            builderCache.put(dsKey, new SystemDsBuilder());
        } else if (dsType == DsType.Attach) {
            builderCache.put(dsKey, new AttachDsBuilder());
        } else if (dsType == DsType.Report) {
            builderCache.put(dsKey, new ReportDsBuilder());
        } else if (dsType == DsType.Head) {
            builderCache.put(dsKey, new MainDsBuilder());
        } else if (dsType == DsType.Entry) {
            builderCache.put(dsKey, new EntryDsBuilder(dsType));
        } else if (dsType == DsType.Subentry) {
            builderCache.put(dsKey, new EntryDsBuilder(dsType));
        } else if (dsType == DsType.Approveline || dsType == DsType.Approveactivity) {
            builderCache.put(dsKey, new WorkflowDsBuilder());
        } else if (dsType == DsType.Custom) {
            builderCache.put(dsKey, new CustomDsBuilder());
        } else {
            throw new KDBizException("unknow datasource");
        }
        return builderCache.get(dsKey);
    }

    public static DataSourceInfo buildDataSource(String entityId) {
        String formId = MetadataDao.getNumberById((String)entityId);
        if (StringUtils.isBlank((CharSequence)formId)) {
            String msg = ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u7248\u7ed1\u5b9a\u7684\u6570\u636e\u6e90\u4e0d\u5b58\u5728\u3002", (String)"PrintDataSourceUtil_3", (String)PROJECT_NAME, (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
        String cacheKey = formId + "_ds";
        String runtimeMetaVersion = EntityMetadataCache.getRuntimeMetadataVersion((String)formId);
        runtimeMetaVersion = runtimeMetaVersion.replaceAll("(\\.|-|:|\\s+)", "");
        ArrayList<Map<String, Object>> dataSources = null;
        DataSourceInfo dsInfo = PrintDataSourceUtil.getDatasourceFormCache(cacheKey, runtimeMetaVersion);
        if (dsInfo != null) {
            dataSources = dsInfo.getDataSource();
        } else {
            dataSources = new ArrayList<Map<String, Object>>();
            MetadataReader reader = new MetadataReader(false);
            EntityMetadata entityMetadata = (EntityMetadata)reader.readMeta(entityId, OrmUtils.getDataEntityType(DesignEntityMeta.class), true);
            String modelType = entityMetadata.getModelType();
            BaseDsBuilder sysBuilder = (BaseDsBuilder)PrintDataSourceUtil.getBuilder(DsType.Sys);
            dataSources.add(sysBuilder.build());
            if (!"ReportFormModel".equals(modelType)) {
                MainDsBuilder builder = (MainDsBuilder)PrintDataSourceUtil.getBuilder(DsType.Head);
                builder.setEntityId(entityId).setEntityNum(formId);
                if ("DynamicFormModel".equals(modelType)) {
                    builder.setEntityMetadata(entityMetadata).setDsType(DsType.Main).setCheckDBField(false);
                    dataSources.add(builder.build());
                } else if ("BaseFormModel".equals(modelType) || "BillFormModel".equals(modelType)) {
                    builder.setEntityMetadata(entityMetadata).setDsType(DsType.Main);
                    dataSources.add(builder.build());
                }
            }
            dsInfo = new DataSourceInfo(entityId, formId, modelType, dataSources, runtimeMetaVersion, dsVer);
            PrintDataSourceUtil.cacheDatasource(cacheKey, dsInfo);
        }
        if ("BaseFormModel".equals(dsInfo.getModelType()) || "BillFormModel".equals(dsInfo.getModelType())) {
            List items;
            BaseDsBuilder builder;
            Map<String, Object> workflowTree;
            boolean existWorkflow = WorkflowDsBuilder.existWorkflow(formId);
            dsInfo.setContainWf(existWorkflow);
            if (existWorkflow && (workflowTree = (builder = (BaseDsBuilder)PrintDataSourceUtil.getBuilder(DsType.Approveline)).setEntityId(entityId).setEntityNum(formId).build()) != null && !(items = (List)workflowTree.get("Items")).isEmpty()) {
                List mainItems = (List)((Map)dataSources.get(1)).get("Items");
                mainItems.add(0, workflowTree);
            }
        }
        dsInfo.setDataSource(dataSources);
        return dsInfo;
    }

    public static List buildMainDataSource(String entityId) {
        DataSourceInfo dataSourceInfo = PrintDataSourceUtil.buildDataSource(entityId);
        return dataSourceInfo.getDataSource();
    }

    public static List buildCustomDataSource(List<Map> customParams) {
        ArrayList<Map<String, Object>> customDsList = new ArrayList<Map<String, Object>>(10);
        CustomDsBuilder customDsBuilder = (CustomDsBuilder)PrintDataSourceUtil.getBuilder(DsType.Custom);
        for (Map item : customParams) {
            customDsList.add(customDsBuilder.build(item));
        }
        return customDsList;
    }

    public static List buildRefDataSource(String entityId) {
        String formId = MetadataDao.getNumberById((String)entityId);
        if (StringUtils.isBlank((CharSequence)formId)) {
            throw new KDBizException(new ErrorCode("3", "datasource is not found."), new Object[0]);
        }
        String cacheKey = formId + "_refds";
        String runtimeMetaVersion = EntityMetadataCache.getRuntimeMetadataVersion((String)formId);
        DataSourceInfo dsInfo = PrintDataSourceUtil.getDatasourceFormCache(cacheKey, runtimeMetaVersion = runtimeMetaVersion.replaceAll("(\\.|-|:|\\s+)", ""));
        if (dsInfo != null) {
            return dsInfo.getDataSource();
        }
        ArrayList<Map<String, Object>> dataSources = new ArrayList<Map<String, Object>>(10);
        MetadataReader reader = new MetadataReader(false);
        EntityMetadata entityMetadata = (EntityMetadata)reader.readMeta(entityId, OrmUtils.getDataEntityType(DesignEntityMeta.class), true);
        if ("BaseFormModel".equals(entityMetadata.getModelType()) || "BillFormModel".equals(entityMetadata.getModelType())) {
            MainDsBuilder builder = (MainDsBuilder)PrintDataSourceUtil.getBuilder(DsType.Head);
            builder.setEntityId(entityId).setEntityNum(formId);
            builder.setEntityMetadata(entityMetadata).setDsType(DsType.Ref);
            dataSources.add(builder.build());
            dsInfo = new DataSourceInfo(entityId, formId, entityMetadata.getModelType(), dataSources, runtimeMetaVersion, dsVer);
            PrintDataSourceUtil.cacheDatasource(cacheKey, dsInfo);
        }
        return dataSources;
    }

    private static void cacheDatasource(String cacheKey, DataSourceInfo dataSources) {
        cache.put("PrtDsGroup", cacheKey, SerializeUtils.toJsonString((Object)dataSources), 432000);
    }

    private static DataSourceInfo getDatasourceFormCache(String key, String nowVersion) {
        String ds = (String)cache.get("PrtDsGroup", key);
        if (ds == null) {
            return null;
        }
        DataSourceInfo dsInfo = (DataSourceInfo)SerializeUtils.fromJsonString((String)ds, DataSourceInfo.class);
        String version = dsInfo.getVersion();
        if (!StringUtils.equals((CharSequence)nowVersion, (CharSequence)version)) {
            cache.remove("PrtDsGroup", key);
            return null;
        }
        if (!StringUtils.equals((CharSequence)dsInfo.getDsVer(), (CharSequence)dsVer)) {
            cache.remove("PrtDsGroup", key);
            return null;
        }
        return dsInfo;
    }
}

