/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.designer.datasource;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.entity.DesignEntityMeta;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.api.facade.IPrtDataSourceFacade;
import kd.bos.print.api.facade.PrtFacadeFactory;
import kd.bos.print.api.utils.ConfigConstUtil;
import kd.bos.print.business.designer.datasource.AttachDsBuilder;
import kd.bos.print.business.designer.datasource.DataSourceInfo;
import kd.bos.print.business.designer.datasource.DsType;
import kd.bos.print.business.designer.datasource.PrintDataSourceUtil;
import kd.bos.print.business.designer.datasource.SystemDsBuilder;
import kd.bos.print.business.designer.datasource.WorkflowDsBuilder;
import kd.bos.print.business.designer.datasource.simple.BillDsBuilder;
import kd.bos.print.business.designer.datasource.simple.QueryDsBuilder;
import kd.bos.print.business.designer.datasource.simple.ReportDsBuilder;

public class PrtDataSourceUtil {
    protected static final String PROJECT_NAME = "bos-print-business";
    private static final Log log = LogFactory.getLog(PrtDataSourceUtil.class);

    public static DataSourceInfo buildDataSource(String entityId) {
        String numberById = MetadataDao.getNumberById((String)entityId);
        if (StringUtils.isBlank((CharSequence)numberById)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u7248\u7ed1\u5b9a\u7684\u6570\u636e\u6e90\u4e0d\u5b58\u5728\u3002", (String)"PrtDataSourceUtil_0", (String)PROJECT_NAME, (Object[])new Object[0]));
        }
        MainEntityType mainEntityType = PrtDataSourceUtil.getMainEntityType(numberById);
        boolean existWorkflow = false;
        if (mainEntityType instanceof BillEntityType || mainEntityType instanceof BasedataEntityType) {
            String formId = mainEntityType.getName();
            existWorkflow = WorkflowDsBuilder.existWorkflow(formId);
        }
        return PrtDataSourceUtil.buildDataSource(mainEntityType, entityId, existWorkflow);
    }

    public static DataSourceInfo buildDataSource(String entityId, boolean withWorkflow) {
        String numberById = MetadataDao.getNumberById((String)entityId);
        if (StringUtils.isBlank((CharSequence)numberById)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u7248\u7ed1\u5b9a\u7684\u6570\u636e\u6e90\u4e0d\u5b58\u5728\u3002", (String)"PrtDataSourceUtil_0", (String)PROJECT_NAME, (Object[])new Object[0]));
        }
        MainEntityType mainEntityType = PrtDataSourceUtil.getMainEntityType(numberById);
        return PrtDataSourceUtil.buildDataSource(mainEntityType, entityId, withWorkflow);
    }

    private static DataSourceInfo buildDataSource(MainEntityType mainEntityType, String entityId, boolean withWorkflow) {
        ArrayList<Map<String, Object>> dataSources = new ArrayList<Map<String, Object>>();
        SystemDsBuilder sysBuilder = new SystemDsBuilder();
        dataSources.add(sysBuilder.build());
        if (mainEntityType instanceof BillEntityType) {
            Map<String, Object> build = PrtDataSourceUtil.buildFormDataSource(mainEntityType);
            if (build != null) {
                dataSources.add(build);
            }
        } else {
            Map<String, Object> build;
            EntityMetadata entityMetadata = (EntityMetadata)new MetadataReader(false).readMeta(MetadataDao.getIdByNumber((String)mainEntityType.getName(), (MetaCategory)MetaCategory.Entity), OrmUtils.getDataEntityType(DesignEntityMeta.class), true);
            if (entityMetadata != null && "ReportFormModel".equals(entityMetadata.getModelType()) && (build = PrtDataSourceUtil.buildFormDataSource(mainEntityType)) != null) {
                dataSources.add(build);
            }
        }
        String formId = mainEntityType.getName();
        DataSourceInfo dsInfo = new DataSourceInfo(entityId, formId, null, dataSources, "1.0.01", "1.0.01");
        List mainItems = PrtDataSourceUtil.getItems(dataSources, 1);
        PrtDataSourceUtil.buildAttachmentPanelNode(entityId, mainItems, formId);
        if (mainEntityType instanceof BillEntityType || mainEntityType instanceof BasedataEntityType) {
            List items;
            WorkflowDsBuilder builder;
            Map<String, Object> workflowTree;
            dsInfo.setContainWf(withWorkflow);
            if (withWorkflow && (workflowTree = (builder = new WorkflowDsBuilder()).setEntityId(entityId).setEntityNum(formId).build()) != null && !(items = (List)workflowTree.get("Items")).isEmpty()) {
                mainItems.add(0, workflowTree);
            }
        }
        dsInfo.setDataSource(dataSources);
        return dsInfo;
    }

    private static List getItems(List<Map<String, Object>> dataSources, int index) {
        if (CollectionUtils.isEmpty(dataSources) || index >= dataSources.size()) {
            return new ArrayList(0);
        }
        Map<String, Object> map = dataSources.get(index);
        if (CollectionUtils.isEmpty(map)) {
            return new ArrayList(0);
        }
        List mainItems = (List)map.get("Items");
        if (mainItems == null) {
            return new ArrayList(0);
        }
        return mainItems;
    }

    private static void buildAttachmentPanelNode(String entityId, List mainItems, String formId) {
        try {
            List items;
            AttachDsBuilder attachBuilder = new AttachDsBuilder();
            Map<String, Object> attachTree = attachBuilder.setEntityId(entityId).setEntityNum(formId).build();
            if (attachTree != null && (items = (List)attachTree.get("Items")) != null && !items.isEmpty()) {
                mainItems.add(0, attachTree);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    public static List loadRefDs(String entityId) {
        if (ConfigConstUtil.isUseSimpleDs()) {
            return PrtDataSourceUtil.buildRefDataSource(entityId).getDataSource();
        }
        return PrintDataSourceUtil.buildRefDataSource(entityId);
    }

    public static DataSourceInfo buildRefDataSource(String entityId) {
        ArrayList<Map<String, Object>> dataSources = new ArrayList<Map<String, Object>>(1);
        String numberById = MetadataDao.getNumberById((String)entityId);
        if (StringUtils.isBlank((CharSequence)numberById)) {
            throw new KDBizException(new ErrorCode("3", "datasource is not found."), new Object[0]);
        }
        MainEntityType mainEntityType = PrtDataSourceUtil.getMainEntityType(numberById);
        String formId = mainEntityType.getName();
        Map<String, Object> ds = PrtDataSourceUtil.buildFormDataSource(mainEntityType);
        if (ds != null) {
            List dsItems;
            List items;
            WorkflowDsBuilder builder;
            Map<String, Object> workflowTree;
            DsType dsType = DsType.Ref;
            ds.put("Icon", dsType.getIcon());
            ds.put("DsType", (Object)dsType);
            ds.put("IsDataGridDs", Boolean.TRUE);
            HashMap<String, String> tag = new HashMap<String, String>();
            tag.put("Name", ResManager.loadKDString((String)"\u5173\u8054", (String)"PrintDataSourceUtil_1", (String)PROJECT_NAME, (Object[])new Object[0]));
            tag.put("Color", "#16B0F1");
            ds.put("Tag", tag);
            dataSources.add(ds);
            List mainItems = PrtDataSourceUtil.getItems(dataSources, 0);
            PrtDataSourceUtil.buildAttachmentPanelNode(entityId, mainItems, formId);
            if ((mainEntityType instanceof BillEntityType || mainEntityType instanceof BasedataEntityType) && WorkflowDsBuilder.existWorkflow(formId) && (workflowTree = (builder = new WorkflowDsBuilder()).setEntityId(entityId).setEntityNum(formId).build()) != null && !(items = (List)workflowTree.get("Items")).isEmpty() && (dsItems = (List)ds.get("Items")) != null) {
                ((Map)items.get(0)).put("IsDataGridDs", Boolean.FALSE);
                dsItems.add(0, workflowTree);
            }
        }
        DataSourceInfo dsInfo = new DataSourceInfo();
        dsInfo.setDataSource(dataSources);
        return dsInfo;
    }

    private static Map<String, Object> buildFormDataSource(MainEntityType mainEntityType) {
        List prtDataSourceServices = PrtFacadeFactory.getAllPrtDataSourceFacades();
        if (mainEntityType instanceof QueryEntityType) {
            return new QueryDsBuilder().setEntityType((EntityType)mainEntityType).setPrtDataSourceServices(prtDataSourceServices).build();
        }
        if (mainEntityType instanceof BillEntityType) {
            return new BillDsBuilder().setEntityType((EntityType)mainEntityType).setPrtDataSourceServices(prtDataSourceServices).build();
        }
        return new ReportDsBuilder().setEntityType((EntityType)mainEntityType).setPrtDataSourceServices(prtDataSourceServices).setEntityNum(mainEntityType.getName()).build();
    }

    private static MainEntityType getMainEntityType(String numberById) {
        List allPrtDataSourceFacades = PrtFacadeFactory.getAllPrtDataSourceFacades();
        if (allPrtDataSourceFacades != null && !allPrtDataSourceFacades.isEmpty()) {
            return ((IPrtDataSourceFacade)allPrtDataSourceFacades.get(0)).getDataEntityType(numberById);
        }
        return EntityMetadataCache.getDataEntityType((String)numberById);
    }
}

