/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.designer.datasource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.business.designer.datasource.BaseDsBuilder;
import kd.bos.print.business.designer.datasource.DsType;
import kd.bos.print.business.designer.datasource.FieldType;
import kd.bos.service.ServiceFactory;
import kd.bos.workflow.api.IWorkflowService;

public class WorkflowDsBuilder
extends BaseDsBuilder {
    private static Log log = LogFactory.getLog(WorkflowDsBuilder.class);
    private static String SIGN = "signature";

    @Override
    public void init() {
        this.key = "workflow";
        this.name = ResManager.loadKDString((String)"\u5de5\u4f5c\u6d41", (String)"WorkflowDsBuilder_0", (String)"bos-print-business", (Object[])new Object[0]);
        this.dsType = DsType.Workflow;
    }

    public static boolean existWorkflow(String entityNumber) {
        Boolean exist = WorkflowDsBuilder.getWFService().existProcDefByEntityNumber(entityNumber);
        log.debug("\u5de5\u4f5c\u6d41\u6570\u636e\u6e90\u6784\u9020\uff1aentityNumber=%s\uff0cexist=%s", (Object)entityNumber, (Object)exist);
        return exist;
    }

    @Override
    public List buildItems() {
        List<Object> eleNodes;
        ArrayList workflowNodes = new ArrayList();
        List<Object> activityNodes = this.buildActivityNodes(this.entityNum);
        if (!activityNodes.isEmpty()) {
            HashMap<String, Object> activityNode = new HashMap<String, Object>();
            activityNode.put("Key", "activity");
            activityNode.put("Name", ResManager.loadKDString((String)"\u5ba1\u6279\u8282\u70b9", (String)"WorkflowDsBuilder_2", (String)"bos-print-business", (Object[])new Object[0]));
            activityNode.put("DsType", DsType.Approveactivity.getCode());
            activityNode.put("IsDs", true);
            activityNode.put("Items", activityNodes);
            workflowNodes.add(activityNode);
        }
        if (!(eleNodes = this.buildApproveLineNodes()).isEmpty()) {
            HashMap<String, Object> aplNode = new HashMap<String, Object>();
            aplNode.put("Key", "approveline");
            aplNode.put("Name", ResManager.loadKDString((String)"\u5ba1\u6279\u7ebf\u8def", (String)"WorkflowDsBuilder_1", (String)"bos-print-business", (Object[])new Object[0]));
            aplNode.put("DsType", DsType.Approveline.getCode());
            aplNode.put("IsDs", Boolean.TRUE);
            aplNode.put("IsDataGridDs", Boolean.TRUE);
            aplNode.put("Items", eleNodes);
            workflowNodes.add(aplNode);
        }
        return workflowNodes;
    }

    private List<Object> buildApproveLineNodes() {
        ArrayList<Object> eleNodes = new ArrayList<Object>(10);
        IWorkflowService workflowService = WorkflowDsBuilder.getWFService();
        Map approvalRecord = workflowService.getApprovalRecordMeta();
        for (Map.Entry entry : approvalRecord.entrySet()) {
            String fieldKey = (String)entry.getKey();
            if (SIGN.equals(fieldKey)) {
                Map<String, Object> fieldNode = this.createFieldNode((String)entry.getKey(), (String)entry.getValue(), FieldType.Image);
                Map initAttr = fieldNode.getOrDefault("InitAttr", new HashMap(1));
                initAttr.put("TextFormat", FieldType.Text.getCode());
                fieldNode.put("InitAttr", initAttr);
                eleNodes.add(fieldNode);
                continue;
            }
            eleNodes.add(this.createFieldNode((String)entry.getKey(), (String)entry.getValue(), FieldType.Text));
        }
        return eleNodes;
    }

    private List<Object> buildActivityNodes(String entityNumber) {
        IWorkflowService workflowService = WorkflowDsBuilder.getWFService();
        Collection activities = workflowService.getPrintMetaEntityNumber(entityNumber);
        log.debug("\u6253\u5370\u5ba1\u6279\u8282\u70b9\uff1a" + SerializationUtils.toJsonString((Object)activities));
        ArrayList<Object> activityNodes = new ArrayList<Object>(10);
        for (Map active : activities) {
            Object bizIdentifyKey = active.get("bizIdentifyKey");
            Object activityName = active.get("activityName");
            Map printMeta = (Map)active.get("printMeta");
            ArrayList<Object> detailNodes = new ArrayList<Object>(10);
            for (Map.Entry entry : printMeta.entrySet()) {
                String fieldKey = (String)entry.getKey();
                if (SIGN.equals(fieldKey)) {
                    Map<String, Object> fieldNode = this.createFieldNode(fieldKey, entry.getValue() + "", activityName + "." + entry.getValue(), FieldType.Image);
                    Map initAttr = fieldNode.getOrDefault("InitAttr", new HashMap(1));
                    initAttr.put("TextFormat", FieldType.Text.getCode());
                    fieldNode.put("InitAttr", initAttr);
                    detailNodes.add(fieldNode);
                    continue;
                }
                detailNodes.add(this.createFieldNode(fieldKey, entry.getValue() + "", activityName + "." + entry.getValue(), FieldType.Text));
            }
            activityNodes.add(this.createContainNode(bizIdentifyKey.toString(), activityName.toString(), detailNodes));
        }
        return activityNodes;
    }

    private static IWorkflowService getWFService() {
        return (IWorkflowService)ServiceFactory.getService(IWorkflowService.class);
    }
}

