/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.designer.datasource.simple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.print.api.facade.IPrtDataSourceFacade;
import kd.bos.print.api.facade.PrtFacadeFactory;
import kd.bos.print.business.designer.datasource.DsType;
import kd.bos.print.business.designer.datasource.simple.EntryDsBuilder;
import kd.bos.print.business.designer.datasource.simple.SimpleDsBuilder;
import kd.bos.util.CollectionUtils;

public class BillDsBuilder
extends SimpleDsBuilder {
    @Override
    public void init() {
        super.init();
        this.dsType = DsType.Main;
    }

    @Override
    public Map<String, Object> build() {
        this.init();
        Map<String, Object> ds = super.build();
        HashMap<String, String> tag = new HashMap<String, String>();
        this.dsType = DsType.Main;
        tag.put("Name", ResManager.loadKDString((String)"\u4e3b\u8868", (String)"PrintDataSourceUtil_0", (String)"bos-print-business", (Object[])new Object[0]));
        tag.put("Color", "#FF991C");
        ds.put("Tag", tag);
        List items = this.buildItems();
        ds.put("Items", items);
        MainEntityType mainEntityType = (MainEntityType)this.entityType;
        Map allEntities = mainEntityType.getAllEntities();
        ArrayList<Map<String, Object>> entryNodes = new ArrayList<Map<String, Object>>(10);
        EntryDsBuilder builder = new EntryDsBuilder();
        builder.setPrtDataSourceServices(this.prtDataSourceServices);
        Collection values = allEntities.values();
        for (EntityType entityType : values) {
            if (this.getEntityTypePredicate().test(entityType) || entityType instanceof LinkEntryType) continue;
            Map<String, Object> entryNode = builder.setEntityType(entityType).build();
            if (entityType instanceof EntryType && !(entityType instanceof SubEntryType)) {
                List collectionProperties = entityType.getProperties().getCollectionProperties(true);
                for (ICollectionProperty prop : collectionProperties) {
                    if (!(prop instanceof SubEntryProp)) continue;
                    List subEntryList = entryNode.getOrDefault("SubEntryList", new ArrayList());
                    subEntryList.add(mainEntityType.getName() + "." + prop.getName());
                    entryNode.put("SubEntryList", subEntryList);
                }
            }
            entryNodes.add(entryNode);
        }
        items.addAll(0, entryNodes);
        return ds;
    }

    private Predicate<EntityType> getEntityTypePredicate() {
        Predicate entityTypeFilter = null;
        List allPrtDataSourceFacades = PrtFacadeFactory.getAllPrtDataSourceFacades();
        if (!CollectionUtils.isEmpty((Collection)allPrtDataSourceFacades)) {
            entityTypeFilter = ((IPrtDataSourceFacade)allPrtDataSourceFacades.get(0)).entityTypeFilter();
        }
        if (entityTypeFilter == null) {
            entityTypeFilter = entityType -> StringUtils.isBlank((CharSequence)entityType.getAlias()) || !(entityType instanceof EntryType);
        }
        return entityTypeFilter;
    }
}

