/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.designer.datasource.simple;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.list.JoinProperty;
import kd.bos.entity.mulentities.QuerySelectField;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.print.business.designer.datasource.DsType;
import kd.bos.print.business.designer.datasource.simple.SimpleDsBuilder;

public class QueryDsBuilder
extends SimpleDsBuilder {
    @Override
    public void init() {
        super.init();
        this.dsType = DsType.Main;
    }

    @Override
    public Map<String, Object> build() {
        this.init();
        Map<String, Object> ds = super.build();
        HashMap<String, String> tag = new HashMap<String, String>(2);
        this.dsType = DsType.Main;
        tag.put("Name", ResManager.loadKDString((String)"\u4e3b\u8868", (String)"PrintDataSourceUtil_0", (String)"bos-print-business", (Object[])new Object[0]));
        tag.put("Color", "#FF991C");
        ds.put("Tag", tag);
        List items = this.buildItems();
        ds.put("Items", items);
        return ds;
    }

    @Override
    protected List<Object> buildItems(IDataEntityType dataEntityType, String viewPrefix, boolean enableFilter) {
        QueryEntityType queryEntityType = (QueryEntityType)dataEntityType;
        List selectFields = queryEntityType.getSelectFields();
        Map<String, IDataEntityProperty> allHeadField = this.getAllFieldKey("", (IDataEntityType)queryEntityType);
        ArrayList<Object> nodes = new ArrayList<Object>(selectFields.size());
        for (QuerySelectField field : selectFields) {
            String key = field.getAlias();
            IDataEntityProperty property = allHeadField.get(key);
            if (property == null) continue;
            if (property instanceof FlexProp) {
                this.buildFlexNodes(nodes, (FlexProp)property, viewPrefix);
                continue;
            }
            nodes.add(this.createFieldNode(field, property, viewPrefix));
        }
        return nodes;
    }

    private Map<String, IDataEntityProperty> getAllFieldKey(String prefix, IDataEntityType dataEntityType) {
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        HashMap<String, IDataEntityProperty> propMap = new HashMap<String, IDataEntityProperty>(16);
        for (IDataEntityProperty property : properties) {
            if (property instanceof EntryProp || property instanceof JoinProperty) continue;
            if (property instanceof FieldProp || property instanceof FlexProp || property instanceof MulBasedataProp) {
                propMap.put(prefix + property.getName(), property);
                continue;
            }
            if (property instanceof ItemClassProp) {
                ItemClassProp itemClassProp = (ItemClassProp)property;
                IDataEntityType complexType = itemClassProp.getComplexType();
                if (complexType == null) continue;
                RefEntityType refEntityType = (RefEntityType)complexType;
                DynamicProperty numberProp = refEntityType.getProperty(refEntityType.getNumberProperty());
                propMap.put(prefix + numberProp.getName(), (IDataEntityProperty)numberProp);
                DynamicProperty nameProp = refEntityType.getProperty(refEntityType.getNameProperty());
                propMap.put(prefix + nameProp.getName(), (IDataEntityProperty)nameProp);
                continue;
            }
            if (!(property instanceof IComplexProperty)) continue;
            IComplexProperty complexProperty = (IComplexProperty)property;
            String prefixName = "";
            prefixName = kd.bos.util.StringUtils.isBlank((String)prefix) ? complexProperty.getName() + "." : prefix + complexProperty.getName() + ".";
            Map<String, IDataEntityProperty> nodes = this.getAllFieldKey(prefixName, complexProperty.getComplexType());
            propMap.putAll(nodes);
        }
        return propMap;
    }

    private Map<String, Object> createFieldNode(QuerySelectField field, IDataEntityProperty property, String viewPrefix) {
        HashMap<String, Object> node = new HashMap<String, Object>(5);
        node.put("Key", field.getAlias());
        node.put("Type", this.getControlType(property));
        String name = field.getDisplayName();
        node.put("Name", name);
        if (StringUtils.isNotBlank((CharSequence)viewPrefix)) {
            node.put("ViewName", viewPrefix + "." + name);
        }
        node.put("IsField", Boolean.TRUE);
        this.setAttr(node, property);
        return node;
    }
}

