/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.designer.datasource.simple;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.GeoPointProp;
import kd.bos.entity.property.MasterBasedataProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.metadata.AbstractElement;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.entity.DesignEntityMeta;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.FlexField;
import kd.bos.metadata.entity.commonfield.DateRangeField;
import kd.bos.metadata.entity.commonfield.PictureField;
import kd.bos.metadata.entity.commonfield.StepperField;
import kd.bos.metadata.entity.commonfield.TimeRangeField;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.DesignFormMeta;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.metadata.report.ReportFilterAp;
import kd.bos.metadata.report.ReportListAp;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.api.facade.IPrtDataSourceFacade;
import kd.bos.print.business.designer.datasource.DsType;
import kd.bos.print.business.designer.datasource.simple.ReportEntryDsBuilder;
import kd.bos.print.business.designer.datasource.simple.SimpleDsBuilder;

public class ReportDsBuilder
extends SimpleDsBuilder {
    private MainEntityType mainEntityType;

    @Override
    public void init() {
        this.mainEntityType = EntityMetadataCache.getDataEntityType((String)this.entityNum);
        this.key = this.mainEntityType.getName();
        this.name = this.mainEntityType.getDisplayName().toString();
        this.dsType = DsType.Report;
    }

    @Override
    public Map<String, Object> build() {
        Map<String, Object> ds = super.build();
        ds.put("Icon", "zhushujuyuan");
        HashMap<String, String> tag = new HashMap<String, String>(2);
        tag.put("Name", ResManager.loadKDString((String)"\u4e3b\u8868", (String)"PrintDataSourceUtil_0", (String)"bos-print-business", (Object[])new Object[0]));
        tag.put("Color", "#FF991C");
        ds.put("Tag", tag);
        FormMetadata formMetadata = (FormMetadata)new MetadataReader(false).readMeta(MetadataDao.getIdByNumber((String)this.key, (MetaCategory)MetaCategory.Form), OrmUtils.getDataEntityType(DesignFormMeta.class), true);
        EntityMetadata entityMetadata = (EntityMetadata)new MetadataReader(false).readMeta(MetadataDao.getIdByNumber((String)this.key, (MetaCategory)MetaCategory.Entity), OrmUtils.getDataEntityType(DesignEntityMeta.class), true);
        List<ControlAp<?>> filterControls = formMetadata.getItems().stream().filter(f -> f instanceof ReportFilterAp).flatMap(fMap -> ((ReportFilterAp)fMap).getItems().stream()).collect(Collectors.toList());
        List<String> filterKeys = this.findFields(filterControls).stream().map(AbstractElement::getKey).collect(Collectors.toList());
        this.filterFields = !CollectionUtils.isEmpty(filterKeys) ? (Set)this.findFilterKeys(filterKeys, entityMetadata.getItems(), (Predicate<EntityItem>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$build$2(kd.bos.metadata.entity.EntityItem ), (Lkd/bos/metadata/entity/EntityItem;)Z)()).item1 : Collections.emptySet();
        List<ControlAp<?>> entryAps = formMetadata.getItems().stream().filter(f -> f instanceof ReportListAp).flatMap(fMap -> ((ReportListAp)fMap).getItems().stream()).collect(Collectors.toList());
        ArrayList<Map<Object, Object>> items = new ArrayList<Map<Object, Object>>(2);
        List filterItems = this.buildItems();
        if (!CollectionUtils.isEmpty((Collection)filterItems)) {
            HashMap<String, Object> filterItemMap = new HashMap<String, Object>(4);
            filterItemMap.put("Name", ResManager.loadKDString((String)"\u8fc7\u6ee4\u5b57\u6bb5", (String)"PrintDataSourceUtil_4", (String)"bos-print-business", (Object[])new Object[0]));
            filterItemMap.put("Key", "filter");
            filterItemMap.put("Icon", "danjuti");
            filterItemMap.put("Items", filterItems);
            items.add(0, filterItemMap);
        }
        ReportEntryDsBuilder builder = new ReportEntryDsBuilder(entryAps);
        builder.setPrtDataSourceServices(this.prtDataSourceServices);
        List<String> entryKeys = this.findEntryFields(entryAps).stream().map(AbstractElement::getKey).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(entryKeys)) {
            Tuple<Set<String>, Map<String, EntityItem>> tupe = this.findFilterKeys(entryKeys, entityMetadata.getItems());
            builder.filterFields = (Set)tupe.item1;
            builder.setEntityItemMap((Map)tupe.item2);
        } else {
            builder.filterFields = Collections.emptySet();
            builder.setEntityItemMap(Collections.EMPTY_MAP);
        }
        Map<String, Object> entryNode = builder.setEntityType((EntityType)this.mainEntityType).build();
        entryNode.put("Key", "reportEntry");
        entryNode.put("DsType", (Object)DsType.ReportEntry);
        entryNode.put("Name", ResManager.loadKDString((String)"\u62a5\u8868\u5b57\u6bb5", (String)"PrintDataSourceUtil_5", (String)"bos-print-business", (Object[])new Object[0]));
        if (entryNode.get("Items") != null && ((List)entryNode.get("Items")).size() > 0) {
            List entryNodeItems = (List)entryNode.get("Items");
            Map<String, Object> noField = this.createNoFieldNode();
            entryNodeItems.add(0, noField);
            items.add(entryNode);
        }
        ds.put("Items", items);
        return ds;
    }

    private Map<String, Object> createNoFieldNode() {
        HashMap<String, Object> noField = new HashMap<String, Object>(7);
        noField.put("Type", "Text");
        HashMap<String, String> initAttr = new HashMap<String, String>(1);
        initAttr.put("TextFormat", "Number");
        noField.put("InitAttr", initAttr);
        noField.put("SortedAble", Boolean.TRUE);
        noField.put("Icon", "shuzhi2");
        noField.put("Key", "seq");
        noField.put("Name", ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"EntryDsBuilder_0", (String)"bos-print-business", (Object[])new Object[0]));
        noField.put("IsField", Boolean.TRUE);
        return noField;
    }

    private Tuple<Set<String>, Map<String, EntityItem>> findFilterKeys(List<String> filterKeys, List<EntityItem<?>> items) {
        return this.findFilterKeys(filterKeys, items, entityItem -> false);
    }

    private Tuple<Set<String>, Map<String, EntityItem>> findFilterKeys(List<String> filterKeys, List<EntityItem<?>> items, Predicate<EntityItem> controlNoSupport) {
        if (CollectionUtils.isEmpty(filterKeys) || CollectionUtils.isEmpty(items)) {
            return new Tuple((Object)Collections.EMPTY_SET, (Object)Collections.EMPTY_MAP);
        }
        HashSet<String> result = new HashSet<String>(16);
        HashMap entityItemMap = new HashMap(16);
        for (EntityItem<?> entityItem : items) {
            TimeRangeField rangeField;
            if (!filterKeys.contains(entityItem.getKey()) || controlNoSupport.test(entityItem)) continue;
            if (entityItem instanceof TimeRangeField) {
                rangeField = (TimeRangeField)entityItem;
                result.add(rangeField.getStartDateFieldKey() + SimpleDsBuilder.getColonSplit() + rangeField.getStartDateFieldName());
                result.add(rangeField.getEndDateFieldKey() + SimpleDsBuilder.getColonSplit() + rangeField.getEndDateFieldName());
                entityItemMap.put(entityItem.getKey(), entityItem);
                continue;
            }
            if (entityItem instanceof DateRangeField) {
                rangeField = (DateRangeField)entityItem;
                result.add(rangeField.getStartDateFieldKey() + SimpleDsBuilder.getColonSplit() + rangeField.getStartDateFieldName());
                result.add(rangeField.getEndDateFieldKey() + SimpleDsBuilder.getColonSplit() + rangeField.getEndDateFieldName());
                entityItemMap.put(entityItem.getKey(), entityItem);
                continue;
            }
            result.add(entityItem.getKey());
        }
        return new Tuple(result, entityItemMap);
    }

    private List<EntryFieldAp> findEntryFields(List<ControlAp<?>> entryAps) {
        ArrayList<EntryFieldAp> result = new ArrayList<EntryFieldAp>();
        for (ControlAp<?> entryAp : entryAps) {
            if (entryAp instanceof ContainerAp) {
                result.addAll(this.findEntryFields(((ContainerAp)entryAp).getItems()));
                continue;
            }
            if (!(entryAp instanceof EntryFieldAp)) continue;
            result.add((EntryFieldAp)entryAp);
        }
        return result;
    }

    private List<FieldAp> findFields(List<ControlAp<?>> controls) {
        ArrayList<FieldAp> result = new ArrayList<FieldAp>();
        for (ControlAp<?> control : controls) {
            if (control instanceof ContainerAp) {
                List<FieldAp> child = this.findFields(((ContainerAp)control).getItems());
                result.addAll(child);
                continue;
            }
            if (!(control instanceof FieldAp)) continue;
            result.add((FieldAp)control);
        }
        return result;
    }

    @Override
    protected boolean isShowProperty(IDataEntityType dataEntityType, IDataEntityProperty property, String parentKey) {
        String masteridPropName;
        if (property instanceof PKFieldProp || property instanceof AttachmentProp || property instanceof GeoPointProp) {
            return false;
        }
        if (dataEntityType instanceof RefEntityType && StringUtils.equals((CharSequence)(masteridPropName = ((RefEntityType)dataEntityType).getMasteridPropName()), (CharSequence)property.getName()) && !(property instanceof MasterBasedataProp)) {
            return false;
        }
        if (this.prtDataSourceServices != null && !this.prtDataSourceServices.isEmpty()) {
            for (IPrtDataSourceFacade prtDataSourceService : this.prtDataSourceServices) {
                if (prtDataSourceService.isShowFieldNode(dataEntityType, property, parentKey)) continue;
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$build$2(EntityItem entityItem) {
        return entityItem instanceof StepperField || entityItem instanceof FlexField || entityItem instanceof PictureField;
    }
}

