/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.designer.datasource.simple;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.commonfield.DateRangeField;
import kd.bos.metadata.entity.commonfield.TimeRangeField;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.EntryFieldGroupAp;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.business.designer.datasource.DsType;
import kd.bos.print.business.designer.datasource.simple.SimpleDsBuilder;

public class ReportEntryDsBuilder
extends SimpleDsBuilder {
    private List<ControlAp<?>> entryAps;
    private Map<String, EntityItem> entityItemMap;

    public Map<String, EntityItem> getEntityItemMap() {
        if (this.entityItemMap == null) {
            return new HashMap<String, EntityItem>();
        }
        return this.entityItemMap;
    }

    public void setEntityItemMap(Map<String, EntityItem> entityItemMap) {
        this.entityItemMap = entityItemMap;
    }

    ReportEntryDsBuilder(List<ControlAp<?>> entryAps) {
        this.entryAps = entryAps;
    }

    @Override
    public void init() {
        super.init();
        this.dsType = DsType.Entry;
    }

    @Override
    public Map<String, Object> build() {
        Map<String, Object> entryNode = super.build();
        if (this.dsType == DsType.Entry) {
            entryNode.put("IsDataGridDs", Boolean.TRUE);
        } else {
            entryNode.put("IsDataGridDs", Boolean.TRUE);
            entryNode.put("IsSubDataGridDs", Boolean.TRUE);
        }
        if (this.entityType == null || CollectionUtils.isEmpty(this.entryAps)) {
            return entryNode;
        }
        SimpleDsBuilder.DsBuildInfo buildInfo = new SimpleDsBuilder.DsBuildInfo();
        buildInfo.setDataEntityType((IDataEntityType)this.entityType);
        buildInfo.setViewPrefix("");
        buildInfo.setEnableFilter(true);
        buildInfo.setParentKey(this.entityType.getName());
        List<Object> allItems = this.buildReportItems(buildInfo);
        if (!CollectionUtils.isEmpty(allItems)) {
            entryNode.put("Items", allItems);
        }
        return entryNode;
    }

    private List<Object> buildReportItems(SimpleDsBuilder.DsBuildInfo buildInfo) {
        IDataEntityType dataEntityType = buildInfo.getDataEntityType();
        List<IDataEntityProperty> iDataEntityProperties = this.filterProperty(dataEntityType, buildInfo.isEnableFilter());
        Map<String, IDataEntityProperty> allPropMap = iDataEntityProperties.stream().collect(Collectors.toMap(item -> item.getName(), item -> item));
        ArrayList<Object> nodes = new ArrayList<Object>();
        String parentKey = buildInfo.getParentKey();
        String viewPrefix = buildInfo.getViewPrefix();
        this.buildItems(buildInfo, nodes, allPropMap, this.entryAps, parentKey, viewPrefix);
        this.handChildNodes(nodes, 1);
        return nodes;
    }

    private void buildItems(SimpleDsBuilder.DsBuildInfo buildInfo, List<Object> nodes, Map<String, IDataEntityProperty> allPropMap, List<ControlAp<?>> entryAps, String parentKey, String viewPrefix) {
        IDataEntityType dataEntityType = buildInfo.getDataEntityType();
        for (ControlAp<?> controlAp : entryAps) {
            if (controlAp instanceof EntryFieldGroupAp) {
                EntryFieldGroupAp entryFieldGroupAp = (EntryFieldGroupAp)controlAp;
                List items = entryFieldGroupAp.getItems();
                String containName = entryFieldGroupAp.getName() != null ? entryFieldGroupAp.getName().getLocaleValue() : entryFieldGroupAp.getKey();
                String prefixName = StringUtils.isBlank((CharSequence)viewPrefix) ? containName : viewPrefix + "." + containName;
                String containKey = entryFieldGroupAp.getKey();
                ArrayList<Object> childNodes = new ArrayList<Object>(items.size());
                Map<String, Object> containNode = this.createContainNode(containKey, containName, childNodes);
                containNode.put("Type", "ReportEntryGroup");
                this.buildItems(buildInfo, childNodes, allPropMap, items, parentKey, prefixName);
                nodes.add(containNode);
                continue;
            }
            if (!(controlAp instanceof EntryFieldAp)) continue;
            IDataEntityProperty property = allPropMap.get(controlAp.getKey());
            if (property == null) {
                String endKey;
                String startKey;
                TimeRangeField rangeField;
                EntityItem entityItem = this.getEntityItemMap().get(controlAp.getKey());
                if (entityItem == null) continue;
                if (entityItem instanceof TimeRangeField) {
                    rangeField = (TimeRangeField)entityItem;
                    startKey = rangeField.getStartDateFieldKey();
                    endKey = rangeField.getEndDateFieldKey();
                } else {
                    if (!(entityItem instanceof DateRangeField)) continue;
                    rangeField = (DateRangeField)entityItem;
                    startKey = rangeField.getStartDateFieldKey();
                    endKey = rangeField.getEndDateFieldKey();
                }
                property = allPropMap.get(startKey);
                if (property != null) {
                    this.builItemsFromProp(buildInfo, dataEntityType, nodes, property, parentKey, viewPrefix);
                }
                if ((property = allPropMap.get(endKey)) == null) continue;
                this.builItemsFromProp(buildInfo, dataEntityType, nodes, property, parentKey, viewPrefix);
                continue;
            }
            this.builItemsFromProp(buildInfo, dataEntityType, nodes, property, parentKey, viewPrefix);
        }
    }

    private void handChildNodes(List<Object> childNodes, int level) {
        for (int i = 0; i < childNodes.size(); ++i) {
            Object items;
            Object node = childNodes.get(i);
            if (!(node instanceof Map)) continue;
            Map nodeMap = (Map)node;
            if (level == 1 && !"ReportEntryGroup".equals(nodeMap.get("Type")) || !((items = nodeMap.get("Items")) instanceof List)) continue;
            if (level >= 3) {
                List<Map<String, Object>> flatMapList = this.flatMap2List(nodeMap);
                childNodes.remove(i);
                childNodes.addAll(i, flatMapList);
                i += flatMapList.size() - 1;
                continue;
            }
            this.handChildNodes((List)items, level + 1);
        }
    }

    private List<Map<String, Object>> flatMap2List(Map<String, Object> nodeMap) {
        List itemList = (List)nodeMap.get("Items");
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(itemList.size());
        for (Map node : itemList) {
            Object items = node.get("Items");
            if (!"ReportEntryGroup".equals(nodeMap.get("Type"))) {
                node.put("Key", nodeMap.get("Key") + "." + node.get("Key"));
            }
            if (items instanceof List) {
                List<Map<String, Object>> childNodes = this.flatMap2List(node);
                resultList.addAll(childNodes);
                continue;
            }
            resultList.add(node);
        }
        return resultList;
    }
}

