/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.designer.datasource.simple;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.CreaterProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.GeoPointProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.LargeTextProp;
import kd.bos.entity.property.MasterBasedataProp;
import kd.bos.entity.property.MaterielProp;
import kd.bos.entity.property.ModifierProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.property.PictureProp;
import kd.bos.entity.property.PriceProp;
import kd.bos.entity.property.RichTextProp;
import kd.bos.entity.property.SignatureProp;
import kd.bos.entity.property.TextAreaProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.api.facade.IPrtDataSourceFacade;
import kd.bos.print.business.designer.datasource.DsType;
import kd.bos.print.business.designer.datasource.FieldType;
import kd.bos.print.business.designer.datasource.IDsBuilder;

public abstract class SimpleDsBuilder
implements IDsBuilder {
    protected static final String PROJECT_NAME = "bos-print-business";
    private static final String LARGE_TEXT_SUFFIX = "_tag";
    protected String key;
    protected String name;
    protected DsType dsType;
    protected Boolean isDs = Boolean.TRUE;
    protected String entityNum;
    protected EntityType entityType;
    protected List<IPrtDataSourceFacade> prtDataSourceServices;
    private Log log = LogFactory.getLog(SimpleDsBuilder.class);
    protected Set<String> filterFields;
    private Set<String> largeTextTags;
    private static final String COLON_SPLIT = ":";
    private static final String NAME = "name";
    private static final String FULL_NAME = "fullname";
    private static final String NUMBER = "number";
    private static final String LONG_NUMBER = "longnumber";
    private static final String MULBASEDATAFIELD = "mulbasedatafield";
    private static final String KEY_NUMBER_NAME = "number+name";
    private static final String KEY_NAME_NUMBER = "name+number";

    public static String getColonSplit() {
        return COLON_SPLIT;
    }

    public SimpleDsBuilder setEntityNum(String formId) {
        this.entityNum = formId;
        return this;
    }

    public SimpleDsBuilder setEntityType(EntityType entityType) {
        this.entityType = entityType;
        return this;
    }

    public SimpleDsBuilder setPrtDataSourceServices(List<IPrtDataSourceFacade> prtDataSourceServices) {
        this.prtDataSourceServices = prtDataSourceServices;
        return this;
    }

    @Override
    public void init() {
        this.key = this.entityType.getName();
        this.name = this.entityType.getDisplayName().toString();
    }

    @Override
    public Map<String, Object> build() {
        this.init();
        HashMap<String, Object> ds = new HashMap<String, Object>(16);
        ds.put("Key", this.key);
        ds.put("Name", this.name);
        ds.put("Icon", this.dsType.getIcon());
        ds.put("IsDs", this.isDs);
        ds.put("DsType", (Object)this.dsType);
        return ds;
    }

    @Override
    public List buildItems() {
        List<Object> nodes = this.buildItems((IDataEntityType)this.entityType, "", true);
        return nodes;
    }

    protected List<Object> buildItems(IDataEntityType dataEntityType, String viewPrefix) {
        return this.buildItems(dataEntityType, viewPrefix, true);
    }

    protected List<Object> buildItems(IDataEntityType dataEntityType, String viewPrefix, boolean enableFilter) {
        DsBuildInfo buildInfo = new DsBuildInfo();
        buildInfo.setDataEntityType(dataEntityType);
        buildInfo.setViewPrefix(viewPrefix);
        buildInfo.setEnableFilter(enableFilter);
        buildInfo.setParentKey(dataEntityType != null ? dataEntityType.getName() : "");
        return this.buildItems(buildInfo);
    }

    protected List<Object> buildItems(DsBuildInfo buildInfo) {
        IDataEntityType dataEntityType = buildInfo.getDataEntityType();
        String parentKey = buildInfo.getParentKey();
        String viewPrefix = buildInfo.getViewPrefix();
        boolean enableFilter = buildInfo.isEnableFilter();
        ArrayList<Object> nodes = new ArrayList<Object>();
        if (dataEntityType == null) {
            return nodes;
        }
        List<IDataEntityProperty> properties = this.filterProperty(dataEntityType, enableFilter);
        for (IDataEntityProperty property : properties) {
            this.builItemsFromProp(buildInfo, dataEntityType, nodes, property, parentKey, viewPrefix);
        }
        return nodes;
    }

    protected void builItemsFromProp(DsBuildInfo buildInfo, IDataEntityType dataEntityType, List<Object> nodes, IDataEntityProperty property, String parentKey, String viewPrefix) {
        if (!this.isShowProperty(dataEntityType, property, parentKey)) {
            return;
        }
        if (property instanceof MulBasedataProp) {
            if (property instanceof AttachmentProp) {
                Map<String, Object> fieldNode = this.createFieldNode(property, viewPrefix, (IDataEntityType)this.entityType, dataEntityType);
                if (fieldNode != null && !fieldNode.isEmpty()) {
                    nodes.add(fieldNode);
                }
                return;
            }
            MulBasedataProp mulBasedataProp = (MulBasedataProp)property;
            IDataEntityType complexType = mulBasedataProp.getComplexType();
            if (null == complexType) {
                return;
            }
            String containName = this.getContainDisplayName(property, (IDataEntityType)this.entityType);
            String prefixName = "";
            prefixName = StringUtils.isBlank((CharSequence)viewPrefix) ? containName : viewPrefix + "." + containName;
            ArrayList<Object> list = new ArrayList<Object>(16);
            RefEntityType refEntityType = (RefEntityType)complexType;
            this.buildSingleMulProp(prefixName, list, refEntityType, refEntityType.getNumberProperty());
            this.buildSingleMulProp(prefixName, list, refEntityType, refEntityType.getNameProperty());
            this.buildSingleMulProp(prefixName, list, refEntityType, LONG_NUMBER);
            this.buildSingleMulProp(prefixName, list, refEntityType, FULL_NAME);
            nodes.add(this.createContainNode(mulBasedataProp, list, containName));
        } else if (property instanceof FlexProp) {
            this.buildFlexNodes(nodes, (FlexProp)property, viewPrefix);
        } else if (property instanceof FieldProp) {
            Map<String, Object> fieldNode = this.createFieldNode(property, viewPrefix, (IDataEntityType)this.entityType, dataEntityType);
            if (fieldNode != null && !fieldNode.isEmpty()) {
                nodes.add(fieldNode);
            }
        } else if (property instanceof ItemClassProp) {
            ItemClassProp itemClassProp = (ItemClassProp)property;
            String prefixName = "";
            String localeValue = this.getFieldName((IDataEntityProperty)itemClassProp);
            prefixName = StringUtils.isBlank((CharSequence)viewPrefix) ? localeValue : viewPrefix + "." + localeValue;
            ArrayList<Object> list = new ArrayList<Object>();
            IDataEntityType complexType = itemClassProp.getComplexType();
            if (complexType == null) {
                return;
            }
            RefEntityType refEntityType = (RefEntityType)complexType;
            DynamicProperty numberProp = refEntityType.getProperty(refEntityType.getNumberProperty());
            Map<String, Object> numberNode = null;
            if (numberProp != null) {
                numberNode = this.createFieldNode((IDataEntityProperty)numberProp, prefixName, (IDataEntityType)this.entityType, (IDataEntityType)refEntityType);
            }
            if (numberNode != null && !numberNode.isEmpty()) {
                list.add(numberNode);
            }
            DynamicProperty nameProp = refEntityType.getProperty(refEntityType.getNameProperty());
            Map<String, Object> nameNode = null;
            if (nameProp != null) {
                nameNode = this.createFieldNode((IDataEntityProperty)nameProp, prefixName, (IDataEntityType)this.entityType, (IDataEntityType)refEntityType);
            }
            if (nameNode != null && !nameNode.isEmpty()) {
                list.add(nameNode);
            }
            nodes.add(this.createContainNode((IComplexProperty)itemClassProp, list));
        } else if (property instanceof IComplexProperty) {
            IComplexProperty complexProperty = (IComplexProperty)property;
            String containName = this.getContainDisplayName((IDataEntityProperty)complexProperty, (IDataEntityType)this.entityType);
            String prefixName = "";
            prefixName = StringUtils.isBlank((CharSequence)viewPrefix) ? containName : viewPrefix + "." + containName;
            buildInfo.setDataEntityType(complexProperty.getComplexType());
            buildInfo.setViewPrefix(prefixName);
            buildInfo.setEnableFilter(false);
            buildInfo.setParentKey(complexProperty.getName());
            List<Object> objects = this.buildItems(buildInfo);
            nodes.add(this.createContainNode(complexProperty, objects, containName));
        }
        if (property instanceof EntryProp) {
            return;
        }
    }

    protected void buildFlexNodes(List<Object> nodes, FlexProp flexProp, String viewPrefix) {
        IDataEntityType parent = flexProp.getParent();
        String basePropertyKey = flexProp.getBasePropertyKey();
        IDataEntityProperty property = (IDataEntityProperty)parent.getProperties().get((Object)basePropertyKey);
        String fieldName = this.getFieldName((IDataEntityProperty)flexProp);
        viewPrefix = StringUtils.isBlank((CharSequence)viewPrefix) ? fieldName : viewPrefix + "." + fieldName;
        if (property instanceof BasedataProp) {
            ArrayList<Object> itemList = new ArrayList<Object>(10);
            Map<String, Object> historyNode = this.getFlexChildrenNode(flexProp, viewPrefix, flexProp.getName(), fieldName, FieldType.Text.getCode());
            itemList.add(historyNode);
            Map<String, String> propertyMap = this.getPropertyMap(flexProp, (BasedataProp)property);
            for (Map.Entry<String, String> entry : propertyMap.entrySet()) {
                String propertyId = entry.getKey();
                String propertyName = entry.getValue();
                String controlType = FieldType.Text.getCode();
                Map<String, Object> node = this.getFlexChildrenNode(flexProp, viewPrefix, propertyId, propertyName, controlType);
                itemList.add(node);
            }
            Map<String, Object> containNode = this.createContainNode(flexProp.getName(), viewPrefix, itemList);
            nodes.add(containNode);
        }
    }

    private Map<String, Object> getFlexChildrenNode(FlexProp flexProp, String viewPrefix, String propertyId, String propertyName, String controlType) {
        HashMap<String, Object> node = new HashMap<String, Object>();
        node.put("Key", propertyId);
        node.put("Type", controlType);
        node.put("Name", propertyName);
        if (StringUtils.isNotBlank((CharSequence)viewPrefix)) {
            node.put("ViewName", viewPrefix + "." + propertyName);
        }
        node.put("IsField", Boolean.TRUE);
        this.setAttr(node, (IDataEntityProperty)flexProp);
        return node;
    }

    private Map<String, String> getPropertyMap(FlexProp flexProp, BasedataProp property) {
        try {
            Map<String, String> propertyMap = new HashMap<String, String>(16);
            BasedataProp basedataProp = property;
            String flexPropertyKey = basedataProp.getFlexPropertyKey();
            String baseEntityId = basedataProp.getBaseEntityId();
            BasedataEntityType baseEntityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)baseEntityId);
            if (StringUtils.isBlank((CharSequence)baseEntityType.getFlexProperty()) && baseEntityType.getMasteridType() == 2) {
                BasedataProp masterProp = (BasedataProp)baseEntityType.getProperty(baseEntityType.getMasteridPropName());
                baseEntityType = (BasedataEntityType)masterProp.getComplexType();
            }
            IDataEntityProperty entityProperty = (IDataEntityProperty)baseEntityType.getAllFields().get(flexPropertyKey);
            IDataEntityType entityType = entityProperty.getParent();
            String alias = entityType.getAlias();
            String sql = "select " + entityProperty.getAlias() + " from " + alias;
            Set baseDataIdSet = (Set)DB.query((DBRoute)new DBRoute(entityType.getDBRouteKey()), (String)sql, resultSet -> {
                HashSet<Object> res = new HashSet<Object>(10);
                while (resultSet.next()) {
                    Object baseDataId = resultSet.getObject(1);
                    res.add(baseDataId);
                }
                return res;
            });
            if (baseDataIdSet.isEmpty()) {
                return propertyMap;
            }
            int flexTypeId = flexProp.getFlexTypeId();
            SqlBuilder flexBaseDataSqlBuilder = new SqlBuilder();
            flexBaseDataSqlBuilder.append("select t.fflexfield,tl.fname from t_bas_flex_property as t left join t_bas_flex_property_l as tl on  t.fentryid = tl.fentryid where fid=" + flexTypeId + " and ", new Object[0]);
            flexBaseDataSqlBuilder.appendIn("t.fentryid", baseDataIdSet.toArray());
            flexBaseDataSqlBuilder.append(" and tl.FLOCALEID = '" + RequestContext.get().getLang().toString() + "'", new Object[0]);
            propertyMap = (Map)DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)flexBaseDataSqlBuilder, resultSet -> {
                LinkedHashMap<String, String> properties1 = new LinkedHashMap<String, String>(16);
                while (resultSet.next()) {
                    String propertyId = resultSet.getString(1);
                    String propertyName = resultSet.getString(2);
                    if (StringUtils.isBlank((CharSequence)propertyName)) continue;
                    properties1.put(propertyId, propertyName);
                    if (properties1.size() != 20) continue;
                    break;
                }
                return properties1;
            });
            return propertyMap;
        }
        catch (Exception e) {
            this.log.warn((Throwable)e);
            return new HashMap<String, String>(0);
        }
    }

    private void buildSingleMulProp(String prefixName, List<Object> list, RefEntityType refEntityType, String propName) {
        DynamicProperty dyProp = refEntityType.getProperty(propName);
        Map<String, Object> node = null;
        if (null != dyProp) {
            node = this.createFieldNode((IDataEntityProperty)dyProp, prefixName, (IDataEntityType)this.entityType, (IDataEntityType)refEntityType);
        }
        if (null != node && !node.isEmpty()) {
            list.add(node);
        }
    }

    private String getFieldName(IDataEntityProperty property) {
        LocaleString displayName = property.getDisplayName();
        if (displayName == null) {
            return property.getName();
        }
        String localeValue = displayName.getLocaleValue();
        if (StringUtils.isBlank((CharSequence)localeValue)) {
            return property.getName();
        }
        return localeValue;
    }

    private String getContainDisplayName(IDataEntityProperty complexProperty, IDataEntityType dataEntityType) {
        String displayName = "";
        if (this.prtDataSourceServices != null && !this.prtDataSourceServices.isEmpty()) {
            for (IPrtDataSourceFacade prtDataSourceService : this.prtDataSourceServices) {
                String modifyName = prtDataSourceService.getContainDisplayName(complexProperty, dataEntityType);
                if (!StringUtils.isNotBlank((CharSequence)modifyName)) continue;
                displayName = modifyName;
            }
        }
        if (StringUtils.isBlank((CharSequence)displayName)) {
            displayName = this.getFieldName(complexProperty);
        }
        return displayName;
    }

    protected boolean isShowProperty(IDataEntityType dataEntityType, IDataEntityProperty property, String parentKey) {
        String masteridPropName;
        if (property instanceof PKFieldProp || property instanceof GeoPointProp) {
            return false;
        }
        if (property instanceof BooleanProp && property.isDbIgnore()) {
            return false;
        }
        if (dataEntityType instanceof RefEntityType && StringUtils.equals((CharSequence)(masteridPropName = ((RefEntityType)dataEntityType).getMasteridPropName()), (CharSequence)property.getName()) && !(property instanceof MasterBasedataProp)) {
            return false;
        }
        if (this.prtDataSourceServices != null && !this.prtDataSourceServices.isEmpty()) {
            for (IPrtDataSourceFacade prtDataSourceService : this.prtDataSourceServices) {
                if (prtDataSourceService.isShowFieldNode(dataEntityType, property, parentKey)) continue;
                return false;
            }
        }
        return true;
    }

    protected Map<String, Object> createFieldNode(IDataEntityProperty property, String viewPrefix, IDataEntityType dataEntityType) {
        return this.createFieldNode(property, viewPrefix, dataEntityType, null);
    }

    private Map<String, Object> createFieldNode(IDataEntityProperty property, String viewPrefix, IDataEntityType dataEntityType, IDataEntityType currentType) {
        Map<String, Object> node = this.createFieldNode(property, viewPrefix);
        if (currentType instanceof RefEntityType) {
            RefEntityType refEntityType = (RefEntityType)currentType;
            if (StringUtils.equals((CharSequence)refEntityType.getNameProperty(), (CharSequence)property.getName())) {
                node.put("NameProp", Boolean.TRUE);
            } else if (StringUtils.equals((CharSequence)refEntityType.getNumberProperty(), (CharSequence)property.getName())) {
                node.put("NumberProp", Boolean.TRUE);
            }
        }
        if (this.prtDataSourceServices != null && !this.prtDataSourceServices.isEmpty()) {
            this.prtDataSourceServices.forEach(prtDataSourceService -> prtDataSourceService.modifyFieldNode(node, property, dataEntityType));
        }
        return node;
    }

    protected Map<String, Object> createFieldNode(IDataEntityProperty property, String viewPrefix) {
        boolean notSupportText;
        String propertyName = property.getName();
        String controlType = this.getControlType(property);
        HashMap<String, Object> node = new HashMap<String, Object>();
        node.put("Key", propertyName);
        node.put("Type", controlType);
        LocaleString displayName = property.getDisplayName();
        String name = "seq".equalsIgnoreCase(propertyName) ? ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"EntryDsBuilder_0", (String)PROJECT_NAME, (Object[])new Object[0]) : (displayName != null ? this.getFieldName(property) : propertyName);
        node.put("Name", name);
        if (StringUtils.isNotBlank((CharSequence)viewPrefix)) {
            node.put("ViewName", viewPrefix + "." + name);
        }
        node.put("IsField", Boolean.TRUE);
        boolean bl = notSupportText = property instanceof TextAreaProp || property instanceof LargeTextProp || this.largeTextTagContains(property);
        if (!notSupportText) {
            node.put("SortedAble", Boolean.TRUE);
        }
        if (property instanceof LargeTextProp) {
            this.addLargeTextTag(property);
        }
        this.setAttr(node, property);
        return node;
    }

    private void addLargeTextTag(IDataEntityProperty property) {
        if (!(property instanceof LargeTextProp)) {
            return;
        }
        if (this.largeTextTags == null) {
            this.largeTextTags = new HashSet<String>(10);
        }
        this.largeTextTags.add(property.getName() + LARGE_TEXT_SUFFIX);
    }

    private boolean largeTextTagContains(IDataEntityProperty property) {
        if (CollectionUtils.isEmpty(this.largeTextTags)) {
            return false;
        }
        return this.largeTextTags.remove(property.getName());
    }

    protected Map<String, Object> createContainNode(String key, String name, List<Object> itemsList) {
        HashMap<String, Object> node = new HashMap<String, Object>();
        node.put("Key", key);
        node.put("Name", name);
        node.put("Items", itemsList);
        return node;
    }

    protected Map<String, Object> createContainNode(IComplexProperty complexProperty, List<Object> itemsList, String displayName) {
        String key = complexProperty.getName();
        if (StringUtils.isBlank((CharSequence)displayName)) {
            displayName = this.getFieldName((IDataEntityProperty)complexProperty);
        }
        Map<String, Object> node = this.createContainNode(key, displayName, itemsList);
        if (complexProperty instanceof CreaterProp) {
            node.put("Icon", "chuangjianren");
        } else if (complexProperty instanceof ModifierProp) {
            node.put("Icon", "xiugairen");
        } else if (complexProperty instanceof MaterielProp) {
            node.put("Icon", "wuliao");
        }
        return node;
    }

    protected Map<String, Object> createContainNode(MulBasedataProp mulBasedataProp, List<Object> itemsList, String displayName) {
        String key = mulBasedataProp.getName();
        if (StringUtils.isBlank((CharSequence)displayName)) {
            displayName = this.getFieldName((IDataEntityProperty)mulBasedataProp);
        }
        return this.createContainNode(key, displayName, itemsList);
    }

    protected Map<String, Object> createContainNode(IComplexProperty complexProperty, List<Object> itemsList) {
        return this.createContainNode(complexProperty, itemsList, null);
    }

    protected String getControlType(IDataEntityProperty property) {
        if (property instanceof PictureProp || property instanceof SignatureProp) {
            return FieldType.Image.getCode();
        }
        if (property instanceof RichTextProp) {
            return FieldType.RichText.getCode();
        }
        return FieldType.Text.getCode();
    }

    protected Map setAttr(Map<String, Object> node, IDataEntityProperty property) {
        AmountProp amountProp;
        String controlName;
        HashMap<String, String> intiAttr = new HashMap<String, String>();
        FieldType fieldType = SimpleDsBuilder.getFieldType(property);
        intiAttr.put("TextFormat", fieldType == FieldType.Image || fieldType == FieldType.Attach || fieldType == FieldType.RichText ? FieldType.Text.getCode() : fieldType.getCode());
        if (property instanceof AmountProp && StringUtils.isNotBlank((CharSequence)(controlName = (amountProp = (AmountProp)property).getControlPropName()))) {
            intiAttr.put("CurrencyCode", "FROM_CURRENCY");
        }
        if (property instanceof DecimalProp) {
            DecimalProp fieldProp = (DecimalProp)property;
            boolean zeroShow = fieldProp.isZeroShow();
            node.put("IgnoreZero", !zeroShow);
        }
        node.put("Icon", fieldType.getIcon());
        node.put("InitAttr", intiAttr);
        return intiAttr;
    }

    private static FieldType getFieldType(IDataEntityProperty property) {
        if (property instanceof DateProp || property instanceof DateTimeProp) {
            return FieldType.Date;
        }
        if (property instanceof TimeProp) {
            return FieldType.Time;
        }
        if (property instanceof AmountProp || property instanceof PriceProp) {
            return FieldType.Amount;
        }
        if (property instanceof DecimalProp) {
            return FieldType.Number;
        }
        if (property instanceof PictureProp) {
            return FieldType.Image;
        }
        if (property instanceof SignatureProp) {
            return FieldType.Image;
        }
        if (property instanceof AttachmentProp) {
            return FieldType.Attach;
        }
        if (property instanceof RichTextProp) {
            return FieldType.RichText;
        }
        return FieldType.Text;
    }

    protected List<IDataEntityProperty> filterProperty(IDataEntityType mainEntityType, boolean enableFilter) {
        if (!enableFilter || this.filterFields == null) {
            return mainEntityType.getProperties();
        }
        DataEntityPropertyCollection properties = mainEntityType.getProperties();
        ArrayList<IDataEntityProperty> result = new ArrayList<IDataEntityProperty>(properties.size());
        for (IDataEntityProperty property : properties) {
            this.findByProp(result, property);
        }
        return result;
    }

    private void findByProp(List<IDataEntityProperty> result, IDataEntityProperty property) {
        String name = property.toString();
        if (StringUtils.isBlank((CharSequence)name)) {
            return;
        }
        String[] split = name.split(COLON_SPLIT);
        if (split.length > 0 && !this.rangeProp(property)) {
            name = split[0];
        }
        if (property instanceof PKFieldProp) {
            boolean refId = ((PKFieldProp)property).isRefId();
            if (refId && this.filterFields.contains(name.substring(0, name.lastIndexOf("_id")))) {
                result.add(property);
                this.filterFields.remove(name.substring(0, name.lastIndexOf("_id")));
            }
        } else if (this.filterFields.remove(name)) {
            result.add(property);
        }
    }

    private boolean rangeProp(IDataEntityProperty property) {
        return property instanceof TimeProp && ((TimeProp)property).getRelateTimeRange() != null || property instanceof DateTimeProp && ((DateTimeProp)property).getRelateDateTimeRange() != null;
    }

    static class DsBuildInfo {
        private IDataEntityType dataEntityType;
        private String viewPrefix;
        private String parentKey;
        private boolean enableFilter;

        DsBuildInfo() {
        }

        public IDataEntityType getDataEntityType() {
            return this.dataEntityType;
        }

        public void setDataEntityType(IDataEntityType dataEntityType) {
            this.dataEntityType = dataEntityType;
        }

        public String getViewPrefix() {
            return this.viewPrefix;
        }

        public void setViewPrefix(String viewPrefix) {
            this.viewPrefix = viewPrefix;
        }

        public String getParentKey() {
            return this.parentKey;
        }

        public void setParentKey(String parentKey) {
            this.parentKey = parentKey;
        }

        public boolean isEnableFilter() {
            return this.enableFilter;
        }

        public void setEnableFilter(boolean enableFilter) {
            this.enableFilter = enableFilter;
        }
    }
}

