/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.designer.function;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.print.business.designer.function.FunctionBuilder;
import kd.bos.print.business.designer.function.FunctionItem;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class InitFunctionUtil {
    private static final String PROJECT_NAME = "bos-print-InitFunction";
    private static final Map<String, List<FunctionBuilder>> localeDataCache = new HashMap<String, List<FunctionBuilder>>(8);

    private InitFunctionUtil() {
        throw new IllegalStateException("Utility class");
    }

    private static SAXReader getSaxReader() {
        SAXReader saxReader = new SAXReader();
        try {
            saxReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            saxReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            saxReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        return saxReader;
    }

    public static List<FunctionBuilder> getFun() {
        String lang = RequestContext.get().getLang().toString();
        List<FunctionBuilder> result = localeDataCache.get(lang);
        if (result != null) {
            return result;
        }
        result = new ArrayList<FunctionBuilder>(10);
        try (InputStream in = InitFunctionUtil.class.getResourceAsStream("/PrintInitFunction.xml");){
            SAXReader reader = InitFunctionUtil.getSaxReader();
            Document doc = reader.read(in);
            Element rootElement = doc.getRootElement();
            Iterator iterator = rootElement.elementIterator();
            while (iterator.hasNext()) {
                Element category = (Element)iterator.next();
                ArrayList<FunctionItem> items = new ArrayList<FunctionItem>(10);
                String categoryKey = category.attributeValue("Key");
                String categoryName = category.attributeValue("Name");
                FunctionBuilder fb = new FunctionBuilder(categoryKey, ResManager.loadKDString((String)categoryName, (String)(categoryKey + "_Name"), (String)PROJECT_NAME, (Object[])new Object[0]), items);
                result.add(fb);
                List functionList = category.elements();
                for (Element function : functionList) {
                    String functionKey = function.attributeValue("Key");
                    String functionName = function.attributeValue("Name");
                    String functionTitle = function.attributeValue("Title");
                    String text = function.getText();
                    FunctionItem fi = new FunctionItem(functionKey, ResManager.loadKDString((String)functionName, (String)(functionKey + "_Name"), (String)PROJECT_NAME, (Object[])new Object[0]), ResManager.loadKDString((String)functionTitle, (String)(functionKey + "_Title"), (String)PROJECT_NAME, (Object[])new Object[0]), ResManager.loadKDString((String)text, (String)(functionKey + "_Text"), (String)PROJECT_NAME, (Object[])new Object[0]));
                    items.add(fi);
                }
            }
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        localeDataCache.put(lang, result);
        return result;
    }
}

