/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.designer.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.print.business.designer.TplType;
import kd.bos.print.business.metedata.bean.DesignMetadata;
import kd.bos.print.business.metedata.service.AbstractTplService;
import kd.bos.print.business.metedata.service.PrintTplService;
import kd.bos.servicehelper.QueryServiceHelper;

public abstract class AbstractNewPrintTplPlugin
extends AbstractFormPlugin
implements ClickListener,
BeforeF7SelectListener {
    protected static final String BTN_CANCEL = "btncancel";
    protected static final String BTN_OK = "btnok";
    protected static final String KEY_NUMBER = "number";
    protected static final String KEY_NAME = "name";
    protected static final String PRINT_METEDATA = "bos_print_meta";
    protected static final String PROJECT_NAME = "bos-print-business";
    protected AbstractTplService tplService = new PrintTplService();
    private static String NEW_TPL_VERSION = "7.01";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_CANCEL, BTN_OK});
    }

    abstract String genTplNumber(String var1);

    protected Map createPrintTemplate(String key, ILocaleString name, String entityId, String formId, Map<String, Object> sTpldata, Map<String, String> localValueMap) {
        HashMap<String, String> paper;
        if (StringUtils.isBlank((CharSequence)key) || StringUtils.isBlank((CharSequence)name.getLocaleValue())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e2d\u6587\u540d\u79f0\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"NewPrintTplGuidePlugin_6", (String)PROJECT_NAME, (Object[])new Object[0]));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        QFilter[] qFilters = new QFilter[]{new QFilter(KEY_NUMBER, "=", (Object)key)};
        boolean exists = QueryServiceHelper.exists((String)PRINT_METEDATA, (QFilter[])qFilters);
        if (exists) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"AbstractNewPrintTplPlugin_0", (String)PROJECT_NAME, (Object[])new Object[0]));
        }
        FormMetadata formMeta = (FormMetadata)MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Form);
        String bizAppId = formMeta.getBizappId();
        String tplId = DB.genStringId((String)"t_svc_printmeta");
        String bizType = "0";
        long creator = RequestContext.get().getCurrUserId();
        long orgId = RequestContext.get().getOrgId();
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        data.put("id", tplId);
        data.put("key", key);
        data.put(KEY_NAME, name);
        data.put("type", TplType.PrintTpl.toString());
        data.put("stplId", " ");
        data.put("entityId", entityId);
        data.put("formId", formId);
        data.put("bizappId", bizAppId);
        data.put("version", NEW_TPL_VERSION);
        data.put("refDs", null);
        data.put("customDs", null);
        data.put("oriLang", RequestContext.get().getLang().toString());
        if (sTpldata != null) {
            Object customDs;
            paper = (HashMap<String, String>)sTpldata.get("paper");
            paper.put("key", key);
            paper.put(KEY_NAME, (String)name);
            data.put("paper", paper);
            data.put("pages", sTpldata.get("pages"));
            data.put("stplId", sTpldata.get("id"));
            data.put("plugins", sTpldata.get("plugins"));
            bizType = Optional.ofNullable(sTpldata.get("bizType")).orElse("0").toString();
            data.put("bizType", bizType);
            Object refDs = sTpldata.get("refDs");
            if (refDs != null) {
                data.put("refDs", refDs);
            }
            if ((customDs = sTpldata.get("customDs")) != null) {
                data.put("customDs", customDs);
            }
        } else {
            bizType = Optional.ofNullable(this.getModel().getValue("biztype")).orElse("0").toString();
            data.put("bizType", bizType);
            paper = new HashMap<String, String>(16);
            paper.put("id", tplId);
            paper.put("key", key);
            paper.put(KEY_NAME, (String)name);
            paper.put("type", "Paper");
            if ("1".equals(data.get("bizType"))) {
                paper.put("paperType", "L58");
                paper.put("width", (String)((Object)Integer.valueOf(58)));
                paper.put("height", (String)((Object)Integer.valueOf(180)));
                paper.put("marginTop", (String)((Object)Integer.valueOf(0)));
                paper.put("marginBottom", (String)((Object)Integer.valueOf(0)));
                paper.put("marginLeft", (String)((Object)Integer.valueOf(5)));
                paper.put("marginRight", (String)((Object)Integer.valueOf(5)));
                paper.put("dynamicPaper", (String)((Object)Boolean.valueOf(true)));
            } else if ("2".equals(data.get("bizType"))) {
                paper.put("paperType", "L58");
                paper.put("width", (String)((Object)Integer.valueOf(58)));
                paper.put("height", (String)((Object)Integer.valueOf(40)));
                paper.put("marginTop", (String)((Object)Integer.valueOf(0)));
                paper.put("marginBottom", (String)((Object)Integer.valueOf(0)));
                paper.put("marginLeft", (String)((Object)Integer.valueOf(5)));
                paper.put("marginRight", (String)((Object)Integer.valueOf(5)));
            } else if ("3".equals(data.get("bizType"))) {
                paper.put("paperType", "Custom");
                paper.put("width", (String)((Object)Integer.valueOf(241)));
                paper.put("height", (String)((Object)Double.valueOf(139.7)));
                paper.put("marginTop", (String)((Object)Integer.valueOf(0)));
                paper.put("marginBottom", (String)((Object)Integer.valueOf(0)));
                paper.put("marginLeft", (String)((Object)Integer.valueOf(15)));
                paper.put("marginRight", (String)((Object)Integer.valueOf(15)));
            } else {
                paper.put("paperType", "A4");
                paper.put("width", (String)((Object)Integer.valueOf(210)));
                paper.put("height", (String)((Object)Integer.valueOf(297)));
                paper.put("marginTop", (String)((Object)Integer.valueOf(20)));
                paper.put("marginBottom", (String)((Object)Integer.valueOf(20)));
                paper.put("marginLeft", (String)((Object)Integer.valueOf(17)));
                paper.put("marginRight", (String)((Object)Integer.valueOf(17)));
            }
            paper.put("paperDirection", "vertical");
            paper.put("economicType", "");
            paper.put("inteFormat", "zh_CN");
            paper.put("backgroundImg", "");
            paper.put("splicePrint", (String)((Object)Boolean.valueOf(true)));
            data.put("paper", paper);
            ArrayList<List> pages = new ArrayList<List>();
            pages.add(Collections.EMPTY_LIST);
            data.put("pages", pages);
        }
        DesignMetadata dMetadata = new DesignMetadata();
        dMetadata.setId(tplId);
        dMetadata.setMasterid(tplId);
        dMetadata.setNumber(key);
        dMetadata.setStplId((String)data.get("stplId"));
        dMetadata.setName(name.getLocaleValue());
        dMetadata.setlName(name);
        dMetadata.setFormId(formId);
        dMetadata.setCreator(creator);
        dMetadata.setModifier(creator);
        dMetadata.setType("B");
        dMetadata.setBizappid(bizAppId);
        dMetadata.setCreatetime(new Date());
        dMetadata.setModifytime(new Date());
        dMetadata.setOrg(orgId);
        dMetadata.setData(SerializationUtils.toJsonString(data));
        dMetadata.setStatus("C");
        dMetadata.setEnable("1");
        dMetadata.setVersion(NEW_TPL_VERSION);
        dMetadata.setBizType(bizType);
        dMetadata.setTplType("0");
        dMetadata.setIsv(ISVService.getISVInfo().getId());
        this.tplService.save(dMetadata, this.tplService.getDesignMetaL(dMetadata, localValueMap));
        result.put("success", Boolean.TRUE);
        result.put("tplId", tplId);
        result.put("printV", "B");
        return result;
    }
}

