/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.designer.plugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.api.metedata.PrintMetadata;
import kd.bos.print.business.designer.plugin.AbstractNewPrintTplPlugin;
import kd.bos.print.business.designer.plugin.NewPrintTplGuidePlugin;
import kd.bos.print.business.designer.plugin.NumberCheckUtils;
import kd.bos.print.business.designer.tplcopy.builder.ITplCopyBuilder;
import kd.bos.print.business.designer.tplcopy.factory.TplCopyFactory;
import kd.bos.print.business.metedata.PrintMetadataUtil;
import kd.bos.print.business.utils.PrintOpLogMsgEnum;
import kd.bos.print.business.utils.PrintOpLogUtils;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class CopyPrintTplPlugin
extends AbstractNewPrintTplPlugin {
    private static final Log logger = LogFactory.getLog(CopyPrintTplPlugin.class);
    private static final String KEY_ORI_TPL = "oritpl";
    private static final String BIZ_ENTITY = "bizentity";
    private static final String ID = "id";
    private static final String FORM_ID = "formId";
    private static final String ENTITY_ID = "entityId";
    private static final String TABLE_METADATA_L = "t_svc_printmeta_l";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit bsdPrintTpl = (BasedataEdit)this.getView().getControl(KEY_ORI_TPL);
        bsdPrintTpl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map configinfo = this.getView().getFormShowParameter().getCustomParams();
        if (configinfo != null) {
            String oriTplId = (String)configinfo.get("oriTplId");
            this.getModel().setValue(KEY_ORI_TPL, (Object)oriTplId);
            PrintMetadata oriPrintMetadata = PrintMetadataUtil.getPrintMetadata(oriTplId);
            if (null == oriPrintMetadata) {
                logger.debug("CopyPrintTplPlugin afterCreateNewData error, oriPrintMetadata is null, oriTplId:{}", (Object)oriTplId);
                return;
            }
            this.getModel().setValue(BIZ_ENTITY, (Object)oriPrintMetadata.getFormId());
            this.setModelValue();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object value;
        String property = e.getProperty().getName();
        if (KEY_ORI_TPL.equals(property)) {
            this.setModelValue();
        } else if ("number".equals(property) && StringUtils.isNotBlank((Object)(value = this.getModel().getValue("number")))) {
            String tplNum = String.valueOf(value);
            if (NumberCheckUtils.isKingdeeISV() && !tplNum.startsWith("kdprint_")) {
                tplNum = "kdprint_" + tplNum;
                this.getModel().setValue("number", (Object)tplNum);
            }
        }
    }

    private void setModelValue() {
        DynamicObject oriTplObj = (DynamicObject)this.getModel().getValue(KEY_ORI_TPL);
        if (ObjectUtils.isEmpty((Object)oriTplObj)) {
            return;
        }
        String number = (String)oriTplObj.get("number");
        String tplNum = this.genTplNumber(number);
        boolean withKdPrefix = tplNum.startsWith("kdprint_");
        if (NumberCheckUtils.isKingdeeISV()) {
            if (!withKdPrefix) {
                tplNum = "kdprint_" + tplNum;
            }
        } else if (withKdPrefix) {
            tplNum = tplNum.replaceFirst("kdprint_", "");
        }
        this.getModel().setValue("number", (Object)tplNum);
    }

    @Override
    protected String genTplNumber(String number) {
        return number + "_copy";
    }

    public void click(EventObject evt) {
        String key;
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "btncancel": {
                this.getView().close();
                break;
            }
            case "btnok": {
                this.newPrintTpl();
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
    }

    private void newPrintTpl() {
        Map result;
        try {
            ILocaleString name = (ILocaleString)this.getModel().getValue("name");
            String number = (String)this.getModel().getValue("number");
            Tuple<Boolean, String> checkResult = NumberCheckUtils.validateIsv(number);
            if (!((Boolean)checkResult.item1).booleanValue()) {
                this.getView().showTipNotification((String)checkResult.item2);
                return;
            }
            checkResult = NumberCheckUtils.validate(number);
            if (!((Boolean)checkResult.item1).booleanValue()) {
                this.getView().showTipNotification((String)checkResult.item2);
                return;
            }
            DynamicObject orgObj = this.getModel().getDataEntity().getDynamicObject("createOrg");
            if (orgObj != null && !NewPrintTplGuidePlugin.checkTplPermission(orgObj.getLong(ID), "47156aff000000ac")) {
                String permItemName = String.valueOf(PermissionServiceHelper.getPermItemNameById((String)"47156aff000000ac"));
                String formName = String.valueOf(FormMetadataCache.getFormConfig((String)"bos_manageprinttpl").getCaption());
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u65e0\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PrintDesignerPlugin_15", (String)"bos-print-business", (Object[])new Object[0]), formName, permItemName));
                return;
            }
            ITplCopyBuilder tplCopyBuilder = TplCopyFactory.getBuilder(this.getModel(), this.getView());
            if (null == tplCopyBuilder) {
                throw new KDBizException("create tplCopyBuilder error, tplCopyBuilder is null");
            }
            Map resultMetedata = tplCopyBuilder.build();
            result = this.createPrintTemplate(number, name, (String)resultMetedata.get(ENTITY_ID), (String)resultMetedata.get(FORM_ID), resultMetedata, this.queryLocalValueMap(resultMetedata));
            PrintOpLogUtils.addLog((IFormView)this.getView().getParentView(), (String)number, (PrintOpLogMsgEnum)PrintOpLogMsgEnum.TPL_COPY);
        }
        catch (Exception e) {
            this.getView().showTipNotification(e.getMessage());
            return;
        }
        this.getView().returnDataToParent((Object)result);
        this.getView().close();
    }

    private Map<String, String> queryLocalValueMap(Map resultMetadata) {
        Object id = resultMetadata.get(ID);
        if (id == null) {
            return null;
        }
        String select = String.format("select flocaleid,fdata from %s where fid = ?", TABLE_METADATA_L);
        return (Map)DB.query((DBRoute)DBRoute.basedata, (String)select, (Object[])new SqlParameter[]{new SqlParameter("fid", 12, (Object)id.toString())}, res -> {
            HashMap<String, String> localValueMap = new HashMap<String, String>(8);
            while (res.next()) {
                String localData;
                String localId = res.getString(1);
                if (localId == null || (localData = res.getString(2)) == null) continue;
                localValueMap.put(localId, localData);
            }
            return localValueMap;
        });
    }
}

