/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.designer.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.business.designer.TplType;
import kd.bos.print.business.metedata.service.AbstractTplService;
import kd.bos.print.business.metedata.service.migrate.AbstractImpExp;
import kd.bos.print.business.metedata.service.migrate.LibraryTplImpExp;
import kd.bos.print.business.metedata.service.migrate.PrintTplImpExp;
import kd.bos.print.business.service.BosPrintBusinessServiceImpl;

public class ImportPrintTplPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final Log logger = LogFactory.getLog(ImportPrintTplPlugin.class);
    private static final String PROJECT_NAME = "bos-print-business";
    private static AbstractTplService tplService;
    private static BosPrintBusinessServiceImpl printBusinessService;
    private long LIMITSIZ = 0x500000L;
    private static final String CACHE_FILE = "cachefile";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"confirm"});
        AttachmentPanel dbspanel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
        dbspanel.addUploadListener((UploadListener)this);
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "confirm": {
                String cacheFile = this.getPageCache().get(CACHE_FILE);
                if (StringUtils.isBlank((CharSequence)cacheFile)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6587\u4ef6\u3002", (String)"ImportPrintTplPlugin_5", (String)PROJECT_NAME, (Object[])new Object[0]), Integer.valueOf(3000));
                    return;
                }
                Map fileInfo = (Map)SerializationUtils.fromJsonString((String)cacheFile, Map.class);
                this.importTpl(fileInfo);
                break;
            }
        }
    }

    private void importTpl(Map<String, Object> fileInfo) {
        String tplType = (String)this.getView().getFormShowParameter().getCustomParam("TplType");
        boolean isPrintTpl = TplType.valueOf(tplType) == TplType.PrintTpl;
        AbstractImpExp impExpService = isPrintTpl ? new PrintTplImpExp() : new LibraryTplImpExp();
        String url = (String)fileInfo.get("url");
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        try (InputStream inputStream = cache.getInputStream(url);){
            Map<String, Object> result = impExpService.doImport(inputStream);
            int success = (Integer)result.get("success");
            int count = (Integer)result.get("count");
            List errMsg = (List)result.get("message");
            Object isDuplicateNumber = result.get("isDuplicateNumber");
            String duplicateNumberMsg = "";
            if (StringUtils.equals((CharSequence)"true", (CharSequence)((String)isDuplicateNumber))) {
                duplicateNumberMsg = ResManager.loadKDString((String)"\u7531\u4e8e\u5b58\u5728\u7f16\u7801\u91cd\u590d\u7684\u6a21\u677f\uff0c\u5bfc\u5165\u540e\u6a21\u677f\u7f16\u7801\u5df2\u91cd\u65b0\u751f\u6210\u3002", (String)"ImportPrintTplPlugin_4", (String)PROJECT_NAME, (Object[])new Object[0]);
            }
            if (success == count) {
                String showMsg = ResManager.loadKDString((String)"\u5bfc\u5165\u5b8c\u6210\uff0c\u5171%1$s\u4e2a\u6a21\u677f\uff0c\u5bfc\u5165\u6210\u529f%2$s\u4e2a\u3002%3$s", (String)"ImportPrintTplPlugin_0", (String)PROJECT_NAME, (Object[])new Object[0]);
                showMsg = String.format(showMsg, count, success, duplicateNumberMsg);
                this.getView().showMessage(showMsg);
                this.getView().close();
            } else {
                String showMsg = ResManager.loadKDString((String)"\u5bfc\u5165\u5b8c\u6210\uff0c\u5171%1$s\u4e2a\u6a21\u677f\uff0c\u5bfc\u5165\u6210\u529f%2$s\u4e2a\u3002\u5931\u8d25\u539f\u56e0\uff1a\n%3$s", (String)"ImportPrintTplPlugin_1", (String)PROJECT_NAME, (Object[])new Object[0]);
                showMsg = String.format(showMsg, count, success, StringUtils.join((Object[])errMsg.toArray(), (String)"\n")) + duplicateNumberMsg;
                this.getView().showMessage(ResManager.loadKDString((String)"\u6e29\u99a8\u63d0\u793a", (String)"ImportPrintTplPlugin_2", (String)PROJECT_NAME, (Object[])new Object[0]), showMsg, MessageTypes.Commit);
                this.getView().close();
            }
        }
        catch (IOException e) {
            logger.error((Throwable)e);
            this.getView().showErrorNotification(e.getMessage());
        }
    }

    public void upload(UploadEvent arg) {
        if (arg == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u6587\u4ef6\u670d\u52a1\u5668zk\u914d\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"ImportPrintTplPlugin_3", (String)PROJECT_NAME, (Object[])new Object[0]));
            return;
        }
        Object[] args = arg.getUrls();
        if (args == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u6587\u4ef6\u670d\u52a1\u5668zk\u914d\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"ImportPrintTplPlugin_3", (String)PROJECT_NAME, (Object[])new Object[0]));
            return;
        }
        Object fileInfo = args[0];
        this.getPageCache().put(CACHE_FILE, SerializationUtils.toJsonString((Object)fileInfo));
    }

    public void remove(UploadEvent arg0) {
        this.getPageCache().remove(CACHE_FILE);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
    }

    static {
        printBusinessService = new BosPrintBusinessServiceImpl();
    }
}

