/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.designer.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.exception.OrmException;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.QueryResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormConfig;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.ITreeListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCacheUtils;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.metadata.form.DesignFormMeta;
import kd.bos.metadata.form.DesignFormMetaL;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.api.utils.ConfigConstUtil;
import kd.bos.print.business.designer.TplType;
import kd.bos.print.business.metedata.service.migrate.PrintTplImpExp;
import kd.bos.print.business.scheme.dao.CloudAppMenuDao;
import kd.bos.print.business.utils.OldPrintTemplateUtil;
import kd.bos.print.business.utils.PrintOpLogMsgEnum;
import kd.bos.print.business.utils.PrintOpLogUtils;
import kd.bos.print.business.utils.PrintParamUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.bos.svc.util.TreeNodeFilter;

public class ManagePrintTplListPlugin
extends StandardTreeListPlugin
implements RowClickEventListener,
ItemClickListener {
    private static final String PRINT_METEDATA = "bos_print_meta";
    private String PRINT_RESOURCE = "bos_print_resource";
    private static final Log log = LogFactory.getLog(ManagePrintTplListPlugin.class);
    private static final String PREFIX_APP = "app_";
    private static final String PREFIX_CLOUD = "cloud_";
    private static final String UPDATE_OLD_PRINT_TPL = "updateOldPrintTemplate";
    private static final String BTN_NEW = "btnnew";
    private static final String BTN_EDIT = "btnedit";
    private static final String BTN_DELETE = "btndel";
    private static final String TABLENAME = "t_bas_printtplinfo";
    private static final String PROJECT_NAME = "bos-print-business";
    private static final String MODELTYPE = "modeltype";
    private static final String BILLFORMID = "billformid";
    private static final String BILLLISTAP = "billlistap";
    private static final String BOS_MANAGEPRINTTPL = "bos_manageprinttpl";
    private static final String PRINTTPLID_ID = "printtplid_id";
    private static final String BOS_DEVPORTAL_UNITRELFORM = "bos_devportal_unitrelform";
    private static final String BIZAPP = "bizapp";
    private static final String BUNBER = "number";
    private static final String BIZAPPID = "bizappid";
    private static final String IDE_PRINTDESIGNER = "ide_printdesigner";
    private static final String NOTIFY_UNIQUE_KEY = "bos_manageprinttpl_newclienttips";
    private QFilter qFilter;
    private PrintTplImpExp tplImpExp = new PrintTplImpExp();
    private String errDataMsg = ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u7248\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u662f\u5386\u53f2\u810f\u6570\u636e\u5bfc\u81f4\uff0c\u8bf7\u68c0\u67e5\u786e\u8ba4\u540e\u5220\u9664\u5f53\u524d\u8bb0\u5f55\u6216\u91cd\u5efa\u6a21\u7248\u3002", (String)"ManagePrintInfoListEdit_1", (String)"bos-print-business", (Object[])new Object[0]);
    private static final String APP_IDS = "appIds";
    private static final String App_EXT_IDS = "appExtIds";
    private static final String KEY_BILLFORMID_APPID = "billformid.bizappid.id";
    public static final String KEY_FORMID = "formid";

    public void initialize() {
        super.initialize();
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_NEW, BTN_EDIT, BTN_DELETE});
    }

    public void initializeTree(EventObject e) {
        this.initTree();
    }

    public void billListGetEntityType(GetEntityTypeEventArgs args) {
        BasedataProp printTplId;
        IDataEntityType dataEntityType;
        super.billListGetEntityType(args);
        MainEntityType originalEntityType = args.getOriginalEntityType();
        if (PrintParamUtils.isOpenBizTypeExt()) {
            return;
        }
        DynamicProperty property = originalEntityType.getProperty("printtplid");
        if (property instanceof BasedataProp && (dataEntityType = (printTplId = (BasedataProp)property).getComplexType()) instanceof RefEntityType) {
            RefEntityType complexType = (RefEntityType)dataEntityType;
            ComboProp bizType = (ComboProp)complexType.getProperty("biztype");
            List comboItems = bizType.getComboItems();
            comboItems.removeIf(item -> !"0".equals(item.getValue()) && !"1".equals(item.getValue()));
        }
        args.setNewEntityType(originalEntityType);
    }

    public void setFilter(SetFilterEvent e) {
        ITreeListView treeListView;
        super.setFilter(e);
        if (this.qFilter != null) {
            List qFilters = e.getQFilters();
            e.setQFilters(new ArrayList());
            e.addCustomQFilter(this.qFilter);
        }
        if (ConfigConstUtil.isNewTenantOfVersion((int)7)) {
            e.addCustomQFilter(new QFilter("type", "!=", (Object)"A"));
        }
        if ((treeListView = this.getTreeListView()) == null) {
            return;
        }
        ITreeModel treeModel = this.getTreeModel();
        if (treeModel == null) {
            return;
        }
        String nodeId = String.valueOf(treeModel.getCurrentNodeId());
        QFilter filter = null;
        if (!this.isTopNodeId(nodeId)) {
            if (nodeId.startsWith(PREFIX_CLOUD)) {
                TreeNode treeNode = treeModel.getRoot().getTreeNode(nodeId);
                String appExtStr = this.getPageCache().get(App_EXT_IDS);
                if (treeNode != null && appExtStr != null) {
                    Map appExtMap = (Map)SerializationUtils.fromJsonString((String)appExtStr, Map.class);
                    List children = treeNode.getChildren();
                    ArrayList appIds = new ArrayList(10);
                    children.stream().map(m -> StringUtils.substringAfter((String)m.getId(), (String)"_")).forEach(appId -> {
                        appIds.add(appId);
                        List appExtIds = (List)appExtMap.get(appId);
                        if (appExtIds != null) {
                            appIds.addAll(appExtIds);
                        }
                    });
                    filter = new QFilter(KEY_BILLFORMID_APPID, "in", appIds);
                }
            } else if (nodeId.startsWith(PREFIX_APP)) {
                Map appExtMap;
                List appExtIds;
                String appId2 = StringUtils.substringAfter((String)nodeId, (String)"_");
                ArrayList<String> appIds = new ArrayList<String>(10);
                appIds.add(appId2);
                String appExtStr = this.getPageCache().get(App_EXT_IDS);
                if (appExtStr != null && (appExtIds = (List)(appExtMap = (Map)SerializationUtils.fromJsonString((String)appExtStr, Map.class)).get(appId2)) != null) {
                    appIds.addAll(appExtIds);
                }
                filter = new QFilter(KEY_BILLFORMID_APPID, "in", appIds);
            } else {
                filter = new QFilter(BILLFORMID, "=", (Object)nodeId);
            }
        } else {
            String str = this.getPageCache().get(APP_IDS);
            if (str == null) {
                return;
            }
            List appIds = SerializationUtils.fromJsonStringToList((String)str, String.class);
            filter = new QFilter(KEY_BILLFORMID_APPID, "in", (Object)appIds);
        }
        e.addCustomQFilter(filter);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.getListDataProvider();
    }

    public void packageData(PackageDataEvent e) {
        DynamicObject rowData = e.getRowData();
        DynamicObject printtpObj = rowData.getDynamicObject("printtplid");
        if (printtpObj == null) {
            if (ConfigConstUtil.isNewTenantOfVersion((int)7)) {
                return;
            }
            Object tplId = rowData.get(PRINTTPLID_ID);
            QFilter qFilter = new QFilter("id", "=", tplId);
            BasedataProp basedataProp = (BasedataProp)rowData.getDynamicObjectType().getProperty("printtplid");
            DynamicObject printObj = new DynamicObject(basedataProp.getDynamicComplexPropertyType());
            DynamicObject formMeta = OldPrintTemplateUtil.loadSingleFromCache("id,number,bizappid,basedatafield,modifierid", new QFilter[]{qFilter});
            if (formMeta == null || formMeta.getDynamicObject("basedatafield") == null) {
                Object printtplid = rowData.get(PRINTTPLID_ID);
                printObj.set("id", printtplid);
                printObj.set(BUNBER, printtplid);
                printObj.set("type", (Object)"A");
                rowData.set("printtplid", (Object)printObj);
                return;
            }
            try {
                DynamicObject metaObj = BusinessDataServiceHelper.newDynamicObject((String)PRINT_METEDATA);
                String number = (String)formMeta.get(BUNBER);
                boolean isExist = QueryServiceHelper.exists((String)PRINT_METEDATA, (QFilter[])new QFilter[]{new QFilter(BUNBER, "=", (Object)number)});
                if (isExist) {
                    number = number + "(old)";
                }
                metaObj.set("id", tplId);
                metaObj.set("masterid", tplId);
                metaObj.set(BUNBER, (Object)number);
                metaObj.set("name", formMeta.get("name"));
                DynamicObject basedatafield = formMeta.getDynamicObject("basedatafield");
                metaObj.set(KEY_FORMID, basedatafield.get(BUNBER));
                metaObj.set("creator", formMeta.get("modifierid"));
                metaObj.set("modifier", formMeta.get("modifierid"));
                metaObj.set("type", (Object)"A");
                metaObj.set(BIZAPPID, formMeta.get(BIZAPPID));
                metaObj.set("createtime", (Object)new Date());
                metaObj.set("modifytime", (Object)new Date());
                metaObj.set("status", (Object)"C");
                metaObj.set("enable", (Object)"1");
                metaObj.set("version", (Object)"1");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{metaObj});
                DataEntityCacheManager cacheManager = new DataEntityCacheManager("t_svc_printmeta");
                cacheManager.removeByPrimaryKey(new Object[]{tplId});
                printObj.set("id", metaObj.get("id"));
                printObj.set(BUNBER, (Object)number);
                printObj.set("name", metaObj.get("name"));
                printObj.set("masterid", metaObj.get("masterid"));
                printObj.set("type", metaObj.get("type"));
                rowData.set("printtplid", (Object)printObj);
                e.setRowData(rowData);
            }
            catch (Exception e1) {
                log.error((Throwable)e1);
            }
        } else {
            String bizType = printtpObj.getString("bizType");
            if (StringUtils.isBlank((CharSequence)bizType)) {
                printtpObj.set("bizType", (Object)"0");
            }
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        if (ConfigConstUtil.isNewTenantOfVersion((int)7)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"update"});
            List listColumns = args.getListColumns();
            Iterator iterator = listColumns.iterator();
            while (iterator.hasNext()) {
                IListColumn column = (IListColumn)iterator.next();
                if (!"type".equals(column.getListFieldKey())) continue;
                iterator.remove();
                break;
            }
            args.setListColumns(listColumns);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    private void initTree() {
        TreeNode root = new TreeNode();
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"ManagePrintTplListPlugin_0", (String)PROJECT_NAME, (Object[])new Object[0]));
        root.setId("root");
        root.setParentid("");
        root.setIsOpened(true);
        List<TreeNode> cloudNodes = this.getCloudNodes();
        root.setChildren(cloudNodes);
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)root.getId());
        this.setBarItemEnable(false, true);
    }

    private List<TreeNode> getCloudNodes() {
        TreeNode root = CloudAppMenuDao.getTreeIncludeAll(this.getPageCache(), "app", true);
        List clouds = null;
        clouds = root.getChildren();
        if (clouds == null) {
            return new ArrayList<TreeNode>(0);
        }
        TreeNodeFilter treeNodeFilter = new TreeNodeFilter();
        clouds = treeNodeFilter.filterCloudTreeNode(clouds);
        Iterator cloudIterator = clouds.iterator();
        while (cloudIterator.hasNext()) {
            TreeNode cloud = (TreeNode)cloudIterator.next();
            String cloudNodeId = PREFIX_CLOUD + cloud.getId();
            cloud.setId(cloudNodeId);
            cloud.setData((Object)"cloud");
            List apps = cloud.getChildren();
            apps = treeNodeFilter.filterAppTreeNode(apps);
            cloud.setChildren(apps);
            if (CollectionUtils.isEmpty((Collection)apps)) {
                cloudIterator.remove();
                continue;
            }
            for (TreeNode app : apps) {
                String appNodeId = PREFIX_APP + app.getId();
                app.setId(appNodeId);
                app.setParentid(cloudNodeId);
                app.setData((Object)"app");
                app.setChildren(null);
            }
        }
        return clouds;
    }

    private TreeNodeFilter getTreeNodeFilter() {
        String treeNodeFilterJson = this.getPageCache().get("treeNodeFilter");
        if (StringUtils.isBlank((CharSequence)treeNodeFilterJson)) {
            TreeNodeFilter treeNodeFilter = new TreeNodeFilter();
            this.getPageCache().put("treeNodeFilter", SerializationUtils.toJsonString((Object)treeNodeFilter));
            return treeNodeFilter;
        }
        return (TreeNodeFilter)SerializationUtils.fromJsonString((String)treeNodeFilterJson, TreeNodeFilter.class);
    }

    private List<TreeNode> getChildNodes(String parentId) {
        TreeNode root = this.getTreeModel().getRoot();
        if (StringUtils.equals((CharSequence)parentId, (CharSequence)root.getId())) {
            if (CollectionUtils.isEmpty((Collection)root.getChildren())) {
                return this.getCloudNodes();
            }
            return root.getChildren();
        }
        if (parentId.startsWith(PREFIX_CLOUD)) {
            String cloudId = StringUtils.substringAfter((String)parentId, (String)"_");
            return this.getAppNodes(cloudId);
        }
        return new ArrayList<TreeNode>(0);
    }

    private List<TreeNode> getAppNodes(String cloudNodeId) {
        TreeNode root = (TreeNode)BizAppServiceHelp.getRuntimeSubsysTree((String[])new String[]{cloudNodeId}, null, null, (String)"app");
        List clouds = null;
        if (root != null) {
            clouds = root.getChildren();
        }
        if (clouds == null || clouds.isEmpty()) {
            return new ArrayList<TreeNode>();
        }
        List apps = ((TreeNode)clouds.get(0)).getChildren();
        if (apps == null || apps.isEmpty()) {
            return new ArrayList<TreeNode>();
        }
        apps = this.getTreeNodeFilter().filterAppTreeNode(apps);
        for (TreeNode app : apps) {
            if (app == null) continue;
            String appNodeId = PREFIX_APP + app.getId();
            app.setId(appNodeId);
            app.setParentid(PREFIX_CLOUD + cloudNodeId);
            app.setData((Object)"app");
        }
        return apps;
    }

    private void setBarItemEnable(boolean enable, boolean isSetAll) {
        if (isSetAll) {
            this.getView().setEnable(Boolean.valueOf(enable), new String[]{BTN_NEW, BTN_EDIT, BTN_DELETE});
        } else {
            this.getView().setEnable(Boolean.valueOf(enable), new String[]{BTN_NEW});
            this.getView().setEnable(Boolean.valueOf(!enable), new String[]{BTN_EDIT, BTN_DELETE});
        }
    }

    public void afterCreateNewData(EventObject e) {
        ListShowParameter listShowParameter;
        FormShowParameter showParameter;
        String setting = UserConfigServiceHelper.getSetting((long)RequestContext.get().getCurrUserId(), (String)NOTIFY_UNIQUE_KEY);
        if (null == setting && (showParameter = this.getView().getFormShowParameter()) instanceof ListShowParameter && !(listShowParameter = (ListShowParameter)this.getView().getFormShowParameter()).isLookUp()) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.NonModal);
            parameter.setFormId("bos_clientguide_tips");
            this.getView().showForm(parameter);
        }
    }

    public void refreshNode(RefreshNodeEvent e) {
        String nodeId = e.getNodeId().toString();
        List<TreeNode> childNodes = this.getChildNodes(nodeId);
        e.setChildNodes(childNodes);
    }

    public void treeNodeClick(TreeNodeEvent treenodeevent) {
        this.getTreeModel().setNodeClickExpand(false);
        String nodeId = treenodeevent.getNodeId().toString();
        this.getPageCache().put("nodeId", nodeId);
        this.getTreeModel().refreshNode((Object)nodeId);
        super.treeNodeClick(treenodeevent);
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        e.setCancel(true);
    }

    private boolean isTopNodeId(String currNodeId) {
        return currNodeId.equals(this.getTreeModel().getRoot().getId());
    }

    public void billListHyperLinkClick(HyperLinkClickArgs evt) {
        boolean isHasPermisson = ManagePrintTplListPlugin.checkPagePermission("47150e89000000ac");
        if (!isHasPermisson) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u8be2\u6743\u9650\uff0c\u8bf7\u6dfb\u52a0\u6743\u9650\u540e\u518d\u8bd5\u3002", (String)"ManagePrintTplListPlugin_1", (String)PROJECT_NAME, (Object[])new Object[0]));
        }
        FormConfig formConfig = this.getView().getFormShowParameter().getFormConfig();
        if (formConfig != null && "bos_listf7".equals(formConfig.getEntityTypeId())) {
            evt.setCancel(true);
            return;
        }
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        ListSelectedRow listSelectedRow = billList.getCurrentSelectedRowInfo();
        Long pkid = (Long)listSelectedRow.getPrimaryKeyValue();
        DynamicObject infoObj = BusinessDataServiceHelper.loadSingle((Object)pkid, (String)BOS_MANAGEPRINTTPL, (String)"printtplid_id,type");
        String tplId = infoObj.getString(PRINTTPLID_ID);
        String printType = infoObj.getString("type");
        if ("B".equals(printType)) {
            this.gotoPrintDesigner(tplId);
        } else {
            this.gotoOldPrintDesigner(tplId);
        }
        evt.setCancel(true);
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        BillShowParameter param = e.getParameter();
        String currentNodeId = this.getTreeModel().getCurrentNodeId().toString();
        String rootId = this.getTreeModel().getRoot().getId();
        if (currentNodeId.contains(PREFIX_CLOUD) || currentNodeId.contains(PREFIX_APP) || rootId.equals(currentNodeId)) {
            return;
        }
        param.setCustomParam("tree_parent_id", null);
        param.setCustomParam(BILLFORMID, (Object)currentNodeId);
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operateKey = evt.getOperateKey();
        if (evt.getOperationResult() != null && evt.getOperationResult().isSuccess()) {
            if ("donothing_upgrade".equals(operateKey)) {
                String currentNodeId = this.getTreeModel().getCurrentNodeId().toString();
                FormShowParameter parameter = new FormShowParameter();
                String curNodeId = currentNodeId.replace(PREFIX_APP, "");
                curNodeId = curNodeId.replace(PREFIX_CLOUD, "");
                parameter.getCustomParams().put("currentNodeId", curNodeId);
                parameter.setFormId("bos_tpl_update_tool");
                CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, UPDATE_OLD_PRINT_TPL);
                parameter.setCloseCallBack(callBack);
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setCaption(ResManager.loadKDString((String)"\u6a21\u677f\u5347\u7ea7", (String)"ManagePrintTplListPlugin_31", (String)PROJECT_NAME, (Object[])new Object[0]));
                this.getView().showForm(parameter);
            } else if ("donothing_new".equals(operateKey)) {
                String currentNodeId = this.getTreeModel().getCurrentNodeId().toString();
                FormShowParameter parameter = new FormShowParameter();
                String curNodeId = currentNodeId.replace(PREFIX_APP, "");
                curNodeId = curNodeId.replace(PREFIX_CLOUD, "");
                parameter.getCustomParams().put("currentNodeId", curNodeId);
                parameter.setFormId("bos_newtpl_guide");
                CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "createPrintTemplate");
                parameter.setCloseCallBack(callBack);
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setCaption(ResManager.loadKDString((String)"\u521b\u5efa\u6253\u5370\u6a21\u677f", (String)"ManagePrintTplListPlugin_2", (String)PROJECT_NAME, (Object[])new Object[0]));
                this.getView().showForm(parameter);
            } else if ("donothing_delete".equals(operateKey)) {
                this.deleteInfo();
            } else if ("donothing_copy".equals(operateKey)) {
                this.copyPrintTemplate();
            } else if ("donothing_import".equals(operateKey)) {
                this.doImport();
            } else if ("donothing_export".equals(operateKey)) {
                this.doExport();
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("tblsetdefault".equals(itemKey)) {
            this.setTblDefaultState(itemKey, ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u677f\u4e3a\u7981\u7528\u72b6\u6001\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u4e3a\u9ed8\u8ba4\u6a21\u677f\u3002", (String)"ManagePrintTplListPlugin_5", (String)PROJECT_NAME, (Object[])new Object[0]), "ManagePrintTplListPlugin_5");
        } else if ("tblsetundefault".equals(itemKey)) {
            this.setTblDefaultState(itemKey, ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u677f\u4e3a\u7981\u7528\u72b6\u6001\uff0c\u65e0\u6cd5\u64a4\u9500\u9ed8\u8ba4\u6a21\u677f\u3002", (String)"ManagePrintTplListPlugin_6", (String)PROJECT_NAME, (Object[])new Object[0]), "ManagePrintTplListPlugin_6");
        } else if ("importsetting".equals(itemKey)) {
            this.showPrintTplType();
        } else if ("tbldisable".equals(itemKey)) {
            BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
            PrintOpLogUtils.addLog((IFormView)this.getView(), (ListSelectedRowCollection)billList.getSelectedRows(), (PrintOpLogMsgEnum)PrintOpLogMsgEnum.TPL_DISABLE);
        } else if ("tblenable".equals(itemKey)) {
            BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
            PrintOpLogUtils.addLog((IFormView)this.getView(), (ListSelectedRowCollection)billList.getSelectedRows(), (PrintOpLogMsgEnum)PrintOpLogMsgEnum.TPL_ENABLE);
        }
    }

    private void showPrintTplType() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_printtpltype");
        OpenStyle style = new OpenStyle();
        style.setShowType(ShowType.Modal);
        showParameter.setOpenStyle(style);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if ("createPrintTemplate".equals(e.getActionId()) || "copyPrintTemplate".equals(e.getActionId())) {
            Map returnData = (Map)e.getReturnData();
            if (returnData != null) {
                String tplId = (String)returnData.get("tplId");
                String printV = (String)returnData.get("printV");
                if ("B".equals(printV)) {
                    this.getTreeListView().refresh();
                    this.gotoPrintDesigner(tplId);
                } else {
                    tplId = (String)returnData.get("id");
                    DataEntityCacheManager cacheManager = new DataEntityCacheManager("t_svc_printmeta");
                    cacheManager.removeByPrimaryKey(new Object[]{tplId});
                    this.getTreeListView().refresh();
                    this.gotoOldPrintDesigner(tplId);
                }
            }
        } else if ("doImport".equals(e.getActionId())) {
            this.getTreeListView().refresh();
        } else if (UPDATE_OLD_PRINT_TPL.equals(e.getActionId())) {
            Map returnData = (Map)e.getReturnData();
            this.refreshBillDataAfterUpdateTpl(returnData);
        }
    }

    private void refreshBillDataAfterUpdateTpl(Map<String, List<String>> returnData) {
        QFilter filter;
        List<String> newTplIds;
        this.getView().getControl(BILLLISTAP);
        try {
            newTplIds = returnData.get("newTplIds");
        }
        catch (Exception ex) {
            log.info(ex.getMessage());
            return;
        }
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        this.qFilter = filter = new QFilter("printtplid", "in", newTplIds);
        billList.refresh();
    }

    private void doExport() {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a21\u677f\u5bfc\u51fa\u3002", (String)"ManagePrintTplListPlugin_8", (String)PROJECT_NAME, (Object[])new Object[0]));
            return;
        }
        Map<String, List<String>> classifyMap = this.classifyPackTplId();
        List<String> newCanDelTplIds = classifyMap.get("newCanDelTplIds");
        List<String> newTplCannotDelNumbers = classifyMap.get("newTplCannotDelNumbers");
        ArrayList<String> tplidList = new ArrayList<String>(10);
        tplidList.addAll(newCanDelTplIds);
        tplidList.addAll(newTplCannotDelNumbers);
        if (selectedRows.size() != tplidList.size()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e7\u6a21\u677f\u4e0d\u652f\u6301\u5bfc\u51fa\u3002", (String)"ManagePrintTplListPlugin_9", (String)PROJECT_NAME, (Object[])new Object[0]));
            return;
        }
        if (newTplCannotDelNumbers.size() != 0) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u9884\u7f6e\u6a21\u677f\u4e0d\u652f\u6301\u5bfc\u51fa\uff1a%s\u3002", (String)"ManagePrintTplListPlugin_35", (String)PROJECT_NAME, (Object[])new Object[0]), StringUtils.join((Object[])newTplCannotDelNumbers.toArray(), (String)"\uff0c")));
            return;
        }
        if (tplidList.size() > 1000) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u5927\u652f\u6301\u5bfc\u51fa1000\u4e2a\u6a21\u677f\u3002", (String)"ManagePrintTplListPlugin_33", (String)PROJECT_NAME, (Object[])new Object[0]));
            return;
        }
        try {
            String url = this.tplImpExp.doExport(tplidList, 5000);
            PrintOpLogUtils.addLog((IFormView)this.getView(), (ListSelectedRowCollection)selectedRows, (PrintOpLogMsgEnum)PrintOpLogMsgEnum.TPL_EXPORT);
            this.getView().download(url);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6a21\u677f\u5bfc\u51fa\u5931\u8d25\u3002", (String)"ManagePrintTplListPlugin_10", (String)PROJECT_NAME, (Object[])new Object[0]));
        }
    }

    private void doImport() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_import_printtpl");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("TplType", (Object)TplType.PrintTpl);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "doImport");
        parameter.setCloseCallBack(callBack);
        this.getView().showForm(parameter);
    }

    private void setTblDefaultState(String itemKey, String description, String resourceID) {
        boolean isHasPermisson = ManagePrintTplListPlugin.checkPagePermission("4715a0df000000ac");
        if (!isHasPermisson) {
            throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u7f16\u8f91\u201d\u6743\u9650\uff0c\u8bf7\u6dfb\u52a0\u6743\u9650\u540e\u518d\u8bd5\u3002", (String)"ManagePrintTplListPlugin_11", (String)PROJECT_NAME, (Object[])new Object[0]));
        }
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.isEmpty()) {
            return;
        }
        if (selectedRows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u3002", (String)"ManagePrintTplListPlugin_12", (String)PROJECT_NAME, (Object[])new Object[0]));
            return;
        }
        int focusRow = billList.getEntryState().getFocusRow();
        ListSelectedRow listSelectedRow = selectedRows.get(0);
        Long pkid = (Long)listSelectedRow.getPrimaryKeyValue();
        Map cacheObjs = BusinessDataServiceHelper.loadFromCache((Object[])new Object[]{pkid}, (String)BOS_MANAGEPRINTTPL);
        DynamicObject infoObj = (DynamicObject)cacheObjs.get(pkid);
        if (infoObj == null) {
            return;
        }
        Object printtplid = infoObj.get("printtplid");
        if (printtplid == null) {
            this.getView().showMessage(this.errDataMsg);
            return;
        }
        String formId = infoObj.getString("billformId_id");
        boolean tplEnable = this.getTplEnable(pkid);
        if (!tplEnable) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)description, (String)resourceID, (String)PROJECT_NAME, (Object[])new Object[0]));
            return;
        }
        if (this.getIsdefault(pkid) && "tblsetdefault".equals(itemKey)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u4e3a\u9ed8\u8ba4\u6a21\u677f\u72b6\u6001\u3002", (String)"ManagePrintTplListPlugin_13", (String)PROJECT_NAME, (Object[])new Object[0]));
            return;
        }
        if (!this.getIsdefault(pkid) && "tblsetundefault".equals(itemKey)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u4e3a\u975e\u9ed8\u8ba4\u6a21\u677f\u72b6\u6001\u3002", (String)"ManagePrintTplListPlugin_14", (String)PROJECT_NAME, (Object[])new Object[0]));
            return;
        }
        this.updateInfo(pkid, formId, itemKey);
        this.getTreeListView().refresh();
        billList.selectRows(focusRow);
        if ("tblsetdefault".equals(itemKey)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8bbe\u4e3a\u9ed8\u8ba4\u6a21\u677f\u6210\u529f\u3002", (String)"ManagePrintTplListPlugin_15", (String)PROJECT_NAME, (Object[])new Object[0]));
            PrintOpLogUtils.addLog((IFormView)this.getView(), (ListSelectedRowCollection)selectedRows, (PrintOpLogMsgEnum)PrintOpLogMsgEnum.TPL_SET_DEFAULT);
            return;
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64a4\u9500\u9ed8\u8ba4\u6a21\u677f\u6210\u529f\u3002", (String)"ManagePrintTplListPlugin_16", (String)PROJECT_NAME, (Object[])new Object[0]));
        PrintOpLogUtils.addLog((IFormView)this.getView(), (ListSelectedRowCollection)selectedRows, (PrintOpLogMsgEnum)PrintOpLogMsgEnum.TPL_SET_UN_DEFAULT);
    }

    public boolean getTplEnable(Long pkid) {
        boolean enable = false;
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", (Object)pkid)};
        DynamicObject pageRelInfo = QueryServiceHelper.queryOne((String)BOS_MANAGEPRINTTPL, (String)"enable", (QFilter[])qFilters);
        String tplenable = (String)pageRelInfo.get("enable");
        if (tplenable.equals("1")) {
            enable = true;
        }
        return enable;
    }

    public boolean getIsdefault(Long pkid) {
        boolean isdefault = false;
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", (Object)pkid)};
        DynamicObject pageRelInfo = QueryServiceHelper.queryOne((String)BOS_MANAGEPRINTTPL, (String)"isdefault", (QFilter[])qFilters);
        Boolean tblsetdefault = (Boolean)pageRelInfo.get("isdefault");
        if (tblsetdefault.booleanValue()) {
            isdefault = true;
        }
        return isdefault;
    }

    private void gotoPrintDesigner(String id) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(IDE_PRINTDESIGNER);
        parameter.setCustomParam("id", (Object)id);
        parameter.setCustomParam("tplType", (Object)TplType.PrintTpl.toString());
        parameter.getOpenStyle().setShowType(ShowType.NewWindow);
        this.getView().showForm(parameter);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
    }

    private void gotoOldPrintDesigner(String id) {
        QFilter qFormId = new QFilter("form", "=", (Object)id);
        DynamicObject pageRelInfo = QueryServiceHelper.queryOne((String)BOS_DEVPORTAL_UNITRELFORM, (String)"bizapp,bizunit", (QFilter[])new QFilter[]{qFormId});
        if (StringUtils.isBlank((Object)pageRelInfo)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5173\u8054\u7684\u5355\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002", (String)"ManagePrintTplListPlugin_18", (String)PROJECT_NAME, (Object[])new Object[0]));
            return;
        }
        String appId = pageRelInfo.getString(BIZAPP);
        DynamicObject pageInfo = OldPrintTemplateUtil.loadSingleFromCache(id);
        if (pageInfo == null) {
            this.getView().showMessage(this.errDataMsg);
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ide_formdesigner");
        parameter.setCustomParam("id", (Object)id);
        parameter.setCustomParam(BUNBER, pageInfo.get(BUNBER));
        parameter.setCustomParam(BIZAPPID, (Object)appId);
        parameter.setClientParam(MODELTYPE, pageInfo.get(MODELTYPE));
        parameter.setClientParam("modelver", (Object)DomainModelType.getVersion());
        parameter.getOpenStyle().setShowType(ShowType.NewWindow);
        this.getView().showForm(parameter);
    }

    private static boolean checkPagePermission(String permissionItemId) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        int flag = PermissionServiceHelper.checkFunctionPermission((long)userId, (long)0L, (String)BOS_MANAGEPRINTTPL, (String)permissionItemId);
        boolean isHasPermission = flag == 1;
        return isHasPermission;
    }

    private void copyPrintTemplate() {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u590d\u5236\u7684\u6a21\u677f\u3002", (String)"ManagePrintTplListPlugin_19", (String)PROJECT_NAME, (Object[])new Object[0]));
            return;
        }
        if (selectedRows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u590d\u5236\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"ManagePrintTplListPlugin_34", (String)PROJECT_NAME, (Object[])new Object[0]));
            return;
        }
        ListSelectedRow listSelectedRow = selectedRows.get(0);
        Long pkid = (Long)listSelectedRow.getPrimaryKeyValue();
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((Object)pkid, (String)BOS_MANAGEPRINTTPL);
        if (obj == null) {
            ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5b58\u5728\u4e0d\u80fd\u590d\u5236\u3002", (String)"ManagePrintTplListPlugin_30", (String)PROJECT_NAME, (Object[])new Object[0]);
            return;
        }
        DynamicObject printMeta = obj.getDynamicObject("printtplid");
        if (printMeta == null) {
            this.getView().showMessage(this.errDataMsg);
            return;
        }
        String tplType = printMeta.getString("type");
        if ("A".equalsIgnoreCase(tplType)) {
            if (ConfigConstUtil.isOldPrintClose()) {
                String msg = ResManager.loadKDString((String)"\u65e7\u6a21\u677f\u4e0d\u652f\u6301\u590d\u5236\u3002", (String)"ManagePrintTplListPlugin_20", (String)PROJECT_NAME, (Object[])new Object[0]);
                this.getView().showTipNotification(msg);
                return;
            }
            String currentIsv = ISVService.getISVInfo().getId();
            if (StringUtils.isBlank((CharSequence)currentIsv)) {
                String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e2d\u5fc3\u672a\u6ce8\u518c\u5f00\u53d1\u5546\uff0c\u8bf7\u7528\u8d85\u7ea7\u7ba1\u7406\u5458\u8d26\u53f7\u767b\u5f55\u5e76\u6ce8\u518c\u5f00\u53d1\u5546\u3002", (String)"ManagePrintInfoListEdit_0", (String)PROJECT_NAME, (Object[])new Object[0]);
                throw new KDBizException(errorMsg);
            }
            String tplId = obj.getString(PRINTTPLID_ID);
            String bizUnitId = this.getUnitId(tplId);
            String bizAppId = this.getAppId(tplId);
            String number = (String)obj.get("printtplid.number");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(MODELTYPE, "PrintModel");
            map.put("bizunitid", bizUnitId);
            map.put(BIZAPPID, bizAppId);
            map.put("bizentity", tplId);
            map.put(BUNBER, number);
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("bos_devp_copyprinttpl");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCustomParams(map);
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "copyPrintTemplate");
            parameter.setCloseCallBack(callBack);
            this.getView().showForm(parameter);
        } else {
            String tplId = obj.getString(PRINTTPLID_ID);
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("bos_copyprinttpl");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            HashMap<String, String> customParam = new HashMap<String, String>();
            customParam.put("oriTplId", tplId);
            parameter.setCustomParams(customParam);
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "copyPrintTemplate");
            parameter.setCloseCallBack(callBack);
            this.getView().showForm(parameter);
        }
    }

    private String getUnitId(String fromId) {
        String unitId = "";
        QFilter qFormId = new QFilter("form", "=", (Object)fromId);
        DynamicObject pageRelInfo = QueryServiceHelper.queryOne((String)BOS_DEVPORTAL_UNITRELFORM, (String)"bizunit", (QFilter[])new QFilter[]{qFormId});
        if (!StringUtils.isBlank((Object)pageRelInfo)) {
            unitId = pageRelInfo.getString("bizunit");
        }
        return unitId;
    }

    private String getAppId(String fromId) {
        String appId = "";
        QFilter qFormId = new QFilter("form", "=", (Object)fromId);
        DynamicObject pageRelInfo = QueryServiceHelper.queryOne((String)BOS_DEVPORTAL_UNITRELFORM, (String)BIZAPP, (QFilter[])new QFilter[]{qFormId});
        if (!StringUtils.isBlank((Object)pageRelInfo)) {
            appId = pageRelInfo.getString(BIZAPP);
        }
        return appId;
    }

    private void updateInfo(Long id, String billFormId, String fisdefault) {
        String UPDATEOTHER_SQL = "update %s set  fisdefault = ? where fbillformid = ? and fid <> ?";
        String UPDATE_SQL = "update %s set  fisdefault = ? where fid = ?";
        String sql = String.format(UPDATE_SQL, TABLENAME);
        String fisdefaultSelf = "1";
        String fisdefaultOtrher = "0";
        Object[] params = new SqlParameter[2];
        if ("tblsetundefault".equals(fisdefault)) {
            fisdefaultSelf = "0";
            fisdefaultOtrher = "0";
        }
        params[0] = new SqlParameter("fisdefault", 1, (Object)fisdefaultSelf);
        params[1] = new SqlParameter("fid", -5, (Object)id);
        String sql1 = String.format(UPDATEOTHER_SQL, TABLENAME);
        Object[] otherParams = new SqlParameter[]{new SqlParameter("fisdefault", 1, (Object)fisdefaultOtrher), new SqlParameter("fbillformid", 12, (Object)billFormId), new SqlParameter("fid", -5, (Object)id)};
        try (TXHandle h = TX.required();){
            DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
            if ("tblsetdefault".equals(fisdefault)) {
                DB.execute((DBRoute)DBRoute.basedata, (String)sql1, (Object[])otherParams);
            }
        }
        catch (Throwable e) {
            if (e instanceof KDException) {
                throw (KDException)e;
            }
            if (e instanceof OrmException) {
                throw (OrmException)e;
            }
            throw new KDException(e, BosErrorCode.sQL, new Object[]{String.format("Error:%s.", e.getMessage())});
        }
    }

    private void deleteInfo() {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows == null || selectedRows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u6a21\u677f\u3002", (String)"ManagePrintTplListPlugin_21", (String)PROJECT_NAME, (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u5f53\u524d\u6a21\u677f\uff0c\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u8ba4\u8981\u5220\u9664\u5f53\u524d\u6a21\u677f\u5417\uff1f", (String)"ManagePrintTplListPlugin_22", (String)PROJECT_NAME, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("deleteTpls", (IFormPlugin)this));
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (callBackId.equals("deleteTpls") && event.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.deleteTpls();
        }
    }

    private void deleteTpls() {
        int unusualSuccess;
        int oldDelSuccess;
        Map<String, List<String>> classifyMap = this.classifyPackTplId();
        List<String> newTplCannotDelNumbers = classifyMap.get("newTplCannotDelNumbers");
        List<String> newCanDelTplIds = classifyMap.get("newCanDelTplIds");
        List<String> oldCanDelTplIds = classifyMap.get("oldCanDelTplIds");
        List<String> oldNotDelTplIds = classifyMap.get("oldNotDelTplIds");
        List<String> unusualCanDelTplIds = classifyMap.get("unusualCanDelTplIds");
        int count = newCanDelTplIds.size() + oldCanDelTplIds.size() + oldNotDelTplIds.size() + unusualCanDelTplIds.size() + newTplCannotDelNumbers.size();
        int newDelSuccess = this.deleteNewTpls(newCanDelTplIds);
        int successCount = newDelSuccess + (oldDelSuccess = this.deleteOldTpls(oldCanDelTplIds)) + (unusualSuccess = this.deleteUnusualTpls(unusualCanDelTplIds));
        if (successCount == count) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"ManagePrintTplListPlugin_23", (String)PROJECT_NAME, (Object[])new Object[0]));
            BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
            PrintOpLogUtils.addLog((IFormView)this.getView(), (ListSelectedRowCollection)billList.getSelectedRows(), (PrintOpLogMsgEnum)PrintOpLogMsgEnum.TPL_DELETE);
        } else {
            ArrayList<String> failNumbers = new ArrayList<String>(10);
            failNumbers.addAll(oldNotDelTplIds);
            failNumbers.addAll(newTplCannotDelNumbers);
            this.showDelErrorInfo(count, successCount, failNumbers);
        }
        this.getView().invokeOperation("refresh");
    }

    private Map<String, List<String>> classifyPackTplId() {
        HashMap<String, List<String>> classifyMap = new HashMap<String, List<String>>();
        ArrayList<String> newTplCannotDelNumbers = new ArrayList<String>();
        ArrayList<String> newCanDelTplIds = new ArrayList<String>();
        ArrayList<String> oldCanDelTplIds = new ArrayList<String>();
        ArrayList<String> oldNotDelTplIds = new ArrayList<String>();
        ArrayList<String> unusualCanDelTplIds = new ArrayList<String>();
        DynamicObjectCollection collection = this.getSelectRows();
        ArrayList<String> oldTplIds = new ArrayList<String>(10);
        for (DynamicObject obj : collection) {
            DynamicObject tplObj = obj.getDynamicObject("printtplid");
            if (tplObj == null) {
                unusualCanDelTplIds.add(obj.getString(PRINTTPLID_ID));
                continue;
            }
            String tylType = tplObj.getString("type");
            String tplId = tplObj.getString("id");
            String tplNumber = tplObj.getString(BUNBER);
            if ("B".equals(tylType)) {
                String isv = obj.getString("printtplid.isv");
                String tplType = obj.getString("printtplid.tpltype");
                if (StringUtils.isNotBlank((CharSequence)isv) && !isv.equals(ISVService.getISVInfo().getId())) {
                    newTplCannotDelNumbers.add(tplNumber);
                    continue;
                }
                if ("1".equals(tplType)) {
                    newTplCannotDelNumbers.add(tplNumber);
                    continue;
                }
                newCanDelTplIds.add(tplId);
                continue;
            }
            oldTplIds.add(tplId);
        }
        if (!oldTplIds.isEmpty()) {
            Map oldMap = BusinessDataServiceHelper.loadFromCache((String)"bos_formmeta", (String)"id,isv,number", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)oldTplIds.toArray())});
            for (String oldTplId : oldTplIds) {
                if (oldMap.containsKey(oldTplId)) {
                    DynamicObject dynamicObject = (DynamicObject)oldMap.get(oldTplId);
                    String currentIsv = ISVService.getISVInfo().getId();
                    boolean isKingdee = StringUtils.equals((CharSequence)currentIsv, (CharSequence)"kingdee");
                    if (isKingdee || String.valueOf(dynamicObject.getString("isv")).equalsIgnoreCase(currentIsv)) {
                        oldCanDelTplIds.add(oldTplId);
                        continue;
                    }
                    oldNotDelTplIds.add(dynamicObject.getString(BUNBER));
                    continue;
                }
                oldCanDelTplIds.add(oldTplId);
            }
        }
        classifyMap.put("newCanDelTplIds", newCanDelTplIds);
        classifyMap.put("oldCanDelTplIds", oldCanDelTplIds);
        classifyMap.put("oldNotDelTplIds", oldNotDelTplIds);
        classifyMap.put("unusualCanDelTplIds", unusualCanDelTplIds);
        classifyMap.put("newTplCannotDelNumbers", newTplCannotDelNumbers);
        return classifyMap;
    }

    private DynamicObjectCollection getSelectRows() {
        ListView listview = (ListView)this.getView();
        ListSelectedRowCollection selectedRows = listview.getSelectedRows();
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        QueryResult queryResult = billList.queryDataBySelectedRows(selectedRows);
        DynamicObjectCollection collection = queryResult.getCollection();
        return collection;
    }

    private int deleteUnusualTpls(List<String> unusualCanDelTplIds) {
        int success = 0;
        if (unusualCanDelTplIds == null || unusualCanDelTplIds.isEmpty()) {
            return success;
        }
        QFilter qFilter = new QFilter("id", "in", unusualCanDelTplIds);
        DeleteServiceHelper.delete((String)PRINT_METEDATA, (QFilter[])new QFilter[]{qFilter});
        qFilter = new QFilter("printtplid", "in", unusualCanDelTplIds);
        DeleteServiceHelper.delete((String)this.PRINT_RESOURCE, (QFilter[])new QFilter[]{qFilter});
        success = DeleteServiceHelper.delete((String)BOS_MANAGEPRINTTPL, (QFilter[])new QFilter[]{qFilter});
        return success;
    }

    private int deleteNewTpls(List<String> newCanDelTplIds) {
        int success = 0;
        if (newCanDelTplIds == null || newCanDelTplIds.isEmpty()) {
            return success;
        }
        try (TXHandle tx = TX.required();){
            QFilter qFilter = new QFilter("id", "in", newCanDelTplIds);
            success = DeleteServiceHelper.delete((String)PRINT_METEDATA, (QFilter[])new QFilter[]{qFilter});
            qFilter = new QFilter("printtplid", "in", newCanDelTplIds);
            DeleteServiceHelper.delete((String)this.PRINT_RESOURCE, (QFilter[])new QFilter[]{qFilter});
            DeleteServiceHelper.delete((String)BOS_MANAGEPRINTTPL, (QFilter[])new QFilter[]{qFilter});
        }
        return success;
    }

    private int deleteOldTpls(List<String> oldCanDelTplIds) {
        Object[] canDelTplIds;
        if (oldCanDelTplIds == null || oldCanDelTplIds.isEmpty()) {
            return 0;
        }
        String isvName = ISVService.getISVInfo().getName();
        if (isvName == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u5f53\u524d\u6570\u636e\u4e2d\u5fc3\u672a\u6ce8\u518c\u5f00\u53d1\u5546\uff0c\u8bf7\u7528\u8d85\u7ea7\u7528\u6237\u767b\u5f55\u5e76\u6ce8\u518c\u5f00\u53d1\u5546\u3002", (String)"ManagePrintTplListPlugin_24", (String)PROJECT_NAME, (Object[])new Object[0]));
        }
        ArrayList<String> canDelTplNumbers = new ArrayList<String>(10);
        for (Object id : canDelTplIds = oldCanDelTplIds.toArray()) {
            canDelTplNumbers.add(MetadataDao.getNumberById((String)((String)id)));
        }
        int successCount = 0;
        try (TXHandle tx = TX.required();){
            QFilter qFilter = new QFilter("printtplid", "in", (Object)canDelTplIds);
            successCount = DeleteServiceHelper.delete((String)BOS_MANAGEPRINTTPL, (QFilter[])new QFilter[]{qFilter});
            qFilter = new QFilter("id", "in", (Object)canDelTplIds);
            int pSuccessCount = DeleteServiceHelper.delete((String)PRINT_METEDATA, (QFilter[])new QFilter[]{qFilter});
            if (successCount != pSuccessCount || successCount != canDelTplIds.length) {
                tx.markRollback();
                successCount = 0;
            }
        }
        if (successCount == canDelTplIds.length) {
            tx = TX.requiresNew();
            var7_10 = null;
            try {
                BusinessDataWriter.delete((IDataEntityType)OrmUtils.getDataEntityType(DesignFormMeta.class), (Object[])canDelTplIds);
                BusinessDataWriter.delete((IDataEntityType)OrmUtils.getDataEntityType(DesignFormMetaL.class), (Object[])canDelTplIds);
                for (String tplNumber : canDelTplNumbers) {
                    MetaCacheUtils.removeDistributeCache((String[])new String[]{tplNumber});
                }
            }
            catch (Throwable throwable) {
                var7_10 = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (var7_10 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var7_10.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        return successCount;
    }

    public void showDelErrorInfo(int allCount, int successCount, List<String> oldNotDelTplIds) {
        String isvName = ISVService.getISVInfo().getName();
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("bos_operationresult");
        parameters.setShowTitle(false);
        String title = String.format(ResManager.loadKDString((String)"\u5171%1$s\u5f20\u5355\u636e\uff0c\u5220\u9664\u6210\u529f%2$s\u5f20\uff0c\u5931\u8d25%3$s\u5f20\u3002", (String)"ManagePrintTplListPlugin_25", (String)PROJECT_NAME, (Object[])new Object[0]), allCount, successCount, allCount - successCount);
        parameters.setCustomParam("title", (Object)title);
        String msg = String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u9884\u7f6e\u6a21\u677f\u4e0d\u652f\u6301\u5220\u9664\uff1a\n%s", (String)"ManagePrintTplListPlugin_26", (String)PROJECT_NAME, (Object[])new Object[0]), StringUtils.join((Object[])oldNotDelTplIds.toArray(), (String)","));
        parameters.setCustomParam("errorMsg", (Object)msg);
        this.getView().showForm(parameters);
    }

    public void search(SearchEnterEvent evt) {
        String searchText = evt.getText();
        TreeNode root = this.getTreeModel().getRoot();
        if (CollectionUtils.isEmpty((Collection)root.getChildren())) {
            return;
        }
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        String matchNodesCacheKey = this.getView().getPageId() + "_matchNodes";
        String oldSearchTextCacheKey = this.getView().getPageId() + "_oldSearchText";
        String oldSearchText = pageCache.get(oldSearchTextCacheKey);
        String matchNodesCache = pageCache.get(matchNodesCacheKey);
        if (oldSearchText != null && !oldSearchText.equals(searchText) || StringUtils.isBlank((CharSequence)matchNodesCache)) {
            Map<String, String> apps = this.searchApp(searchText);
            Set<String> clouds = this.searchCloud(root, searchText);
            clouds.addAll(apps.values());
            root.iterate(1, node -> {
                if ((node.getChildren() == null || node.getChildren().size() == 0) && clouds.contains(node.getId())) {
                    List<TreeNode> children = this.getChildNodes(node.getId());
                    this.getTreeModel().addNodes((Object)node.getId(), children);
                }
            });
        }
        super.search(evt);
        String currentNodeId = (String)this.getTreeModel().getCurrentNodeId();
        TreeNode treeNode = this.getTreeModel().getRoot().getTreeNode(currentNodeId);
        if ("app".equals(treeNode.getData())) {
            String parentId = PREFIX_CLOUD + treeNode.getParentid();
            this.getTreeListView().getTreeView().expand(parentId);
        }
        this.getTreeListView().getTreeView().focusNode(treeNode);
    }

    private Map<String, String> searchApp(String searchText) {
        String likeExp = String.format("%%%s%%", searchText);
        List<DynamicObject> objs = this.getApps(new QFilter[]{new QFilter("name", "like", (Object)likeExp)}, true, true);
        HashMap<String, String> apps = new HashMap<String, String>(objs != null ? objs.size() : 0);
        for (DynamicObject obj : objs) {
            apps.put(PREFIX_APP + obj.getString("id"), PREFIX_CLOUD + obj.getString("bizcloud_id"));
        }
        return apps;
    }

    private Set<String> searchCloud(TreeNode root, String searchText) {
        HashSet<String> cloud = new HashSet<String>();
        for (TreeNode node : root.getChildren()) {
            if (!node.getText().contains(searchText)) continue;
            cloud.add(PREFIX_CLOUD + node.getId());
        }
        return cloud;
    }

    private List<DynamicObject> getApps(QFilter[] filters, boolean isRuntime, boolean onlyVisible) {
        QFilter mstEmpty;
        QFilter mstNotNUll;
        QFilter[] mstfilters;
        Map appExtends;
        filters = RunModeServiceHelper.getAppAndCloudBlacklistFilters((QFilter[])filters, (String)"id", (String)"bizcloud");
        Map appsMap = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizapp", (String)"id,name,number,type,industry,bizcloud,sequence,visible", (QFilter[])filters, (String)"sequence asc");
        HashSet<String> extendedAppIds = new HashSet<String>();
        if (isRuntime && onlyVisible && (appExtends = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizapp", (String)"masterid,visible", (QFilter[])(mstfilters = new QFilter[]{mstNotNUll = new QFilter("masterid", "is not null", (Object)Boolean.TRUE), mstEmpty = new QFilter("masterid", "!=", (Object)" ")}))).size() > 0) {
            for (DynamicObject obj : appExtends.values()) {
                extendedAppIds.add(obj.getString("masterid"));
            }
        }
        ArrayList<DynamicObject> apps = new ArrayList<DynamicObject>();
        if (appsMap != null) {
            for (DynamicObject obj : appsMap.values()) {
                String appId = obj.getString("id");
                String appNum = obj.getString(BUNBER);
                if (isRuntime && onlyVisible) {
                    if ("portal".equals(appNum)) continue;
                    if (extendedAppIds.contains(appId)) {
                        AppInfo appInfo = AppMetadataCache.getAppInfo((String)appNum);
                        if (!appInfo.isRealRuntime()) continue;
                        obj.set("name", (Object)appInfo.getName());
                    } else {
                        boolean visible = obj.getBoolean("visible");
                        if (!visible) continue;
                    }
                }
                apps.add(obj);
            }
        }
        final Map<Object, DynamicObject> cloudsMap = ManagePrintTplListPlugin.getClouds(null);
        try {
            Collections.sort(apps, new Comparator<DynamicObject>(){

                @Override
                public int compare(DynamicObject o1, DynamicObject o2) {
                    if (o1.getString("bizcloud_id").equals(o2.getString("bizcloud_id"))) {
                        return 0;
                    }
                    DynamicObject obj1 = (DynamicObject)cloudsMap.get(o1.getString("bizcloud_id"));
                    DynamicObject obj2 = (DynamicObject)cloudsMap.get(o2.getString("bizcloud_id"));
                    if (obj1 != null && obj2 != null && StringUtils.isNotBlank((Object)obj1.getInt("sequence")) && StringUtils.isNotBlank((Object)obj2.getInt("sequence"))) {
                        return obj1.getInt("sequence") - obj2.getInt("sequence");
                    }
                    return 0;
                }
            });
        }
        catch (Exception exception) {
            log.warn(exception.getMessage());
        }
        return apps;
    }

    private static Map<Object, DynamicObject> getClouds(QFilter[] filters) {
        String fields = "id,name,number,sequence";
        filters = RunModeServiceHelper.getCloudIdBlacklistFilters((QFilter[])filters, (String)"id");
        Map cloudsMap = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizcloud", (String)fields, (QFilter[])filters, (String)"sequence asc");
        return cloudsMap;
    }
}

