/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.designer.plugin;

import com.alibaba.fastjson.JSONObject;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.AnchorItems;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.param.CustomParam;
import kd.bos.ext.form.control.AnchorControl;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.ImageAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.metadata.form.control.VectorAp;
import kd.bos.orm.query.QFilter;
import kd.bos.print.business.designer.plugin.AbstractNewPrintTplPlugin;
import kd.bos.print.business.designer.plugin.NumberCheckUtils;
import kd.bos.print.business.designer.plugin.PrintResultPlugin;
import kd.bos.print.business.metedata.bean.LibraryDesignMetadata;
import kd.bos.print.business.metedata.service.LibraryTplService;
import kd.bos.print.business.utils.PrintOpLogMsgEnum;
import kd.bos.print.business.utils.PrintOpLogUtils;
import kd.bos.print.business.utils.PrintParamUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class NewPrintTplGuidePlugin
extends AbstractNewPrintTplPlugin {
    private static final String KEY_TPLID = "tplid";
    private static final String BIZ_ENTITY = "bizentity";
    private static final String CENTER = "center";
    private static final String IMAGE_URL_PREFIX = "api/print/download.do?rcId=";
    private static final String LIBRARY_ENTITY_NAME = "bos_printtpl_lbr";
    private static final String GROUP_ENTITY_NAME = "bos_printtpl_lbr_group";
    private static final String CACHE_SELECTED_KEY = "selectedKey";
    private static final String CACHE_TPLDATA_KEY = "tpldata";
    private static final String IMAGEAP_PREFIX = "imageap_";
    private static final String VECTORAP_PREFIX = "vectorap_";
    private static final String KD_TPLNUM_PREFIX = "kdprint_";
    private CustomStyle customStyle = new CustomStyle();
    private static final Log log = LogFactory.getLog(NewPrintTplGuidePlugin.class);

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit bsdPrintTpl = (BasedataEdit)this.getView().getControl(BIZ_ENTITY);
        bsdPrintTpl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"flexpanelap", "selectedimg"});
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String formId = (String)customParams.get("formId");
        String sTplId = (String)customParams.get("sTplId");
        String tplKey = (String)customParams.get("tplKey");
        String bizType = (String)customParams.get("bizType");
        Object tplName = customParams.get("tplName");
        if (StringUtils.isNotBlank((CharSequence)formId)) {
            this.getModel().setValue(BIZ_ENTITY, (Object)formId);
            this.getModel().setValue("number", (Object)tplKey);
            this.getModel().setValue("name", tplName);
            this.getModel().setValue("biztype", (Object)bizType);
            this.getView().setVisible(Boolean.FALSE, new String[]{"blankap"});
            this.getView().setEnable(Boolean.FALSE, new String[]{BIZ_ENTITY, "number", "name", "biztype"});
            IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            proxy.setFieldProperty("btnok", "text", (Object)ResManager.loadKDString((String)"\u786e\u5b9a", (String)"NewPrintTplGuidePlugin_0", (String)"bos-print-business", (Object[])new Object[0]));
            if (StringUtils.isNotBlank((CharSequence)sTplId) && this.tplIdExist(sTplId)) {
                this.getModel().setValue(KEY_TPLID, (Object)sTplId);
            }
        } else {
            Container container = (Container)this.getView().getControl("flexpanelap");
            container.setCustomeStyles(this.customStyle.getCustomStyle("imgapSelected"));
            this.getView().getPageCache().put(CACHE_SELECTED_KEY, "flexpanelap");
            this.getView().updateControlMetadata("flexpanelap", this.createClientConfig(container));
        }
    }

    public void afterBindData(EventObject e) {
        Map customParams;
        String sTplId;
        if (!PrintParamUtils.isOpenBizTypeExt()) {
            ComboEdit comboEdit = (ComboEdit)this.getView().getControl("biztype");
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(4);
            ComboItem item0 = new ComboItem();
            item0.setValue("0");
            item0.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5e38\u89c4", (String)"NewPrintTplGuidePlugin_11", (String)"bos-print-business", (Object[])new Object[0])));
            comboItems.add(item0);
            ComboItem item1 = new ComboItem();
            item1.setValue("1");
            item1.setCaption(new LocaleString(ResManager.loadKDString((String)"\u84dd\u7259\u5c0f\u7968", (String)"NewPrintTplGuidePlugin_12", (String)"bos-print-business", (Object[])new Object[0])));
            comboItems.add(item1);
            comboEdit.setComboItems(comboItems);
        }
        if (StringUtils.isNotBlank((CharSequence)(sTplId = (String)(customParams = this.getView().getFormShowParameter().getCustomParams()).get("sTplId"))) && this.tplIdExist(sTplId)) {
            this.getModel().setValue(KEY_TPLID, (Object)sTplId);
            String cKey = IMAGEAP_PREFIX + sTplId.toLowerCase();
            Container container = (Container)this.getView().getControl(cKey);
            container.setCustomeStyles(this.customStyle.getCustomStyle("imgapSelected"));
            this.getView().getPageCache().put(CACHE_SELECTED_KEY, cKey);
            this.getView().updateControlMetadata(cKey, this.createClientConfig(container));
            this.createSelectNode(sTplId);
            this.getView().setVisible(Boolean.TRUE, new String[]{"selectedap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"selectedblankap"});
        }
    }

    public void beforeBindData(EventObject e) {
        List<TplGroupData> groupDataList = this.queryTplData();
        this.createAncho(groupDataList);
        this.createTplNodes(groupDataList);
        this.getView().setVisible(Boolean.FALSE, new String[]{"selectedap"});
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btnok".equals(key)) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Object formId = customParams.get("formId");
            if (StringUtils.isNotBlank(formId)) {
                this.switchSysPrintTpl();
            } else {
                this.newPrintTpl();
            }
        } else if ("selectedimg".equals(key)) {
            String tplId = (String)this.getModel().getValue(KEY_TPLID);
            TplData tplData = this.getTplData(tplId);
            if (tplData != null) {
                String imageUrl = tplData.getImgUrl();
                PrintResultPlugin.showPictureView(this.getView(), new String[]{IMAGE_URL_PREFIX + imageUrl}, 0);
            }
        } else if (control instanceof Vector && key.startsWith(VECTORAP_PREFIX)) {
            String tplId = key.replace(VECTORAP_PREFIX, "");
            TplData tplData = this.getTplData(tplId = tplId.toUpperCase());
            if (tplData != null) {
                String imageUrl = tplData.getImgUrl();
                PrintResultPlugin.showPictureView(this.getView(), new String[]{IMAGE_URL_PREFIX + imageUrl}, 0);
            }
        } else if (control instanceof Container && (key.startsWith(IMAGEAP_PREFIX) || StringUtils.equals((CharSequence)key, (CharSequence)"flexpanelap"))) {
            String lastSelectedKey = this.getPageCache().get(CACHE_SELECTED_KEY);
            if (StringUtils.isNotBlank((CharSequence)lastSelectedKey)) {
                Container selectedContainer = (Container)this.getView().getControl(lastSelectedKey);
                selectedContainer.setCustomeStyles(this.customStyle.getCustomStyle("imgapDefault"));
                this.getView().updateControlMetadata(lastSelectedKey, this.createClientConfig(selectedContainer));
            }
            Container container = (Container)control;
            container.setCustomeStyles(this.customStyle.getCustomStyle("imgapSelected"));
            this.getView().getPageCache().put(CACHE_SELECTED_KEY, key);
            this.getView().updateControlMetadata(key, this.createClientConfig(container));
            if (key.startsWith(IMAGEAP_PREFIX)) {
                String tplId = key.replace(IMAGEAP_PREFIX, "");
                tplId = tplId.toUpperCase();
                this.getModel().setValue(KEY_TPLID, (Object)tplId);
                this.createSelectNode(tplId);
                this.getView().setVisible(Boolean.TRUE, new String[]{"selectedap"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"selectedblankap"});
            } else {
                this.getModel().setValue(KEY_TPLID, (Object)"");
                this.getView().setVisible(Boolean.FALSE, new String[]{"selectedap"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"selectedblankap"});
            }
        }
    }

    private Map<String, Object> createClientConfig(Container container) {
        HashMap<String, Object> ctl = new HashMap<String, Object>();
        if (container.getKey() != null) {
            ctl.put("id", container.getKey().toLowerCase());
        }
        if (container.getCustomeStyles() != null) {
            ctl.put("cstyles", container.getCustomeStyles());
        }
        ctl.put("gr", 1);
        return ctl;
    }

    private void createTplNodes(List<TplGroupData> groupDataList) {
        Container container = (Container)this.getView().getControl("tplcardap");
        for (TplGroupData data : groupDataList) {
            FlexPanelAp flexPanelAp = this.createFlexPanel(data);
            ArrayList<Map> list = new ArrayList<Map>();
            list.add(flexPanelAp.createControl());
            container.addControls(list);
            Container flexContainer = new Container();
            flexContainer.setKey(flexPanelAp.getKey());
            flexContainer.setView(this.getView());
            List controls = ((Container)flexPanelAp.buildRuntimeControl()).getItems();
            for (Control control : controls) {
                control.setView(this.getView());
                flexContainer.getItems().add(control);
            }
            container.getItems().add(flexContainer);
        }
        this.getView().createControlIndex(container.getItems());
    }

    private boolean tplIdExist(String tplId) {
        TplData tplData = this.getTplData(tplId);
        return tplData != null;
    }

    private void createSelectNode(String tplId) {
        TplData tplData = this.getTplData(tplId);
        if (tplData == null) {
            return;
        }
        String direction = tplData.getDirection();
        String tplName = tplData.getTplName();
        String imgUrl = tplData.getImgUrl();
        int picWidth = tplData.getPicWidth();
        int picHeight = tplData.getPicHeight();
        int boxWidth = 120;
        int boxHeight = 169;
        if ("A".equals(direction)) {
            boxWidth = 156;
            boxHeight = 111;
        }
        this.showSelectedNode(tplName, picWidth, picHeight, boxWidth, boxHeight, IMAGE_URL_PREFIX + imgUrl);
    }

    private void showSelectedNode(String tplName, int picWidth, int picHeight, int boxWidth, int boxHeight, String imageUrl) {
        Object[] imageSize = this.calcImageSize(picWidth, picHeight, boxWidth, boxHeight);
        Container container = (Container)this.getView().getControl("selectedap");
        List items = container.getItems();
        for (Control control : items) {
            String key = control.getKey();
            if ("selectedimgbox".equals(key)) {
                Container imgBox = (Container)control;
                Map clientConfig = this.createClientConfig(imgBox);
                clientConfig.put((String)"w", (Object)new LocaleString(boxWidth + 2 + "px"));
                clientConfig.put((String)"h", (Object)new LocaleString(boxHeight + 2 + "px"));
                clientConfig.put((String)"sk", 1);
                clientConfig.put((String)"gr", 0);
                this.getView().updateControlMetadata(key, clientConfig);
                Control imgControl = (Control)imgBox.getItems().get(0);
                if (!"selectedimg".equals(imgControl.getKey())) continue;
                clientConfig = imgControl.createClientConfig();
                clientConfig.put("w", new LocaleString(imageSize[0] + "px"));
                clientConfig.put("h", new LocaleString(imageSize[1] + "px"));
                clientConfig.put("imageKey", imageUrl);
                clientConfig.put("sk", 1);
                clientConfig.put("gr", 0);
                this.getView().updateControlMetadata(imgControl.getKey(), clientConfig);
                continue;
            }
            if (!"selectedlabel".equals(key)) continue;
            Map clientConfig = control.createClientConfig();
            clientConfig.put("caption", new LocaleString(tplName));
            this.getView().updateControlMetadata(key, clientConfig);
        }
    }

    private TplData getTplData(String tplId) {
        String cachedata = this.getPageCache().get(CACHE_TPLDATA_KEY);
        if (cachedata == null) {
            return null;
        }
        Map cacheDataObj = (Map)SerializationUtils.fromJsonString((String)cachedata, Map.class);
        Map obj = (Map)cacheDataObj.get(tplId);
        if (obj == null) {
            return null;
        }
        return new TplData(obj);
    }

    public void onGetControl(OnGetControlArgs e) {
        String key = e.getKey();
        if (key.startsWith(IMAGEAP_PREFIX)) {
            Container container = new Container();
            container.setKey(key);
            container.setView(this.getView());
            container.addClickListener((ClickListener)this);
            e.setControl((Control)container);
        } else if (key.startsWith(VECTORAP_PREFIX)) {
            Vector vector = new Vector();
            vector.setKey(key);
            vector.setView(this.getView());
            vector.addClickListener((ClickListener)this);
            e.setControl((Control)vector);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        FormShowParameter showParameter = arg0.getFormShowParameter();
        Map configInfo = this.getView().getFormShowParameter().getCustomParams();
        String currentNodeId = (String)configInfo.get("currentNodeId");
        if (showParameter instanceof ListShowParameter) {
            ListShowParameter listShowParameter = (ListShowParameter)showParameter;
            listShowParameter.setCustomParam("treeRootNodeId", (Object)currentNodeId);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object value;
        String property = e.getProperty().getName();
        if (BIZ_ENTITY.equals(property)) {
            DynamicObject bizentity = (DynamicObject)this.getModel().getValue(BIZ_ENTITY);
            if (bizentity == null) {
                return;
            }
            String number = (String)bizentity.get("number");
            if (!ObjectUtils.isEmpty((Object)bizentity)) {
                number = this.genTplNumber(number);
            }
            if (NumberCheckUtils.isKingdeeISV() && !number.startsWith(KD_TPLNUM_PREFIX)) {
                number = KD_TPLNUM_PREFIX + number;
            }
            this.getModel().setValue("number", (Object)number);
        } else if ("number".equals(property) && StringUtils.isNotBlank((Object)(value = this.getModel().getValue("number")))) {
            String tplNum = String.valueOf(value);
            if (NumberCheckUtils.isKingdeeISV() && !tplNum.startsWith(KD_TPLNUM_PREFIX)) {
                tplNum = KD_TPLNUM_PREFIX + tplNum;
                this.getModel().setValue("number", (Object)tplNum);
            }
        }
    }

    private void newPrintTpl() {
        Map result;
        ILocaleString name = (ILocaleString)this.getModel().getValue("name");
        String number = (String)this.getModel().getValue("number");
        String stplId = (String)this.getModel().getValue(KEY_TPLID);
        try {
            DynamicObject mainEntity = (DynamicObject)this.getModel().getValue(BIZ_ENTITY);
            if (mainEntity == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u4e1a\u52a1\u5b9e\u4f53\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"NewPrintTplGuidePlugin_1", (String)"bos-print-business", (Object[])new Object[0]));
                return;
            }
            Tuple<Boolean, String> checkResult = NumberCheckUtils.validateIsv(number);
            if (!((Boolean)checkResult.item1).booleanValue()) {
                this.getView().showTipNotification((String)checkResult.item2);
                return;
            }
            checkResult = NumberCheckUtils.validate(number);
            if (!((Boolean)checkResult.item1).booleanValue()) {
                this.getView().showTipNotification((String)checkResult.item2);
                return;
            }
            DynamicObject orgObj = this.getModel().getDataEntity().getDynamicObject("createOrg");
            if (orgObj != null && !NewPrintTplGuidePlugin.checkTplPermission(orgObj.getLong("id"), "47156aff000000ac")) {
                String permItemName = String.valueOf(PermissionServiceHelper.getPermItemNameById((String)"47156aff000000ac"));
                String formName = String.valueOf(FormMetadataCache.getFormConfig((String)"bos_manageprinttpl").getCaption());
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u65e0\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PrintDesignerPlugin_15", (String)"bos-print-business", (Object[])new Object[0]), formName, permItemName));
                return;
            }
            String entityId = (String)mainEntity.get("dentityid");
            String formId = (String)mainEntity.get("number");
            Map data = null;
            if (StringUtils.isNotBlank((CharSequence)stplId)) {
                LibraryTplService tplService = new LibraryTplService();
                LibraryDesignMetadata designMeta = (LibraryDesignMetadata)tplService.getDesignMeta(stplId);
                String dataTag = designMeta.getData();
                data = (Map)SerializationUtils.fromJsonString((String)dataTag, Map.class);
            }
            result = this.createPrintTemplate(number, name, entityId, formId, data, null);
            result.put("printV", "B");
        }
        catch (Exception e) {
            this.getView().showTipNotification(e.getMessage());
            log.warn((Throwable)e);
            return;
        }
        PrintOpLogUtils.addLog((IFormView)this.getView().getParentView(), (String)number, (PrintOpLogMsgEnum)PrintOpLogMsgEnum.TPL_ADD);
        this.getView().returnDataToParent((Object)result);
        this.getView().close();
    }

    public static boolean checkTplPermission(long createorg, String permissionItemId) {
        if (!PrintParamUtils.isTemplateOrgIsolated()) {
            return true;
        }
        CustomParam customParam = new CustomParam();
        customParam.getSearchKeySet().add("printcheckPermission");
        Map paramMap = SystemParamServiceHelper.loadCustomParameterFromCache((CustomParam)customParam);
        if ("false".equals(paramMap.get("printcheckPermission"))) {
            return true;
        }
        return 1 == PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (Long)createorg, (String)"15", (String)AppMetadataCache.getAppInfoByNumber((String)"cts").getId(), (String)"bos_manageprinttpl", (String)permissionItemId);
    }

    private void switchSysPrintTpl() {
        String stplId = (String)this.getModel().getValue(KEY_TPLID);
        if (StringUtils.isBlank((CharSequence)stplId)) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a21\u677f", (String)"NewPrintTplGuidePlugin_2", (String)"bos-print-business", (Object[])new Object[0]);
            this.getView().showMessage(msg);
            return;
        }
        ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("switchTpl", (IFormPlugin)this);
        String title = ResManager.loadKDString((String)"\u6e29\u99a8\u63d0\u793a", (String)"NewPrintTplGuidePlugin_3", (String)"bos-print-business", (Object[])new Object[0]);
        String detail = ResManager.loadKDString((String)"\u5207\u6362\u6a21\u677f\u5c06\u4f1a\u6e05\u7a7a\u5f53\u524d\u6a21\u677f\u6570\u636e\uff0c\u786e\u8ba4\u5207\u6362\u6a21\u677f\uff1f", (String)"NewPrintTplGuidePlugin_4", (String)"bos-print-business", (Object[])new Object[0]);
        this.getView().showConfirm(title, detail, MessageBoxOptions.YesNo, null, confirmCallBackListener, null, stplId);
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callbackId = evt.getCallBackId();
        if ("switchTpl".equals(callbackId)) {
            if (evt.getResult().getValue() != MessageBoxResult.Yes.getValue()) {
                return;
            }
            String gtplId = evt.getCustomVaule();
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("stplId", gtplId);
            this.getView().returnDataToParent(res);
            this.getView().close();
        }
    }

    private void createAncho(List<TplGroupData> groupDataList) {
        AnchorControl anchorCtl = (AnchorControl)this.getView().getControl("classify_ancho");
        anchorCtl.setHighlight(true);
        ArrayList<AnchorItems> anchorItemList = new ArrayList<AnchorItems>(10);
        for (TplGroupData data : groupDataList) {
            AnchorItems item = new AnchorItems();
            item.setCaption(data.getGroupName());
            item.setTarget(data.getGroupId() + "");
            anchorItemList.add(item);
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String formId = (String)customParams.get("formId");
        if (StringUtils.isBlank((CharSequence)formId)) {
            AnchorItems blankItem = new AnchorItems();
            blankItem.setCaption(ResManager.loadKDString((String)"\u7a7a\u767d", (String)"NewPrintTplGuidePlugin_5", (String)"bos-print-business", (Object[])new Object[0]));
            blankItem.setTarget("blankap");
            anchorItemList.add(0, blankItem);
        }
        anchorCtl.addItems(anchorItemList);
    }

    private FlexPanelAp createFlexPanel(TplGroupData data) {
        long groupId = data.getGroupId();
        String groupName = data.getGroupName();
        FlexPanelAp groupFlexAp = new FlexPanelAp();
        groupFlexAp.setLazyLoad(false);
        groupFlexAp.setKey(groupId + "");
        groupFlexAp.setDirection("row");
        groupFlexAp.setWrap(true);
        groupFlexAp.setAlignItems("flex-end");
        groupFlexAp.setJustifyContent("flex-start");
        groupFlexAp.setAlignContent("default");
        groupFlexAp.setShrink(0);
        groupFlexAp.setWidth(new LocaleString("100%"));
        groupFlexAp.setOverflow("hidden");
        Style style = new Style();
        Margin margin = new Margin();
        style.setMargin(margin);
        groupFlexAp.setStyle(style);
        FlexPanelAp groupNamePanelAp = new FlexPanelAp();
        groupNamePanelAp.setKey(this.getRandomKey());
        groupNamePanelAp.setWidth(new LocaleString("100%"));
        groupNamePanelAp.setHeight(new LocaleString("48px"));
        groupNamePanelAp.setLazyLoad(false);
        LabelAp labelAp = new LabelAp();
        labelAp.setKey(this.getRandomKey());
        labelAp.setName(new LocaleString(groupName));
        labelAp.setFontSize(14);
        labelAp.setHeight(new LocaleString("20px"));
        style = new Style();
        margin = new Margin();
        margin.setTop("20px");
        margin.setLeft("20px");
        style.setMargin(margin);
        labelAp.setStyle(style);
        groupNamePanelAp.getItems().add(labelAp);
        groupFlexAp.getItems().add(groupNamePanelAp);
        List<TplData> items = data.getItems();
        for (int i = 0; i < items.size(); ++i) {
            TplData obj = items.get(i);
            FlexPanelAp containerAp = this.getTplPanelAp(obj);
            groupFlexAp.getItems().add(containerAp);
        }
        return groupFlexAp;
    }

    private FlexPanelAp getTplPanelAp(TplData tplData) {
        String direction = tplData.getDirection();
        String tplId = tplData.getTplId();
        FlexPanelAp containerAp = new FlexPanelAp();
        containerAp.setKey(this.getRandomKey());
        containerAp.setOperationKey("tplBox");
        containerAp.setDirection("column");
        containerAp.setWrap(false);
        containerAp.setGrow(0);
        containerAp.setJustifyContent(CENTER);
        containerAp.setAlignItems(CENTER);
        containerAp.setShrink(1);
        containerAp.setOverflow("hidden");
        containerAp.setLazyLoad(false);
        Style style = new Style();
        Margin margin = new Margin();
        margin.setLeft("20px");
        style.setMargin(margin);
        containerAp.setStyle(style);
        String imgUrl = tplData.getImgUrl();
        int picWidth = tplData.getPicWidth();
        int picHeight = tplData.getPicHeight();
        FlexPanelAp imageContainerAp = new FlexPanelAp();
        imageContainerAp.setLazyLoad(false);
        imageContainerAp.setKey(IMAGEAP_PREFIX + tplId);
        imageContainerAp.setBackColor("#FFFFFF");
        imageContainerAp.setOverflow("hidden");
        imageContainerAp.setShadow(true);
        imageContainerAp.setClickable(true);
        imageContainerAp.setJustifyContent(CENTER);
        imageContainerAp.setCustomeStyles(this.customStyle.getCustomStyle("imgapDefault"));
        int boxWidth = 120;
        int boxHeight = 169;
        if ("A".equals(direction)) {
            boxWidth = 156;
            boxHeight = 111;
        }
        imageContainerAp.setWidth(new LocaleString(boxWidth + "px"));
        imageContainerAp.setHeight(new LocaleString(boxHeight + "px"));
        ImageAp imageAp = new ImageAp();
        imageAp.setKey(this.getRandomKey());
        imageAp.setImageKey(IMAGE_URL_PREFIX + imgUrl);
        Object[] imageSize = this.calcImageSize(picWidth, picHeight, boxWidth, boxHeight);
        imageAp.setWidth(new LocaleString(imageSize[0] + "px"));
        imageAp.setHeight(new LocaleString(imageSize[1] + "px"));
        imageContainerAp.getItems().add(imageAp);
        VectorAp vectorAp = new VectorAp();
        vectorAp.setKey(VECTORAP_PREFIX + tplId);
        vectorAp.setClickable(true);
        vectorAp.setfontClass("kdfont kdfont-yulan");
        imageContainerAp.getItems().add(vectorAp);
        FlexPanelAp labelContainerAp = new FlexPanelAp();
        labelContainerAp.setLazyLoad(false);
        labelContainerAp.setKey(this.getRandomKey());
        labelContainerAp.setHeight(new LocaleString("20px"));
        labelContainerAp.setOverflow("hidden");
        style = new Style();
        margin = new Margin();
        margin.setTop("8px");
        style.setMargin(margin);
        labelContainerAp.setStyle(style);
        LabelAp tplLabelAp = new LabelAp();
        tplLabelAp.setKey(this.getRandomKey());
        tplLabelAp.setName(new LocaleString(tplData.getTplName()));
        labelContainerAp.getItems().add(tplLabelAp);
        containerAp.getItems().add(imageContainerAp);
        containerAp.getItems().add(labelContainerAp);
        return containerAp;
    }

    private String getRandomKey() {
        return UUID.randomUUID().toString();
    }

    private Object[] calcImageSize(int imageWidth, int imageHeight, int boxWidth, int boxHeight) {
        float b1 = (float)imageWidth / (float)boxWidth;
        float b2 = (float)imageHeight / (float)boxHeight;
        if (b1 <= 1.0f && b2 <= 1.0f) {
            return new Object[]{imageWidth, imageHeight};
        }
        if (b1 <= 1.0f && b2 > 1.0f) {
            return new Object[]{Float.valueOf((float)imageWidth / b2), boxHeight};
        }
        if (b1 > 1.0f && b2 < 1.0f) {
            return new Object[]{boxWidth, Float.valueOf((float)imageHeight / b1)};
        }
        float b = b1 > b2 ? b1 : b2;
        return new Object[]{Float.valueOf((float)imageWidth / b), Float.valueOf((float)imageHeight / b)};
    }

    private List<TplGroupData> queryTplData() {
        Map collection;
        if (!StringUtils.equals((CharSequence)Lang.zh_CN.toString(), (CharSequence)RequestContext.get().getLang().toString())) {
            return new ArrayList<TplGroupData>(0);
        }
        Object bizType = this.getView().getFormShowParameter().getCustomParam("bizType");
        HashMap<String, TplData> cacheMap = new HashMap<String, TplData>(16);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("status", "=", (Object)"C"));
        filters.add(new QFilter("enable", "=", (Object)"1"));
        if (bizType != null) {
            filters.add(new QFilter("biztype", "=", (Object)bizType.toString()));
        }
        if ((collection = BusinessDataServiceHelper.loadFromCache((String)LIBRARY_ENTITY_NAME, (String)"id,number,name,picture,picwidth,picHeight,group,paperdirection", (QFilter[])filters.toArray(new QFilter[0]), (String)"paperdirection desc ")).size() <= 0) {
            return new ArrayList<TplGroupData>(0);
        }
        List pkIds = collection.values().stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(String.format("select fid,fpicture,fpic_width,fpic_height from %s where ", "t_svc_printtpl_l"), new Object[0]).append("flocaleid = ?", new Object[]{RequestContext.get().getLang().toString()}).append(" and ", new Object[0]).appendIn("fid", pkIds);
        HashMap tplLocaleMap = new HashMap(pkIds.size());
        DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)sqlBuilder, rs -> {
            while (rs.next()) {
                String fId = rs.getString(1);
                TplData tplData = new TplData();
                tplData.setImgUrl(rs.getString(2));
                tplData.setPicWidth(rs.getInt(3));
                tplData.setPicHeight(rs.getInt(4));
                tplLocaleMap.put(fId, tplData);
            }
            return true;
        });
        HashMap groupMap = new HashMap();
        HashMap<Long, Date> orderMap = new HashMap<Long, Date>();
        for (Map.Entry entry : collection.entrySet()) {
            List<TplData> list;
            DynamicObject obj = (DynamicObject)entry.getValue();
            DynamicObject group = obj.getDynamicObject("group");
            if (group == null) continue;
            long groupId = group.getLong("id");
            String groupName = group.getString("name");
            String groupKey = group.getString("number");
            String tplId = obj.getString("id");
            String tplName = obj.getString("name");
            String direction = obj.getString("paperdirection");
            TplData tplData = new TplData();
            tplData.setGroupId(groupId);
            tplData.setGroupKey(groupKey);
            tplData.setGroupName(groupName);
            tplData.setTplId(tplId);
            tplData.setTplName(tplName);
            tplData.setDirection(direction);
            TplData localeData = (TplData)tplLocaleMap.get(tplId);
            if (localeData != null) {
                tplData.setImgUrl(localeData.getImgUrl());
                tplData.setPicWidth(localeData.getPicWidth());
                tplData.setPicHeight(localeData.getPicHeight());
            }
            if (!groupMap.containsKey(groupId)) {
                list = new ArrayList<TplData>();
                list.add(tplData);
                groupMap.put(groupId, list);
                orderMap.put(groupId, group.getDate("createtime"));
            } else {
                list = (List)groupMap.get(groupId);
                list.add(tplData);
                groupMap.put(groupId, list);
            }
            cacheMap.put(obj.getString("id"), tplData);
        }
        ArrayList<TplGroupData> tplGroupList = new ArrayList(10);
        for (Map.Entry entry : groupMap.entrySet()) {
            long groupId = (Long)entry.getKey();
            List tplDataList = (List)entry.getValue();
            TplData tplData = (TplData)tplDataList.get(0);
            TplGroupData groupData = new TplGroupData(groupId, tplData.getGroupKey(), tplData.getGroupName(), tplDataList);
            groupData.setCreateTime((Date)orderMap.get(groupId));
            tplGroupList.add(groupData);
        }
        tplGroupList = tplGroupList.stream().sorted(Comparator.comparing(TplGroupData::getCreateTime)).collect(Collectors.toList());
        this.getPageCache().put(CACHE_TPLDATA_KEY, SerializationUtils.toJsonString(cacheMap));
        return tplGroupList;
    }

    @Override
    String genTplNumber(String number) {
        return number + "_prtpl";
    }

    private static class TplGroupData {
        private long groupId;
        private String groupKey;
        private String groupName;
        private Date createTime;
        private List<TplData> items;

        public TplGroupData(long groupId, String groupKey, String groupName, List<TplData> items) {
            this.groupId = groupId;
            this.groupKey = groupKey;
            this.groupName = groupName;
            this.items = items;
        }

        public long getGroupId() {
            return this.groupId;
        }

        public void setGroupId(long groupId) {
            this.groupId = groupId;
        }

        public String getGroupName() {
            return this.groupName;
        }

        public void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public List<TplData> getItems() {
            return this.items;
        }

        public void setItems(List<TplData> items) {
            this.items = items;
        }

        public String getGroupKey() {
            return this.groupKey;
        }

        public void setGroupKey(String groupKey) {
            this.groupKey = groupKey;
        }

        public Date getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(Date createTime) {
            this.createTime = createTime;
        }
    }

    private static class TplData {
        private String tplId;
        private String tplName;
        private String direction;
        private String imgUrl;
        private int picWidth;
        private int picHeight;
        private long groupId;
        private String groupKey;
        private String groupName;

        public TplData() {
        }

        public TplData(Map obj) {
            this.tplId = (String)obj.get("tplId");
            this.tplName = (String)obj.get("tplName");
            this.direction = (String)obj.get("direction");
            this.imgUrl = (String)obj.get("imgUrl");
            this.picWidth = (Integer)obj.get("picWidth");
            this.picHeight = (Integer)obj.get("picHeight");
            this.groupId = (Long)obj.get("groupId");
            this.groupKey = (String)obj.get("groupKey");
            this.groupName = (String)obj.get("groupName");
        }

        public String getTplId() {
            return this.tplId;
        }

        public void setTplId(String tplId) {
            this.tplId = tplId;
        }

        public String getTplName() {
            return this.tplName;
        }

        public void setTplName(String tplName) {
            this.tplName = tplName;
        }

        public String getDirection() {
            return this.direction;
        }

        public void setDirection(String direction) {
            this.direction = direction;
        }

        public String getImgUrl() {
            return this.imgUrl;
        }

        public void setImgUrl(String imgUrl) {
            this.imgUrl = imgUrl;
        }

        public int getPicWidth() {
            return this.picWidth;
        }

        public void setPicWidth(int picWidth) {
            this.picWidth = picWidth;
        }

        public int getPicHeight() {
            return this.picHeight;
        }

        public void setPicHeight(int picHeight) {
            this.picHeight = picHeight;
        }

        public long getGroupId() {
            return this.groupId;
        }

        public void setGroupId(long groupId) {
            this.groupId = groupId;
        }

        public String getGroupKey() {
            return this.groupKey;
        }

        public void setGroupKey(String groupKey) {
            this.groupKey = groupKey;
        }

        public String getGroupName() {
            return this.groupName;
        }

        public void setGroupName(String groupName) {
            this.groupName = groupName;
        }
    }

    private static class CustomStyle {
        private Map<String, String> customStyle = new HashMap<String, String>();
        public static final String IMGAP_SELECTED = "imgapSelected";
        public static final String IMGAP_DEFAULT = "imgapDefault";

        private CustomStyle() {
        }

        public String getCustomStyle(String type) {
            String style = this.customStyle.get(type);
            if (style != null) {
                return style;
            }
            if (StringUtils.equals((CharSequence)IMGAP_SELECTED, (CharSequence)type)) {
                style = "${border: 1px solid 'themeColor';border-radius:4px}$ .FontIcon_font-icon_1ogd,.US6Vr-ci{position: absolute;right:4px;bottom:4px;display: inherit;z-index:100;}";
            } else if (StringUtils.equals((CharSequence)IMGAP_DEFAULT, (CharSequence)type)) {
                style = "${border: 1px solid #E5E5E5;border-radius:4px}$ .FontIcon_font-icon_1ogd,.US6Vr-ci{display:none}$:hover {border: 1px solid 'themeColor';}$:hover .FontIcon_font-icon_1ogd,.US6Vr-ci{position: absolute;right:4px;bottom:4px;display: inherit;z-index:100;}";
            }
            JSONObject json = new JSONObject();
            json.put("content", (Object)style);
            style = Base64.getEncoder().encodeToString(json.toJSONString().getBytes(Charset.defaultCharset()));
            this.customStyle.put(type, style);
            return style;
        }
    }
}

