/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.designer.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.devportal.AppMenuElement;
import kd.bos.entity.report.CellStyle;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.container.Wizard;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.list.events.ListRowSelectAllEvent;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.business.designer.TplType;
import kd.bos.print.business.metedata.bean.MetaUpdateResult;
import kd.bos.print.business.scheme.dao.TreeDataDao;
import kd.bos.print.business.scheme.entity.Tuple4;
import kd.bos.print.business.scheme.util.PageCacheUtils;
import kd.bos.print.business.utils.OldPrintTemplateUtil;
import kd.bos.print.business.utils.PrintOpLogMsgEnum;
import kd.bos.print.business.utils.PrintOpLogUtils;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;

public class NewPrintUpdateGuidePlugin
extends AbstractTreeListPlugin
implements SearchEnterListener,
TreeNodeClickListener,
TreeNodeQueryListener,
ProgresssListener,
RowClickEventListener,
HyperLinkClickListener,
ListRowClickListener {
    private static final String PREFIX_CLOUD = "cloud_";
    private static final String TREE_WIDGET_KEY = "tree";
    private static final String BILLFORMID = "billformid";
    private static final String BOS_MANAGEPRINTTPL = "bos_manageprinttpl";
    private static final String PRINTTPLID_ID = "printtplid_id";
    private static final String PREFIX_APP = "app_";
    private static final String UPDATE_KEY = "update_key";
    private static final String DELET_KEY = "delet_key";
    private static final String ERROR_TPL_KEY = "error_tpl";
    private static final String SEARCH_WIDGET_KEY = "searchap";
    private static final String TYPE_KEY = "bos-print-business";
    private static final String BOS_FORM_BUSINESS = "bos-form-business";
    private static final String CACHEKEY_TASKID = "print_update_taskid";
    private static final String CACHEKEY_JOBFORMINFO = "print_update_jobforminfo";
    private static final String UPDATE_DETAIL = "updatedetail";
    private static final String CLOSE_FLAG = "closeFlag";
    private static final String PROJECT_NAME = "bos-print-business";
    private static final String IDE_PRINTDESIGNER = "ide_printdesigner";
    private static final String BOS_UPDATE_REPORT = "bos_update_report_info";
    private String PRINT_RESOURCE = "bos_print_resource";
    private static final String PRINT_METEDATA = "bos_print_meta";
    private static final String KEY_BILLFORMID_APPID = "billformid.bizappid.id";
    private static final String APP_IDS = "appIds";
    private static final String App_EXT_IDS = "appExtIds";
    private static final BigDecimal ONE_HUNDRED = BigDecimal.valueOf(1L);
    private static final BigDecimal FIFTY = BigDecimal.valueOf(0.5);
    private static final Log log = LogFactory.getLog(NewPrintUpdateGuidePlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressbar = (ProgressBar)this.getControl("progressbarap");
        progressbar.addProgressListener((ProgresssListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getControl(UPDATE_DETAIL);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        entryGrid.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{"btncancel", "billlistap"});
        TreeView treeLeft = (TreeView)this.getControl(TREE_WIDGET_KEY);
        treeLeft.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        treeLeft.addTreeNodeClickListener((TreeNodeClickListener)this);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addClearSelectionListener((Consumer)new Consumer<EventObject>(){

            @Override
            public void accept(EventObject eventObject) {
                NewPrintUpdateGuidePlugin.this.setTabUseful();
            }
        });
        billList.addListRowSelectAllListeners((Consumer)new Consumer<ListRowSelectAllEvent>(){

            @Override
            public void accept(ListRowSelectAllEvent listRowSelectAllEvent) {
                NewPrintUpdateGuidePlugin.this.setTabUseful();
            }
        });
        billList.addListRowClickListener((ListRowClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setTabUseful();
        this.initTree();
    }

    public void initialize() {
        EntryGrid dsentry = (EntryGrid)this.getControl(UPDATE_DETAIL);
        dsentry.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{"btnnext", "btnprev", "btndone"});
        IPageCache iPageCache = this.getPageCache();
        iPageCache.put("oneTime", "true");
        iPageCache.put(CLOSE_FLAG, "true");
    }

    private void initTree() {
        TreeView tree = (TreeView)this.getView().getControl(TREE_WIDGET_KEY);
        tree.deleteAllNodes();
        TreeNode root = new TreeNode();
        root.setParentid("");
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"NewPrintUpdateGuidePlugin_1", (String)"bos-print-business", (Object[])new Object[0]));
        root.setId("rootNode");
        root.setIsOpened(true);
        List<TreeNode> cloudNodes = TreeDataDao.getAllCloudsByUpdate(this.getPageCache());
        root.setChildren(cloudNodes);
        tree.addNode(root);
        tree.focusNode(root);
        TreeNodeEvent nodeEvent = new TreeNodeEvent((Object)this, (Object)root.getParentid(), (Object)root.getId());
        this.treeNodeClick(nodeEvent);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        IPageCache iPageCache = this.getPageCache();
        String closeFlag = iPageCache.get(CLOSE_FLAG);
        if ("true".equals(closeFlag) && !this.isLastStep() && !this.isfistStep()) {
            e.setCancel(true);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5173\u95ed\u540e\u5c06\u7ed3\u675f\u672c\u6b21\u5347\u7ea7\uff0c\u662f\u5426\u9000\u51fa\u672c\u9875?", (String)"WizardPlugin_0", (String)"bos-designer-plugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("exitGuideCallBack"));
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        String searchText = searchEnterEvent.getText();
        TreeView tree = (TreeView)this.getView().getControl(TREE_WIDGET_KEY);
        Tuple4<List<TreeNode>, TreeNode, String, String> result = TreeDataDao.searchNodesByUpdate(this.getPageCache(), searchText);
        List treeNodes = (List)result.item1;
        TreeNode focusNode = (TreeNode)result.item2;
        if (focusNode == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22\uff0c\u6ca1\u6709\u627e\u5230\u641c\u7d22\u9879\u3002", (String)"AbstractTreeListPlugin_1", (String)"bos-print-business", (Object[])new Object[0]));
            return;
        }
        if (!treeNodes.isEmpty()) {
            TreeNodeEvent event = new TreeNodeEvent((Object)this, (Object)focusNode.getParentid(), (Object)focusNode.getId());
            this.treeNodeClick(event);
            String nodeId = focusNode.getId();
            if (nodeId.startsWith(PREFIX_APP)) {
                tree.addNodes(treeNodes);
                tree.expand((String)result.item3);
            } else if (nodeId.startsWith("menu_")) {
                ArrayList appNodes = new ArrayList(10);
                ArrayList menuNodes = new ArrayList(10);
                for (TreeNode treeNode : treeNodes) {
                    if (!treeNode.getId().startsWith("menu_") && !treeNode.getId().startsWith(PREFIX_APP)) continue;
                }
                tree.addNodes(appNodes);
                tree.addNodes(menuNodes);
                tree.expand((String)result.item4);
                tree.expand((String)result.item3);
            }
            tree.focusNode(focusNode);
        } else if (focusNode != null && focusNode.getId().startsWith(PREFIX_CLOUD)) {
            tree.focusNode(focusNode);
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Object nodeId = evt.getNodeId();
        Object parentId = evt.getParentNodeId();
        if (nodeId != null) {
            String nodeIdStr = String.valueOf(nodeId);
            if (nodeIdStr.startsWith("menu_") && parentId != null) {
                String parentIdStr = String.valueOf(parentId);
                AppMenuElement menu = AppMetaServiceHelper.getMenuById((String)nodeIdStr.replace("menu_", ""), (String)parentIdStr.replace(PREFIX_APP, ""), (boolean)true);
                PageCacheUtils.cacheValueToPageCache(this.getPageCache(), "form_id", nodeIdStr.replace("menu_", ""));
                PageCacheUtils.cacheValueToPageCache(this.getPageCache(), "form_number", menu.getFormNumber());
            } else {
                PageCacheUtils.removeValueFromPageCache(this.getPageCache(), "form_id");
                PageCacheUtils.removeValueFromPageCache(this.getPageCache(), "form_number");
            }
            TreeNodeEvent event = new TreeNodeEvent((Object)this, parentId, nodeId);
            this.queryTreeNodeChildren(event);
            TreeView tree = (TreeView)this.getView().getControl(TREE_WIDGET_KEY);
            tree.expand(nodeId.toString());
            this.afterTreeNodeFocus(nodeIdStr);
        }
        BillList billList = (BillList)this.getView().getControl("billlistap");
        QFilter filter = new QFilter("type", "=", (Object)"A");
        String nodeIdStr = evt.getNodeId().toString();
        if (!this.isTopNodeId(nodeIdStr)) {
            if (nodeIdStr.startsWith(PREFIX_CLOUD)) {
                List<TreeNode> appNodes = TreeDataDao.getAppByCloudId(this.getPageCache(), nodeIdStr);
                String appExtStr = this.getPageCache().get(App_EXT_IDS);
                if (!CollectionUtils.isEmpty(appNodes) && appExtStr != null) {
                    Map appExtMap = (Map)SerializationUtils.fromJsonString((String)appExtStr, Map.class);
                    ArrayList appIds = new ArrayList(10);
                    appNodes.stream().map(m -> StringUtils.substringAfter((String)m.getId(), (String)"_")).forEach(appId -> {
                        appIds.add(appId);
                        List appExtIds = (List)appExtMap.get(appId);
                        if (appExtIds != null) {
                            appIds.addAll(appExtIds);
                        }
                    });
                    filter.and(new QFilter(KEY_BILLFORMID_APPID, "in", appIds));
                }
            } else if (nodeIdStr.startsWith(PREFIX_APP)) {
                Map appExtMap;
                List appExtIds;
                String appId2 = StringUtils.substringAfter((String)String.valueOf(nodeId), (String)"_");
                ArrayList<String> appIds = new ArrayList<String>(10);
                appIds.add(appId2);
                String appExtStr = this.getPageCache().get(App_EXT_IDS);
                if (appExtStr != null && (appExtIds = (List)(appExtMap = (Map)SerializationUtils.fromJsonString((String)appExtStr, Map.class)).get(appId2)) != null) {
                    appIds.addAll(appExtIds);
                }
                filter.and(new QFilter(KEY_BILLFORMID_APPID, "in", appIds));
            } else {
                filter.and(new QFilter(BILLFORMID, "=", nodeId));
            }
        } else {
            String str = this.getPageCache().get(APP_IDS);
            if (str != null) {
                List appIds = SerializationUtils.fromJsonStringToList((String)str, String.class);
                filter.and(new QFilter(KEY_BILLFORMID_APPID, "in", (Object)appIds));
            }
        }
        billList.setFilter(filter);
        billList.refresh();
    }

    public void queryTreeNodeChildren(TreeNodeEvent treeNodeEvent) {
        TreeView tree = (TreeView)this.getView().getControl(TREE_WIDGET_KEY);
        String nodeId = treeNodeEvent.getNodeId().toString();
        Tuple<TreeNode, List<TreeNode>> nodes = null;
        if (nodeId.startsWith(PREFIX_CLOUD)) {
            nodes = TreeDataDao.getChildrenNodeById(this.getPageCache(), nodeId);
        }
        if (nodes != null && !CollectionUtils.isEmpty((Collection)((Collection)nodes.item2))) {
            for (TreeNode treeNo : (List)nodes.item2) {
                if (treeNo.getChildren() == null || treeNo.getChildren().size() != 0) continue;
                treeNo.setChildren(null);
            }
            tree.addNodes((List)nodes.item2);
        }
        if (nodes != null && nodes.item1 != null) {
            tree.focusNode((TreeNode)nodes.item1);
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnnext": {
                this.next();
                break;
            }
            case "btnprev": {
                this.previous();
                break;
            }
            case "btndone": {
                this.closeWin();
                break;
            }
        }
    }

    private void closeWin() {
        HashMap<String, List> res = new HashMap<String, List>();
        IPageCache iPageCache = this.getPageCache();
        res.put("newTplIds", JSON.parseArray((String)iPageCache.get(UPDATE_KEY), String.class));
        this.getView().returnDataToParent(res);
        this.getView().close();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btndone"});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"btnprev"});
        this.setWizard(0, "process");
    }

    private void setWizard(int step, String stepStatus) {
        Wizard wizard = (Wizard)this.getControl("wizardap");
        HashMap<String, Object> currentStepMap = new HashMap<String, Object>();
        currentStepMap.put("currentStep", step);
        currentStepMap.put("currentStatus", stepStatus);
        wizard.setWizardCurrentStep(currentStepMap);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        if ("exitGuideCallBack".equals(e.getCallBackId()) && MessageBoxResult.Yes.equals((Object)e.getResult())) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(UPDATE_DETAIL);
            EntryData entryData = entryGrid.getEntryData();
            DynamicObject[] dynamicObjects = entryData.getDataEntitys();
            if (dynamicObjects.length > 0) {
                ArrayList<String> tplids = new ArrayList<String>();
                for (int i = 0; i < dynamicObjects.length; ++i) {
                    DynamicObject dynamicObject = dynamicObjects[i];
                    BigDecimal decimalfield = (BigDecimal)dynamicObject.get("decimalfield");
                    if (decimalfield.compareTo(BigDecimal.ZERO) == 0) continue;
                    String newtplid = (String)dynamicObject.get("newtplid");
                    tplids.add(newtplid);
                }
                this.deleteNewTpls(tplids);
            }
            IPageCache iPageCache = this.getPageCache();
            iPageCache.put(CLOSE_FLAG, "false");
            this.getView().close();
        }
    }

    private String getTaskId() {
        if (this.getView().getFormShowParameter().getCustomParams().containsKey(CACHEKEY_TASKID)) {
            return (String)this.getView().getFormShowParameter().getCustomParam(CACHEKEY_TASKID);
        }
        return this.getPageCache().get(CACHEKEY_TASKID);
    }

    private void putTaskId(String taskId) {
        this.getPageCache().put(CACHEKEY_TASKID, taskId);
    }

    private void putJobFormInfo(JobFormInfo jobFormInfo) {
        if (jobFormInfo == null) {
            this.getPageCache().remove(CACHEKEY_JOBFORMINFO);
        } else {
            String str = SerializationUtils.toJsonString((Object)jobFormInfo);
            this.getPageCache().put(CACHEKEY_JOBFORMINFO, str);
        }
    }

    private void stepHandler(String currentTab) {
        switch (currentTab) {
            case "choose": {
                this.updateChoose();
                break;
            }
            case "update": {
                break;
            }
            case "handler": {
                this.finishUpdate();
                break;
            }
        }
    }

    private boolean isLastStep() {
        Tab tab = (Tab)this.getView().getControl("guidecontent");
        String currentTab = tab.getCurrentTab();
        return currentTab.equals(((Control)tab.getItems().get(tab.getItems().size() - 1)).getKey());
    }

    private boolean isfistStep() {
        Tab tab = (Tab)this.getView().getControl("guidecontent");
        String currentTab = tab.getCurrentTab();
        return currentTab.equals(((Control)tab.getItems().get(0)).getKey());
    }

    private void next() {
        Tab tab = (Tab)this.getView().getControl("guidecontent");
        String currentTab = tab.getCurrentTab();
        this.stepHandler(currentTab);
        for (int i = 0; i < tab.getItems().size() && !currentTab.equals(((Control)tab.getItems().get(tab.getItems().size() - 1)).getKey()); ++i) {
            Control control = (Control)tab.getItems().get(i);
            if (!control.getKey().equals(currentTab)) continue;
            tab.activeTab(((Control)tab.getItems().get(i + 1)).getKey());
            this.setWizard(i, "finish");
            this.setWizard(i + 1, "process");
            break;
        }
    }

    private void updateChoose() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        for (ListSelectedRow listSelectedRow : selectedRows) {
            Long pkid = (Long)listSelectedRow.getPrimaryKeyValue();
            DynamicObject infoObj = BusinessDataServiceHelper.loadSingle((Object)pkid, (String)BOS_MANAGEPRINTTPL, (String)"printtplid_id,type");
            String tplId = infoObj.getString(PRINTTPLID_ID);
            String string = infoObj.getString("type");
        }
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.setPercent(0);
        bar.start();
        ArrayList<String> tplIds = new ArrayList<String>();
        for (ListSelectedRow listSelectedRow : selectedRows) {
            Long pkid = (Long)listSelectedRow.getPrimaryKeyValue();
            DynamicObject infoObj = BusinessDataServiceHelper.loadSingle((Object)pkid, (String)BOS_MANAGEPRINTTPL, (String)"printtplid_id,type");
            String tplId = infoObj.getString(PRINTTPLID_ID);
            String printType = infoObj.getString("type");
            if (!"A".equals(printType)) continue;
            tplIds.add(tplId);
        }
        JobFormInfo jobFormInfo = this.buildJobFormInfo();
        IPageCache iPageCache = this.getPageCache();
        iPageCache.put("jobId", jobFormInfo.getJobInfo().getId());
        Map params = jobFormInfo.getParams();
        jobFormInfo.getJobInfo().setParams(params);
        params.put("tplIds", tplIds);
        String taskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
        this.putTaskId(taskId);
        this.putJobFormInfo(jobFormInfo);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"btnnext"});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"btnprev"});
    }

    private boolean validationUpdateChoose(ListSelectedRowCollection selectedRows) {
        return selectedRows.size() != 0;
    }

    private void finishUpdate() {
        this.hideCloseTab();
        Label success = (Label)this.getView().getControl("successlabel");
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(UPDATE_DETAIL);
        int[] selectRows = entryGrid.getSelectRows();
        Map<String, List> map = this.getTplMap(entryGrid);
        Integer successNum = selectRows.length - map.get(ERROR_TPL_KEY).size();
        success.setText(successNum + "");
        this.deleteNewTpls(map.get(DELET_KEY));
        IPageCache iPageCache = this.getPageCache();
        iPageCache.put(CLOSE_FLAG, "false");
        List list = map.get(UPDATE_KEY);
        iPageCache.put(UPDATE_KEY, JSON.toJSONString((Object)list));
        this.addLog(list);
    }

    private void addLog(List list) {
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        Map objectMap = BusinessDataServiceHelper.loadFromCache((String)BOS_MANAGEPRINTTPL, (String)"number", (QFilter[])new QFilter[]{new QFilter(PRINTTPLID_ID, "in", (Object)list)});
        if (CollectionUtils.isEmpty((Map)objectMap)) {
            return;
        }
        for (DynamicObject value : objectMap.values()) {
            PrintOpLogUtils.addLog((IFormView)this.getView().getParentView(), (String)value.getString("number"), (PrintOpLogMsgEnum)PrintOpLogMsgEnum.TPL_UPDATE);
        }
    }

    public static boolean useLoop(int[] arr, int targetValue) {
        for (int s : arr) {
            if (s != targetValue) continue;
            return true;
        }
        return false;
    }

    private Map<String, List> getTplMap(EntryGrid entryGrid) {
        HashMap<String, List> map = new HashMap<String, List>();
        map.put(UPDATE_KEY, new ArrayList());
        map.put(DELET_KEY, new ArrayList());
        map.put(ERROR_TPL_KEY, new ArrayList());
        EntryData entryData = entryGrid.getEntryData();
        int[] selectRows = entryGrid.getSelectRows();
        DynamicObject[] dynamicObjects = entryData.getDataEntitys();
        for (int i = 0; i < dynamicObjects.length; ++i) {
            DynamicObject dynamicObject = dynamicObjects[i];
            String newtplid = (String)dynamicObject.get("newtplid");
            BigDecimal decimalfield = (BigDecimal)dynamicObject.get("decimalfield");
            if (NewPrintUpdateGuidePlugin.useLoop(selectRows, i)) {
                if (decimalfield.compareTo(BigDecimal.ZERO) == 0) {
                    ((List)map.get(ERROR_TPL_KEY)).add(newtplid);
                }
                ((List)map.get(UPDATE_KEY)).add(newtplid);
                continue;
            }
            if (decimalfield.compareTo(BigDecimal.ZERO) == 0) continue;
            ((List)map.get(DELET_KEY)).add(newtplid);
        }
        return map;
    }

    private List<String> getTplList(EntryGrid entryGrid) {
        ArrayList<String> tplList = new ArrayList<String>();
        EntryData entryData = entryGrid.getEntryData();
        DynamicObject[] dynamicObjects = entryData.getDataEntitys();
        for (int i = 0; i < dynamicObjects.length; ++i) {
            DynamicObject dynamicObject = dynamicObjects[i];
            String textfield = (String)dynamicObject.get("textfield");
            if (ResManager.loadKDString((String)"\u6a21\u677f\u5df2\u7ecf\u5347\u7ea7\u8fc7\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u5347\u7ea7", (String)"MetaUpdateTask_3", (String)"bos-print-business", (Object[])new Object[0]).equals(textfield)) continue;
            String newtplid = (String)dynamicObject.get("newtplid");
            tplList.add(newtplid);
        }
        return tplList;
    }

    private int deleteNewTpls(List<String> newCanDelTplIds) {
        int success = 0;
        if (newCanDelTplIds == null || newCanDelTplIds.isEmpty()) {
            return success;
        }
        QFilter qFilter = new QFilter("id", "in", newCanDelTplIds);
        qFilter.and("tpltype", "=", (Object)"1");
        Map sysTplMap = BusinessDataServiceHelper.loadFromCache((String)PRINT_METEDATA, (String)"id,name", (QFilter[])new QFilter[]{qFilter});
        if (sysTplMap != null && sysTplMap.size() > 0) {
            String message = ResManager.loadKDString((String)"\u7cfb\u7edf\u9884\u7f6e\u6a21\u677f\u4e0d\u652f\u6301\u5220\u9664\uff1a\n%s", (String)"ManagePrintTplListPlugin_26", (String)"bos-print-business", (Object[])new Object[0]);
            StringBuilder builder = new StringBuilder();
            for (Map.Entry entry : sysTplMap.entrySet()) {
                builder.append(",").append(((DynamicObject)entry.getValue()).getLocaleString("name"));
            }
            message = String.format(message, builder.toString().replaceFirst(",", ""));
            throw new KDBizException(message);
        }
        try (TXHandle tx = TX.required();){
            qFilter = new QFilter("id", "in", newCanDelTplIds);
            success = DeleteServiceHelper.delete((String)PRINT_METEDATA, (QFilter[])new QFilter[]{qFilter});
            qFilter = new QFilter("printtplid", "in", newCanDelTplIds);
            DeleteServiceHelper.delete((String)this.PRINT_RESOURCE, (QFilter[])new QFilter[]{qFilter});
            DeleteServiceHelper.delete((String)BOS_MANAGEPRINTTPL, (QFilter[])new QFilter[]{qFilter});
        }
        return success;
    }

    private void hideCloseTab() {
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"btndone"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnprev"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnnext"});
    }

    private void previous() {
        Tab tab = (Tab)this.getView().getControl("guidecontent");
        String currentTab = tab.getCurrentTab();
        for (int i = 0; i < tab.getItems().size(); ++i) {
            this.setWizard(i - 1, "process");
            if (currentTab.equals(((Control)tab.getItems().get(1)).getKey())) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"btnprev"});
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"btnnext"});
                this.deletLastNewTpl();
            } else if (currentTab.equals(((Control)tab.getItems().get(2)).getKey())) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"btnnext"});
            }
            Control control = (Control)tab.getItems().get(i);
            if (!control.getKey().equals(currentTab)) continue;
            tab.activeTab(((Control)tab.getItems().get(i - 1)).getKey());
            break;
        }
    }

    private void deletLastNewTpl() {
        List<String> tplList = this.getTplList((EntryGrid)this.getView().getControl(UPDATE_DETAIL));
        this.deleteNewTpls(tplList);
    }

    public void afterTreeNodeFocus(String nodeId) {
        if (nodeId.startsWith("menu_")) {
            PageCacheUtils.cacheValueToPageCache(this.getPageCache(), "focus_menu", nodeId);
        } else {
            PageCacheUtils.removeValueFromPageCache(this.getPageCache(), "focus_menu");
        }
    }

    private static boolean checkPagePermission(String permissionItemId) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        int flag = PermissionServiceHelper.checkFunctionPermission((long)userId, (long)0L, (String)BOS_MANAGEPRINTTPL, (String)permissionItemId);
        boolean isHasPermission = flag == 1;
        return isHasPermission;
    }

    private boolean isTopNodeId(String currNodeId) {
        return "rootNode".equals(currNodeId);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs evt) {
        boolean isHasPermisson = NewPrintUpdateGuidePlugin.checkPagePermission("47150e89000000ac");
        if (!isHasPermisson) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u8be2\u6743\u9650\uff0c\u8bf7\u6dfb\u52a0\u6743\u9650\u540e\u518d\u8bd5\u3002", (String)"ManagePrintTplListPlugin_1", (String)"bos-print-business", (Object[])new Object[0]));
        }
    }

    public void onProgress(ProgressEvent progressEvent) {
        String taskId = this.getTaskId();
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        progressEvent.setProgress(taskInfo.getProgress());
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        if ("FAILED".equals(taskInfo.getStatus())) {
            if (100 == taskInfo.getProgress()) {
                this.setProgressDone(taskInfo);
            }
            progressEvent.setProgress(100);
            bar.stop();
        } else if ("COMPLETED".equals(taskInfo.getStatus())) {
            this.setProgressDone(taskInfo);
            progressEvent.setProgress(100);
            bar.stop();
        }
        if (!"COMPLETED".equals(taskInfo.getStatus()) && progressEvent.getProgress() == 100) {
            progressEvent.setProgress(99);
        }
    }

    private void setProgressDone(TaskInfo taskInfo) {
        this.next();
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"btnnext"});
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"btnprev"});
        this.setResultVaule(taskInfo);
    }

    private void setResultVaule(TaskInfo taskInfo) {
        Map data = null;
        try {
            data = (Map)SerializationUtils.fromJsonString((String)taskInfo.getData(), Map.class);
        }
        catch (Exception ex) {
            log.warn((Throwable)ex);
        }
        IPageCache iPageCache = this.getPageCache();
        String jsonResult = Optional.ofNullable(data).map(m -> (String)m.get("meta-update-result")).orElse(null);
        List metaUpdateResults = JSONObject.parseArray((String)jsonResult, MetaUpdateResult.class);
        EntryGrid entryGrid = (EntryGrid)this.getControl(UPDATE_DETAIL);
        if (metaUpdateResults != null) {
            ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>(metaUpdateResults.size());
            this.getModel().batchCreateNewEntryRow(UPDATE_DETAIL, metaUpdateResults.size());
            int i = 0;
            for (MetaUpdateResult metaUpdateResult : metaUpdateResults) {
                try {
                    iPageCache.put(metaUpdateResult.getNewTplId(), JSONObject.toJSONString((Object)metaUpdateResult.getMetaUpdatReport()));
                }
                catch (Exception ex) {
                    log.warn((Throwable)ex);
                }
                this.getModel().setValue("tplcode", (Object)metaUpdateResult.getTplCode(), i);
                this.getModel().setValue("tplId", (Object)metaUpdateResult.getTplId(), i);
                this.getModel().setValue("newtplid", (Object)metaUpdateResult.getNewTplId(), i);
                this.getModel().setValue("tplname", (Object)metaUpdateResult.getTplName(), i);
                this.getModel().setValue("decimalfield", (Object)metaUpdateResult.getCompatibility(), i);
                this.getModel().setValue("textfield", (Object)metaUpdateResult.getDifferenceAnalysis(), i);
                this.getModel().setValue("cmd1", (Object)ResManager.loadKDString((String)"\u5904\u7406", (String)"NewPrintTplGuidePlugin_9", (String)"bos-print-business", (Object[])new Object[0]), i);
                this.getModel().setValue("cmd", (Object)ResManager.loadKDString((String)"\u67e5\u770b\u62a5\u544a", (String)"NewPrintTplGuidePlugin_10", (String)"bos-print-business", (Object[])new Object[0]), i);
                cellStyles.add(this.setColor(i, metaUpdateResult.getCompatibility()));
                ++i;
            }
            entryGrid.setCellStyle(cellStyles);
            int[] rows = new int[metaUpdateResults.size()];
            for (int index = 0; index < metaUpdateResults.size(); ++index) {
                rows[index] = index;
            }
            this.getModel().clearNoDataRow();
            List list = Arrays.stream(rows).boxed().collect(Collectors.toList());
            entryGrid.selectRowsChanged(new ArrayList(), list);
            entryGrid.selectRows(rows, 0);
        }
    }

    private CellStyle setColor(int i, BigDecimal compatibility) {
        if (compatibility.compareTo(ONE_HUNDRED) == 0) {
            this.getModel().setValue("textfield", (Object)ResManager.loadKDString((String)"\u65e0\u5dee\u5f02\uff0c\u53ef\u5347\u7ea7", (String)"NewPrintUpdateGuidePlugin_0", (String)"bos-print-business", (Object[])new Object[0]), i);
            return this.genStyle("textfield", i, "#1BA854");
        }
        if (compatibility.compareTo(FIFTY) > 0) {
            return this.genStyle("textfield", i, "#FF991C");
        }
        return this.genStyle("textfield", i, "#FB2323");
    }

    private CellStyle genStyle(String key, int i, String foreColor) {
        CellStyle cellStyle = new CellStyle();
        cellStyle.setFieldKey(key);
        cellStyle.setRow(i);
        cellStyle.setForeColor(foreColor);
        return cellStyle;
    }

    private JobFormInfo buildJobFormInfo() {
        JobInfo jobInfo = new JobInfo();
        FormShowParameter fs = this.getView().getFormShowParameter();
        jobInfo.setlName(ResManager.getLocaleString((String)"\u6253\u5370\u6a21\u677f\u5347\u7ea7", (String)"PrintDataProgressFormPlugin_0", (String)"bos-print-business"));
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setAppId(fs.getServiceAppId());
        jobInfo.setTaskClassname("kd.bos.print.business.metedata.transformer.MetaUpdateTask");
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setParentPageId(fs.getParentPageId());
        jobFormInfo.setRootPageId(fs.getRootPageId());
        jobFormInfo.setTimeout(2000);
        jobFormInfo.getParams().putAll(fs.getCustomParams());
        if (fs.getCloseCallBack() != null) {
            jobFormInfo.setCloseCallBack(fs.getCloseCallBack());
        } else {
            CloseCallBack closeCallBack = new CloseCallBack("kd.bos.form.plugin.print.PrintCloseCallBack", "");
            jobFormInfo.setCloseCallBack(closeCallBack);
        }
        jobFormInfo.setClickClassName("kd.bos.form.plugin.print.PrintTaskClick");
        return jobFormInfo;
    }

    public void listRowClick(ListRowClickEvent evt) {
        this.setTabUseful();
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(UPDATE_DETAIL);
        int[] selectedRows = entryGrid.getSelectRows();
        if (selectedRows.length == 0) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"btnnext"});
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"btnnext"});
        }
    }

    private void setTabUseful() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (this.validationUpdateChoose(selectedRows)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"btnnext"});
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"btnnext"});
        }
    }

    private void gotoOldPrintDesigner(String id) {
        QFilter qFormId = new QFilter("form", "=", (Object)id);
        DynamicObject pageRelInfo = QueryServiceHelper.queryOne((String)"bos_devportal_unitrelform", (String)"bizapp,bizunit", (QFilter[])new QFilter[]{qFormId});
        if (StringUtils.isBlank((Object)pageRelInfo)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9875\u9762\u521b\u5efa\u5931\u8d25\uff0c\u5e94\u7528\u548c\u5e94\u7528\u5355\u5143\u4e4b\u95f4\u6ca1\u6709\u5173\u8054\u3002", (String)"ManagePrintTplListPlugin_32", (String)"bos-print-business", (Object[])new Object[0]));
            return;
        }
        String appId = pageRelInfo.getString("bizapp");
        DynamicObject pageInfo = OldPrintTemplateUtil.loadSingleFromCache(id);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ide_formdesigner");
        parameter.setCustomParam("id", (Object)id);
        parameter.setCustomParam("number", pageInfo.get("number"));
        parameter.setCustomParam("bizappid", (Object)appId);
        parameter.setClientParam("modeltype", pageInfo.get("modeltype"));
        parameter.setClientParam("modelver", (Object)DomainModelType.getVersion());
        parameter.getOpenStyle().setShowType(ShowType.NewWindow);
        this.getView().showForm(parameter);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String tplId = (String)this.getModel().getValue("newtplid", evt.getRowIndex());
        if ("cmd1".equals(evt.getFieldName())) {
            this.gotoPrintDesigner(tplId);
        } else if ("tplcode".equals(evt.getFieldName())) {
            String tplcode = (String)this.getModel().getValue("tplId", evt.getRowIndex());
            this.gotoOldPrintDesigner(tplcode);
        } else {
            this.gotoReport(tplId);
        }
    }

    private void gotoPrintDesigner(String id) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(IDE_PRINTDESIGNER);
        parameter.setCustomParam("id", (Object)id);
        parameter.setCustomParam("tplType", (Object)TplType.PrintTpl.toString());
        parameter.getOpenStyle().setShowType(ShowType.NewWindow);
        this.getView().showForm(parameter);
    }

    private void gotoReport(String id) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(BOS_UPDATE_REPORT);
        IPageCache iPageCache = this.getPageCache();
        String reportJson = iPageCache.get(id);
        parameter.setCustomParam("id", (Object)id);
        parameter.setCustomParam("reportJson", (Object)reportJson);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(parameter);
    }
}

