/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.designer.plugin;

import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.print.api.metedata.PrintMetadata;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class NumberCheckUtils {
    public static final String KD_TPLNUM_PREFIX = "kdprint_";
    private static final String regex = "^\\w+$";

    private static String getTipOne() {
        return ResManager.loadKDString((String)"\u7f16\u7801\u5fc5\u987b\u7531\u5c0f\u5199\u5b57\u6bcd\u3001\u6570\u5b57\u6216\u4e0b\u5212\u7ebf\u7ec4\u6210\u3002", (String)"NumberCheckUtils_1", (String)"bos-print-business", (Object[])new Object[0]);
    }

    private static final String getTipTwo() {
        return ResManager.loadKDString((String)"\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc750\u4e2a\u5b57\u7b26\u3002", (String)"NumberCheckUtils_2", (String)"bos-print-business", (Object[])new Object[0]);
    }

    public static boolean isKingdeeISV() {
        return ISVServiceHelper.isKingdeeISV();
    }

    public static Tuple<Boolean, String> validateIsv(String number) {
        boolean valid = true;
        String message = "";
        boolean withKdPrefix = number.startsWith(KD_TPLNUM_PREFIX);
        if (NumberCheckUtils.isKingdeeISV()) {
            if (!withKdPrefix) {
                valid = false;
                message = String.format(ResManager.loadKDString((String)"\u8bf7\u5728\u6a21\u677f\u7f16\u7801\u52a0\u4e0a\u539f\u5382\u6807\u8bc6\u524d\u7f00\u201ckdprint_\u201d\u3002", (String)"NewPrintTplGuidePlugin_8", (String)"bos-print-business", (Object[])new Object[0]), KD_TPLNUM_PREFIX);
            }
        } else if (withKdPrefix) {
            valid = false;
            message = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7f16\u7801\u5df2\u88ab\u7cfb\u7edf\u4f7f\u7528\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"NewPrintTplGuidePlugin_7", (String)"bos-print-business", (Object[])new Object[0]), KD_TPLNUM_PREFIX);
        }
        return new Tuple((Object)valid, (Object)message);
    }

    public static Tuple<Boolean, String> validate(String number) {
        String message = NumberCheckUtils.getTipOne();
        boolean valid = true;
        if (StringUtils.isNotBlank((CharSequence)number)) {
            if (!Pattern.matches(regex, number)) {
                valid = false;
            } else if (number.length() > 50) {
                message = NumberCheckUtils.getTipTwo();
                valid = false;
            }
        } else {
            valid = false;
        }
        return new Tuple((Object)valid, (Object)message);
    }

    public static boolean isNumberExist(String tplKey) {
        QFilter filter = new QFilter("number", "=", (Object)tplKey);
        boolean exist = QueryServiceHelper.exists((String)"bos_print_meta", (QFilter[])new QFilter[]{filter});
        return exist;
    }

    @Deprecated
    public static void isNumberExist(Map<String, Object> content, PrintMetadata printMetadata) {
        QFilter filter;
        boolean exist;
        Object oldKey = content.get("key");
        String newKey = printMetadata.getKey();
        if (oldKey != null && !newKey.equals(oldKey) && (exist = QueryServiceHelper.exists((String)"bos_print_meta", (QFilter[])new QFilter[]{filter = new QFilter("number", "=", (Object)newKey)}))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"NumberCheckUtils_3", (String)"bos-print-business", (Object[])new Object[0]));
        }
    }
}

