/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.designer.plugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.service.dto.AppType;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.print.business.metedata.service.TplFileUtil;
import kd.bos.svc.util.print.PrintFileUtil;
import kd.bos.svc.util.print.PrtTaskResult;
import kd.bos.svc.util.print.PrtTaskResultServiceHelper;
import org.apache.commons.io.IOUtils;

public class PrintResultViewPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final Log log = LogFactory.getLog(PrintResultViewPlugin.class);
    private int rowIndex;
    private static final String ATTACH_DETAIL = "attachdetail";
    private static final String BTN_BATCH_PREVIEW = "batchpreview";
    private static final String BTN_BATCH_DOWNLOAD = "batchdownload";
    private static final String BASE_DIR = "bos_print_resultview";
    private static String WORK_DIR = System.getProperty("user.home") + File.separator + "KINGDEEDOWNLOAD";

    public void initialize() {
        super.initialize();
        EntryGrid dsentry = (EntryGrid)this.getControl(ATTACH_DETAIL);
        dsentry.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{BTN_BATCH_PREVIEW});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        if (BTN_BATCH_PREVIEW.equals(evt.getItemKey())) {
            this.batchPreview();
        } else if (BTN_BATCH_DOWNLOAD.equals(evt.getItemKey())) {
            this.batchDownload();
        }
    }

    public void click(EventObject event) {
        Control c = (Control)event.getSource();
        String key = c.getKey();
        if (BTN_BATCH_PREVIEW.equals(key)) {
            this.batchPreview();
        }
    }

    private void batchPreview() {
        EntryGrid dsentry = (EntryGrid)this.getControl(ATTACH_DETAIL);
        int[] selectRows = dsentry.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u9884\u89c8\u7684\u6570\u636e\u3002", (String)"PrintResultViewPlugin_0", (String)"bos-print-business", (Object[])new Object[0]));
            return;
        }
        Object taskId = this.getModel().getValue("taskid");
        Object openSource = this.getView().getFormShowParameter().getCustomParam("openSource");
        for (int rowIndex : selectRows) {
            DynamicObject entryObj = this.getModel().getEntryRowEntity(ATTACH_DETAIL, rowIndex);
            Object attachId = entryObj.get("attachid");
            String downloadUrl = "api/print/download.do?taskId=%s&attachId=%s";
            downloadUrl = String.format(downloadUrl, taskId, attachId);
            if (AppType.DingTalk.getName().equalsIgnoreCase(String.valueOf(openSource))) {
                downloadUrl = downloadUrl + "&downloadAttach=true";
                this.getView().download(downloadUrl);
                continue;
            }
            this.getView().openUrl(downloadUrl);
        }
    }

    private void batchDownload() {
        EntryGrid dsentry = (EntryGrid)this.getControl(ATTACH_DETAIL);
        int[] selectRows = dsentry.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u4e0b\u8f7d\u7684\u6570\u636e\u3002", (String)"PrintResultViewPlugin_2", (String)"bos-print-business", (Object[])new Object[0]));
            return;
        }
        ArrayList<String> attachIds = new ArrayList<String>(selectRows.length);
        for (int rowIndex : selectRows) {
            DynamicObject entryObj = this.getModel().getEntryRowEntity(ATTACH_DETAIL, rowIndex);
            attachIds.add(String.valueOf(entryObj.get("attachid")));
        }
        Object taskId = this.getModel().getValue("taskid");
        PrtTaskResult prtResult = PrtTaskResultServiceHelper.getPrtResult((String)String.valueOf(taskId), (boolean)false);
        List<PrtTaskResult.Attach> attachList = prtResult.getAttach();
        String zipUrl = this.zipPdfAttachList(attachList = attachList.stream().filter(f -> attachIds.contains(f.getAttachId())).collect(Collectors.toList()), prtResult.getDiskType());
        if (zipUrl != null) {
            this.getView().download(zipUrl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String zipPdfAttachList(List<PrtTaskResult.Attach> attachList, String diskType) {
        InputStream in = null;
        String curDir = System.currentTimeMillis() + "";
        String curWorkPath = WORK_DIR + File.separator + curDir;
        String localPath = curWorkPath + File.separator + BASE_DIR;
        try {
            String firstPdfName;
            Object object;
            File file = new File(localPath);
            if (!file.exists()) {
                file.mkdirs();
            }
            for (PrtTaskResult.Attach attach : attachList) {
                String fileName = attach.getFileName();
                String filePath = attach.getFilePath();
                FileOutputStream fileOutputStream = new FileOutputStream(localPath + File.separator + fileName);
                object = null;
                try {
                    InputStream fileInputStream = "2".equals(diskType) ? PrintFileUtil.getFileInputStream((String)filePath, (String)"2") : FileServiceFactory.getAttachmentFileService().getInputStream(filePath);
                    Throwable throwable = null;
                    try {
                        IOUtils.copy((InputStream)fileInputStream, (OutputStream)fileOutputStream, (int)2048);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (fileInputStream == null) continue;
                        if (throwable != null) {
                            try {
                                fileInputStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        fileInputStream.close();
                    }
                }
                catch (Throwable fileInputStream) {
                    object = fileInputStream;
                    throw fileInputStream;
                }
                finally {
                    if (fileOutputStream == null) continue;
                    if (object != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (Throwable fileInputStream) {
                            ((Throwable)object).addSuppressed(fileInputStream);
                        }
                        continue;
                    }
                    fileOutputStream.close();
                }
            }
            String zipFileName = BASE_DIR;
            if (!CollectionUtils.isEmpty(attachList) && !StringUtils.isEmpty((Object)(firstPdfName = attachList.get(0).getFileName()))) {
                zipFileName = firstPdfName.split("\\.")[0];
            }
            String zipName = zipFileName + ".zip";
            String zipPath = TplFileUtil.zipFiles(zipName, localPath);
            Path downloadPath = Paths.get(zipPath, new String[0]);
            in = Files.newInputStream(downloadPath, new OpenOption[0]);
            object = PrintFileUtil.saveAsPrintTempUrl((InputStream)in, (String)zipName, (boolean)false);
            return object;
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.error((Throwable)e);
                }
            }
            TplFileUtil.deleteFiles(new File(curWorkPath));
        }
        return null;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        boolean isDownloadOp = false;
        if ("preview".equals(operateKey) || (isDownloadOp = "download".equals(operateKey))) {
            if (this.rowIndex < 0) {
                return;
            }
            Object taskId = this.getModel().getValue("taskid");
            DynamicObject entryObj = this.getModel().getEntryRowEntity(ATTACH_DETAIL, this.rowIndex);
            Object attachId = entryObj.get("attachid");
            String downloadUrl = "api/print/download.do?taskId=%s&attachId=%s";
            downloadUrl = String.format(downloadUrl, taskId, attachId);
            Object openSource = this.getView().getFormShowParameter().getCustomParam("openSource");
            if (AppType.DingTalk.getName().equalsIgnoreCase(String.valueOf(openSource)) || isDownloadOp) {
                downloadUrl = downloadUrl + "&downloadAttach=true";
                this.getView().download(downloadUrl);
            } else {
                this.getView().openUrl(downloadUrl);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object taskId = formShowParameter.getCustomParam("taskId");
        if (Objects.isNull(taskId)) {
            return;
        }
        PrtTaskResult taskResult = PrtTaskResultServiceHelper.getPrtResult((String)String.valueOf(taskId));
        List attachList = taskResult.getAttach();
        this.getModel().setValue("taskid", taskId);
        this.getModel().batchCreateNewEntryRow(ATTACH_DETAIL, attachList.size());
        int i = 0;
        for (PrtTaskResult.Attach attach : attachList) {
            this.getModel().setValue("attachid", (Object)attach.getAttachId(), i);
            this.getModel().setValue("filename", (Object)attach.getFileName(), i);
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"filename"});
            ++i;
        }
    }

    public void entryRowClick(RowClickEvent e) {
        this.rowIndex = e.getRow();
    }

    static {
        WORK_DIR = PrintFileUtil.normalize((String)WORK_DIR);
    }
}

