/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.designer.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.QueryResult;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.business.control.PrintControlUtils;
import kd.bos.print.business.utils.PrintOpLogUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;

public class PrtFontListPlugin
extends AbstractListPlugin {
    private static final String BOS_PRT_FONT = "bos_prt_font";
    private static final String NUMBER = "number";
    private static final String BOS_PRINT_BUSINESS = "bos-print-business";

    public void setFilter(SetFilterEvent e) {
        e.addCustomQFilter(new QFilter("source", "=", (Object)"2"));
        e.addCustomQFilter(new QFilter("tenantid", "=", (Object)RequestContext.get().getTenantId()));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (StringUtils.equals((CharSequence)"new", (CharSequence)operateKey)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("bos_dutystate");
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "fontDutyState");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCloseCallBack(callBack);
            parameter.setCaption(ResManager.loadKDString((String)"\u514d\u8d23\u58f0\u660e", (String)"PrtFontListPlugin_0", (String)BOS_PRINT_BUSINESS, (Object[])new Object[0]));
            parameter.setCustomParam("type", (Object)"new");
            this.getView().showForm(parameter);
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        AbstractOperate source = (AbstractOperate)args.getSource();
        String opKey = source.getOperateKey();
        String opName = source.getOperateName() == null ? "" : source.getOperateName().getLocaleValue_zh_CN();
        OperationResult operationResult = args.getOperationResult();
        String errorFormId = "bos_operationresult";
        String titleKey = "title";
        String errorMsg = "errorMsg";
        String titleMsg = ResManager.loadKDString((String)"\u5171%1$s\u5f20\u5355\u636e\uff0c\u5176\u4e2d\u6210\u529f%2$s\u5f20\uff0c\u5931\u8d25%3$s\u5f20\u3002", (String)"PrtFontListPlugin_1", (String)BOS_PRINT_BUSINESS, (Object[])new Object[0]);
        if ("submit".equals(operateKey)) {
            if (operationResult != null) {
                List successPkIds = operationResult.getSuccessPkIds();
                this.errorMsgProcess(opKey, operationResult, errorFormId, titleKey, errorMsg, titleMsg, operationResult.getAllErrorOrValidateInfo());
                if (successPkIds == null || successPkIds.isEmpty()) {
                    return;
                }
                this.notifyFontChange();
                this.writeLog(opKey, opName, successPkIds);
            }
        } else if ("delete".equals(operateKey)) {
            List successPkIds = operationResult.getSuccessPkIds();
            this.errorMsgProcess(opKey, operationResult, errorFormId, titleKey, errorMsg, titleMsg, operationResult.getAllErrorOrValidateInfo());
            successPkIds = successPkIds.stream().map(pkId -> String.valueOf(pkId)).collect(Collectors.toList());
            if (!successPkIds.isEmpty()) {
                DeleteServiceHelper.delete((String)"bos_print_resource", (QFilter[])new QFilter[]{new QFilter("printtplid", "in", successPkIds)});
                this.notifyFontChange();
            }
        } else if (operationResult != null && "unsubmit".equals(operateKey)) {
            List successPkIds = operationResult.getSuccessPkIds();
            int successCount = successPkIds.size();
            this.errorMsgProcess(opKey, operationResult, errorFormId, titleKey, errorMsg, titleMsg, operationResult.getAllErrorOrValidateInfo());
            if (successCount > 0) {
                this.notifyFontChange();
                this.writeLog(opKey, opName, successPkIds);
            }
        }
    }

    private void writeLog(String opKey, String opName, List<Object> successPkIds) {
        QFilter filter = new QFilter("id", "in", successPkIds);
        Map fontMap = BusinessDataServiceHelper.loadFromCache((String)BOS_PRT_FONT, (String)"id,alias", (QFilter[])new QFilter[]{filter});
        String fontAlias = fontMap.values().stream().map(m -> m.getString("alias")).collect(Collectors.joining("\uff0c"));
        PrintOpLogUtils.addLog((String)"cts", (String)BOS_PRT_FONT, (String)"web", (String)opKey, (String)opName, (String)fontAlias);
    }

    private void errorMsgProcess(String opName, OperationResult operationResult, String errorFormId, String titleKey, String errorMsg, String titleMsg, List<IOperateInfo> allErrorInfoList) {
        if (!allErrorInfoList.isEmpty()) {
            operationResult.setShowMessage(false);
            ArrayList<String> errorTipList = new ArrayList<String>(10);
            ArrayList<Object> errorPkIds = new ArrayList<Object>(10);
            int len = allErrorInfoList.size();
            for (int i = 0; i < len; ++i) {
                String msg = allErrorInfoList.get(i).getMessage();
                String[] msgArray = msg.split(":");
                errorPkIds.add(allErrorInfoList.get(i).getPkValue());
                if (msgArray.length > 1) {
                    errorTipList.add(msgArray[1]);
                    continue;
                }
                errorTipList.add(msgArray[0]);
            }
            Map errorDynamicObject = BusinessDataServiceHelper.loadFromCache((Object[])errorPkIds.toArray(), (String)BOS_PRT_FONT);
            ArrayList<String> list = new ArrayList<String>(10);
            Iterator it = errorDynamicObject.entrySet().iterator();
            int i = 0;
            while (it.hasNext()) {
                list.add(((DynamicObject)it.next().getValue()).get(NUMBER) + ":" + (String)errorTipList.get(i));
                ++i;
            }
            if (allErrorInfoList.size() > 1) {
                FormShowParameter parameters = new FormShowParameter();
                parameters.getOpenStyle().setShowType(ShowType.Modal);
                parameters.setFormId(errorFormId);
                parameters.setShowTitle(false);
                int successCount = operationResult.getSuccessPkIds().size();
                String title = String.format(titleMsg, operationResult.getBillCount(), successCount, operationResult.getBillCount() - successCount);
                parameters.setCustomParam(titleKey, (Object)title);
                parameters.setCustomParam(errorMsg, list);
                this.getView().showForm(parameters);
            } else {
                this.getView().showTipNotification((String)list.get(0));
            }
        }
    }

    private void notifyFontChange() {
        String cacheKey = RequestContext.get().getTenantId();
        PrtFontListPlugin.getFontCache().remove(new String[]{cacheKey});
        PrintControlUtils.removeCache();
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        QueryResult queryResult = billList.queryDataBySelectedRows(selectedRows);
        DynamicObjectCollection collection = queryResult.getCollection();
        if (CollectionUtils.isEmpty((Collection)collection)) {
            return;
        }
        for (DynamicObject dynamicObject : collection) {
            String name = dynamicObject.getString("name");
            if (!StringUtils.isNotBlank((CharSequence)name)) continue;
            PrtFontListPlugin.removeCache(name);
        }
    }

    private static LocalMemoryCache getFontCache() {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(1800);
        info.setMaxMemSize(1000);
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(CacheKeyUtil.getAcctId(), "FontCacheGroup", info);
    }

    static void removeCache(String name) {
        LocalMemoryCache fontLocalCache = PrtFontListPlugin.getKDFontCache();
        fontLocalCache.remove(new String[]{name});
    }

    private static LocalMemoryCache getKDFontCache() {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(86400);
        info.setMaxMemSize(1000);
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(CacheKeyUtil.getAcctId(), "KDFontCache", info);
    }
}

