/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.designer.plugin;

import java.awt.Font;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.print.api.utils.SerializeUtils;
import kd.bos.print.business.control.PrintControlUtils;
import kd.bos.print.business.designer.plugin.PrtFontListPlugin;
import kd.bos.print.business.metedata.bean.ResPowerScope;
import kd.bos.print.business.metedata.bean.TplResource;
import kd.bos.print.business.service.BosPrintBusinessServiceImpl;
import kd.bos.print.business.utils.PrintOpLogUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class PrtFontPlugin
extends AbstractBillPlugIn
implements UploadListener {
    private static final Log log = LogFactory.getLog(PrtFontPlugin.class);
    private static BosPrintBusinessServiceImpl printBusinessService = new BosPrintBusinessServiceImpl();
    private static final String PROJECT_NAME = "bos-print-business";
    private static final String CACHE_FONT_INFO = "fontinfo";

    public void registerListener(EventObject e) {
        AttachmentPanel dbspanel = (AttachmentPanel)this.getView().getControl("attachmentpanel");
        dbspanel.addUploadListener((UploadListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getModel().setValue("tenantid", (Object)RequestContext.get().getTenantId());
        this.getModel().setDataChanged(false);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        IFormView parentView = this.getView().getParentView();
        if (parentView instanceof ListView && "bos_prt_font".equals(((ListView)parentView).getBillFormId())) {
            parentView.invokeOperation("refresh");
            this.getView().sendFormAction(parentView);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null || !operationResult.isSuccess()) {
            return;
        }
        AbstractOperate source = (AbstractOperate)args.getSource();
        String opName = source.getOperateName() == null ? "" : source.getOperateName().getLocaleValue_zh_CN();
        List successPkIds = operationResult.getSuccessPkIds();
        String operateKey = args.getOperateKey();
        if ("delete".equals(operateKey)) {
            DynamicObject obj = this.getModel().getDataEntity();
            Long pkId = (Long)obj.getPkValue();
            printBusinessService.deleteFile(pkId);
            this.notifyFontChange();
        } else if ("submit".equals(operateKey) || "save".equals(operateKey)) {
            Map attachment;
            AttachmentPanel attachmentPanel;
            List attachmentData;
            long rcId;
            Map<String, Object> fileInfo;
            String url;
            String rcIdValue = (String)this.getModel().getValue("rcid");
            if (rcIdValue != null && StringUtils.isBlank((CharSequence)(url = (String)(fileInfo = printBusinessService.getFileInfo(rcId = Long.parseLong(rcIdValue))).get("url"))) && (attachmentData = (attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanel")).getAttachmentData()) != null && attachmentData.size() > 0 && (attachment = (Map)attachmentData.get(0)) != null) {
                String attUrl = (String)attachment.get("relativeUrl");
                String update = "update t_svc_printresource set furl=? where fid=?";
                Object[] params = new SqlParameter[]{new SqlParameter(":furl", 12, (Object)attUrl), new SqlParameter(":fid", -5, (Object)rcIdValue)};
                try (TXHandle tx = TX.required();){
                    DB.execute((DBRoute)DBRoute.basedata, (String)update, (Object[])params);
                }
            }
            if ("submit".equals(operateKey)) {
                this.notifyFontChange();
                this.writeLog(operateKey, opName, successPkIds);
            }
        } else if ("unsubmit".equals(operateKey)) {
            this.notifyFontChange();
            this.writeLog(operateKey, opName, successPkIds);
        }
    }

    private void writeLog(String operateKey, String opName, List<Object> successPkIds) {
        QFilter filter = new QFilter("id", "in", successPkIds);
        Map fontMap = BusinessDataServiceHelper.loadFromCache((String)"bos_prt_font", (String)"id,alias", (QFilter[])new QFilter[]{filter});
        String fontAlias = fontMap.values().stream().map(m -> m.getString("alias")).collect(Collectors.joining("\uff0c"));
        PrintOpLogUtils.addLog((String)"cts", (String)"bos_prt_font", (String)"web", (String)operateKey, (String)opName, (String)fontAlias);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("save".equals(operateKey) || "submit".equals(operateKey)) {
            if (!this.isUploadFontFile()) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u201c\u9644\u4ef6\u201d\u3002", (String)"PrtFontPlugin_2", (String)PROJECT_NAME, (Object[])new Object[0]));
                return;
            }
            String cacheFile = this.getPageCache().get(CACHE_FONT_INFO);
            if (StringUtils.isBlank((CharSequence)cacheFile)) {
                return;
            }
            Map fileInfo = (Map)SerializationUtils.fromJsonString((String)cacheFile, Map.class);
            String source = (String)this.getModel().getValue("source");
            long pkId = (Long)this.getModel().getValue("id");
            if (pkId == 0L) {
                pkId = DB.genLongId((String)"t_svc_prtfont");
                this.getModel().setValue("id", (Object)pkId);
            }
            this.getModel().setValue("billno", (Object)pkId);
            Object rcIdStr = this.getModel().getValue("rcid");
            long rcId = StringUtils.isBlank((Object)rcIdStr) ? DB.genLongId((String)"t_svc_printresource") : Long.parseLong((String)rcIdStr);
            boolean exists = QueryServiceHelper.exists((String)"bos_print_resource", (Object)rcId);
            if (!exists) {
                InputStream inputStream = null;
                try {
                    String name = (String)fileInfo.get("name");
                    String path = (String)fileInfo.get("url");
                    int fileSize = (Integer)fileInfo.get("size");
                    TplResource resource = new TplResource();
                    resource.setRcId(rcId);
                    TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
                    inputStream = cache.getInputStream(path);
                    if ("1".equals(source)) {
                        byte[] bytes = this.readBytes(inputStream);
                        resource.setData(bytes);
                        resource.setUrl(" ");
                    } else {
                        resource.setUrl("");
                        resource.setData(null);
                    }
                    resource.setFilename(name);
                    resource.setPowerscope(ResPowerScope.POWER_TENANT.getCode());
                    resource.setType("3");
                    resource.setFiletype(name.substring(name.lastIndexOf(46) + 1));
                    resource.setPrinttplid(String.valueOf(pkId));
                    resource.setCreatorid(RequestContext.get().getCurrUserId());
                    resource.setCreatetime(new Date());
                    resource.setFilesize((long)fileSize);
                    this.getModel().setValue("rcid", (Object)rcId);
                    printBusinessService.saveTplResources(String.valueOf(pkId), Collections.singletonList(resource));
                }
                catch (Exception e) {
                    args.setCancel(true);
                    args.setCancelMessage(ResManager.loadKDString((String)"\u5b57\u4f53\u4fdd\u5b58\u5931\u8d25\u3002", (String)"PrtFontPlugin_0", (String)PROJECT_NAME, (Object[])new Object[0]));
                    return;
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException e) {
                            log.error((Throwable)e);
                        }
                    }
                }
            }
        }
    }

    public void upload(UploadEvent evt) {
        evt.getSource();
        Object[] urls = evt.getUrls();
        Map fileInfo = (Map)urls[0];
        String url = (String)fileInfo.get("url");
        this.getPageCache().put(CACHE_FONT_INFO, SerializeUtils.toJsonString((Object)fileInfo));
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        try (InputStream inputStream = cache.getInputStream(url);){
            Font f = Font.createFont(0, inputStream);
            String fontName = f.getFontName(Locale.SIMPLIFIED_CHINESE);
            String fontCode = f.getFontName(Locale.ENGLISH);
            QFilter[] qFilters = new QFilter[]{new QFilter("name", "=", (Object)fontName), new QFilter("tenantid", "=", (Object)RequestContext.get().getTenantId()).or(new QFilter("source", "=", (Object)"1"))};
            Map fontMap = BusinessDataServiceHelper.loadFromCache((String)"bos_prt_font", (String)"id,source", (QFilter[])qFilters);
            boolean exists = false;
            for (Map.Entry entry : fontMap.entrySet()) {
                DynamicObject value = (DynamicObject)entry.getValue();
                if ("1".equals(value.getString("source"))) continue;
                exists = true;
            }
            if (exists) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5b57\u4f53\u5df2\u7ecf\u4e0a\u4f20\uff0c\u8bf7\u52ff\u91cd\u590d\u4e0a\u4f20\u3002", (String)"PrtFontPlugin_3", (String)PROJECT_NAME, (Object[])new Object[0]));
                return;
            }
            this.getModel().setValue("name", (Object)fontName);
            this.getModel().setValue("alias", (Object)fontName);
            this.getModel().setValue("number", (Object)fontCode);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            this.getView().showErrorNotification(e.getMessage());
        }
    }

    public void remove(UploadEvent evt) {
        DynamicObject obj = this.getModel().getDataEntity();
        String rcId = obj.getString("rcid");
        this.getModel().setValue("name", (Object)"");
        this.getModel().setValue("billno", (Object)"");
        this.getModel().setValue("rcid", (Object)"");
        if (StringUtils.isNotBlank((CharSequence)rcId)) {
            printBusinessService.deleteFile(Long.parseLong(rcId));
        }
    }

    private byte[] readBytes(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        while ((n = inputStream.read(buffer)) != -1) {
            output.write(buffer, 0, n);
        }
        return output.toByteArray();
    }

    private boolean isUploadFontFile() {
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanel");
        List data = attachmentPanel.getAttachmentData();
        return data != null && !data.isEmpty();
    }

    private void notifyFontChange() {
        String cacheKey = RequestContext.get().getTenantId();
        PrtFontPlugin.getFontCache().remove(new String[]{cacheKey});
        PrintControlUtils.removeCache();
        String name = this.getModel().getDataEntity().getString("name");
        if (StringUtils.isNotBlank((CharSequence)name)) {
            PrtFontListPlugin.removeCache(name);
        }
    }

    private static LocalMemoryCache getFontCache() {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(1800);
        info.setMaxMemSize(1000);
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(CacheKeyUtil.getAcctId(), "FontCacheGroup", info);
    }
}

