/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.designer.plugin;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.formop.NewEntry;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.print.api.metedata.control.prop.SortSetting;
import kd.bos.print.api.utils.SerializeUtils;

public class SortFieldSettingPlugin
extends AbstractFormPlugin {
    private static final String CACHE_KEY2NAME = "key2NameMap";
    private static final String BTN_OK = "btnok";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String ENTRY_BINDFIELD = "bindfield";
    private static final String ENTRY_BINDNAME = "bindname";
    private static final String ENTRY_DATA_SOURCE = "datasource";
    private static final String ENTRY_ORDERBY = "orderby";
    private static final String FORM_PARAM_DATAGRIDID = "datagridId";
    private static final String FORM_PARAM_DATA_SOURCE = "dataSource";
    private static final String FORM_PARAM_SORT_FIELDS = "sortFields";
    private static final String FORM_PARAM_SORT_SETTINGS = "sortSettings";
    private static final int MAX_ENTRY_COUNT = 5;

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void afterBindData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object sortFieldsObj = customParams.get(FORM_PARAM_SORT_FIELDS);
        if (sortFieldsObj != null) {
            List sortFields = (List)sortFieldsObj;
            ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(sortFields.size());
            for (Map sortField : sortFields) {
                comboItemList.add(new ComboItem(new LocaleString(String.valueOf(sortField.get("Name"))), String.valueOf(sortField.get("Key"))));
            }
            ((ComboEdit)this.getView().getControl(ENTRY_BINDFIELD)).setComboItems(comboItemList);
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object sortSettings = customParams.get(FORM_PARAM_SORT_SETTINGS);
        if (sortSettings != null) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
            JSONArray sortSettingList = (JSONArray)sortSettings;
            for (int i = 0; i < sortSettingList.size(); ++i) {
                SortSetting sortSetting = (SortSetting)sortSettingList.getObject(i, SortSetting.class);
                DynamicObject entryObj = new DynamicObject(entryEntity.getDynamicObjectType());
                entryObj.set(ENTRY_BINDFIELD, (Object)sortSetting.getBindField());
                entryObj.set(ENTRY_BINDNAME, (Object)sortSetting.getBindName());
                entryObj.set(ENTRY_DATA_SOURCE, (Object)sortSetting.getDataSource());
                entryObj.set(ENTRY_ORDERBY, (Object)sortSetting.getOrderBy());
                entryEntity.add((Object)entryObj);
            }
            Control control = this.getView().getControl(ENTRY_ENTITY);
            control.getModel().setValue(ENTRY_ENTITY, (Object)entryEntity);
        }
    }

    public void click(EventObject evt) {
        if (BTN_OK.equals(((Button)evt.getSource()).getKey())) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Object dataGridId = customParams.get(FORM_PARAM_DATAGRIDID);
            Object dataSource = customParams.get(FORM_PARAM_DATA_SOURCE);
            HashMap resultMap = new HashMap(2);
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity(ENTRY_ENTITY);
            ArrayList sortFields = new ArrayList(entryentity.getRowCount());
            resultMap.put("dataGridId", dataGridId);
            for (DynamicObject dynamicObject : entryentity) {
                HashMap<String, Object> sortField = new HashMap<String, Object>(4);
                sortField.put("bindField", dynamicObject.get(ENTRY_BINDFIELD));
                sortField.put("orderBy", dynamicObject.get(ENTRY_ORDERBY));
                sortField.put(FORM_PARAM_DATA_SOURCE, String.valueOf(dataSource));
                sortField.put("bindName", dynamicObject.get(ENTRY_BINDNAME));
                sortFields.add(sortField);
            }
            resultMap.put(FORM_PARAM_SORT_SETTINGS, sortFields);
            this.getView().returnDataToParent(resultMap);
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        FormShowParameter parameter;
        Object sortFields;
        IDataEntityProperty property = e.getProperty();
        if (property != null && ENTRY_BINDFIELD.equals(property.getName()) && (sortFields = (parameter = this.getView().getFormShowParameter()).getCustomParams().get(FORM_PARAM_SORT_FIELDS)) != null) {
            Map<Object, Object> key2Name;
            String cacheMap = this.getPageCache().get(CACHE_KEY2NAME);
            if (StringUtils.isBlank((CharSequence)cacheMap)) {
                key2Name = ((List)sortFields).stream().collect(Collectors.toMap(m -> m.get("Key"), m -> m.get("Name"), (m1, m2) -> m2));
                this.getPageCache().put(CACHE_KEY2NAME, SerializeUtils.toJsonString(key2Name));
            } else {
                key2Name = (Map<Object, Object>)SerializeUtils.fromJsonString((String)cacheMap, Map.class);
            }
            for (int i = 0; i < e.getChangeSet().length; ++i) {
                ChangeData changeData = e.getChangeSet()[i];
                if (changeData.getNewValue() == null || changeData.getNewValue() == changeData.getOldValue()) continue;
                ((DynamicObject)this.getModel().getEntryEntity(ENTRY_ENTITY).get(changeData.getRowIndex())).set(ENTRY_BINDNAME, key2Name.get(changeData.getNewValue()));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof NewEntry && this.getModel().getEntryEntity(ENTRY_ENTITY).getRowCount() >= 5) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u5927\u652f\u63015\u4e2a\u6392\u5e8f\u5b57\u6bb5\u3002", (String)"PrintDesignerPlugin_10", (String)"bos-print-business", (Object[])new Object[0]));
        }
    }

    public static String getCustomParamDataGridId() {
        return FORM_PARAM_DATAGRIDID;
    }

    public static String getCustomParamDataSource() {
        return FORM_PARAM_DATA_SOURCE;
    }

    public static String getCustomParamSortFields() {
        return FORM_PARAM_SORT_FIELDS;
    }

    public static String getFormParamSortSettings() {
        return FORM_PARAM_SORT_SETTINGS;
    }
}

