/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.designer.plugin.datasource;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;

public class CustomDsPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String CUSTOM_DS_KEY = "bos_custom_ds";
    private static final String DS_ENTRY_KEY = "dslist";
    private static final String FIELD_SUBENTRY_KEY = "fielditems";
    private static final String PROJECT_NAME = "bos-print-business";

    public void initialize() {
        this.addItemClickListeners(new String[]{"dstoolbar", "fieldtoolbar"});
    }

    public void createNewData(BizDataEventArgs e) {
        Object dsData = this.getView().getFormShowParameter().getCustomParams().get("data");
        if (StringUtils.isBlank(dsData)) {
            return;
        }
        List dsList = (List)SerializationUtils.fromJsonString((String)((String)dsData), List.class);
        MainEntityType entityType = this.getModel().getDataEntityType();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(DS_ENTRY_KEY, dsList);
        data.put("_Type_", CUSTOM_DS_KEY);
        DynamicObject dataSource = CustomDsPlugin.toDynamicObject(SerializationUtils.toJsonString(data), entityType);
        DynamicObjectCollection dsLists = dataSource.getDynamicObjectCollection(DS_ENTRY_KEY);
        for (DynamicObject ds : dsLists) {
            DynamicObjectCollection fieldItems = ds.getDynamicObjectCollection(FIELD_SUBENTRY_KEY);
            for (DynamicObject fieldItem : fieldItems) {
                this.multiLangFieldSetValue(fieldItem, "fieldname", "fieldmname");
            }
            this.multiLangFieldSetValue(ds, "name", "mname");
        }
        e.setDataEntity((Object)dataSource);
    }

    private void multiLangFieldSetValue(DynamicObject object, String textField, String multiTextField) {
        Object multiName = object.get(multiTextField);
        if (multiName == null) {
            return;
        }
        if (multiName instanceof OrmLocaleValue && ((OrmLocaleValue)multiName).isEmpty()) {
            ((OrmLocaleValue)multiName).setLocaleValue_zh_CN(object.getString(textField));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("donothing".equals(operateKey)) {
            OperationResult operationResult = args.getOperationResult();
            if (!operationResult.isSuccess()) {
                return;
            }
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            List<String> msgList = this.validateData(dataEntity);
            if (!msgList.isEmpty()) {
                this.getView().showMessage("", StringUtils.join((Object[])msgList.toArray(), (String)"\r\n"), MessageTypes.Commit);
            } else {
                Map data = CustomDsPlugin.dynamicObjectToMap(dataEntity);
                List dsList = (List)data.get(DS_ENTRY_KEY);
                if (dsList == null) {
                    dsList = Collections.EMPTY_LIST;
                }
                this.getView().returnDataToParent((Object)dsList);
                this.getView().close();
            }
        }
    }

    private List<String> validateData(DynamicObject object) {
        ArrayList<String> msgList = new ArrayList<String>();
        DynamicObjectCollection collection = object.getDynamicObjectCollection(DS_ENTRY_KEY);
        HashSet<String> dsKeys = new HashSet<String>();
        Object dsList = this.getView().getFormShowParameter().getCustomParams().get("dsList");
        if (dsList != null) {
            dsKeys.addAll((Collection)dsList);
        }
        String prefixMsg = ResManager.loadKDString((String)"\u6570\u636e\u6e90\u201c{0}\u201d:", (String)"CustomDsPlugin_0", (String)PROJECT_NAME, (Object[])new Object[0]);
        String keyMsg = ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\uff1b", (String)"CustomDsPlugin_1", (String)PROJECT_NAME, (Object[])new Object[0]);
        String fieldEmptyMsg = ResManager.loadKDString((String)"\u5b57\u6bb5\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff1b", (String)"CustomDsPlugin_3", (String)PROJECT_NAME, (Object[])new Object[0]);
        String fieldKeyMsg = ResManager.loadKDString((String)"\u5b57\u6bb5\u201c{0}\u201d\u5df2\u5b58\u5728\u6216\u4e0e\u6570\u636e\u6e90\u7f16\u7801\u91cd\u590d\uff1b", (String)"CustomDsPlugin_4", (String)PROJECT_NAME, (Object[])new Object[0]);
        HashSet<String> fieldKeys = new HashSet<String>();
        for (DynamicObject dsObj : collection) {
            StringBuilder errMsg = new StringBuilder();
            String dsKey = dsObj.getString("key");
            if (dsKeys.contains(dsKey)) {
                errMsg.append(keyMsg);
            }
            if (errMsg.length() == 0) {
                DynamicObjectCollection fieldItems = dsObj.getDynamicObjectCollection(FIELD_SUBENTRY_KEY);
                if (fieldItems == null || fieldItems.isEmpty()) {
                    errMsg.append(fieldEmptyMsg);
                } else {
                    fieldKeys.clear();
                    fieldKeys.add(dsKey);
                    for (DynamicObject fieldItem : fieldItems) {
                        String fieldKey = fieldItem.getString("fieldkey");
                        if (fieldKeys.contains(fieldKey)) {
                            errMsg.append(MessageFormat.format(fieldKeyMsg, fieldKey));
                        }
                        fieldKeys.add(fieldKey);
                    }
                }
            }
            dsKeys.add(dsKey);
            if (errMsg.length() <= 0) continue;
            errMsg.insert(0, MessageFormat.format(prefixMsg, dsKey));
            msgList.add(errMsg.toString());
        }
        return msgList;
    }

    protected static DynamicObject toDynamicObject(String value, MainEntityType entityType) {
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder((DynamicObjectType)entityType);
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        return (DynamicObject)jser.deserializeFromString(value, null);
    }

    protected static Map dynamicObjectToMap(DynamicObject obj) {
        DynamicObjectType type = obj.getDynamicObjectType();
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(type);
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        jser.setIsLocaleValueFull(true);
        binder.setOnlyDbProperty(false);
        return jser.serializeToMap((Object)obj, null);
    }
}

