/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.designer.plugin.library;

import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.orm.query.QFilter;
import kd.bos.print.business.designer.TplType;
import kd.bos.print.business.metedata.bean.LibraryDesignMetadata;
import kd.bos.print.business.metedata.service.AbstractTplService;
import kd.bos.print.business.metedata.service.LibraryTplService;
import kd.bos.servicehelper.QueryServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewPrinttplLibraryPlugin
extends AbstractFormPlugin {
    private static final String BTN_OK = "btnok";
    private static final String PRINTTPL_LIBRARY = "bos_printtpl_lbr";
    private static final String PRINTTPL_LIBRARY_TABLE = "t_svc_printtpl";
    private static String NEW_TPL_VERSION = "1";
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private AbstractTplService tplService = new LibraryTplService();

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if (key.equals(BTN_OK)) {
            this.createPrintLibraryTemplate();
        }
    }

    private void createPrintLibraryTemplate() {
        ILocaleString name = (ILocaleString)this.getModel().getValue("name");
        String number = (String)this.getModel().getValue("number");
        QFilter[] qFilters = new QFilter[]{new QFilter("number", "=", (Object)number)};
        boolean exists = QueryServiceHelper.exists((String)PRINTTPL_LIBRARY, (QFilter[])qFilters);
        if (exists) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"NewPrinttplLibraryPlugin_0", (String)"bos-print-business", (Object[])new Object[0]));
            return;
        }
        String id = DB.genStringId((String)PRINTTPL_LIBRARY_TABLE);
        String tplGroupId = (String)this.getView().getFormShowParameter().getCustomParam("tplGroupId");
        long creator = RequestContext.get().getCurrUserId();
        try {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("id", id);
            data.put("key", number);
            data.put("name", name);
            data.put("type", TplType.LibraryTpl.toString());
            data.put("version", NEW_TPL_VERSION);
            HashMap<String, Object> paper = new HashMap<String, Object>();
            paper.put("id", id);
            paper.put("key", number);
            paper.put("name", name);
            paper.put("type", "Paper");
            paper.put("paperType", "A4");
            paper.put("width", 210);
            paper.put("height", 297);
            paper.put("paperDirection", "vertical");
            paper.put("economicType", "");
            paper.put("marginTop", 20);
            paper.put("marginBottom", 20);
            paper.put("marginLeft", 17);
            paper.put("marginRight", 17);
            paper.put("inteFormat", "zh_CN");
            paper.put("backgroundImg", "");
            data.put("paper", paper);
            data.put("pages", Collections.EMPTY_LIST);
            LibraryDesignMetadata dMetadata = new LibraryDesignMetadata();
            dMetadata.setId(id);
            dMetadata.setMasterid(id);
            dMetadata.setGroupId(Long.parseLong(tplGroupId));
            dMetadata.setNumber(number);
            dMetadata.setName(name.getLocaleValue());
            dMetadata.setlName(name);
            dMetadata.setCreator(creator);
            dMetadata.setModifier(creator);
            dMetadata.setCreatetime(new Date());
            dMetadata.setModifytime(new Date());
            dMetadata.setPaperdirection("B");
            dMetadata.setData(SerializationUtils.toJsonString(data));
            dMetadata.setStatus("A");
            dMetadata.setEnable("1");
            dMetadata.setVersion(NEW_TPL_VERSION);
            dMetadata.setIsv(ISVService.getISVInfo().getId());
            this.tplService.save(dMetadata);
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("ide_printdesigner");
            parameter.setCustomParam("id", (Object)id);
            parameter.setCustomParam("tplType", (Object)TplType.LibraryTpl.toString());
            parameter.getOpenStyle().setShowType(ShowType.NewWindow);
            HashMap<String, Boolean> result = new HashMap<String, Boolean>();
            result.put("success", Boolean.TRUE);
            this.getView().returnDataToParent(result);
            this.getView().showForm(parameter);
            this.getView().close();
        }
        catch (Exception e) {
            this.logger.error("Error:", (Throwable)e);
            this.getView().showErrorNotification(e.getMessage());
        }
    }
}

