/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.designer.plugin.library;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Delete;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.business.designer.TplType;
import kd.bos.print.business.metedata.service.migrate.LibraryTplImpExp;

public class PrintTplLibraryListPlugin
extends AbstractListPlugin
implements TreeNodeClickListener,
UploadListener {
    private static final String TPL_NEW = "tblnew";
    private static final String CACHE_GROUP_ID = "cacheGroupId";
    private static final String KEY_TREE_VIEW = "treeview";
    private static final Log log = LogFactory.getLog(PrintTplLibraryListPlugin.class);
    private static final String PROJECT_NAME = "bos-print-business";
    private LibraryTplImpExp tplImpExp = new LibraryTplImpExp();
    public static final String BILLLISTAP = "billlistap";

    public void registerListener(EventObject e) {
        Toolbar toolbar = (Toolbar)this.getView().getControl("toolbarap");
        toolbar.addItemClickListener((ItemClickListener)this);
        TreeView tree = (TreeView)this.getView().getControl(KEY_TREE_VIEW);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void treeNodeDoubleClick(TreeNodeEvent evt) {
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        String tplId = (String)billList.getFocusRowPkId();
        ListSelectedRow row = ((BillListHyperLinkClickEvent)args.getHyperLinkClickEvent()).getCurrentRow();
        String billStatus = row.getBillStatus();
        if ("A".equals(billStatus)) {
            args.setCancel(true);
            String pageNumber = "ide_printdesigner";
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId(pageNumber);
            parameter.setCustomParam("id", (Object)tplId);
            parameter.setCustomParam("tplType", (Object)TplType.LibraryTpl.toString());
            parameter.getOpenStyle().setShowType(ShowType.NewWindow);
            this.getView().showForm(parameter);
        } else {
            super.billListHyperLinkClick(args);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (StringUtils.equals((CharSequence)itemKey, (CharSequence)TPL_NEW)) {
            String tplGroupId = this.getPageCache().get(CACHE_GROUP_ID);
            if (StringUtils.isBlank((CharSequence)tplGroupId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a21\u677f\u5206\u7c7b\u3002", (String)"PrintTplLibraryListPlugin_0", (String)PROJECT_NAME, (Object[])new Object[0]));
                return;
            }
            FormShowParameter parameter = new FormShowParameter();
            parameter.setCustomParam("tplGroupId", (Object)tplGroupId);
            parameter.setFormId("bos_new_printtpl_lbr");
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "newPrinttplLbr");
            parameter.setCloseCallBack(closeCallBack);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(parameter);
        } else if ("tblimport".equals(itemKey)) {
            String tplGroupId = this.getPageCache().get(CACHE_GROUP_ID);
            if (StringUtils.isBlank((CharSequence)tplGroupId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a21\u677f\u5206\u7c7b\u3002", (String)"PrintTplLibraryListPlugin_0", (String)PROJECT_NAME, (Object[])new Object[0]));
                return;
            }
            this.doImport(tplGroupId);
        } else if ("tblexport".equals(itemKey)) {
            String tplGroupId = this.getPageCache().get(CACHE_GROUP_ID);
            if (StringUtils.isBlank((CharSequence)tplGroupId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a21\u677f\u5206\u7c7b\u3002", (String)"PrintTplLibraryListPlugin_0", (String)PROJECT_NAME, (Object[])new Object[0]));
                return;
            }
            this.doExport();
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        if ("doImport".equals(actionId)) {
            BillList list = (BillList)this.getControl(BILLLISTAP);
            list.refresh();
        } else if ("newPrinttplLbr".equals(actionId) && e.getReturnData() != null) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object source = args.getSource();
        if (source instanceof Delete) {
            ListSelectedRowCollection listSelectedData = args.getListSelectedData();
            if (CollectionUtils.isEmpty((Collection)listSelectedData)) {
                return;
            }
            List<String> cannotExportTplList = this.getOtherIsvTpls(listSelectedData);
            if (!cannotExportTplList.isEmpty()) {
                String msg = String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u9884\u7f6e\u6a21\u677f\u4e0d\u652f\u6301\u5220\u9664\uff1a\n%s", (String)"ManagePrintTplListPlugin_26", (String)PROJECT_NAME, (Object[])new Object[0]), StringUtils.join((Object[])cannotExportTplList.toArray(), (String)","));
                this.getView().showTipNotification(msg);
                args.setCancel(true);
                args.setCancelMessage(msg);
                return;
            }
        }
    }

    private void doExport() {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u51fa\u7684\u6a21\u677f\u3002", (String)"PrintTplLibraryListPlugin_1", (String)PROJECT_NAME, (Object[])new Object[0]));
            return;
        }
        List<String> cannotExportTplList = this.getOtherIsvTpls(selectedRows);
        if (!cannotExportTplList.isEmpty()) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u9884\u7f6e\u6a21\u677f\u4e0d\u652f\u6301\u5bfc\u51fa\uff1a%s\u3002", (String)"ManagePrintTplListPlugin_35", (String)PROJECT_NAME, (Object[])new Object[0]), StringUtils.join((Object[])cannotExportTplList.toArray(), (String)",")));
            return;
        }
        Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
        ArrayList<String> pkIds = new ArrayList<String>(10);
        for (Object pkId : primaryKeyValues) {
            pkIds.add((String)pkId);
        }
        try {
            String url = this.tplImpExp.doExport(pkIds, 5000);
            this.getView().openUrl(url);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6a21\u677f\u5bfc\u51fa\u5931\u8d25\u3002", (String)"PrintTplLibraryListPlugin_2", (String)PROJECT_NAME, (Object[])new Object[0]));
        }
    }

    private List<String> getOtherIsvTpls(ListSelectedRowCollection selectedRows) {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        ArrayList<String> cannotExportTplList = new ArrayList<String>(10);
        for (DynamicObject dynamicObject : billList.queryDataBySelectedRows(selectedRows).getCollection()) {
            String isv = dynamicObject.getString("isv");
            if (!StringUtils.isNotBlank((CharSequence)isv) || isv.equals(ISVService.getISVInfo().getId())) continue;
            cannotExportTplList.add(dynamicObject.getString("number"));
        }
        return cannotExportTplList;
    }

    private void doImport(String tplGroupId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_import_printtpl");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("TplType", (Object)TplType.LibraryTpl);
        parameter.setCustomParam("TplGroupId", (Object)tplGroupId);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "doImport");
        parameter.setCloseCallBack(callBack);
        this.getView().showForm(parameter);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        if (StringUtils.isNotBlank((Object)evt.getParentNodeId())) {
            String nodeId = (String)evt.getNodeId();
            this.getPageCache().put(CACHE_GROUP_ID, nodeId);
        } else {
            this.getPageCache().remove(CACHE_GROUP_ID);
        }
    }
}

