/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.designer.plugin.library;

import com.tongtech.backport.java.util.Collections;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.imageio.ImageIO;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Image;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.api.IInteService;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.api.metedata.PrintMetadata;
import kd.bos.print.business.metedata.bean.LibraryDesignMetadata;
import kd.bos.print.business.metedata.bean.ResPowerScope;
import kd.bos.print.business.metedata.service.LibraryTplService;
import kd.bos.print.business.service.BosPrintBusinessServiceImpl;
import kd.bos.print.business.utils.PrintParamUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.service.attachment.FileItemExt;
import kd.bos.service.attachment.FileSource;
import kd.bos.svc.util.print.UpdateLocalNameUtil;
import kd.bos.url.UrlService;

public class PrintTplLibraryPlugin
extends AbstractBillPlugIn
implements UploadListener {
    private static final String PREVIEW_TPL = "previewtpl";
    private static final Log log = LogFactory.getLog(PrintTplLibraryPlugin.class);
    private BosPrintBusinessServiceImpl printBusinessService = new BosPrintBusinessServiceImpl();
    private static final String IMAGE_URL_PREFIX = UrlService.getDomainContextUrl() + "/api/print/download.do?rcId=";
    private static final String PIC_LOCALE = "piclocale";
    public static final String TPL_TABLE_L = "t_svc_printtpl_l";

    public void registerListener(EventObject e) {
        Toolbar toolbar = (Toolbar)this.getView().getControl("tbmain");
        toolbar.addItemClickListener((ItemClickListener)this);
        AttachmentPanel dbspanel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
        dbspanel.addUploadListener((UploadListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (StringUtils.equals((CharSequence)itemKey, (CharSequence)PREVIEW_TPL)) {
            this.previewTpl();
        } else if ("bar_save".equals(itemKey)) {
            Object bizType;
            Object picHeight;
            Object picWidth;
            DynamicObject group;
            Object pkValue = this.getModel().getDataEntity().getPkValue();
            if (pkValue == null) {
                return;
            }
            IDataEntityType dataEntityType = OrmUtils.getDataEntityType(LibraryDesignMetadata.class);
            LibraryDesignMetadata designMetadata = (LibraryDesignMetadata)BusinessDataReader.read((Object)pkValue, (IDataEntityType)dataEntityType, (Boolean)Boolean.FALSE);
            Object name = this.getModel().getValue("name");
            if (name instanceof OrmLocaleValue) {
                OrmLocaleValue localeName = (OrmLocaleValue)name;
                designMetadata.setlName((ILocaleString)localeName);
            }
            if ((group = (DynamicObject)this.getModel().getValue("group")) != null) {
                designMetadata.setGroupId(((Long)group.getPkValue()).longValue());
            }
            if ((picWidth = this.getModel().getValue("picwidth")) != null) {
                designMetadata.setPicwidth(((Integer)picWidth).intValue());
            }
            if ((picHeight = this.getModel().getValue("picheight")) != null) {
                designMetadata.setPicHeight(((Integer)picHeight).intValue());
            }
            if ((bizType = this.getModel().getValue("biztype")) != null) {
                designMetadata.setBizType((String)bizType);
            }
            designMetadata.setModifier(RequestContext.get().getCurrUserId());
            designMetadata.setModifytime(new Date());
            designMetadata.setModifyVersion(System.currentTimeMillis());
            try (TXHandle tx = TX.required();){
                BusinessDataWriter.delete((IDataEntityType)dataEntityType, (Object[])new Object[]{pkValue});
                BusinessDataWriter.save((IDataEntityType)dataEntityType, (Object[])new Object[]{designMetadata});
            }
            if (!(name instanceof OrmLocaleValue)) {
                return;
            }
            OrmLocaleValue localeName = (OrmLocaleValue)name;
            HashMap<String, String> nameMap = new HashMap<String, String>(localeName.size());
            for (Map.Entry entry : localeName.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (key == null || value == null || "GLang".equals(key)) continue;
                nameMap.put(key, value);
            }
            UpdateLocalNameUtil.updateLocaleData((Object)pkValue, (int)12, nameMap, (Map)Collections.emptyMap(), (String)TPL_TABLE_L);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"PrintDesignerPlugin_3", (String)"bos-print-business", (Object[])new Object[0]));
        }
    }

    public void afterCreateNewData(EventObject e) {
        String rcId = (String)this.getModel().getValue("picture");
        if (StringUtils.isNotBlank((CharSequence)rcId)) {
            Image converImg = (Image)this.getView().getControl("converimg");
            converImg.setUrl(IMAGE_URL_PREFIX + rcId);
        }
    }

    public void afterLoadData(EventObject e) {
        Object pkValue;
        String lang = RequestContext.get().getLang().getLocale().toString();
        this.getModel().setValue(PIC_LOCALE, (Object)lang);
        String picLocale = null;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (dataEntity != null && (pkValue = dataEntity.getPkValue()) != null) {
            String select = String.format("select fpicture,fpic_width,fpic_height from %s where fid = ? and flocaleid = ?", TPL_TABLE_L);
            Object[] params = new Object[]{new SqlParameter("fid", 12, (Object)String.valueOf(pkValue)), new SqlParameter("flocaleid", 12, (Object)lang)};
            picLocale = (String)DB.query((DBRoute)DBRoute.basedata, (String)select, (Object[])params, rs -> {
                if (rs.next()) {
                    String picture = rs.getString(1);
                    int width = rs.getInt(2);
                    int height = rs.getInt(3);
                    this.getModel().setValue("picture", (Object)picture);
                    this.getModel().setValue("picwidth", (Object)width);
                    this.getModel().setValue("picheight", (Object)height);
                    return picture;
                }
                return null;
            });
        }
        if (StringUtils.isNotBlank(picLocale)) {
            Image converImg = (Image)this.getView().getControl("converimg");
            converImg.setUrl(IMAGE_URL_PREFIX + picLocale);
        }
        IInteService inteService = (IInteService)ServiceFactory.getService(IInteService.class);
        List languages = inteService.getLocalLangForPrint("1");
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(10);
        for (EnabledLang language : languages) {
            comboItemList.add(new ComboItem(new LocaleString(language.getName()), language.getNumber()));
        }
        ((ComboEdit)this.getView().getControl(PIC_LOCALE)).setComboItems(comboItemList);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (!PrintParamUtils.isOpenBizTypeExt()) {
            ComboEdit comboEdit = (ComboEdit)this.getView().getControl("biztype");
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(4);
            ComboItem item0 = new ComboItem();
            item0.setValue("0");
            item0.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5e38\u89c4", (String)"NewPrintTplGuidePlugin_11", (String)"bos-print-business", (Object[])new Object[0])));
            comboItems.add(item0);
            ComboItem item1 = new ComboItem();
            item1.setValue("1");
            item1.setCaption(new LocaleString(ResManager.loadKDString((String)"\u84dd\u7259\u5c0f\u7968", (String)"NewPrintTplGuidePlugin_12", (String)"bos-print-business", (Object[])new Object[0])));
            comboItems.add(item1);
            comboEdit.setComboItems(comboItems);
        }
    }

    public void upload(UploadEvent evt) {
        evt.getSource();
        Object[] urls = evt.getUrls();
        Map fileInfo = (Map)urls[0];
        String tplId = (String)this.getModel().getValue("id");
        String fileName = (String)fileInfo.get("name");
        String url = (String)fileInfo.get("url");
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        try (InputStream inputStream = cache.getInputStream(url);
             InputStream inputStream2 = cache.getInputStream(url);){
            BufferedImage image = ImageIO.read(inputStream2);
            String path = this.getUploadPath(fileName);
            FileItemExt fileItem = new FileItemExt(fileName, path, inputStream);
            fileItem.setSource(FileSource.PRINT_TPL_RESOURCE);
            String uploadUrl = FileServiceFactory.getImageFileService().upload((FileItem)fileItem);
            HashMap<String, Object> param = new HashMap<String, Object>(4);
            param.put("printtplid", tplId);
            param.put("fileName", fileName);
            param.put("url", uploadUrl);
            param.put("powerScope", ResPowerScope.POWER_PUBLIC.getCode());
            long rcId = this.printBusinessService.saveFile(param);
            int height = image.getHeight();
            int width = image.getWidth();
            this.getModel().setValue("picwidth", (Object)width);
            this.getModel().setValue("picheight", (Object)height);
            this.getModel().setValue("picture", (Object)rcId);
            Image converImg = (Image)this.getView().getControl("converimg");
            converImg.setUrl(IMAGE_URL_PREFIX + rcId);
            this.updateLocaleTable();
        }
        catch (IOException e) {
            log.error((Throwable)e);
            this.getView().showErrorNotification(e.getMessage());
        }
    }

    private String getUploadPath(String fileName) {
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        String userId = RequestContext.get().getUserId();
        String suffix = fileName.substring(fileName.lastIndexOf(46) + 1);
        String format = "/%s/%s/%s/%s/%s/%s";
        return String.format(format, tenantId, accountId, "printfile", this.getDateStr(), userId, UUID.randomUUID() + "." + suffix);
    }

    private String getDateStr() {
        Calendar cale = Calendar.getInstance();
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMM");
        return sf.format(cale.getTime());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        if (PIC_LOCALE.equals(property.getName())) {
            ChangeData[] changeSet;
            DynamicObject dataEntity = this.getModel().getDataEntity();
            Object pkValue = dataEntity.getPkValue();
            if (pkValue == null || (changeSet = e.getChangeSet()).length <= 0) {
                return;
            }
            String select = String.format("select fid,flocaleid,fpicture,fpic_width,fpic_height from %s where fid = ? and flocaleid = ?", TPL_TABLE_L);
            Object[] params = new Object[]{new SqlParameter("fid", 12, (Object)String.valueOf(pkValue)), new SqlParameter("flocaleid", 12, (Object)String.valueOf(changeSet[0].getNewValue()))};
            DB.query((DBRoute)DBRoute.basedata, (String)select, (Object[])params, rs -> {
                Image converimg = (Image)this.getControl("converimg");
                String picture = null;
                Integer picWidth = null;
                Integer picHeight = null;
                while (rs.next()) {
                    picture = rs.getString(3);
                    picWidth = rs.getInt(4);
                    picHeight = rs.getInt(5);
                }
                if (picture == null || "".equals(picture)) {
                    converimg.setUrl("");
                } else {
                    converimg.setUrl(IMAGE_URL_PREFIX + picture);
                }
                AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl("attachmentpanelap");
                this.getModel().setValue("picwidth", (Object)picWidth);
                this.getModel().setValue("picheight", (Object)picHeight);
                this.getModel().setValue("picture", (Object)picture);
                IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                List attachmentData = attachmentPanel.getAttachmentData();
                if (attachmentData != null && attachmentData.size() > 0) {
                    attachmentData.stream().map(m -> m.get("uid")).forEach(uid -> {
                        HashMap<String, Object> removeResult = new HashMap<String, Object>(2);
                        removeResult.put("remove", Boolean.TRUE);
                        removeResult.put("uid", uid);
                        clientViewProxy.invokeControlMethod("attachmentpanelap", "removeAttachment", new Object[]{removeResult});
                    });
                    for (Map attachmentDatum : attachmentData) {
                        attachmentPanel.remove(attachmentDatum);
                    }
                }
                return true;
            });
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            args.setCancel(true);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    private void updateLocaleTable() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Object pkValue = dataEntity.getPkValue();
        String picLocale = dataEntity.getString(PIC_LOCALE);
        String picture = dataEntity.getString("picture");
        int picWidth = dataEntity.getInt("picwidth");
        int picHeight = dataEntity.getInt("picheight");
        String select = String.format("select fid,flocaleid from %s where fid = ? and flocaleid = ?", TPL_TABLE_L);
        Boolean exist = (Boolean)DB.query((DBRoute)DBRoute.basedata, (String)select, (Object[])new SqlParameter[]{new SqlParameter("fid", 12, pkValue), new SqlParameter("flocaleid", 12, (Object)picLocale)}, ResultSet::next);
        if (exist != null && exist.booleanValue()) {
            String updateSql = String.format("update %s set fpicture = ?, fpic_width = ?, fpic_height = ? where fid = ? and flocaleid = ?", TPL_TABLE_L);
            Object[] sqlParameters = new SqlParameter[]{new SqlParameter("fpicture", 12, (Object)picture), new SqlParameter("fpic_width", -5, (Object)picWidth), new SqlParameter("fpic_height", -5, (Object)picHeight), new SqlParameter("fid", 12, pkValue), new SqlParameter("flocaleid", 12, (Object)picLocale)};
            try (TXHandle tx = TX.required();){
                DB.execute((DBRoute)DBRoute.basedata, (String)updateSql, (Object[])sqlParameters);
            }
        }
        String insertSql = String.format("insert into %s (fpkid,fid,flocaleid,fpicture,fpic_width,fpic_height) values (?,?,?,?,?,?)", TPL_TABLE_L);
        Object[] sqlParameters = new SqlParameter[]{new SqlParameter("fpkid", 12, (Object)DB.genStringId((String)TPL_TABLE_L)), new SqlParameter("fid", 12, pkValue), new SqlParameter("flocaleid", 12, (Object)picLocale), new SqlParameter("fpicture", 12, (Object)picture), new SqlParameter("fpic_width", -5, (Object)picWidth), new SqlParameter("fpic_height", -5, (Object)picHeight)};
        try (TXHandle tx = TX.required();){
            DB.execute((DBRoute)DBRoute.basedata, (String)insertSql, (Object[])sqlParameters);
        }
    }

    public void remove(UploadEvent evt) {
    }

    private void previewTpl() {
        String tplId = (String)this.getView().getModel().getValue("id");
        LibraryTplService designService = new LibraryTplService();
        PrintMetadata metadata = designService.getMetadata(tplId);
        String previewUrl = designService.getPreviewUrl(metadata, Lang.get().toString());
        this.getView().openUrl(previewUrl);
    }
}

