/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.designer.tplcopy.builder.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.api.metedata.LocaleValue;
import kd.bos.print.api.metedata.PrintMetadata;
import kd.bos.print.api.metedata.control.BaseDsControl;
import kd.bos.print.api.metedata.control.Control;
import kd.bos.print.api.metedata.control.Paper;
import kd.bos.print.api.metedata.control.Text;
import kd.bos.print.api.metedata.control.grid.datagrid.DataGrid;
import kd.bos.print.api.metedata.control.grid.datagrid.DataGridRow;
import kd.bos.print.api.metedata.control.grid.datagrid.SubDataGrid;
import kd.bos.print.api.metedata.control.grid.layoutgrid.LayoutGrid;
import kd.bos.print.api.metedata.control.grid.layoutgrid.LayoutGridCell;
import kd.bos.print.api.metedata.control.grid.layoutgrid.LayoutGridRow;
import kd.bos.print.business.designer.OpResult;
import kd.bos.print.business.designer.datasource.DsType;
import kd.bos.print.business.designer.tplcopy.builder.impl.AbstractTplCopyBuilder;
import kd.bos.print.business.metedata.service.AbstractTplService;

public class TplSaveAsBuilder
extends AbstractTplCopyBuilder {
    private static final Log logger = LogFactory.getLog(TplSaveAsBuilder.class);
    private static final String DS_TYPE = "DsType";
    private static final String IS_DS = "IsDs";
    private static final String KEY = "Key";
    private static final String IS_FIELD = "IsField";
    private static final String NAME = "Name";
    private static final String MAIN = "Main";
    private static final String CUSTOM = "Custom";
    private static final String SYS = "Sys";
    private static final String ENTRY = "Entry";
    private static final String Ref = "Ref";
    private static final String SUB_ENTRY = "Subentry";
    private static final String NUMBER = "number";
    private static final String ITEMS = "Items";
    private static final String DATA_GRID = "DataGrid";
    private static final String SUB_DATA_GRID = "SubDataGrid";
    private static final String DATA_CELL = "DataCell";
    private static final String CELL_TYPE_DETAIL = "Detail";
    private static final String CELL_TYPE_LAYOUT = "Layout";
    private static final String CELL_TYPE_STATISTIC = "Statistic";
    private static final String CELL_TYPE_GROUP = "Group";
    private static final String ROW_TYPE_GROUP = "Group";
    private static final String FORMULA = "Formula";
    private static final String WORKFLOW = "Workflow";
    private AbstractTplService designService;
    private String oriEntityId;
    private String seleEntityId;
    private String oriFormId;
    private String seleFormNumber;
    private String seleFormName;
    private PrintMetadata oriPrintMetadata;
    private String keyNumber;
    private OrmLocaleValue tplNameOLV;

    public TplSaveAsBuilder(AbstractTplService designService, String oriEntityId, String seleEntityId, String oriFormId, String seleFormNumber, String seleFormName, PrintMetadata oriPrintMetadata, String keyNumber, OrmLocaleValue tplName) {
        this.designService = designService;
        this.oriEntityId = oriEntityId;
        this.seleEntityId = seleEntityId;
        this.oriFormId = oriFormId;
        this.seleFormNumber = seleFormNumber;
        this.seleFormName = seleFormName;
        this.oriPrintMetadata = oriPrintMetadata;
        this.keyNumber = keyNumber;
        this.tplNameOLV = tplName;
    }

    @Override
    public Map build() {
        List oriDs = this.designService.loadDataSource(this.oriEntityId, null, null, new OpResult());
        List seleDs = this.designService.loadDataSource(this.seleEntityId, null, null, new OpResult());
        if (CollectionUtils.isEmpty((Collection)oriDs) || CollectionUtils.isEmpty((Collection)seleDs)) {
            return new HashMap(16);
        }
        Boolean seleDsWfFlag = this.includeWorkFlow(seleDs);
        Map seleAllFlatMap = this.convertTreeToFlat(seleDs, this.seleEntityId, false, false, null);
        Map tplRetainKeyMap = this.convertTreeToFlat(oriDs, this.oriEntityId, true, true, seleAllFlatMap);
        Map oriFlatMap = this.convertTreeToFlat(oriDs, this.oriEntityId, false, true, null);
        List allPages = this.oriPrintMetadata.getPages();
        String oriDsName = this.getOriDsName(oriDs);
        String oriDsKey = this.getDsKey(oriDs);
        String seleDsKey = this.getDsKey(seleDs);
        if (!CollectionUtils.isEmpty((Collection)allPages)) {
            HashMap<String, Boolean> subGridCleanMap = new HashMap<String, Boolean>(16);
            for (List fieldsPerPage : allPages) {
                if (CollectionUtils.isEmpty((Collection)fieldsPerPage)) continue;
                for (Control fieldC : fieldsPerPage) {
                    String id;
                    SubDataGrid fieldSDG;
                    String dataSource;
                    if (null == fieldC) continue;
                    String type = fieldC.getType();
                    if (fieldC instanceof BaseDsControl) {
                        String rowType;
                        LayoutGridRow fieldLGR;
                        BaseDsControl fieldBDC = (BaseDsControl)fieldC;
                        dataSource = fieldBDC.getDataSource();
                        String bindField = fieldBDC.getBindField();
                        String dsType = fieldBDC.getDsType();
                        LocaleValue bindText = fieldBDC.getBindText();
                        String matchKey = dataSource + "." + bindField;
                        if (StringUtils.isEmpty((CharSequence)dataSource) && StringUtils.isEmpty((CharSequence)bindField) && null != bindText && StringUtils.isEmpty((CharSequence)dsType)) {
                            if (!(fieldBDC instanceof LayoutGridRow)) continue;
                            fieldLGR = (LayoutGridRow)fieldBDC;
                            rowType = fieldLGR.getRowType();
                            if (StringUtils.isNotEmpty((CharSequence)rowType) && "Group".equals(rowType)) {
                                fieldLGR.setBindField("");
                                fieldLGR.setBindText(new LocaleValue((Object)""));
                            }
                            if (!(fieldLGR instanceof DataGridRow)) continue;
                            DataGridRow fieldDGR = (DataGridRow)fieldLGR;
                            this.cleanMerge(fieldDGR);
                            continue;
                        }
                        if (SYS.equals(dsType)) continue;
                        if (StringUtils.isEmpty((CharSequence)dataSource) && StringUtils.isNotEmpty((CharSequence)bindField) && null != bindText && StringUtils.isNotEmpty((CharSequence)dsType) && fieldBDC instanceof LayoutGridRow && StringUtils.isNotEmpty((CharSequence)(rowType = (fieldLGR = (LayoutGridRow)fieldBDC).getRowType())) && "Group".equals(rowType)) {
                            fieldLGR.setBindField("");
                            fieldLGR.setBindText(new LocaleValue((Object)""));
                            fieldLGR.setDsType("");
                        }
                        if (StringUtils.isNotEmpty((CharSequence)dataSource) && null != bindText && StringUtils.isNotEmpty((CharSequence)dsType)) {
                            if (Ref.equals(dsType)) {
                                this.cleanBaseDsControl(fieldBDC);
                            } else if (DsType.Approveactivity.getCode().equals(dsType) || DsType.Approveline.getCode().equals(dsType)) {
                                if (!seleDsWfFlag.booleanValue()) {
                                    this.cleanBaseDsControl(fieldBDC);
                                } else {
                                    this.handleBindTextAndDs(oriDsName, fieldBDC, dataSource, (LocaleValue<String>)bindText, matchKey, seleDsKey, seleAllFlatMap);
                                }
                            } else if (MAIN.equals(dsType) || ENTRY.equals(dsType) || SUB_ENTRY.equals(dsType)) {
                                if (!tplRetainKeyMap.containsKey(matchKey)) {
                                    this.cleanBaseDsControl(fieldBDC);
                                } else {
                                    this.handleBindTextAndDs(oriDsName, fieldBDC, dataSource, (LocaleValue<String>)bindText, matchKey, seleDsKey, seleAllFlatMap);
                                }
                            } else if (CUSTOM.equals(dsType)) continue;
                        }
                        if (fieldBDC instanceof Text) {
                            Text fieldT = (Text)fieldBDC;
                            String viewText = fieldT.getViewText();
                            if (Ref.equals(dsType)) {
                                fieldT.setViewText("");
                            }
                            if (StringUtils.isNotEmpty((CharSequence)dataSource) && StringUtils.isNotEmpty((CharSequence)dsType) && (DsType.Approveactivity.getCode().equals(dsType) || DsType.Approveline.getCode().equals(dsType))) {
                                if (!seleDsWfFlag.booleanValue()) {
                                    fieldT.setViewText("");
                                } else {
                                    this.handleViewText(tplRetainKeyMap, oriFlatMap, matchKey, fieldT, viewText, seleAllFlatMap, oriDsKey, seleDsKey);
                                }
                            }
                            if (StringUtils.isNotEmpty((CharSequence)dataSource) && (MAIN.equals(dsType) || ENTRY.equals(dsType) || SUB_ENTRY.equals(dsType))) {
                                this.handleViewText(tplRetainKeyMap, oriFlatMap, matchKey, fieldT, viewText, seleAllFlatMap, oriDsKey, seleDsKey);
                            }
                            if (fieldT instanceof LayoutGridCell) {
                                LayoutGridCell fieldLGC = (LayoutGridCell)fieldT;
                                String cellType = fieldLGC.getCellType();
                                if (DATA_CELL.equals(type) && (CELL_TYPE_DETAIL.equals(cellType) || CELL_TYPE_STATISTIC.equals(cellType) || CELL_TYPE_LAYOUT.equals(cellType))) {
                                    if (!tplRetainKeyMap.containsKey(matchKey)) {
                                        fieldLGC.setBindText(new LocaleValue((Object)""));
                                        fieldLGC.setViewText("");
                                    } else {
                                        Map map;
                                        if (subGridCleanMap.containsKey(fieldLGC.getParentId())) {
                                            subGridCleanMap.put(fieldLGC.getParentId(), Boolean.FALSE);
                                        }
                                        if (null != (map = (Map)tplRetainKeyMap.get(matchKey))) {
                                            Map oriItem = (Map)oriFlatMap.get(matchKey);
                                            String oriName = (String)oriItem.get(NAME);
                                            String seleName = (String)map.get(NAME);
                                            String newViewText = viewText.replaceAll(oriName, seleName);
                                            fieldT.setViewText(newViewText);
                                        }
                                    }
                                }
                                if ("Group".equals(cellType)) {
                                    fieldLGC.setDataSource("");
                                    fieldLGC.setDsType("");
                                    fieldLGC.setBindField("");
                                    fieldLGC.setBindText(new LocaleValue((Object)""));
                                    fieldLGC.setViewText("");
                                }
                            }
                        }
                        List fData = fieldBDC.getFormulaData();
                        if (!StringUtils.isEmpty((CharSequence)dataSource) || !StringUtils.isEmpty((CharSequence)bindField) || null == dsType || !FORMULA.equals(dsType) || null == fData) continue;
                        ArrayList<String> emptyList = new ArrayList<String>(1);
                        emptyList.add("");
                        fieldBDC.setFormulaData(emptyList);
                        fieldBDC.setBindText(new LocaleValue((Object)ResManager.loadKDString((String)"\u516c\u5f0f", (String)"TplSaveAsBuilder_0", (String)"bos-print-business", (Object[])new Object[0])));
                        continue;
                    }
                    if (!(fieldC instanceof LayoutGrid) || !(fieldC instanceof DataGrid)) continue;
                    DataGrid fieldDG = (DataGrid)fieldC;
                    dataSource = fieldDG.getDataSource();
                    Boolean curGridIsMainDs = StringUtils.equals((CharSequence)dataSource, (CharSequence)oriDsKey) || StringUtils.equals((CharSequence)dataSource, (CharSequence)seleDsKey);
                    Boolean curGridIsEntity = this.dsIsGrid(dataSource) != false && (StringUtils.equals((CharSequence)dataSource.substring(0, dataSource.indexOf(".")), (CharSequence)oriDsKey) || StringUtils.equals((CharSequence)dataSource.substring(0, dataSource.indexOf(".")), (CharSequence)seleDsKey));
                    if (StringUtils.isNotEmpty((CharSequence)dataSource) && StringUtils.isNotEmpty((CharSequence)type)) {
                        String keyAfterReplace = dataSource.replaceAll(this.oriFormId, this.seleFormNumber);
                        Boolean refDsFlag = this.cleanRefDsAndReturnFlag(fieldDG, dataSource);
                        if ((DATA_GRID.equals(type) || SUB_DATA_GRID.equals(type)) && !refDsFlag.booleanValue() && (curGridIsMainDs.booleanValue() || curGridIsEntity.booleanValue())) {
                            Map v = (Map)seleAllFlatMap.get(keyAfterReplace);
                            if (null == v) {
                                fieldDG.setDataSourceText("");
                            } else {
                                fieldDG.setDataSourceText((String)v.get(NAME));
                            }
                            fieldDG.setDataSource(keyAfterReplace);
                        }
                        fieldDG.setSortSettingsText("");
                        fieldDG.setSortSettings(new ArrayList(1));
                    }
                    if (!(fieldDG instanceof SubDataGrid) || null == (fieldSDG = (SubDataGrid)fieldDG) || !SUB_DATA_GRID.equals(fieldSDG.getType()) || subGridCleanMap.containsKey(id = fieldSDG.getId())) continue;
                    subGridCleanMap.put(id, Boolean.TRUE);
                }
            }
            this.subDataGridClean(allPages, subGridCleanMap);
            this.oriPrintMetadata.setKey(this.keyNumber);
            this.oriPrintMetadata.setEntityId(this.seleEntityId);
            this.oriPrintMetadata.setFormId(this.seleFormNumber);
            Paper paper = this.oriPrintMetadata.getPaper();
            paper.setKey(this.keyNumber);
            paper.setName(new LocaleValue((Object)this.tplNameOLV.getLocaleValue()));
            this.oriPrintMetadata.setPaper(paper);
            this.oriPrintMetadata.setRefDs("");
            return (Map)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)this.oriPrintMetadata), Map.class);
        }
        return (Map)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)this.oriPrintMetadata), Map.class);
    }

    private Boolean cleanRefDsAndReturnFlag(DataGrid fieldDG, String dataSource) {
        List refOri;
        String refDs = this.oriPrintMetadata.getRefDs();
        Boolean refDsFlag = false;
        if (StringUtils.isNotEmpty((CharSequence)refDs) && !CollectionUtils.isEmpty((Collection)(refOri = (List)SerializationUtils.fromJsonString((String)refDs, List.class)))) {
            for (Map refOriMap : refOri) {
                String refOriNumber = (String)refOriMap.get(NUMBER);
                if (!dataSource.equals(refOriNumber)) continue;
                fieldDG.setDataSourceText("");
                fieldDG.setDataSource("");
                refDsFlag = true;
                break;
            }
        }
        return refDsFlag;
    }

    private void handleBindTextAndDs(String oriDsName, BaseDsControl fieldBDC, String dataSource, LocaleValue<String> bindText, String matchKey, String seleDsKey, Map<String, Map> seleAllFlatMap) {
        Map<Integer, String> treeKeyMap = this.transformKeyList2Tree(matchKey, seleDsKey);
        if (StringUtils.isNotEmpty((CharSequence)oriDsName) && StringUtils.isNotEmpty((CharSequence)this.seleFormName)) {
            bindText.forEach((k, v) -> {
                StringBuilder sb = this.replaceDataSourceName(oriDsName, (String)v);
                this.replaceOtherName(seleAllFlatMap, treeKeyMap, sb);
                bindText.put(k, (Object)sb.toString());
            });
        }
        fieldBDC.setBindText(bindText);
        fieldBDC.setDataSource(dataSource.replace(this.oriFormId, this.seleFormNumber));
    }

    private StringBuilder replaceDataSourceName(String oriDsName, String v) {
        StringBuilder sb = new StringBuilder();
        if (v.contains(oriDsName)) {
            String rplsV = v.replaceAll(oriDsName, this.seleFormName);
            sb.append(rplsV.substring(0, Math.max(rplsV.indexOf("."), 0)));
        } else {
            sb.append("=$").append(this.seleFormName);
        }
        return sb;
    }

    private void replaceOtherName(Map<String, Map> seleAllFlatMap, Map<Integer, String> treeKeyMap, StringBuilder sb) {
        treeKeyMap.forEach((k1, v1) -> {
            Map map2Sele = (Map)seleAllFlatMap.get(v1);
            if (null != map2Sele) {
                String name = (String)map2Sele.get(NAME);
                sb.append(".").append(name);
            }
        });
    }

    private Map<Integer, String> transformKeyList2Tree(String matchKey, String seleDsKey) {
        String[] split = matchKey.split("\\.");
        HashMap<Integer, String> treeKeyMap = new HashMap<Integer, String>(16);
        if (null != split && split.length > 1) {
            StringBuilder appendKSb = new StringBuilder(seleDsKey);
            for (int i = 1; i < split.length; ++i) {
                appendKSb.append(".").append(split[i]);
                treeKeyMap.put(i, appendKSb.toString());
            }
        }
        return treeKeyMap;
    }

    private void handleViewText(Map<String, Map> tplRetainKeyMap, Map<String, Map> oriFlatMap, String matchKey, Text fieldT, String viewText, Map<String, Map> seleAllFlatMap, String oriDsKey, String seleDsKey) {
        Boolean viewTextHasChild = this.viewTextHasChild(viewText);
        if (viewTextHasChild.booleanValue()) {
            String subKey = matchKey.substring(0, matchKey.lastIndexOf(".")).replaceAll(oriDsKey, seleDsKey);
            Map map = seleAllFlatMap.get(subKey);
            if (null != map) {
                String name = (String)map.get(NAME);
                StringBuilder newViewTextSb = new StringBuilder("=$").append(name).append(viewText.substring(viewText.indexOf(".")));
                fieldT.setViewText(newViewTextSb.toString());
            }
        } else if (tplRetainKeyMap.containsKey(matchKey)) {
            Map map = tplRetainKeyMap.get(matchKey);
            if (null != map) {
                Map oriItem = oriFlatMap.get(matchKey);
                String oriName = (String)oriItem.get(NAME);
                String seleName = (String)map.get(NAME);
                String newViewText = viewText.replaceAll(oriName, seleName);
                fieldT.setViewText(newViewText);
            }
        } else {
            fieldT.setViewText("");
        }
    }

    private String getOriDsName(List<Map> oriDs) {
        String oriDsName = null;
        for (Map oriItem : oriDs) {
            Object dsType;
            if (null == oriItem || null == (dsType = oriItem.get(DS_TYPE)) || !(dsType instanceof DsType) || !MAIN.equals(((DsType)((Object)dsType)).getCode())) continue;
            oriDsName = (String)oriItem.get(NAME);
            break;
        }
        return oriDsName;
    }

    private String getDsKey(List<Map> dataSource) {
        String dsKey = null;
        for (Map oriItem : dataSource) {
            Object dsType;
            if (null == oriItem || null == (dsType = oriItem.get(DS_TYPE)) || !(dsType instanceof DsType) || !MAIN.equals(((DsType)((Object)dsType)).getCode())) continue;
            dsKey = (String)oriItem.get(KEY);
            break;
        }
        return dsKey;
    }

    private Map convertTreeToFlat(List<Map> dataSources, String entityId, Boolean untilIsField, Boolean isReplace, Map<String, Map> seleFlatMap) {
        HashMap<String, Map> flatMap = new HashMap<String, Map>(16);
        if (CollectionUtils.isEmpty(dataSources)) {
            return flatMap;
        }
        for (Map dataSource : dataSources) {
            if (this.notMainFlag(dataSource)) continue;
            Boolean dsFlag = (Boolean)dataSource.get(IS_DS);
            if (null == dsFlag || !dsFlag.booleanValue()) {
                return flatMap;
            }
            String rootKey = (String)dataSource.get(KEY);
            if (StringUtils.isBlank((CharSequence)rootKey)) {
                return flatMap;
            }
            ArrayList rootItems = (ArrayList)dataSource.get(ITEMS);
            if (CollectionUtils.isEmpty((Collection)rootItems)) {
                return flatMap;
            }
            if (untilIsField.booleanValue()) {
                if (isReplace.booleanValue()) {
                    this.recusAndReplace(rootItems, rootKey, flatMap, seleFlatMap);
                } else {
                    this.recusDsTreeUntilIsField(rootItems, rootKey, flatMap);
                }
            } else {
                this.recusDsTreeAll(rootItems, rootKey, flatMap);
            }
            return flatMap;
        }
        return flatMap;
    }

    private boolean notMainFlag(Map dataSource) {
        DsType dsType;
        Object dsTypeObj = dataSource.get(DS_TYPE);
        if (null == dsTypeObj) {
            return true;
        }
        if (dsTypeObj instanceof String && !MAIN.equals(dsTypeObj)) {
            return true;
        }
        return dsTypeObj instanceof DsType && !MAIN.equals((dsType = (DsType)((Object)dsTypeObj)).getCode());
    }

    private Boolean includeWorkFlow(List<Map> dataSources) {
        if (CollectionUtils.isEmpty(dataSources)) {
            return false;
        }
        for (Map dataSource : dataSources) {
            Boolean dsFlag;
            if (this.notMainFlag(dataSource) || null == (dsFlag = (Boolean)dataSource.get(IS_DS)) || !dsFlag.booleanValue()) continue;
            ArrayList items = (ArrayList)dataSource.get(ITEMS);
            if (CollectionUtils.isEmpty((Collection)items)) {
                return false;
            }
            for (Map item : items) {
                DsType dsType;
                Object dsTypeObj = item.get(DS_TYPE);
                if (null == dsTypeObj) {
                    return false;
                }
                if (WORKFLOW.equals(dsTypeObj)) {
                    return true;
                }
                if (!(dsTypeObj instanceof DsType) || !WORKFLOW.equals((dsType = (DsType)((Object)dsTypeObj)).getCode())) continue;
                return true;
            }
        }
        return false;
    }

    private void recusDsTreeUntilIsField(List<Map> items, String parentKey, Map<String, Map> flatMap) {
        if (CollectionUtils.isEmpty(items)) {
            return;
        }
        for (Map item : items) {
            List subItems;
            String curKey = StringUtils.defaultString((String)((String)item.get(KEY)), (String)"");
            String appendKey = parentKey + "." + curKey;
            Boolean isField = (Boolean)item.get(IS_FIELD);
            if (null != isField && isField.booleanValue()) {
                flatMap.put(appendKey, item);
            }
            if (CollectionUtils.isEmpty((Collection)(subItems = (List)item.get(ITEMS)))) continue;
            this.recusDsTreeUntilIsField(subItems, appendKey, flatMap);
        }
    }

    private void recusAndReplace(List<Map> items, String parentKey, Map<String, Map> flatMap, Map<String, Map> seleFlatMap) {
        if (CollectionUtils.isEmpty(items)) {
            return;
        }
        for (Map item : items) {
            List subItems;
            String afterReplaceKey;
            Map seleV;
            String curKey = StringUtils.defaultString((String)((String)item.get(KEY)), (String)"");
            String appendKey = parentKey + "." + curKey;
            Boolean isField = (Boolean)item.get(IS_FIELD);
            if (null != isField && isField.booleanValue() && null != (seleV = seleFlatMap.get(afterReplaceKey = appendKey.replace(this.oriFormId, this.seleFormNumber)))) {
                flatMap.put(appendKey, seleV);
            }
            if (CollectionUtils.isEmpty((Collection)(subItems = (List)item.get(ITEMS)))) continue;
            this.recusAndReplace(subItems, appendKey, flatMap, seleFlatMap);
        }
    }

    private void recusDsTreeAll(List<Map> items, String parentKey, Map<String, Map> flatMap) {
        if (CollectionUtils.isEmpty(items)) {
            return;
        }
        for (Map item : items) {
            String curKey = StringUtils.defaultString((String)((String)item.get(KEY)), (String)"");
            String appendKey = parentKey + "." + curKey;
            Boolean isField = (Boolean)item.get(IS_FIELD);
            flatMap.put(appendKey, item);
            List subItems = (List)item.get(ITEMS);
            if (null != isField && isField.booleanValue() && CollectionUtils.isEmpty((Collection)subItems)) continue;
            this.recusDsTreeAll(subItems, appendKey, flatMap);
        }
    }

    private Boolean viewTextHasChild(String viewText) {
        if (viewText == null) {
            return false;
        }
        String[] split = viewText.split("\\.");
        if (null != split && split.length > 1) {
            return true;
        }
        return false;
    }

    private Boolean dsIsGrid(String dataSource) {
        String[] split = dataSource.split("\\.");
        if (null != split && split.length > 1) {
            return true;
        }
        return false;
    }
}

