/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.designer.tplcopy.builder.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.api.metedata.LocaleValue;
import kd.bos.print.api.metedata.PrintMetadata;
import kd.bos.print.api.metedata.control.BaseDsControl;
import kd.bos.print.api.metedata.control.Control;
import kd.bos.print.api.metedata.control.Paper;
import kd.bos.print.api.metedata.control.Text;
import kd.bos.print.api.metedata.control.grid.datagrid.DataGrid;
import kd.bos.print.api.metedata.control.grid.datagrid.DataGridRow;
import kd.bos.print.api.metedata.control.grid.datagrid.SubDataGrid;
import kd.bos.print.api.metedata.control.grid.layoutgrid.LayoutGrid;
import kd.bos.print.business.designer.tplcopy.builder.impl.AbstractTplCopyBuilder;
import kd.bos.print.business.metedata.service.AbstractTplService;

public class TplSaveAsCleanAllBuilder
extends AbstractTplCopyBuilder {
    private static final Log logger = LogFactory.getLog(TplSaveAsCleanAllBuilder.class);
    private static final String SUB_DATA_GRID = "SubDataGrid";
    private static final String FORMULA = "Formula";
    private AbstractTplService designService;
    private String oriEntityId;
    private String seleEntityId;
    private String oriFormId;
    private String seleFormNumber;
    private String seleFormName;
    private PrintMetadata oriPrintMetadata;
    private String keyNumber;
    private OrmLocaleValue tplNameOLV;

    public TplSaveAsCleanAllBuilder(AbstractTplService designService, String oriEntityId, String seleEntityId, String oriFormId, String seleFormNumber, String seleFormName, PrintMetadata oriPrintMetadata, String keyNumber, OrmLocaleValue tplNameOLV) {
        this.designService = designService;
        this.oriEntityId = oriEntityId;
        this.seleEntityId = seleEntityId;
        this.oriFormId = oriFormId;
        this.seleFormNumber = seleFormNumber;
        this.seleFormName = seleFormName;
        this.oriPrintMetadata = oriPrintMetadata;
        this.keyNumber = keyNumber;
        this.tplNameOLV = tplNameOLV;
    }

    @Override
    public Map build() {
        List allPages = this.oriPrintMetadata.getPages();
        if (!CollectionUtils.isEmpty((Collection)allPages)) {
            HashMap<String, Boolean> subGridCellAllNotMatchMap = new HashMap<String, Boolean>(16);
            for (List fieldsPerPage : allPages) {
                if (CollectionUtils.isEmpty((Collection)fieldsPerPage)) continue;
                for (Control fieldC : fieldsPerPage) {
                    String id;
                    SubDataGrid fieldSDG;
                    String dataSource;
                    String type = fieldC.getType();
                    if (fieldC instanceof BaseDsControl) {
                        BaseDsControl fieldBDC = (BaseDsControl)fieldC;
                        dataSource = fieldBDC.getDataSource();
                        if (StringUtils.isEmpty((CharSequence)dataSource)) {
                            // empty if block
                        }
                        String dsType = fieldBDC.getDsType();
                        this.cleanBaseDsControl(fieldBDC);
                        if (fieldBDC instanceof DataGridRow) {
                            DataGridRow fieldDGR = (DataGridRow)fieldBDC;
                            this.cleanMerge(fieldDGR);
                        }
                        if (fieldBDC instanceof Text) {
                            Text fieldT = (Text)fieldBDC;
                            fieldT.setViewText("");
                        }
                        List fData = fieldBDC.getFormulaData();
                        if (null == dsType || !FORMULA.equals(dsType) || null == fData) continue;
                        ArrayList<String> emptyList = new ArrayList<String>(1);
                        emptyList.add("");
                        fieldBDC.setFormulaData(emptyList);
                        fieldBDC.setBindText(new LocaleValue());
                        continue;
                    }
                    if (!(fieldC instanceof LayoutGrid) || !(fieldC instanceof DataGrid)) continue;
                    DataGrid fieldDG = (DataGrid)fieldC;
                    dataSource = fieldDG.getDataSource();
                    if (StringUtils.isNotEmpty((CharSequence)dataSource) && StringUtils.isNotEmpty((CharSequence)type)) {
                        fieldDG.setDataSourceText("");
                        fieldDG.setSortSettingsText("");
                        fieldDG.setSortSettings(new ArrayList(1));
                    }
                    if (!(fieldDG instanceof SubDataGrid) || !SUB_DATA_GRID.equals((fieldSDG = (SubDataGrid)fieldDG).getType()) || subGridCellAllNotMatchMap.containsKey(id = fieldSDG.getId())) continue;
                    subGridCellAllNotMatchMap.put(id, Boolean.TRUE);
                }
            }
            this.subDataGridClean(allPages, subGridCellAllNotMatchMap);
            this.oriPrintMetadata.setKey(this.keyNumber);
            this.oriPrintMetadata.setEntityId(this.seleEntityId);
            this.oriPrintMetadata.setFormId(this.seleFormNumber);
            Paper paper = this.oriPrintMetadata.getPaper();
            paper.setKey(this.keyNumber);
            paper.setName(new LocaleValue((Object)this.tplNameOLV.getLocaleValue()));
            this.oriPrintMetadata.setPaper(paper);
            this.oriPrintMetadata.setRefDs("");
            return (Map)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)this.oriPrintMetadata), Map.class);
        }
        return (Map)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)this.oriPrintMetadata), Map.class);
    }
}

