/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.designer.tplcopy.factory;

import java.util.Collections;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.print.api.metedata.PrintMetadata;
import kd.bos.print.business.designer.tplcopy.builder.ITplCopyBuilder;
import kd.bos.print.business.designer.tplcopy.builder.impl.TplCopyBuilder;
import kd.bos.print.business.designer.tplcopy.builder.impl.TplSaveAsBuilder;
import kd.bos.print.business.designer.tplcopy.builder.impl.TplSaveAsCleanAllBuilder;
import kd.bos.print.business.metedata.PrintMetadataUtil;
import kd.bos.print.business.metedata.service.AbstractTplService;
import kd.bos.print.business.metedata.service.PrintTplService;
import kd.bos.print.business.utils.OldPrintTemplateUtil;

public class TplCopyFactory {
    private static final Log logger = LogFactory.getLog(TplCopyFactory.class);
    private static final String KEY_ORI_TPL = "oritpl";
    private static final String BIZ_ENTITY = "bizentity";
    private static final String ID = "id";
    protected static final String KEY_NUMBER = "number";
    protected static final String KEY_NAME = "name";
    protected static final String MODEL_TYPE = "modeltype";
    private static final AbstractTplService tplService = new PrintTplService();

    public static ITplCopyBuilder getBuilder(IDataModel dataModel, IFormView formView) {
        if (null == dataModel || null == formView) {
            return null;
        }
        DynamicObject oriTplObj = (DynamicObject)dataModel.getValue(KEY_ORI_TPL);
        DynamicObject bizEntityObj = (DynamicObject)dataModel.getValue(BIZ_ENTITY);
        if (null == oriTplObj || null == bizEntityObj) {
            return null;
        }
        String keyNumber = (String)dataModel.getValue(KEY_NUMBER);
        OrmLocaleValue tplNameOLV = (OrmLocaleValue)dataModel.getValue(KEY_NAME);
        String oriTplId = oriTplObj.getString(ID);
        PrintMetadata oriPrintMetadata = PrintMetadataUtil.getPrintMetadata(oriTplId);
        if (null == oriPrintMetadata) {
            return null;
        }
        Map oriTplMetedata = (Map)SerializationUtils.fromJsonString((String)oriPrintMetadata.toString(), Map.class);
        if (null == oriTplMetedata) {
            return null;
        }
        String oriFormId = oriPrintMetadata.getFormId();
        String oriEntityId = oriPrintMetadata.getEntityId();
        String seleFormNumber = bizEntityObj.getString(KEY_NUMBER);
        String seleFormName = bizEntityObj.getString(KEY_NAME);
        String seleEntityId = MetadataDao.getIdByNumber((String)seleFormNumber, (MetaCategory)MetaCategory.Entity);
        if (StringUtils.equals((CharSequence)oriEntityId, (CharSequence)seleEntityId)) {
            return new TplCopyBuilder(oriTplMetedata);
        }
        String oriModelType = TplCopyFactory.getModelType(oriEntityId);
        String seleModelType = TplCopyFactory.getModelType(seleEntityId);
        if (StringUtils.isEmpty((CharSequence)oriModelType) || StringUtils.isEmpty((CharSequence)seleModelType)) {
            return null;
        }
        if (StringUtils.equals((CharSequence)oriModelType, (CharSequence)seleModelType) || "BillFormModel".equals(oriModelType) && "BaseFormModel".equals(seleModelType) || "BillFormModel".equals(seleModelType) && "BaseFormModel".equals(oriModelType)) {
            return new TplSaveAsBuilder(tplService, oriEntityId, seleEntityId, oriFormId, seleFormNumber, seleFormName, oriPrintMetadata, keyNumber, tplNameOLV);
        }
        return new TplSaveAsCleanAllBuilder(tplService, oriEntityId, seleEntityId, oriFormId, seleFormNumber, seleFormName, oriPrintMetadata, keyNumber, tplNameOLV);
    }

    private static String getModelType(String entityId) {
        QFilter qFilter = new QFilter(ID, "in", Collections.singletonList(entityId));
        Map<Object, DynamicObject> bosFormmeta = OldPrintTemplateUtil.loadFromCache("id, number, modeltype", new QFilter[]{qFilter});
        if (null == bosFormmeta) {
            return null;
        }
        DynamicObject dynamicObject = bosFormmeta.get(entityId);
        if (null == dynamicObject) {
            return null;
        }
        String modelType = (String)dynamicObject.get(MODEL_TYPE);
        if (StringUtils.isEmpty((CharSequence)modelType)) {
            return null;
        }
        return modelType;
    }
}

