/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.metedata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.api.metedata.DesignerMetadata;
import kd.bos.print.api.metedata.LocaleValue;
import kd.bos.print.api.metedata.MetadataUtil;
import kd.bos.print.api.metedata.PrintMetadata;
import kd.bos.print.api.metedata.control.BaseControl;
import kd.bos.print.api.metedata.control.BaseDsControl;
import kd.bos.print.api.metedata.control.Control;
import kd.bos.print.api.metedata.control.HeaderFooter;
import kd.bos.print.api.metedata.control.Image;
import kd.bos.print.api.metedata.control.Paper;
import kd.bos.print.api.metedata.control.Text;
import kd.bos.print.api.metedata.control.grid.datagrid.DataGrid;
import kd.bos.print.api.metedata.control.grid.datagrid.DataGridRow;
import kd.bos.print.api.metedata.control.grid.datagrid.SubDataGrid;
import kd.bos.print.api.metedata.control.grid.layoutgrid.LayoutGridRow;
import kd.bos.print.business.designer.datasource.DsType;
import kd.bos.print.business.designer.plugin.NumberCheckUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class PrintMetadataUtil {
    private static final String PRINT_METEDATA = "bos_print_meta";
    private static final String PROJECT_NAME = "bos-print-business";

    public static PrintMetadata getPrintMetadata(String tplid) {
        return MetadataUtil.getMetadata((String)tplid);
    }

    public static PrintMetadata parseMetadata(String str, String lang) {
        return MetadataUtil.parseMetadata((String)str, (String)lang);
    }

    public static PrintMetadata parseMetadata(String str) {
        return PrintMetadataUtil.parseMetadata(str, null);
    }

    public static PrintMetadata parseMetadata(Map metadataMap, String lang) {
        PrintMetadata metadata = MetadataUtil.parseMetadata((Map)metadataMap, (String)lang);
        if (StringUtils.isNotBlank((CharSequence)lang)) {
            PrintMetadataUtil.validate(metadata, lang);
        }
        return metadata;
    }

    public static void mergeLocaleDataMap(PrintMetadata metadata, Map<String, Map<String, Object>> localValueMap) {
        if (CollectionUtils.isEmpty(localValueMap)) {
            return;
        }
        MetadataUtil.mergeLocaleDataMap((PrintMetadata)metadata, localValueMap);
    }

    private static void validate(PrintMetadata metadata, String lang) {
        Paper paper = metadata.getPaper();
        if (StringUtils.isBlank((CharSequence)metadata.getKey())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PrintMetadataUtil_0", (String)PROJECT_NAME, (Object[])new Object[0]));
        }
        Tuple<Boolean, String> checkResult = NumberCheckUtils.validate(metadata.getKey());
        if (!((Boolean)checkResult.item1).booleanValue()) {
            throw new KDBizException(ResManager.loadKDString((String)((String)checkResult.item2), (String)"PrintMetadataUtil_10", (String)PROJECT_NAME, (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)((CharSequence)metadata.getName().get((Object)lang)))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\u540d\u79f0\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PrintMetadataUtil_1", (String)PROJECT_NAME, (Object[])new Object[0]));
        }
        String paperId = paper.getId();
        float paperHeight = paper.getHeight().floatValue();
        float printY1 = 0.0f;
        float printHeight = paperHeight - paper.getMarginTop().floatValue() - paper.getMarginBottom().floatValue();
        float printY2 = printY1 + printHeight;
        List pages = metadata.getPages();
        Set<String> dsSet = PrintMetadataUtil.getDsSet(metadata);
        HashSet<String> keySet = new HashSet<String>();
        for (List page : pages) {
            Float headHeight = Float.valueOf(0.0f);
            Float footerHeight = Float.valueOf(0.0f);
            Float minY1 = null;
            Float maxY2 = null;
            HashMap<String, Object> dataGrid = new HashMap<String, Object>(16);
            HashMap<String, String> gridMap = new HashMap<String, String>(16);
            for (Control control : page) {
                String key = control.getKey();
                if (StringUtils.isBlank((CharSequence)key)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6807\u8bc6\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PrintMetadataUtil_2", (String)PROJECT_NAME, (Object[])new Object[0]));
                }
                if (keySet.contains(key)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6807\u8bc6\u4e0d\u5141\u8bb8\u91cd\u590d\u3010%s\u3011\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PrintMetadataUtil_3", (String)PROJECT_NAME, (Object[])new Object[0]), key));
                }
                if (control instanceof BaseControl && paperId.equals(control.getParentId())) {
                    BaseControl baseControl = (BaseControl)control;
                    float cY1 = ((Number)baseControl.getY().getLocaleValue()).floatValue();
                    float cY2 = cY1 + ((Number)baseControl.getHeight().getLocaleValue()).floatValue();
                    if (cY1 < printY1 || cY2 > printY2) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u63a7\u4ef6\u6ea2\u51fa\u753b\u5e03\u53ef\u6253\u5370\u533a\u57df\uff0c\u8bf7\u8c03\u6574\u6a21\u677f\u3002", (String)"PrintMetadataUtil_4", (String)PROJECT_NAME, (Object[])new Object[0]));
                    }
                    if (baseControl instanceof HeaderFooter) {
                        if ("Header".equals(baseControl.getType())) {
                            headHeight = Float.valueOf(((Number)baseControl.getHeight().getLocaleValue()).floatValue());
                        } else {
                            footerHeight = Float.valueOf(((Number)baseControl.getHeight().getLocaleValue()).floatValue());
                        }
                    } else {
                        if (minY1 == null || cY1 < minY1.floatValue()) {
                            minY1 = Float.valueOf(cY1);
                        }
                        if (maxY2 == null || cY2 > maxY2.floatValue()) {
                            maxY2 = Float.valueOf(cY2);
                        }
                    }
                }
                if (control instanceof BaseDsControl) {
                    String[] arr;
                    Object dsKey;
                    BaseDsControl dsControl = (BaseDsControl)control;
                    String dataSource = dsControl.getDataSource();
                    if (StringUtils.isNotBlank((CharSequence)dataSource) && !DsType.Sys.getCode().equals(dsControl.getDsType()) && !dsSet.contains(dsKey = (arr = dataSource.split("\\."))[0])) {
                        String viewText = (String)dsControl.getBindText().getLocaleValue();
                        if (StringUtils.isBlank((CharSequence)viewText) && dsControl instanceof Text) {
                            viewText = ((Text)dsControl).getViewText();
                        }
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u3010%s\u3011\u7684\u6570\u636e\u6e90\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PrintMetadataUtil_5", (String)PROJECT_NAME, (Object[])new Object[0]), viewText));
                    }
                    if (DsType.FORMULA.getCode().equals(dsControl.getDsType())) {
                        List formulaData = dsControl.getFormulaData();
                        dsKey = formulaData.iterator();
                        while (dsKey.hasNext()) {
                            Object object = dsKey.next();
                            if (!(object instanceof Map)) continue;
                            String ds = (String)((Map)object).get("dataSource");
                            Object bf = (String)((Map)object).get("bindField");
                            String dt = (String)((Map)object).get("dsType");
                            String bfName = (String)((Map)object).get("formulaName");
                            if (!"$DsKey=[System]".equals(ds) && StringUtils.isNotBlank((CharSequence)ds) && !dsSet.contains(ds.split("\\.")[0])) {
                                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u516c\u5f0f\u4e2d\u5b57\u6bb5\u3010%s\u3011\u7684\u6570\u636e\u6e90\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PrintMetadataUtil_12", (String)PROJECT_NAME, (Object[])new Object[0]), bfName));
                            }
                            bf = ((String)bf).split("\\.")[0];
                            if (DsType.Main.getCode().equals(dt)) {
                                if (EntityMetadataCache.getDataEntityType((String)ds).findProperty((String)bf) != null) continue;
                                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u516c\u5f0f\u4e2d\u3010%s\u3011\u5b57\u6bb5\u5df2\u88ab\u5220\u9664\u3002", (String)"PrintMetadataUtil_9", (String)PROJECT_NAME, (Object[])new Object[0]), bfName));
                            }
                            if (!DsType.Entry.getCode().equals(dt) && !DsType.Subentry.getCode().equals(dt)) continue;
                            String[] dsArray = ds.split("\\.");
                            if (((String)bf).equals("seq") || EntityMetadataCache.getDataEntityType((String)dsArray[0]).findProperty((String)bf) != null) continue;
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u516c\u5f0f\u4e2d\u3010%s\u3011\u5b57\u6bb5\u5df2\u88ab\u5220\u9664\u3002", (String)"PrintMetadataUtil_9", (String)PROJECT_NAME, (Object[])new Object[0]), bfName));
                        }
                    }
                    if (control instanceof DataGridRow) {
                        DataGrid dg = null;
                        DataGridRow dataGridRow = (DataGridRow)control;
                        String mergeByField = dataGridRow.getMergeByField();
                        List mergeSummaryField = dataGridRow.getMergeSummaryField();
                        if (StringUtils.isNotBlank((CharSequence)mergeByField)) {
                            for (Control c : page) {
                                if (!dataGridRow.getParentId().equals(c.getId())) continue;
                                dg = (DataGrid)c;
                                break;
                            }
                            if (dg != null && dg.getDataSource().contains(".")) {
                                String ds = dg.getDataSource();
                                String[] dsArray = ds.split("\\.");
                                MainEntityType mainEntity = EntityMetadataCache.getDataEntityType((String)dsArray[0]);
                                if (dsArray.length > 1 && mainEntity.getAllEntities().containsKey(dsArray[1])) {
                                    String[] mergeByFieldArr = mergeByField.split(";");
                                    for (String mergeField : mergeByFieldArr) {
                                        String[] mergeByFieldArray = mergeField.split("\\.");
                                        if (mergeField.equals("seq") || mainEntity.findProperty(mergeByFieldArray[0]) != null) continue;
                                        throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u5b57\u6bb5\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u6e90\u3002", (String)"PrintMetadataUtil_11", (String)PROJECT_NAME, (Object[])new Object[0]), mergeByFieldArray[0]));
                                    }
                                    if (mergeSummaryField != null) {
                                        for (String msf : mergeSummaryField) {
                                            String[] msfArray = msf.split("\\.");
                                            if (msf.equals("seq") || mainEntity.findProperty(msfArray[0]) != null) continue;
                                            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u5b57\u6bb5\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u6e90\u3002", (String)"PrintMetadataUtil_11", (String)PROJECT_NAME, (Object[])new Object[0]), msfArray[0]));
                                        }
                                    }
                                }
                            }
                        }
                    }
                } else if (control instanceof SubDataGrid) {
                    String parentGridId = ((SubDataGrid)control).getParentGridId();
                    String direction = ((SubDataGrid)control).getSubGridDirection();
                    if ("right".equals(direction) && dataGrid.containsKey(parentGridId)) {
                        gridMap.put(control.getId(), parentGridId);
                        Map value = (Map)dataGrid.get(parentGridId);
                        HashMap<String, String> subGird = new HashMap<String, String>(16);
                        subGird.put("subGirdId", control.getId());
                        value.put("subGrid", subGird);
                    }
                } else if (control instanceof DataGrid) {
                    List subGridId = ((DataGrid)control).getSubGridId();
                    if (!CollectionUtils.isEmpty((Collection)subGridId)) {
                        HashMap<String, String> value = new HashMap<String, String>(16);
                        value.put("girdId", control.getId());
                        dataGrid.put(control.getId(), value);
                    }
                } else if (control instanceof LayoutGridRow) {
                    String parentGridId;
                    String rowType = null;
                    if ("Normal".equals(((LayoutGridRow)control).getRowType())) {
                        rowType = "normalRow";
                    } else if ("Statistic".equals(((LayoutGridRow)control).getRowType())) {
                        rowType = "statisticRow";
                    }
                    String parentId = control.getParentId();
                    if (dataGrid.containsKey(parentId) && rowType != null) {
                        Map value = (Map)dataGrid.get(parentId);
                        value.put(rowType, true);
                    } else if (gridMap.containsKey(parentId) && rowType != null && dataGrid.containsKey(parentGridId = (String)gridMap.get(parentId))) {
                        Map value = (Map)dataGrid.get(parentGridId);
                        Map subGrid = (Map)value.get("subGrid");
                        subGrid.put(rowType, true);
                    }
                }
                keySet.add(key);
            }
            Tuple<Boolean, String> result = PrintMetadataUtil.checkGridAndSubGrid(dataGrid);
            if (!((Boolean)result.item1).booleanValue()) {
                throw new KDBizException((String)result.item2);
            }
            if (minY1 == null || maxY2 == null || !(minY1.floatValue() < headHeight.floatValue()) && !(maxY2.floatValue() > printY2 - footerHeight.floatValue())) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u5185\u5bb9\u533a\u63a7\u4ef6\u6ea2\u51fa\u81f3\u9875\u7709\u6216\u9875\u811a\uff0c\u8bf7\u8c03\u6574\u6a21\u677f\u3002", (String)"PrintMetadataUtil_6", (String)PROJECT_NAME, (Object[])new Object[0]));
        }
    }

    private static Set<String> getDsSet(PrintMetadata metadata) {
        String customDs;
        HashSet<String> dsSets = new HashSet<String>();
        dsSets.add(metadata.getFormId());
        metadata.getFormId();
        Object refMap = null;
        String refDs = metadata.getRefDs();
        if (StringUtils.isNotBlank((CharSequence)refDs)) {
            List resList = (List)SerializationUtils.fromJsonString((String)refDs, List.class);
            for (Map refItem : resList) {
                dsSets.add((String)refItem.get("formId"));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(customDs = metadata.getCustomDs()))) {
            List customList = (List)SerializationUtils.fromJsonString((String)customDs, List.class);
            for (Map customItem : customList) {
                dsSets.add((String)customItem.get("key"));
            }
        }
        return dsSets;
    }

    public static PrintMetadata parseMetadata(Map metadataMap) {
        return MetadataUtil.parseMetadata((Map)metadataMap, null);
    }

    public static Map<String, LocaleValue> mergeMetedata(PrintMetadata printMetadata, Map<String, Map<String, Object>> localeValueMap, String lang) {
        Map valueMap = MetadataUtil.mergeMetedata((PrintMetadata)printMetadata, localeValueMap, (String)lang);
        return valueMap;
    }

    public static List<String> getResIds(PrintMetadata metadata) {
        ArrayList<String> rcList = new ArrayList<String>(4);
        Paper paper = metadata.getPaper();
        String bgImgRcId = paper.getBgImgRcId();
        if (StringUtils.isNotBlank((CharSequence)bgImgRcId)) {
            rcList.add(bgImgRcId);
        }
        List pages = metadata.getPages();
        for (List page : pages) {
            for (Control control : page) {
                String bindField;
                Image image;
                if (!(control instanceof Image) || !"upload".equals((image = (Image)control).getBindType()) || !StringUtils.isNotBlank((CharSequence)(bindField = image.getBindField()))) continue;
                rcList.add(bindField);
            }
        }
        return rcList;
    }

    public static DesignerMetadata toDesignerMetadata(PrintMetadata printMetadata, String lang) {
        DesignerMetadata meta = MetadataUtil.toDesignerMetadata((PrintMetadata)printMetadata, (String)lang);
        Map paper = (Map)meta.getMetadata().get("paper");
        paper.put("language", lang);
        return meta;
    }

    private static Tuple<Boolean, String> checkGridAndSubGrid(Map<String, Object> data) {
        if (data.isEmpty()) {
            return new Tuple((Object)true, (Object)"");
        }
        String tipOne = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e\u8868\u683c\u6dfb\u52a0\u6807\u9898\u884c\uff08\u6216\u5408\u8ba1\u884c\uff09\u65f6\uff0c\u5b50\u6570\u636e\u8868\u683c\u4e5f\u9700\u6dfb\u52a0\u6807\u9898\u884c\uff08\u6216\u5408\u8ba1\u884c\uff09\u3002", (String)"PrintMetadataUtil_7", (String)PROJECT_NAME, (Object[])new Object[0]);
        String tipTwo = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e\u8868\u683c\u672a\u6dfb\u52a0\u6807\u9898\u884c\uff08\u6216\u5408\u8ba1\u884c\uff09\u65f6\uff0c\u5b50\u6570\u636e\u8868\u683c\u6807\u9898\u884c\uff08\u6216\u5408\u8ba1\u884c\uff09\u9700\u5220\u9664\u3002", (String)"PrintMetadataUtil_8", (String)PROJECT_NAME, (Object[])new Object[0]);
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            Map value = (Map)entry.getValue();
            if (!value.containsKey("subGrid")) continue;
            boolean parentTitleExist = value.containsKey("normalRow");
            boolean parentTStatExist = value.containsKey("statisticRow");
            Map subGrid = (Map)value.get("subGrid");
            boolean subTitleExist = subGrid.containsKey("normalRow");
            boolean subStatExist = subGrid.containsKey("statisticRow");
            if (parentTitleExist && !subTitleExist || parentTStatExist && !subStatExist) {
                return new Tuple((Object)false, (Object)tipOne);
            }
            if ((parentTitleExist || !subTitleExist) && (parentTStatExist || !subStatExist)) continue;
            return new Tuple((Object)false, (Object)tipTwo);
        }
        return new Tuple((Object)true, (Object)"");
    }
}

