/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.metedata.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.isv.ISVService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.print.api.metedata.LocaleValue;
import kd.bos.print.api.metedata.PrintMetadata;
import kd.bos.print.business.designer.OpResult;
import kd.bos.print.business.metedata.PrintMetadataUtil;
import kd.bos.print.business.metedata.bean.AbstractDesignMetadata;
import kd.bos.print.business.metedata.bean.AbstractDesignMetadataL;
import kd.bos.print.business.metedata.bean.DesignMetadata;
import kd.bos.print.business.metedata.bean.DesignMetadataL;
import kd.bos.print.business.metedata.bean.LibraryDesignMetadataL;
import kd.bos.print.business.metedata.service.PrintTplObj;
import kd.bos.print.business.service.BosPrintBusinessServiceImpl;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public abstract class AbstractTplService<T extends AbstractDesignMetadata> {
    protected String PRINT_METEDATA = "bos_print_meta";
    protected String PRINT_METEDATA_TABLE = "t_svc_printmeta";
    protected String PRINT_RESOURCE = "bos_print_resource";
    private Log log = LogFactory.getLog(AbstractTplService.class);

    public String getMetedataKey() {
        return this.PRINT_METEDATA;
    }

    public abstract IDataEntityType getDataEntityType();

    public abstract IDataEntityType getDataEntityLType();

    public T getDesignMeta(String tplId) {
        AbstractDesignMetadata read = (AbstractDesignMetadata)BusinessDataReader.read((Object)tplId, (IDataEntityType)this.getDataEntityType(), (Boolean)Boolean.FALSE);
        return (T)read;
    }

    public Object[] getDesignMetaL(String tplId) {
        Object[] metaL = BusinessDataReader.load((Object[])new String[]{tplId}, (IDataEntityType)this.getDataEntityLType());
        return metaL;
    }

    public PrintMetadata getMetadata(String tplId) {
        T designMeta = this.getDesignMeta(tplId);
        Object[] metaL = this.getDesignMetaL(tplId);
        return this.buildMetadata((AbstractDesignMetadata)designMeta, metaL);
    }

    public Tuple<PrintMetadata, Boolean> getMetadataWithType(String tplId) {
        T designMeta = this.getDesignMeta(tplId);
        PrintMetadata printMetadata = this.getPrintMetadata((AbstractDesignMetadata)designMeta);
        boolean sysTemplate = this.isSysTemplate((AbstractDesignMetadata)designMeta);
        return Tuple.create((Object)printMetadata, (Object)sysTemplate);
    }

    public PrintMetadata getPrintMetadata(AbstractDesignMetadata designMeta) {
        Object[] metaL = this.getDesignMetaL(designMeta.getId());
        PrintMetadata printMetadata = this.buildMetadata(designMeta, metaL);
        return printMetadata;
    }

    public boolean isSysTemplate(AbstractDesignMetadata designMeta) {
        boolean sysTemplate = false;
        if (designMeta instanceof DesignMetadata) {
            sysTemplate = "1".equals(((DesignMetadata)designMeta).getTplType());
        }
        return sysTemplate;
    }

    private PrintMetadata buildMetadata(AbstractDesignMetadata designMeta, Object[] metaL) {
        String metaData = designMeta.getData();
        PrintMetadata printMetadata = PrintMetadataUtil.parseMetadata(metaData);
        LocaleValue name = printMetadata.getName();
        if (name == null) {
            name = new LocaleValue();
        }
        HashMap<String, Map<String, Object>> localeDateMap = new HashMap<String, Map<String, Object>>(metaL.length);
        for (Object localValue : metaL) {
            AbstractDesignMetadataL designMetadataL = (AbstractDesignMetadataL)localValue;
            String data = designMetadataL.getData();
            if (StringUtils.isNotBlank((CharSequence)data)) {
                Map value = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
                localeDateMap.put(designMetadataL.getLocaleId(), value);
            }
            name.put(designMetadataL.getLocaleId(), (Object)designMetadataL.getName());
        }
        String version = designMeta.getVersion();
        if (version != null && printMetadata.getVersion() != null && version.compareTo(printMetadata.getVersion()) > 0) {
            printMetadata.setVersion(version);
        }
        PrintMetadataUtil.mergeLocaleDataMap(printMetadata, localeDateMap);
        return printMetadata;
    }

    public abstract List loadDataSource(String var1, List<Map> var2, List<Map> var3, OpResult var4);

    public abstract Map beforeSave(Map<String, Object> var1);

    public abstract PrintTplObj updatePrintMeta(Map<String, Object> var1, String var2, String var3);

    public void save(T designMeta) {
        try (TXHandle tx = TX.required();){
            BusinessDataWriter.save((IDataEntityType)this.getDataEntityType(), (Object[])new Object[]{designMeta});
            BusinessDataWriter.save((IDataEntityType)this.getDataEntityLType(), (Object[])this.getDesignMetaL(designMeta).toArray());
        }
    }

    public void save(T designMeta, List<AbstractDesignMetadataL> metadataLs) {
        try (TXHandle tx = TX.required();){
            BusinessDataWriter.save((IDataEntityType)this.getDataEntityType(), (Object[])new Object[]{designMeta});
            BusinessDataWriter.save((IDataEntityType)this.getDataEntityLType(), (Object[])metadataLs.toArray());
        }
    }

    public void saveWithEnable(T metadata) {
    }

    public void update(T designMeta) {
        String tplId = designMeta.getId();
        T dbDesignMeta = this.getDesignMeta(tplId);
        designMeta.setCreatetime(dbDesignMeta.getCreatetime());
        designMeta.setCreator(dbDesignMeta.getCreator());
        try (TXHandle tx = TX.required();){
            BusinessDataWriter.delete((IDataEntityType)this.getDataEntityType(), (Object[])new Object[]{designMeta.getId()});
            BusinessDataWriter.save((IDataEntityType)this.getDataEntityType(), (Object[])new Object[]{designMeta});
        }
    }

    public void beforeImport(T designMeta) {
        String isv = designMeta.getIsv();
        this.checkTplTypeAndIsv("0", isv);
    }

    protected void checkTplTypeAndIsv(String tplType, String isv) {
        if (StringUtils.isNotBlank((CharSequence)isv) && !isv.equals(ISVService.getISVInfo().getId()) || "1".equals(tplType)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u9884\u7f6e\u6a21\u677f\u4e0d\u652f\u6301\u5bfc\u5165\u3002", (String)"AbstractTplService_0", (String)"bos-print-business", (Object[])new Object[0]));
        }
    }

    public void saveOrUpdate(T designMeta) {
        String tplId = designMeta.getId();
        QFilter qFilter = new QFilter("id", "=", (Object)tplId);
        DynamicObject record = QueryServiceHelper.queryOne((String)this.getMetedataKey(), (String)"id,number,tpltype,isv", (QFilter[])new QFilter[]{qFilter});
        if (record != null) {
            this.checkTplTypeAndIsv(record.getString("tpltype"), record.getString("isv"));
            this.update(designMeta);
        } else {
            this.save(designMeta);
        }
    }

    protected List<AbstractDesignMetadataL> getDesignMetaL(T designMeta) {
        return this.getDesignMetaL(designMeta, null);
    }

    public List<AbstractDesignMetadataL> getDesignMetaL(T designMeta, Map<String, String> localValueMap) {
        ILocaleString localName = designMeta.getlName();
        ArrayList<AbstractDesignMetadataL> langList = new ArrayList<AbstractDesignMetadataL>(10);
        HashSet<String> langSet = new HashSet<String>(localName.keySet());
        if (localValueMap != null) {
            langSet.addAll(localValueMap.keySet());
        }
        for (String lang : langSet) {
            String data;
            Object metadataL = designMeta instanceof DesignMetadata ? new DesignMetadataL() : new LibraryDesignMetadataL();
            metadataL.setPkId(DBServiceHelper.genStringId());
            metadataL.setId(designMeta.getId());
            metadataL.setLocaleId(lang);
            metadataL.setName((String)localName.get((Object)lang));
            if (localValueMap != null && StringUtils.isNotBlank((CharSequence)(data = localValueMap.get(lang)))) {
                metadataL.setData(data);
            }
            langList.add((AbstractDesignMetadataL)metadataL);
        }
        return langList;
    }

    public String getPreviewUrl(PrintMetadata printMetadata, String curLang) {
        return BosPrintBusinessServiceImpl.preview(printMetadata, curLang);
    }
}

