/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.metedata.service;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.isv.ISVService;
import kd.bos.orm.query.QFilter;
import kd.bos.print.api.metedata.MetadataUtil;
import kd.bos.print.api.metedata.PrintMetadata;
import kd.bos.print.api.utils.SerializeUtils;
import kd.bos.print.business.designer.OpResult;
import kd.bos.print.business.designer.datasource.DsType;
import kd.bos.print.business.designer.datasource.PrintDataSourceUtil;
import kd.bos.print.business.metedata.PrintMetadataUtil;
import kd.bos.print.business.metedata.bean.LibraryDesignMetadata;
import kd.bos.print.business.metedata.bean.LibraryDesignMetadataL;
import kd.bos.print.business.metedata.service.AbstractTplService;
import kd.bos.print.business.metedata.service.PrintTplObj;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.svc.util.print.UpdateLocalNameUtil;

public class LibraryTplService
extends AbstractTplService<LibraryDesignMetadata> {
    private static final String PROJECT_NAME = "bos-print-business";
    private static IDataEntityType tplType = null;
    private static IDataEntityType tplTypeL = null;

    @Override
    public IDataEntityType getDataEntityType() {
        if (tplType == null) {
            tplType = OrmUtils.getDataEntityType(LibraryDesignMetadata.class);
        }
        return tplType;
    }

    @Override
    public IDataEntityType getDataEntityLType() {
        if (tplTypeL == null) {
            tplTypeL = OrmUtils.getDataEntityType(LibraryDesignMetadataL.class);
        }
        return tplTypeL;
    }

    public LibraryTplService() {
        this.PRINT_METEDATA = "bos_printtpl_lbr";
        this.PRINT_METEDATA_TABLE = "t_svc_printtpl";
    }

    @Override
    public List loadDataSource(String entityId, List<Map> refDsList, List<Map> customDsList, OpResult opResult) {
        Map<String, Object> systemDs = PrintDataSourceUtil.getBuilder(DsType.Sys).build();
        return Collections.singletonList(systemDs);
    }

    @Override
    public Map beforeSave(Map<String, Object> content) {
        HashMap<String, String> result = new HashMap<String, String>();
        String id = (String)content.get("id");
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        DynamicObject record = QueryServiceHelper.queryOne((String)this.getMetedataKey(), (String)"id,isv", (QFilter[])new QFilter[]{qFilter});
        if (record == null) {
            result.put("success", "false");
            result.put("message", ResManager.loadKDString((String)"\u6a21\u677f\u4e0d\u5b58\u5728\uff0c\u6216\u5df2\u88ab\u5220\u9664\u3002", (String)"PrintDesignerPlugin_2", (String)PROJECT_NAME, (Object[])new Object[0]));
            return result;
        }
        String isv = record.getString("isv");
        if (StringUtils.isNotBlank((CharSequence)isv) && !isv.equals(ISVService.getISVInfo().getId())) {
            result.put("success", "false");
            result.put("message", ResManager.loadKDString((String)"\u7cfb\u7edf\u9884\u7f6e\u6a21\u677f\u4e0d\u652f\u6301\u4fee\u6539\u3002", (String)"PrintDesignerPlugin_16", (String)PROJECT_NAME, (Object[])new Object[0]));
            return result;
        }
        result.put("success", "true");
        result.put("message", "");
        return result;
    }

    @Override
    public PrintTplObj updatePrintMeta(Map<String, Object> content, String localValueStr, String curLang) {
        PrintMetadata printMetadata = PrintMetadataUtil.parseMetadata(content, curLang);
        Map localeValueMap = (Map)SerializeUtils.fromJsonString((String)localValueStr, Map.class);
        Tuple tuple = MetadataUtil.mergeBuildDataMap((PrintMetadata)printMetadata, (Map)localeValueMap, (String)curLang);
        Map newLocalValueMap = (Map)tuple.item2;
        Map localeDataMap = (Map)tuple.item1;
        String metaTableL = this.PRINT_METEDATA_TABLE + "_L";
        try (TXHandle tx = TX.required();){
            String sql = "update %s set fdata=?,fnumber=?,fmodifierid=?,fmodifytime=?,fdirection=?,fmodify_v=? where fid=?";
            sql = String.format(sql, this.PRINT_METEDATA_TABLE);
            Object[] params = new SqlParameter[7];
            params[0] = new SqlParameter("fdata", -16, (Object)printMetadata.toString());
            params[1] = new SqlParameter("fnumber", 12, (Object)printMetadata.getKey());
            params[2] = new SqlParameter("fmodifierid", -5, (Object)RequestContext.get().getUserId());
            params[3] = new SqlParameter("fmodifytime", 12, (Object)new Date());
            String direction = "vertical".equals(printMetadata.getPaper().getPaperDirection()) ? "B" : "A";
            params[4] = new SqlParameter("fdirection", 12, (Object)direction);
            params[5] = new SqlParameter("fmodify_v", -5, (Object)System.currentTimeMillis());
            params[6] = new SqlParameter("fid", 12, (Object)printMetadata.getId());
            DB.execute((DBRoute)DBRoute.base, (String)sql, (Object[])params);
            UpdateLocalNameUtil.updateLocaleData((Object)printMetadata.getId(), (int)12, (Map)printMetadata.getName(), (Map)localeDataMap, (String)metaTableL);
        }
        return new PrintTplObj(printMetadata, newLocalValueMap);
    }

    @Override
    public void saveOrUpdate(LibraryDesignMetadata designMeta) {
        String tplId = designMeta.getId();
        QFilter qFilter = new QFilter("id", "=", (Object)tplId);
        DynamicObject record = QueryServiceHelper.queryOne((String)this.getMetedataKey(), (String)"id,number", (QFilter[])new QFilter[]{qFilter});
        if (record != null) {
            this.update(designMeta);
        } else {
            this.save(designMeta);
        }
    }
}

