/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.metedata.service;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.isv.ISVService;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.api.facade.IPrtDataSourceFacade;
import kd.bos.print.api.facade.PrtFacadeFactory;
import kd.bos.print.api.metedata.MetadataUtil;
import kd.bos.print.api.metedata.PrintMetadata;
import kd.bos.print.api.metedata.control.Paper;
import kd.bos.print.api.utils.ConfigConstUtil;
import kd.bos.print.api.utils.SerializeUtils;
import kd.bos.print.business.designer.OpResult;
import kd.bos.print.business.designer.datasource.DataSourceInfo;
import kd.bos.print.business.designer.datasource.DsType;
import kd.bos.print.business.designer.datasource.PrintDataSourceUtil;
import kd.bos.print.business.designer.datasource.PrtDataSourceUtil;
import kd.bos.print.business.designer.plugin.NumberCheckUtils;
import kd.bos.print.business.metedata.PrintMetadataUtil;
import kd.bos.print.business.metedata.bean.AbstractDesignMetadataL;
import kd.bos.print.business.metedata.bean.DesignMetadata;
import kd.bos.print.business.metedata.bean.DesignMetadataL;
import kd.bos.print.business.metedata.service.AbstractTplService;
import kd.bos.print.business.metedata.service.PrintTplObj;
import kd.bos.print.business.orgctrl.OrgCtrlUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.bos.svc.util.print.UpdateLocalNameUtil;

public class PrintTplService
extends AbstractTplService<DesignMetadata> {
    private static final String MANAGE_TPL_TABLENAME = "t_bas_printtplinfo";
    private static final String MANAGE_TPL_TABLENAME_L = "t_bas_printtplinfo_l";
    private static final String MANAGE_TPL = "bos_manageprinttpl";
    private static IDataEntityType tplType = null;
    private static IDataEntityType tplTypeL = null;
    private static final String PROJECT_NAME = "bos-print-business";
    private Map<String, Map<String, Boolean>> showScaleZeroCacheMap = new HashMap<String, Map<String, Boolean>>(16);

    @Override
    public IDataEntityType getDataEntityType() {
        if (tplType == null) {
            tplType = OrmUtils.getDataEntityType(DesignMetadata.class);
        }
        return tplType;
    }

    @Override
    public IDataEntityType getDataEntityLType() {
        if (tplTypeL == null) {
            tplTypeL = OrmUtils.getDataEntityType(DesignMetadataL.class);
        }
        return tplTypeL;
    }

    @Override
    public List loadDataSource(String entityId, List<Map> refDsList, List<Map> customDsList, OpResult opResult) {
        DataSourceInfo dsInfo = this.loadMainDs(entityId);
        List dataSource = dsInfo.getDataSource();
        opResult.setContainWf(dsInfo.isContainWf());
        if (refDsList != null && !refDsList.isEmpty()) {
            for (Map ds : refDsList) {
                String refEntityId = (String)ds.get("entityId");
                try {
                    List dsDataSource = this.loadRefDs(refEntityId);
                    dataSource.addAll(dsDataSource);
                }
                catch (KDBizException e) {
                    opResult.setSuccess(false);
                    if (e.getErrorCode().getCode() == "3") {
                        Map alias = (Map)ds.get("alias");
                        String dsName = (String)alias.get(RequestContext.get().getLang().toString());
                        String msg = ResManager.loadKDString((String)"\u5173\u8054\u6570\u636e\u6e90\u201c%s\u201d\u4e0d\u5b58\u5728\u3002", (String)"PrintTplService_0", (String)PROJECT_NAME, (Object[])new Object[0]);
                        opResult.addErrMsg(String.format(msg, dsName));
                        continue;
                    }
                    opResult.addErrMsg(e.getMessage());
                }
            }
        }
        if (customDsList != null && !customDsList.isEmpty()) {
            List dsDataSource = PrintDataSourceUtil.buildCustomDataSource(customDsList);
            dataSource.addAll(dsDataSource);
        }
        for (Object source : dataSource) {
            Object formId;
            Map sourceMap;
            Object type;
            String dsTypeCode;
            if (!(source instanceof Map) || StringUtils.isBlank((CharSequence)(dsTypeCode = this.getDsTypeCode(type = (sourceMap = (Map)source).get("DsType")))) || !DsType.Main.getCode().equals(dsTypeCode) && !DsType.Ref.getCode().equals(dsTypeCode) && !DsType.Report.getCode().equals(dsTypeCode) || StringUtils.isBlank(formId = sourceMap.get("Key"))) continue;
            Map<String, Boolean> noShowScaleZeroMap = this.getNoShowScaleZeroMap((String)formId);
            this.putShowScaleZeroToItems(noShowScaleZeroMap, sourceMap);
        }
        List prtDataSourceServices = PrtFacadeFactory.getAllPrtDataSourceFacades();
        if (prtDataSourceServices != null && !prtDataSourceServices.isEmpty()) {
            for (IPrtDataSourceFacade prtDataSourceService : prtDataSourceServices) {
                List list = prtDataSourceService.buildCustomDs(entityId, dataSource);
                if (list == null) continue;
                return list;
            }
        }
        return dataSource;
    }

    private void putShowScaleZeroToItems(Map<String, Boolean> noShowScaleZeroMap, Map<String, Object> sourceMap) {
        List items = (List)sourceMap.get("Items");
        if (CollectionUtils.isEmpty((Collection)items)) {
            return;
        }
        for (Map item : items) {
            Object fieldKey = item.get("Key");
            Boolean isField = item.getOrDefault("IsField", Boolean.FALSE);
            if (isField.booleanValue() && noShowScaleZeroMap.containsKey(fieldKey)) {
                Boolean showScaleZero = noShowScaleZeroMap.get(fieldKey);
                item.put("IgnoreTailZero", showScaleZero);
                continue;
            }
            Object type = item.get("DsType");
            String dsTypeCode = this.getDsTypeCode(type);
            if (StringUtils.isBlank((CharSequence)dsTypeCode) || !DsType.Entry.getCode().equals(dsTypeCode) && !DsType.Subentry.getCode().equals(dsTypeCode) && !DsType.ReportEntry.getCode().equals(dsTypeCode)) continue;
            this.putShowScaleZeroToItems(noShowScaleZeroMap, item);
        }
    }

    private String getDsTypeCode(Object type) {
        String dsTypeCode = "";
        if (type instanceof DsType) {
            DsType dsType = (DsType)((Object)type);
            dsTypeCode = dsType.getCode();
        } else if (type instanceof String) {
            dsTypeCode = type.toString();
        }
        return dsTypeCode;
    }

    private Map<String, Boolean> getNoShowScaleZeroMap(String formId) {
        Map<String, Boolean> showScaleZeroMap = this.showScaleZeroCacheMap.get(formId);
        if (showScaleZeroMap != null) {
            return showScaleZeroMap;
        }
        showScaleZeroMap = new HashMap<String, Boolean>(16);
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readMeta((String)MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        formMetadata.createIndex();
        List controlAps = formMetadata.getItems();
        for (ControlAp controlAp : controlAps) {
            if (!(controlAp instanceof FieldAp)) continue;
            FieldAp fieldAp = (FieldAp)controlAp;
            boolean noDisplayScaleZero = fieldAp.isNoDisplayScaleZero();
            String key = fieldAp.getKey();
            Field field = entityMetadata.getFieldByKey(key);
            if (field == null || !(field instanceof DecimalField)) continue;
            String fieldKey = field.getKey();
            showScaleZeroMap.put(fieldKey, noDisplayScaleZero);
        }
        this.showScaleZeroCacheMap.put(formId, showScaleZeroMap);
        return showScaleZeroMap;
    }

    @Override
    public Map beforeSave(Map<String, Object> content) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("success", "true");
        result.put("message", "");
        String id = (String)content.get("id");
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        DynamicObject record = QueryServiceHelper.queryOne((String)this.getMetedataKey(), (String)"id,number,tpltype,isv", (QFilter[])new QFilter[]{qFilter});
        if (record == null) {
            result.put("success", "false");
            result.put("message", ResManager.loadKDString((String)"\u6a21\u677f\u4e0d\u5b58\u5728\uff0c\u6216\u5df2\u88ab\u5220\u9664\u3002", (String)"PrintDesignerPlugin_2", (String)PROJECT_NAME, (Object[])new Object[0]));
            return result;
        }
        String isv = record.getString("isv");
        String tpltype = record.getString("tpltype");
        if (StringUtils.isNotBlank((CharSequence)isv) && !isv.equals(ISVService.getISVInfo().getId()) || "1".equals(tpltype)) {
            result.put("success", "false");
            result.put("message", ResManager.loadKDString((String)"\u7cfb\u7edf\u9884\u7f6e\u6a21\u677f\u4e0d\u652f\u6301\u4fee\u6539\uff0c\u53ef\u901a\u8fc7\u590d\u5236\u6a21\u677f\u540e\u4fee\u6539\u3002", (String)"PrintDesignerPlugin_14", (String)PROJECT_NAME, (Object[])new Object[0]));
            return result;
        }
        if (!OrgCtrlUtil.checkPrintTemplateCanSave(id)) {
            result.put("success", "false");
            result.put("message", ResManager.loadKDString((String)"\u5f53\u524d\u5957\u6253\u6a21\u7248\u521b\u5efa\u7ec4\u7ec7\u548c\u5f53\u524d\u7ec4\u7ec7\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u8fdb\u884c\u4fdd\u5b58\u3002", (String)"FormDesignerPlugin_33", (String)"bos-designer-plugin", (Object[])new Object[0]));
            return result;
        }
        return result;
    }

    @Override
    public PrintTplObj updatePrintMeta(Map<String, Object> content, String localValueStr, String curLang) {
        PrintMetadata printMetadata = PrintMetadataUtil.parseMetadata(content, curLang);
        Tuple<Boolean, String> checkResult = NumberCheckUtils.validateIsv(printMetadata.getKey());
        if (!((Boolean)checkResult.item1).booleanValue()) {
            throw new KDBizException(ResManager.loadKDString((String)((String)checkResult.item2), (String)"NewPrintTplGuidePlugin_8", (String)PROJECT_NAME, (Object[])new Object[0]));
        }
        Map localeValueMap = (Map)SerializeUtils.fromJsonString((String)localValueStr, Map.class);
        Tuple tuple = MetadataUtil.mergeBuildDataMap((PrintMetadata)printMetadata, (Map)localeValueMap, (String)curLang);
        Map newLocalValueMap = (Map)tuple.item2;
        Map localeDataMap = (Map)tuple.item1;
        String metaTableL = this.PRINT_METEDATA_TABLE + "_L";
        try (TXHandle tx = TX.required();){
            String sql = "update %s set fdata=?,fnumber=?,fstplid=?,fmodifierid=?,fmodifytime=?,fmodify_v=? where fid=? ";
            sql = String.format(sql, this.PRINT_METEDATA_TABLE);
            Object[] params = new SqlParameter[]{new SqlParameter("fdata", -16, (Object)printMetadata.toString()), new SqlParameter("fnumber", 12, (Object)printMetadata.getKey()), new SqlParameter("fstplid", 12, (Object)(StringUtils.isBlank((CharSequence)printMetadata.getStplId()) ? " " : printMetadata.getStplId())), new SqlParameter("fmodifierid", -5, (Object)RequestContext.get().getCurrUserId()), new SqlParameter("fmodifytime", 12, (Object)new Date()), new SqlParameter("fmodify_v", -5, (Object)System.currentTimeMillis()), new SqlParameter("fid", 12, (Object)printMetadata.getId())};
            DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
            UpdateLocalNameUtil.updateLocaleData((Object)printMetadata.getId(), (int)12, (Map)printMetadata.getName(), (Map)localeDataMap, (String)metaTableL);
            this.updateManagetpl(printMetadata.getId(), printMetadata.getKey(), (Map)printMetadata.getName());
            DataEntityCacheManager cacheManager = new DataEntityCacheManager(this.PRINT_METEDATA_TABLE);
            cacheManager.removeByPrimaryKey(new Object[]{printMetadata.getId()});
        }
        return new PrintTplObj(printMetadata, newLocalValueMap);
    }

    @Override
    public void save(DesignMetadata metadata) {
        try (TXHandle tx = TX.required();){
            metadata.setTplType("0");
            super.save(metadata);
            metadata.setEnable("1");
            this.inserManagetpl(metadata);
        }
    }

    @Override
    public void save(DesignMetadata designMeta, List<AbstractDesignMetadataL> metadataLs) {
        try (TXHandle tx = TX.required();){
            designMeta.setTplType("0");
            super.save(designMeta, metadataLs);
            designMeta.setEnable("1");
            this.inserManagetpl(designMeta);
        }
    }

    @Override
    public void saveWithEnable(DesignMetadata metadata) {
        String tplId = metadata.getId();
        try (TXHandle tx = TX.required();){
            metadata.setTplType("0");
            super.save(metadata);
            this.inserManagetpl(metadata);
        }
    }

    @Override
    public void update(DesignMetadata metadata) {
        try (TXHandle tx = TX.required();){
            if (StringUtils.isBlank((CharSequence)metadata.getTplType())) {
                metadata.setTplType("0");
            }
            super.update(metadata);
            this.updateManagetpl(metadata.getId(), metadata.getNumber(), (Map)metadata.getlName());
        }
    }

    private void inserManagetpl(DesignMetadata metadata) {
        String printMetaId = metadata.getId();
        String enable = metadata.getEnable();
        String printFormId = metadata.getFormId();
        String number = metadata.getNumber();
        String insertSql = "insert into %s (fid, fprinttplid, fbillformid, fcreatetime, fmodifytime,fmodifierid,fcreatorid, fenable,ftype,fnumber) values (?, ?, ?, ?, ?, ?, ?, ?,?,?)";
        insertSql = String.format(insertSql, MANAGE_TPL_TABLENAME);
        long id = DB.genLongId((String)MANAGE_TPL_TABLENAME);
        String creator = RequestContext.get().getUserId();
        Object[] params = new SqlParameter[]{new SqlParameter("fid", -5, (Object)id), new SqlParameter("fprinttplid", 12, (Object)printMetaId), new SqlParameter("fbillformid", 12, (Object)printFormId), new SqlParameter("fcreatetime", 91, (Object)new Date()), new SqlParameter("fmodifytime", 91, (Object)new Date()), new SqlParameter("fmodifierid", -5, (Object)creator), new SqlParameter("fcreatorid", -5, (Object)creator), new SqlParameter("fenable", 12, (Object)enable), new SqlParameter("ftype", 12, (Object)"B"), new SqlParameter("fnumber", 12, (Object)number)};
        DB.execute((DBRoute)DBRoute.basedata, (String)insertSql, (Object[])params);
        ILocaleString localeName = metadata.getlName();
        UpdateLocalNameUtil.updateLocaleName((Object)id, (int)-5, (Map)localeName, (String)MANAGE_TPL_TABLENAME_L);
    }

    private void updateManagetpl(String printMetaId, String number, Map localName) {
        String creator = RequestContext.get().getUserId();
        String updateSql = "update %s set  fmodifytime = ?,fmodifierid= ?,fnumber= ? where fprinttplid = ?";
        Object[] params = new SqlParameter[]{new SqlParameter("fmodifytime", 91, (Object)new Date()), new SqlParameter("fmodifierid", -5, (Object)creator), new SqlParameter("fnumber", 12, (Object)number), new SqlParameter("fprinttplid", 12, (Object)printMetaId)};
        updateSql = String.format(updateSql, MANAGE_TPL_TABLENAME);
        DB.execute((DBRoute)DBRoute.basedata, (String)updateSql, (Object[])params);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)MANAGE_TPL, (String)"id", (QFilter[])new QFilter[]{new QFilter("printtplid", "=", (Object)printMetaId)});
        if (dynamicObject != null) {
            UpdateLocalNameUtil.updateLocaleName((Object)dynamicObject.getPkValue(), (int)-5, (Map)localName, (String)MANAGE_TPL_TABLENAME_L);
            DataEntityCacheManager cacheManager = new DataEntityCacheManager(MANAGE_TPL_TABLENAME);
            cacheManager.removeByPrimaryKey(new Object[]{dynamicObject.getPkValue()});
        }
    }

    private DataSourceInfo loadMainDs(String entityId) {
        if (ConfigConstUtil.isUseSimpleDs()) {
            return PrtDataSourceUtil.buildDataSource(entityId);
        }
        return PrintDataSourceUtil.buildDataSource(entityId);
    }

    private List loadRefDs(String entityId) {
        return PrtDataSourceUtil.loadRefDs(entityId);
    }

    @Override
    public void saveOrUpdate(DesignMetadata designMeta) {
        String importType = this.getImportType();
        boolean isUpdateImport = this.isUpdateImport(importType);
        QFilter qFilter = this.getQFilter(isUpdateImport, designMeta);
        DynamicObject printTplDynamicObject = QueryServiceHelper.queryOne((String)this.getMetedataKey(), (String)"id,number,tpltype,isv", (QFilter[])new QFilter[]{qFilter});
        if (isUpdateImport) {
            Tuple<Boolean, String> checkResult = NumberCheckUtils.validateIsv(designMeta.getNumber());
            if (!((Boolean)checkResult.item1).booleanValue()) {
                throw new KDBizException((String)checkResult.item2);
            }
            this.saveOrUpdateById(designMeta, printTplDynamicObject);
            return;
        }
        this.saveByNumber(designMeta, printTplDynamicObject);
    }

    private QFilter getQFilter(boolean isUpdateImport, DesignMetadata designMeta) {
        if (isUpdateImport) {
            return new QFilter("id", "=", (Object)designMeta.getId());
        }
        return new QFilter("number", "=", (Object)designMeta.getNumber());
    }

    private void saveByNumber(DesignMetadata designMeta, DynamicObject printTplDynamicObject) {
        if (printTplDynamicObject == null) {
            Tuple<Boolean, String> checkResult = NumberCheckUtils.validateIsv(designMeta.getNumber());
            if (!((Boolean)checkResult.item1).booleanValue()) {
                throw new KDBizException((String)checkResult.item2);
            }
            QFilter qFilter = this.getQFilter(true, designMeta);
            DynamicObject obj = QueryServiceHelper.queryOne((String)this.getMetedataKey(), (String)"id,number,tpltype,isv", (QFilter[])new QFilter[]{qFilter});
            if (obj != null) {
                String newId = DB.genStringId((String)this.PRINT_METEDATA_TABLE);
                designMeta.setId(newId);
                String newData = this.rebuildMetadata(designMeta, newId, designMeta.getNumber());
                designMeta.setData(newData);
            }
            this.save(designMeta);
            return;
        }
        String newId = DB.genStringId((String)this.PRINT_METEDATA_TABLE);
        String prefix = "prt_";
        if (NumberCheckUtils.isKingdeeISV()) {
            prefix = "kdprint_";
        }
        String newNumber = prefix + Uuid8.generateShortUuid().toLowerCase(Locale.ENGLISH);
        designMeta.setId(newId);
        designMeta.setNumber(newNumber);
        String newData = this.rebuildMetadata(designMeta, newId, newNumber);
        designMeta.setData(newData);
        this.save(designMeta);
    }

    private String rebuildMetadata(DesignMetadata designMeta, String newId, String newNumber) {
        String data = designMeta.getData();
        PrintMetadata printMetadata = PrintMetadataUtil.parseMetadata(data);
        printMetadata.setId(newId);
        printMetadata.setKey(newNumber);
        Paper paper = printMetadata.getPaper();
        paper.setKey(newNumber);
        printMetadata.setPaper(paper);
        String newData = SerializationUtils.toJsonString((Object)printMetadata);
        return newData;
    }

    private void saveOrUpdateById(DesignMetadata designMeta, DynamicObject printTplDynamicObject) {
        if (printTplDynamicObject != null) {
            this.checkTplTypeAndIsv(printTplDynamicObject.getString("tpltype"), printTplDynamicObject.getString("isv"));
            this.update(designMeta);
        } else {
            this.save(designMeta);
        }
    }

    private String getImportType() {
        String importType = UserConfigServiceHelper.getSetting((long)RequestContext.get().getCurrUserId(), (String)"print_tpl_import_type_key");
        if (StringUtils.isBlank((CharSequence)importType)) {
            importType = "0";
        }
        return importType;
    }

    private boolean isUpdateImport(String importType) {
        return StringUtils.equals((CharSequence)"0", (CharSequence)importType);
    }
}

