/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.metedata.service;

import com.alibaba.fastjson.JSONArray;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.svc.util.print.PrintFileUtil;

public class TplFileUtil {
    private static final Log logger = LogFactory.getLog(TplFileUtil.class);

    public static void saveFile(String path, String content) {
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(path), StandardCharsets.UTF_8);){
            outputStreamWriter.write(content);
            outputStreamWriter.flush();
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, BosErrorCode.downloadFailed, new Object[0]);
        }
    }

    public static void deleteFiles(File file) {
        try {
            if (!file.isDirectory()) {
                Files.delete(file.toPath());
            } else if (file.isDirectory()) {
                File[] fileList = file.listFiles();
                for (int i = 0; i < fileList.length; ++i) {
                    File delfile = fileList[i];
                    if (!delfile.isDirectory()) {
                        Files.delete(delfile.toPath());
                        continue;
                    }
                    if (!delfile.isDirectory()) continue;
                    TplFileUtil.deleteFiles(fileList[i]);
                }
                Files.delete(file.toPath());
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    public static String zipFiles(String zipName, String zipDir) {
        String metaDir = zipDir.substring(zipDir.lastIndexOf(File.separator) + 1);
        JSONArray files = new JSONArray();
        File file = new File(zipDir = PrintFileUtil.normalize((String)zipDir));
        if (file.exists()) {
            files.add((Object)zipDir);
        }
        String zipFilePath = zipDir.substring(0, zipDir.lastIndexOf(File.separator) + 1);
        zipFilePath = zipFilePath + zipName;
        Path customZipPath = Paths.get(zipFilePath, new String[0]);
        try (ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(customZipPath, new OpenOption[0]));){
            TplFileUtil.zipFile(files, out, metaDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return zipFilePath;
    }

    private static void zipFile(JSONArray files, ZipOutputStream out, String metaDir) {
        for (int i = 0; i < files.size(); ++i) {
            File file = new File((String)files.get(i));
            if (file.isDirectory()) {
                File[] listFiles;
                JSONArray tempFiles = new JSONArray();
                for (File tempFile : listFiles = file.listFiles()) {
                    try {
                        tempFiles.add((Object)tempFile.getCanonicalPath());
                    }
                    catch (IOException e) {
                        logger.error((Throwable)e);
                    }
                }
                TplFileUtil.zipFile(tempFiles, out, metaDir);
                continue;
            }
            String path = null;
            try {
                path = file.getCanonicalPath();
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
            Path zipPath = Paths.get(path, new String[0]);
            int t = -1;
            if (path != null && path.contains(metaDir)) {
                t = path.indexOf(metaDir);
            }
            if (t == -1 || path == null) continue;
            if ((path = path.substring(t)).contains("\\")) {
                path = path.replace('\\', '/');
            }
            try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(zipPath, new OpenOption[0]));){
                ZipEntry entry = new ZipEntry(path);
                entry.setMethod(8);
                out.putNextEntry(entry);
                int n = 0;
                byte[] buf = new byte[1024];
                while ((n = in.read(buf)) != -1) {
                    out.write(buf, 0, n);
                }
                out.closeEntry();
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

