/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.metedata.service.migrate;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.api.metedata.PrintMetadata;
import kd.bos.print.api.metedata.control.Control;
import kd.bos.print.api.metedata.control.Image;
import kd.bos.print.business.metedata.PrintMetadataUtil;
import kd.bos.print.business.metedata.bean.AbstractDesignMetadata;
import kd.bos.print.business.metedata.bean.AbstractDesignMetadataL;
import kd.bos.print.business.metedata.bean.IPrintBaseXml;
import kd.bos.print.business.metedata.bean.PrintMetaLangXml;
import kd.bos.print.business.metedata.bean.TplResource;
import kd.bos.print.business.metedata.service.AbstractTplService;
import kd.bos.print.business.metedata.service.TplFileUtil;
import kd.bos.print.business.metedata.service.migrate.PrintTplImpExp;
import kd.bos.print.business.service.BosPrintBusinessServiceImpl;
import kd.bos.svc.util.print.PrintFileUtil;
import kd.bos.svc.util.print.UpdateLocalNameUtil;

public abstract class AbstractImpExp<T extends AbstractTplService, C> {
    private static Log log = LogFactory.getLog(AbstractImpExp.class);
    protected static final String PROJECT_NAME = "bos-print-business";
    protected BosPrintBusinessServiceImpl printBusinessService = new BosPrintBusinessServiceImpl();
    protected static String WORK_DIR = System.getProperty("user.home") + File.separator + "KINGDEEDOWNLOAD";

    protected abstract T getTplService();

    protected abstract String getBaseDir();

    protected abstract Class<? extends IPrintBaseXml> getTargetClass();

    protected abstract Class<?> getLangTargetClass();

    protected abstract C createTargetObj(AbstractDesignMetadata var1, List<TplResource> var2);

    protected abstract IPrintBaseXml newInstance();

    protected final Boolean isUpdateTplData(String id, String number, long timestamp) {
        String sql = "select fid,fnumber,fmodify_v from %s where fid = ? or fnumber = ?";
        Object[] params = new Object[]{new SqlParameter("fid", 12, (Object)id), new SqlParameter("fnumber", 12, (Object)number)};
        ArrayList resultList = new ArrayList(2);
        DB.query((DBRoute)DBRoute.basedata, (String)String.format(sql, this.getTableName()), (Object[])params, rs -> {
            while (rs.next()) {
                String[] result = new String[3];
                String fId = rs.getString(1);
                String fNumber = rs.getString(2);
                String fModifyVersion = rs.getString(3);
                result[0] = fId;
                result[1] = fNumber;
                result[2] = fModifyVersion;
                resultList.add(result);
            }
            return true;
        });
        if (resultList.size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"NumberCheckUtils_3", (String)PROJECT_NAME, (Object[])new Object[0]));
        }
        if (resultList.size() == 1) {
            String[] result = (String[])resultList.get(0);
            long modifyVersionFromDB = 0L;
            try {
                modifyVersionFromDB = Long.parseLong(result[2]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (timestamp == modifyVersionFromDB) {
                log.info(String.format(ResManager.loadKDString((String)"\u6a21\u677f\u7248\u672c\u672a\u53d1\u751f\u53d8\u5316\uff0cnumber=%s\u3002", (String)"PrintTplImpExp_9", (String)PROJECT_NAME, (Object[])new Object[0]), number));
                return null;
            }
            if (StringUtils.equals((CharSequence)id, (CharSequence)result[0]) && StringUtils.equals((CharSequence)number, (CharSequence)result[1])) {
                return true;
            }
            if (!StringUtils.equals((CharSequence)id, (CharSequence)result[0])) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"NumberCheckUtils_3", (String)PROJECT_NAME, (Object[])new Object[0]));
            }
            if (!StringUtils.equals((CharSequence)number, (CharSequence)result[1])) {
                return true;
            }
            return false;
        }
        return false;
    }

    public abstract void deployFile(C var1);

    public abstract void saveTpl(C var1);

    protected void saveTpl(Map<String, Object> res, C tplMeta) {
    }

    protected void saveTplMetaL(String tplId, List<PrintMetaLangXml> metaLangList) {
        if (metaLangList == null) {
            return;
        }
        HashMap<String, String> localName = new HashMap<String, String>(8);
        HashMap<String, String> localValue = new HashMap<String, String>(8);
        String id = null;
        for (PrintMetaLangXml langXml : metaLangList) {
            id = langXml.getId();
            localName.put(langXml.getLocalId(), langXml.getName());
            localValue.put(langXml.getLocalId(), langXml.getData());
        }
        String string = id = StringUtils.isNotBlank((CharSequence)tplId) ? tplId : id;
        if (id != null) {
            UpdateLocalNameUtil.updateLocaleData((Object)id, (int)12, localName, localValue, (String)this.getMetaTableName());
        }
    }

    public void saveTplMeteL(PrintMetaLangXml metaLangXml) {
        if (metaLangXml == null) {
            return;
        }
        UpdateLocalNameUtil.updateLocaleData((Object)metaLangXml.getId(), (int)12, Collections.singletonMap(metaLangXml.getLocalId(), metaLangXml.getName()), Collections.singletonMap(metaLangXml.getLocalId(), metaLangXml.getData()), (String)this.getMetaTableName());
    }

    protected abstract String getMetaTableName();

    protected abstract String getTableName();

    protected abstract String getMetadataName();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Object> doImport(InputStream inputStream) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        int count = 0;
        int successCount = 0;
        ArrayList<String> errMsg = new ArrayList<String>();
        HashMap<String, IPrintBaseXml> xmlListMap = new HashMap<String, IPrintBaseXml>(10);
        ZipEntry zipEntry = null;
        try (ZipInputStream zipIn = new ZipInputStream(inputStream);){
            while ((zipEntry = zipIn.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) continue;
                String fileName = zipEntry.getName();
                if (fileName.endsWith("xml") || fileName.endsWith("dym") || fileName.endsWith("dymx") || fileName.endsWith("prt")) {
                    ++count;
                }
                if (fileName.endsWith("xml")) {
                    try {
                        JAXBContext cont = JAXBContext.newInstance((Class[])new Class[]{this.getTargetClass()});
                        XMLInputFactory xif = XMLInputFactory.newInstance();
                        xif.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
                        xif.setProperty("javax.xml.stream.supportDTD", Boolean.TRUE);
                        Unmarshaller unmarshaller = cont.createUnmarshaller();
                        ByteArrayOutputStream output = new ByteArrayOutputStream(32);
                        Throwable throwable = null;
                        try {
                            int n;
                            byte[] buffer = new byte[4096];
                            while ((n = zipIn.read(buffer)) != -1) {
                                output.write(buffer, 0, n);
                            }
                            Object metaXml = unmarshaller.unmarshal(xif.createXMLStreamReader(new ByteArrayInputStream(output.toByteArray())));
                            if (this instanceof PrintTplImpExp) {
                                this.saveTpl(result, metaXml);
                            } else {
                                this.saveTpl(metaXml);
                            }
                            ++successCount;
                            continue;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (output == null) continue;
                            if (throwable != null) {
                                try {
                                    output.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            output.close();
                            continue;
                        }
                    }
                    catch (Exception e) {
                        log.error((Throwable)e);
                        errMsg.add(e.getMessage());
                        continue;
                    }
                }
                if (fileName.endsWith("dym") || fileName.endsWith("dymx")) {
                    if (fileName.endsWith("dymx")) {
                        --count;
                    }
                    if (errMsg.contains(ResManager.loadKDString((String)"\u65e7\u6a21\u7248\u4e0d\u652f\u6301\u5bfc\u5165\u3002", (String)"PrintTplImpExp_5", (String)PROJECT_NAME, (Object[])new Object[0]))) continue;
                    errMsg.add(ResManager.loadKDString((String)"\u65e7\u6a21\u7248\u4e0d\u652f\u6301\u5bfc\u5165\u3002", (String)"PrintTplImpExp_5", (String)PROJECT_NAME, (Object[])new Object[0]));
                    continue;
                }
                if (fileName.endsWith("prt")) {
                    this.collectXmlObj(zipIn, this.getTargetClass(), xmlListMap, errMsg);
                    continue;
                }
                if (!fileName.endsWith("prtx")) continue;
                this.collectXmlObj(zipIn, this.getLangTargetClass(), xmlListMap, errMsg);
            }
            if (xmlListMap.size() > 0) {
                successCount = this.saveTplWithLang(xmlListMap, result, errMsg);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            String msg = ResManager.loadKDString((String)"\u5177\u4f53\u539f\u56e0\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"PrintTplImpExp_3", (String)PROJECT_NAME, (Object[])new Object[0]);
            errMsg.add(msg);
        }
        result.put("count", count);
        result.put("success", successCount);
        result.put("message", errMsg);
        return result;
    }

    private int saveTplWithLang(Map<String, IPrintBaseXml> xmlListMap, Map<String, Object> result, List errMsg) {
        if (CollectionUtils.isEmpty(xmlListMap)) {
            return 0;
        }
        int successCount = 0;
        for (Map.Entry<String, IPrintBaseXml> entry : xmlListMap.entrySet()) {
            try {
                IPrintBaseXml value = entry.getValue();
                this.saveTpl(result, value);
                if (value.getNumber() == null) continue;
                ++successCount;
            }
            catch (Exception e) {
                errMsg.add(e.getMessage());
            }
        }
        return successCount;
    }

    private void collectXmlObj(ZipInputStream zipIn, Class<?> targetClass, Map<String, IPrintBaseXml> xmlListMap, List errMsg) {
        Object xml = null;
        try {
            JAXBContext cont = JAXBContext.newInstance((Class[])new Class[]{targetClass});
            XMLInputFactory xif = XMLInputFactory.newInstance();
            xif.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            xif.setProperty("javax.xml.stream.supportDTD", Boolean.TRUE);
            Unmarshaller unmarshaller = cont.createUnmarshaller();
            try (ByteArrayOutputStream output = new ByteArrayOutputStream(32);){
                int n;
                byte[] buffer = new byte[4096];
                while ((n = zipIn.read(buffer)) != -1) {
                    output.write(buffer, 0, n);
                }
                xml = unmarshaller.unmarshal(xif.createXMLStreamReader(new ByteArrayInputStream(output.toByteArray())));
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            errMsg.add(e.getMessage());
        }
        if (xml != null) {
            if (xml instanceof PrintMetaLangXml) {
                PrintMetaLangXml langXml = (PrintMetaLangXml)xml;
                IPrintBaseXml baseXml = xmlListMap.get(langXml.getNumber());
                if (baseXml == null) {
                    baseXml = this.newInstance();
                    xmlListMap.put(langXml.getNumber(), baseXml);
                }
                baseXml.getMetaLangList().add(langXml);
            } else {
                IPrintBaseXml baseXml;
                IPrintBaseXml curXml = (IPrintBaseXml)xml;
                String number = curXml.getNumber();
                if (StringUtils.isNotBlank((CharSequence)number) && (baseXml = xmlListMap.get(number)) != null) {
                    curXml.setMetaLangList(baseXml.getMetaLangList());
                }
                xmlListMap.put(number, curXml);
            }
        }
    }

    public String doExport(List<String> tplIdList, int millis) throws Exception {
        InputStream in = null;
        String curDir = System.currentTimeMillis() + "";
        String curWorkPath = WORK_DIR + File.separator + curDir;
        String localPath = curWorkPath + File.separator + this.getBaseDir();
        File file = new File(localPath);
        if (!file.exists()) {
            file.mkdirs();
        }
        try {
            for (String tplId : tplIdList) {
                try {
                    Object tplObj = ((AbstractTplService)this.getTplService()).getDesignMeta(tplId);
                    String metaData = tplObj.getData();
                    PrintMetadata metadata = PrintMetadataUtil.parseMetadata(metaData);
                    ArrayList<TplResource> resources = new ArrayList(10);
                    List<Long> sourceIds = this.scanResourceIds((AbstractDesignMetadata)tplObj, metadata);
                    if (!sourceIds.isEmpty()) {
                        resources = BosPrintBusinessServiceImpl.getFileListInfo(sourceIds);
                    }
                    Object[] objectArray = null;
                    try (FileOutputStream fileOutputStream = new FileOutputStream(localPath + File.separator + metadata.getKey() + ".prt");
                         OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8);){
                        C metaXml = this.createTargetObj((AbstractDesignMetadata)tplObj, (List<TplResource>)resources);
                        JAXBContext cont = JAXBContext.newInstance((Class[])new Class[]{metaXml.getClass()});
                        Marshaller marshaller = cont.createMarshaller();
                        marshaller.marshal(metaXml, (Writer)outputStreamWriter);
                        outputStreamWriter.flush();
                    }
                    catch (Throwable object) {
                        objectArray = object;
                        throw object;
                    }
                    Object[] designMetaL = ((AbstractTplService)this.getTplService()).getDesignMetaL(tplId);
                    if (designMetaL == null || designMetaL.length <= 0) continue;
                    for (Object metaL : designMetaL) {
                        AbstractDesignMetadataL metadataL = (AbstractDesignMetadataL)metaL;
                        this.writeMetadataL(localPath, metadata, metadataL);
                    }
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
            }
            String zipName = this.getBaseDir() + ".zip";
            String zipPath = TplFileUtil.zipFiles(zipName, localPath);
            Path downloadPath = Paths.get(zipPath, new String[0]);
            in = Files.newInputStream(downloadPath, new OpenOption[0]);
            String string = PrintFileUtil.saveAsPrintTempUrl((InputStream)in, (String)zipName, (boolean)false);
            return string;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\u5bfc\u51fa\u5931\u8d25\u3002", (String)"AbstractImpExp_0", (String)PROJECT_NAME, (Object[])new Object[0]));
        }
        finally {
            if (in != null) {
                in.close();
            }
            TplFileUtil.deleteFiles(new File(curWorkPath));
        }
    }

    protected abstract void writeMetadataL(String var1, PrintMetadata var2, AbstractDesignMetadataL var3) throws IOException, JAXBException;

    protected List<Long> scanResourceIds(AbstractDesignMetadata tplObj, PrintMetadata metadata) {
        ArrayList<Long> sourceIds = new ArrayList<Long>();
        List pages = metadata.getPages();
        for (List page : pages) {
            for (Control control : page) {
                if (!(control instanceof Image)) continue;
                Image image = (Image)control;
                String datasource = image.getDataSource();
                String bindField = image.getBindField();
                if (!StringUtils.isBlank((CharSequence)datasource) || !StringUtils.isNotBlank((CharSequence)bindField)) continue;
                sourceIds.add(Long.parseLong(bindField));
            }
        }
        return sourceIds;
    }

    static {
        WORK_DIR = PrintFileUtil.normalize((String)WORK_DIR);
    }
}

