/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.metedata.service.migrate;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.api.metedata.PrintMetadata;
import kd.bos.print.business.metedata.PrintMetadataUtil;
import kd.bos.print.business.metedata.bean.AbstractDesignMetadata;
import kd.bos.print.business.metedata.bean.AbstractDesignMetadataL;
import kd.bos.print.business.metedata.bean.IPrintBaseXml;
import kd.bos.print.business.metedata.bean.LibraryDesignMetadata;
import kd.bos.print.business.metedata.bean.LibraryDesignMetadataL;
import kd.bos.print.business.metedata.bean.LibraryMetaLangXml;
import kd.bos.print.business.metedata.bean.LibraryMetaXml;
import kd.bos.print.business.metedata.bean.PrintMetaLangXml;
import kd.bos.print.business.metedata.bean.ResPowerScope;
import kd.bos.print.business.metedata.bean.TplResource;
import kd.bos.print.business.metedata.service.LibraryTplService;
import kd.bos.print.business.metedata.service.migrate.AbstractImpExp;
import kd.bos.print.business.metedata.service.migrate.PrintTplImpExp;

public class LibraryTplImpExp
extends AbstractImpExp<LibraryTplService, LibraryMetaXml> {
    private LibraryTplService tplService;
    private Log log = LogFactory.getLog(PrintTplImpExp.class);
    private static final String TABLE_META_L = "t_svc_printtpl_l";
    private static final String TABLE_META = "t_svc_printtpl";
    private static final String METADATA_NAME = "bos_printtpl_lbr";

    @Override
    protected LibraryTplService getTplService() {
        if (this.tplService == null) {
            this.tplService = new LibraryTplService();
        }
        return this.tplService;
    }

    @Override
    protected String getBaseDir() {
        return "sprt_metedata";
    }

    @Override
    protected Class<? extends IPrintBaseXml> getTargetClass() {
        return LibraryMetaXml.class;
    }

    @Override
    protected Class<?> getLangTargetClass() {
        return LibraryMetaLangXml.class;
    }

    protected LibraryMetaXml newInstance() {
        return new LibraryMetaXml();
    }

    @Override
    protected LibraryMetaXml createTargetObj(AbstractDesignMetadata metadata, List<TplResource> resources) {
        LibraryDesignMetadata libMeta = (LibraryDesignMetadata)metadata;
        LibraryMetaXml metaXml = new LibraryMetaXml();
        metaXml.setId(metadata.getId());
        metaXml.setNumber(metadata.getNumber());
        metaXml.setModifyVersion(System.currentTimeMillis());
        metaXml.setGroupId(libMeta.getGroupId());
        metaXml.setPaperdirection(libMeta.getPaperdirection());
        metaXml.setPicwidth(libMeta.getPicwidth());
        metaXml.setPicHeight(libMeta.getPicHeight());
        metaXml.setPicture(libMeta.getPicture());
        metaXml.setData(libMeta.getData());
        metaXml.setIsv(metadata.getIsv());
        metaXml.setBizType(metadata.getBizType());
        if (resources != null && resources.size() > 0) {
            metaXml.setResources(resources);
        }
        return metaXml;
    }

    @Override
    protected String getMetaTableName() {
        return TABLE_META_L;
    }

    @Override
    protected String getTableName() {
        return TABLE_META;
    }

    @Override
    protected String getMetadataName() {
        return METADATA_NAME;
    }

    @Override
    public void deployFile(LibraryMetaXml tplMeta) {
        String tplContent = tplMeta.getData();
        PrintMetadata metadata = PrintMetadataUtil.parseMetadata(tplContent);
        Boolean updateTplData = this.isUpdateTplData(metadata.getId(), tplMeta.getNumber(), tplMeta.getModifyVersion());
        if (updateTplData == null) {
            return;
        }
        try {
            List resources = tplMeta.getResources();
            this.handleResources(metadata, resources);
            long creator = RequestContext.get().getCurrUserId();
            LibraryDesignMetadata dMetadata = this.createDesignMetadata(tplMeta, metadata, creator);
            dMetadata.setStatus("C");
            try (TXHandle tx = TX.required();){
                if (updateTplData.booleanValue()) {
                    this.getTplService().update(dMetadata);
                } else {
                    this.getTplService().save(dMetadata);
                }
                if (resources != null && resources.size() > 0) {
                    this.printBusinessService.saveTplResources(metadata.getId(), resources);
                }
            }
        }
        catch (Exception e) {
            this.log.error("\u6a21\u7248\uff1a" + metadata.getKey() + "\u90e8\u7f72\u5931\u8d25", (Throwable)e);
            String msg = ResManager.loadKDString((String)"\u201c%1$s\u201d\u90e8\u7f72\u5931\u8d25:%2$s", (String)"LibraryTplImpExp_2", (String)"bos-print-business", (Object[])new Object[0]);
            msg = e instanceof KDBizException ? String.format(msg, metadata.getKey(), e.getMessage()) : String.format(msg, metadata.getKey(), ResManager.loadKDString((String)"\u5177\u4f53\u539f\u56e0\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"PrintTplImpExp_3", (String)"bos-print-business", (Object[])new Object[0]));
            throw new KDBizException(new ErrorCode("4", msg), new Object[0]);
        }
    }

    @Override
    protected void saveTpl(Map<String, Object> res, LibraryMetaXml tplMeta) {
        this.saveTpl(tplMeta);
    }

    @Override
    protected void saveTplMetaL(String tplId, List<PrintMetaLangXml> metaLangList) {
        if (metaLangList == null) {
            return;
        }
        this.insertOrUpdateTableMetaL(tplId, metaLangList);
    }

    private void insertOrUpdateTableMetaL(String tplId, List<PrintMetaLangXml> metaLangList) {
        Set localIds = (Set)DB.query((DBRoute)DBRoute.basedata, (String)String.format("select fid,flocaleid from %s where fid = ?", TABLE_META_L), (Object[])new SqlParameter[]{new SqlParameter("fid", 12, (Object)tplId)}, res -> {
            HashSet<String> localSet = new HashSet<String>(8);
            while (res.next()) {
                localSet.add(res.getString(2));
            }
            return localSet;
        });
        ArrayList<SqlParameter[]> insertParams = new ArrayList<SqlParameter[]>(metaLangList.size());
        ArrayList<SqlParameter[]> updateParams = new ArrayList<SqlParameter[]>(metaLangList.size());
        String insertSql = String.format("insert into %s (fpkid,fid,flocaleid,fname,fdata,fpicture,fpic_width,fpic_height) values (?,?,?,?,?,?,?,?)", TABLE_META_L);
        String updateSql = String.format("update %s set fname = ?, fdata = ?, fpicture = ?, fpic_width = ?,fpic_height = ? where fid = ? and flocaleid = ?", TABLE_META_L);
        for (PrintMetaLangXml langXml : metaLangList) {
            String picture;
            if (!(langXml instanceof LibraryMetaLangXml)) {
                return;
            }
            LibraryMetaLangXml lbrLangXml = (LibraryMetaLangXml)langXml;
            String lang = lbrLangXml.getLocalId();
            String name = lbrLangXml.getName() == null ? "" : lbrLangXml.getName();
            String data = lbrLangXml.getData() == null ? "" : lbrLangXml.getData();
            String string = picture = lbrLangXml.getPicture() == null ? "" : lbrLangXml.getPicture();
            if (localIds.contains(lang)) {
                SqlParameter[] sqlParameters = new SqlParameter[]{new SqlParameter("fname", 12, (Object)name), new SqlParameter("fdata", -16, (Object)data), new SqlParameter("fpicture", 12, (Object)picture), new SqlParameter("fpic_width", -5, (Object)lbrLangXml.getPicWidth()), new SqlParameter("fpic_height", -5, (Object)lbrLangXml.getPicHeight()), new SqlParameter("fid", 12, (Object)lbrLangXml.getId()), new SqlParameter("flocaleid", 12, (Object)lang)};
                updateParams.add(sqlParameters);
                continue;
            }
            String pkId = DB.genStringId((String)TABLE_META_L);
            SqlParameter[] sqlParameters = new SqlParameter[]{new SqlParameter("fpkid", 12, (Object)pkId), new SqlParameter("fid", 12, (Object)lbrLangXml.getId()), new SqlParameter("flocaleid", 12, (Object)lang), new SqlParameter("fname", 12, (Object)name), new SqlParameter("fdata", -16, (Object)data), new SqlParameter("fpicture", 12, (Object)picture), new SqlParameter("fpic_width", -5, (Object)lbrLangXml.getPicWidth()), new SqlParameter("fpic_height", -5, (Object)lbrLangXml.getPicHeight())};
            insertParams.add(sqlParameters);
        }
        try (TXHandle tx = TX.required();){
            if (!CollectionUtils.isEmpty(insertParams)) {
                DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql, insertParams);
            }
            if (!CollectionUtils.isEmpty(updateParams)) {
                DB.executeBatch((DBRoute)DBRoute.basedata, (String)updateSql, updateParams);
            }
        }
    }

    @Override
    public void saveTplMeteL(PrintMetaLangXml metaLangXml) {
        if (metaLangXml == null) {
            return;
        }
        this.insertOrUpdateTableMetaL(metaLangXml.getId(), Collections.singletonList(metaLangXml));
    }

    @Override
    public void saveTpl(LibraryMetaXml tplMeta) {
        String tplContent = tplMeta.getData();
        if (StringUtils.isBlank((CharSequence)tplContent)) {
            this.saveTplMetaL(null, tplMeta.getMetaLangList());
            return;
        }
        PrintMetadata metadata = PrintMetadataUtil.parseMetadata(tplContent);
        try {
            List resources = tplMeta.getResources();
            this.handleResources(metadata, resources);
            long creator = RequestContext.get().getCurrUserId();
            LibraryDesignMetadata dMetadata = this.createDesignMetadata(tplMeta, metadata, creator);
            try (TXHandle tx = TX.required();){
                this.getTplService().beforeImport(dMetadata);
                this.getTplService().saveOrUpdate(dMetadata);
                if (resources != null && resources.size() > 0) {
                    this.printBusinessService.saveTplResources(metadata.getId(), resources);
                }
                this.saveTplMetaL(dMetadata.getId(), tplMeta.getMetaLangList());
            }
        }
        catch (Exception e) {
            this.log.error("\u6a21\u7248\uff1a" + metadata.getKey() + "\u5bfc\u5165\u5931\u8d25", (Throwable)e);
            String msg = ResManager.loadKDString((String)"\u201c%1$s\u201d\u5bfc\u5165\u5931\u8d25:%2$s", (String)"LibraryTplImpExp_1", (String)"bos-print-business", (Object[])new Object[0]);
            msg = e instanceof KDBizException ? String.format(msg, metadata.getKey(), e.getMessage()) : String.format(msg, metadata.getKey(), ResManager.loadKDString((String)"\u5177\u4f53\u539f\u56e0\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"PrintTplImpExp_3", (String)"bos-print-business", (Object[])new Object[0]));
            throw new KDBizException(new ErrorCode("4", msg), new Object[0]);
        }
    }

    private LibraryDesignMetadata createDesignMetadata(LibraryMetaXml tplMeta, PrintMetadata metadata, long creator) {
        LibraryDesignMetadata dMetadata = new LibraryDesignMetadata();
        dMetadata.setGroupId(tplMeta.getGroupId());
        String paperDirection = metadata.getPaper().getPaperDirection();
        if ("horizontal".endsWith(paperDirection)) {
            dMetadata.setPaperdirection("A");
        } else {
            dMetadata.setPaperdirection("B");
        }
        dMetadata.setId(metadata.getId());
        dMetadata.setMasterid(metadata.getId());
        dMetadata.setNumber(metadata.getKey());
        dMetadata.setName((String)metadata.getName().getLocaleValue());
        dMetadata.setlName((ILocaleString)LocaleString.fromMap((Map)metadata.getName()));
        dMetadata.setCreator(creator);
        dMetadata.setModifier(creator);
        dMetadata.setCreatetime(new Date());
        dMetadata.setModifytime(new Date());
        dMetadata.setData(SerializationUtils.toJsonString((Object)metadata));
        dMetadata.setPicture(tplMeta.getPicture());
        dMetadata.setPicwidth(tplMeta.getPicwidth());
        dMetadata.setPicHeight(tplMeta.getPicHeight());
        dMetadata.setPaperdirection(tplMeta.getPaperdirection());
        dMetadata.setStatus("A");
        dMetadata.setEnable("1");
        dMetadata.setVersion(metadata.getVersion());
        dMetadata.setModifyVersion(tplMeta.getModifyVersion());
        dMetadata.setIsv(tplMeta.getIsv());
        dMetadata.setBizType(StringUtils.isBlank((CharSequence)tplMeta.getBizType()) ? "0" : tplMeta.getBizType());
        return dMetadata;
    }

    private void handleResources(PrintMetadata metadata, List<TplResource> resources) {
        if (resources != null && resources.size() > 0) {
            for (TplResource resource : resources) {
                resource.setPrinttplid(metadata.getId());
                resource.setPowerscope(ResPowerScope.POWER_PUBLIC.getCode());
                resource.setType("0");
                if (StringUtils.isBlank((CharSequence)resource.getUrl())) {
                    resource.setUrl(" ");
                }
                if (resource.getData() != null) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\u8d44\u6e90\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"LibraryTplImpExp_0", (String)"bos-print-business", (Object[])new Object[0]));
            }
        }
    }

    @Override
    protected List<Long> scanResourceIds(AbstractDesignMetadata tplObj, PrintMetadata metadata) {
        List<Long> souceIds = super.scanResourceIds(tplObj, metadata);
        LibraryDesignMetadata libMeta = (LibraryDesignMetadata)tplObj;
        String picture = libMeta.getPicture();
        if (StringUtils.isNotBlank((CharSequence)picture)) {
            souceIds.add(Long.parseLong(picture));
        }
        return souceIds;
    }

    @Override
    protected void writeMetadataL(String localPath, PrintMetadata metadata, AbstractDesignMetadataL metadataL) throws IOException, JAXBException {
        LibraryDesignMetadataL lbrMetadataL = (LibraryDesignMetadataL)metadataL;
        String lang = metadataL.getLocaleId();
        if (StringUtils.isNotBlank((CharSequence)lang)) {
            String filePath = localPath + File.separator + metadata.getKey() + "." + lang + ".prtx";
            try (FileOutputStream fos = new FileOutputStream(filePath);
                 OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);){
                LibraryMetaLangXml metaLangXml = new LibraryMetaLangXml();
                metaLangXml.setId(metadata.getId());
                metaLangXml.setNumber(metadata.getKey());
                metaLangXml.setName(lbrMetadataL.getName());
                metaLangXml.setLocalId(lang);
                metaLangXml.setData(lbrMetadataL.getData());
                metaLangXml.setPicture(lbrMetadataL.getPicture());
                metaLangXml.setPicWidth(lbrMetadataL.getPicWidth());
                metaLangXml.setPicHeight(lbrMetadataL.getPicHeight());
                JAXBContext cont = JAXBContext.newInstance((Class[])new Class[]{LibraryMetaLangXml.class});
                Marshaller marshaller = cont.createMarshaller();
                marshaller.marshal((Object)metaLangXml, (Writer)osw);
                osw.flush();
            }
        }
    }
}

