/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.metedata.service.migrate;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.print.api.metedata.PrintMetadata;
import kd.bos.print.business.metedata.PrintMetadataUtil;
import kd.bos.print.business.metedata.bean.AbstractDesignMetadata;
import kd.bos.print.business.metedata.bean.AbstractDesignMetadataL;
import kd.bos.print.business.metedata.bean.DesignMetadata;
import kd.bos.print.business.metedata.bean.IPrintBaseXml;
import kd.bos.print.business.metedata.bean.PrintMetaLangXml;
import kd.bos.print.business.metedata.bean.PrintTplMetaXml;
import kd.bos.print.business.metedata.bean.ResPowerScope;
import kd.bos.print.business.metedata.bean.TplResource;
import kd.bos.print.business.metedata.service.PrintTplService;
import kd.bos.print.business.metedata.service.migrate.AbstractImpExp;
import kd.bos.print.business.utils.PrintOpLogMsgEnum;
import kd.bos.print.business.utils.PrintOpLogUtils;
import kd.bos.service.attachment.FileItemExt;
import kd.bos.service.attachment.FileSource;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class PrintTplImpExp
extends AbstractImpExp<PrintTplService, PrintTplMetaXml> {
    private Log log = LogFactory.getLog(PrintTplImpExp.class);
    private PrintTplService tplService;
    private static final String TABLE_META_L = "t_svc_printmeta_l";
    private static final String TABLE_META = "t_svc_printmeta";
    private static final String METADATA_NAME = "bos_print_meta";

    @Override
    protected PrintTplService getTplService() {
        if (this.tplService == null) {
            this.tplService = new PrintTplService();
        }
        return this.tplService;
    }

    @Override
    protected String getBaseDir() {
        return "prt_metedata";
    }

    @Override
    protected Class<? extends IPrintBaseXml> getTargetClass() {
        return PrintTplMetaXml.class;
    }

    @Override
    protected Class<?> getLangTargetClass() {
        return PrintMetaLangXml.class;
    }

    protected PrintTplMetaXml newInstance() {
        return new PrintTplMetaXml();
    }

    @Override
    protected PrintTplMetaXml createTargetObj(AbstractDesignMetadata metadata, List<TplResource> resources) {
        PrintTplMetaXml metaXml = new PrintTplMetaXml();
        metaXml.setId(metadata.getId());
        metaXml.setNumber(metadata.getNumber());
        metaXml.setModifyVersion(System.currentTimeMillis());
        metaXml.setData(metadata.getData());
        metaXml.setIsv(metadata.getIsv());
        metaXml.setBizType(metadata.getBizType());
        if (resources != null && resources.size() > 0) {
            for (TplResource resource : resources) {
                String url = resource.getUrl();
                if (!StringUtils.isNotBlank((CharSequence)url)) continue;
                try {
                    byte[] bytes = this.readFile(url);
                    resource.setData(bytes);
                }
                catch (Exception e) {
                    this.log.error((Throwable)e);
                    throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\u5bfc\u51fa\u5931\u8d25\uff0c\u56fe\u7247\u8d44\u6e90\u83b7\u53d6\u5931\u8d25\u3002", (String)"PrintTplImpExp_0", (String)"bos-print-business", (Object[])new Object[0]));
                }
            }
            metaXml.setResources(resources);
        }
        return metaXml;
    }

    @Override
    protected String getMetaTableName() {
        return TABLE_META_L;
    }

    @Override
    protected String getTableName() {
        return TABLE_META;
    }

    @Override
    protected String getMetadataName() {
        return METADATA_NAME;
    }

    @Override
    public void deployFile(PrintTplMetaXml tplMeta) {
        String tplContent = tplMeta.getData();
        PrintMetadata metadata = PrintMetadataUtil.parseMetadata(tplContent);
        Boolean updateTplData = this.isUpdateTplData(metadata.getId(), tplMeta.getNumber(), tplMeta.getModifyVersion());
        if (updateTplData == null) {
            return;
        }
        try {
            List resources = tplMeta.getResources();
            this.handleResources(metadata, resources);
            long creator = RequestContext.get().getCurrUserId();
            long orgId = RequestContext.get().getOrgId();
            if (StringUtils.isBlank((CharSequence)tplMeta.getIsv())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f00\u53d1\u5546\u6807\u8bc6\u4e0d\u5b58\u5728\u3002", (String)"NumberCheckUtils_4", (String)"bos-print-business", (Object[])new Object[0]));
            }
            DesignMetadata dMetadata = this.createDesignMetadata(tplMeta, metadata, creator, orgId);
            dMetadata.setTplType("0");
            try (TXHandle tx = TX.required();){
                if (updateTplData.booleanValue()) {
                    this.getTplService().update(dMetadata);
                } else {
                    this.getTplService().save(dMetadata);
                }
                if (resources != null && resources.size() > 0) {
                    resources.forEach(resource -> resource.setPrinttplid(dMetadata.getId()));
                    this.printBusinessService.saveTplResources(dMetadata.getId(), resources);
                }
            }
        }
        catch (Exception e) {
            this.log.error("\u6a21\u7248\uff1a" + metadata.getKey() + "\u90e8\u7f72\u5931\u8d25", (Throwable)e);
            String msg = ResManager.loadKDString((String)"\u201c%1$s\u201d\u90e8\u7f72\u5931\u8d25:%2$s", (String)"PrintTplImpExp_10", (String)"bos-print-business", (Object[])new Object[0]);
            msg = e instanceof KDBizException ? String.format(msg, metadata.getKey(), e.getMessage()) : String.format(msg, metadata.getKey(), ResManager.loadKDString((String)"\u5177\u4f53\u539f\u56e0\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"PrintTplImpExp_3", (String)"bos-print-business", (Object[])new Object[0]));
            throw new KDBizException(new ErrorCode("4", msg), new Object[0]);
        }
    }

    @Override
    protected void saveTpl(Map<String, Object> res, PrintTplMetaXml tplMeta) {
        String tplContent = tplMeta.getData();
        if (StringUtils.isBlank((CharSequence)tplContent)) {
            this.saveTplMetaL(null, tplMeta.getMetaLangList());
            return;
        }
        PrintMetadata metadata = PrintMetadataUtil.parseMetadata(tplContent);
        boolean isExist = QueryServiceHelper.exists((String)"bos_entityobject", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)metadata.getFormId())});
        if (!isExist) {
            String msg = ResManager.loadKDString((String)"\u201c%s\u201d\u5bfc\u5165\u5931\u8d25:\u6253\u5370\u6a21\u677f\u7ed1\u5b9a\u7684\u4e3b\u5b9e\u4f53\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PrintTplImpExp_1", (String)"bos-print-business", (Object[])new Object[0]);
            msg = String.format(msg, metadata.getKey());
            throw new KDBizException(new ErrorCode("4", msg), new Object[0]);
        }
        QFilter qFilter = new QFilter("id", "=", (Object)metadata.getId());
        qFilter.and("tpltype", "=", (Object)"1");
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)METADATA_NAME, (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (dynamicObject != null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u9884\u7f6e\u6a21\u677f\u4e0d\u652f\u6301\u5bfc\u5165\u3002", (String)"AbstractTplService_0", (String)"bos-print-business", (Object[])new Object[0]));
        }
        try {
            List resources = tplMeta.getResources();
            this.handleResources(metadata, resources);
            long creator = RequestContext.get().getCurrUserId();
            long orgId = RequestContext.get().getOrgId();
            DesignMetadata dMetadata = this.createDesignMetadata(tplMeta, metadata, creator, orgId);
            try (TXHandle tx = TX.required();){
                this.getTplService().beforeImport(dMetadata);
                this.getTplService().saveOrUpdate(dMetadata);
                this.checkDuplicateNumber(res, metadata, dMetadata);
                if (resources != null && resources.size() > 0) {
                    resources.forEach(resource -> resource.setPrinttplid(dMetadata.getId()));
                    this.printBusinessService.saveTplResources(dMetadata.getId(), resources);
                }
                this.saveTplMetaL(dMetadata.getId(), tplMeta.getMetaLangList());
            }
            PrintOpLogUtils.addLog((String)"cts", (String)"bos_manageprinttpl", (String)dMetadata.getNumber(), (PrintOpLogMsgEnum)PrintOpLogMsgEnum.TPL_IMPORT);
        }
        catch (Exception e) {
            this.log.warn("\u6a21\u7248\uff1a" + metadata.getKey() + "\u5bfc\u5165\u5931\u8d25", (Throwable)e);
            String msg = ResManager.loadKDString((String)"\u201c%1$s\u201d\u5bfc\u5165\u5931\u8d25:%2$s", (String)"PrintTplImpExp_7", (String)"bos-print-business", (Object[])new Object[0]);
            msg = e instanceof KDBizException ? String.format(msg, metadata.getKey(), e.getMessage()) : String.format(msg, metadata.getKey(), ResManager.loadKDString((String)"\u5177\u4f53\u539f\u56e0\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"PrintTplImpExp_3", (String)"bos-print-business", (Object[])new Object[0]));
            throw new KDBizException(new ErrorCode("4", msg), new Object[0]);
        }
    }

    private DesignMetadata createDesignMetadata(PrintTplMetaXml tplMeta, PrintMetadata metadata, long creator, long orgId) {
        DesignMetadata dMetadata = new DesignMetadata();
        dMetadata.setFormId(metadata.getFormId());
        dMetadata.setType("B");
        dMetadata.setBizappid(metadata.getBizappId());
        dMetadata.setOrg(orgId);
        dMetadata.setlName((ILocaleString)LocaleString.fromMap((Map)metadata.getName()));
        dMetadata.setId(metadata.getId());
        dMetadata.setMasterid(metadata.getId());
        dMetadata.setNumber(metadata.getKey());
        dMetadata.setName((String)metadata.getName().getLocaleValue());
        dMetadata.setlName((ILocaleString)LocaleString.fromMap((Map)metadata.getName()));
        dMetadata.setCreator(creator);
        dMetadata.setModifier(creator);
        dMetadata.setCreatetime(new Date());
        dMetadata.setModifytime(new Date());
        dMetadata.setData(SerializationUtils.toJsonString((Object)metadata));
        dMetadata.setStatus("C");
        dMetadata.setEnable("1");
        dMetadata.setVersion(metadata.getVersion());
        dMetadata.setModifyVersion(tplMeta.getModifyVersion());
        dMetadata.setIsv(tplMeta.getIsv());
        dMetadata.setBizType(StringUtils.isBlank((CharSequence)tplMeta.getBizType()) ? "0" : tplMeta.getBizType());
        return dMetadata;
    }

    private void checkDuplicateNumber(Map<String, Object> res, PrintMetadata metadata, DesignMetadata dMetadata) {
        if (!StringUtils.equals((CharSequence)metadata.getKey(), (CharSequence)dMetadata.getNumber())) {
            res.put("isDuplicateNumber", "true");
        }
    }

    @Override
    public void saveTpl(PrintTplMetaXml tplMeta) {
        HashMap<String, Object> res = new HashMap<String, Object>(1);
        this.saveTpl((Map<String, Object>)res, tplMeta);
    }

    private void handleResources(PrintMetadata metadata, List<TplResource> resources) {
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        String userId = RequestContext.get().getUserOpenId();
        if (resources != null && resources.size() > 0) {
            for (TplResource resource : resources) {
                resource.setPrinttplid(metadata.getId());
                resource.setPowerscope(ResPowerScope.POWER_INNER.getCode());
                resource.setType("0");
                if (resource.getData() != null) {
                    String fileName = resource.getFilename();
                    int lastIndexOf = fileName.lastIndexOf(46);
                    String fileNameSuffix = fileName.substring(lastIndexOf + 1);
                    String format = "/%s/%s/%s/%s/%s/%s";
                    String imgPath = String.format(format, tenantId, accountId, "printtpl", this.getDateStr(), userId, UUID.randomUUID() + "." + fileNameSuffix);
                    try {
                        ByteArrayInputStream srcPicStream = new ByteArrayInputStream(resource.getData());
                        Throwable throwable = null;
                        try {
                            FileItemExt newItem = new FileItemExt(fileName, imgPath, (InputStream)srcPicStream);
                            newItem.setSource(FileSource.PRINT_TPL_RESOURCE);
                            String uploadUrl = FileServiceFactory.getImageFileService().upload((FileItem)newItem);
                            resource.setUrl(uploadUrl);
                            continue;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (srcPicStream == null) continue;
                            if (throwable != null) {
                                try {
                                    srcPicStream.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            srcPicStream.close();
                            continue;
                        }
                    }
                    catch (Exception e) {
                        this.log.error((Throwable)e);
                        return;
                    }
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\u8d44\u6e90\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PrintTplImpExp_2", (String)"bos-print-business", (Object[])new Object[0]));
            }
        }
    }

    private String getDateStr() {
        Calendar cale = Calendar.getInstance();
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMM");
        return sf.format(cale.getTime());
    }

    /*
     * Exception decompiling
     */
    private byte[] readFile(String url) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected void writeMetadataL(String localPath, PrintMetadata metadata, AbstractDesignMetadataL metadataL) throws IOException, JAXBException {
        String lang = metadataL.getLocaleId();
        if (StringUtils.isNotBlank((CharSequence)lang)) {
            String filePath = localPath + File.separator + metadata.getKey() + "." + lang + ".prtx";
            try (FileOutputStream fos = new FileOutputStream(filePath);
                 OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);){
                PrintMetaLangXml metaLangXml = new PrintMetaLangXml();
                metaLangXml.setId(metadata.getId());
                metaLangXml.setNumber(metadata.getKey());
                metaLangXml.setName(metadataL.getName());
                metaLangXml.setLocalId(lang);
                metaLangXml.setData(metadataL.getData());
                JAXBContext cont = JAXBContext.newInstance((Class[])new Class[]{PrintMetaLangXml.class});
                Marshaller marshaller = cont.createMarshaller();
                marshaller.marshal((Object)metaLangXml, (Writer)osw);
                osw.flush();
            }
        }
    }
}

