/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.metedata.transformer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.support.util.ReflectionUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.PrintMetadata;
import kd.bos.metadata.print.control.Amount;
import kd.bos.metadata.print.control.Barcode;
import kd.bos.metadata.print.control.BaseContainer;
import kd.bos.metadata.print.control.BaseControl;
import kd.bos.metadata.print.control.BaseGrid;
import kd.bos.metadata.print.control.DataCell;
import kd.bos.metadata.print.control.DataGrid;
import kd.bos.metadata.print.control.DataRow;
import kd.bos.metadata.print.control.Image;
import kd.bos.metadata.print.control.Label;
import kd.bos.metadata.print.control.LayoutCell;
import kd.bos.metadata.print.control.LayoutColumn;
import kd.bos.metadata.print.control.LayoutRow;
import kd.bos.metadata.print.control.SubDataGrid;
import kd.bos.metadata.print.control.Text;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.api.facade.ITemplateUpgradeFacade;
import kd.bos.print.api.facade.PrtFacadeFactory;
import kd.bos.print.api.metedata.LocaleValue;
import kd.bos.print.api.metedata.control.Control;
import kd.bos.print.api.metedata.control.Paper;
import kd.bos.print.api.metedata.control.grid.layoutgrid.LayoutGridRow;
import kd.bos.print.api.utils.SerializeUtils;
import kd.bos.print.business.designer.datasource.DataSourceInfo;
import kd.bos.print.business.designer.datasource.PrtDataSourceUtil;
import kd.bos.print.business.metedata.bean.MetaUpdatReport;
import kd.bos.print.business.metedata.bean.MetaUpdateResult;
import kd.bos.print.business.metedata.transformer.Coordinate;
import kd.bos.print.business.metedata.transformer.Transformer;
import kd.bos.print.business.metedata.transformer.convert.ConversionException;
import kd.bos.print.business.metedata.transformer.convert.ConversionUtils;
import kd.bos.print.business.metedata.transformer.convert.converter.ConvertResult;
import kd.bos.print.business.metedata.transformer.convert.support.GenericConversionService;
import kd.bos.print.business.metedata.transformer.convert.support.PaperConverter;
import kd.bos.print.business.service.BosPrintBusinessServiceImpl;
import org.apache.commons.beanutils.BeanUtils;

public class MetaTransformer
extends Transformer<PrintMetadata, kd.bos.print.api.metedata.PrintMetadata> {
    private static final Log log = LogFactory.getLog(BosPrintBusinessServiceImpl.class);
    private GenericConversionService genericConversionService = new GenericConversionService();

    private void initNewMeta(PrintMetadata source, kd.bos.print.api.metedata.PrintMetadata result, Map ctx) {
        try {
            BeanUtils.copyProperties((Object)result, (Object)source);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        MetaUpdatReport metaUpdatReport = new MetaUpdatReport();
        ctx.put("report", metaUpdatReport);
        result.setVersion("2");
        List<ConversionException> conversionExceptionList = metaUpdatReport.getFixTips().get("error");
        Boolean flag = null;
        for (ITemplateUpgradeFacade facade : PrtFacadeFactory.getAllTemplateUpgradeFacades()) {
            Boolean existBizPlugin = facade.notifyByPluginUpgrade(source.getId());
            if (existBizPlugin == null) continue;
            if (existBizPlugin.booleanValue()) {
                flag = true;
                break;
            }
            flag = false;
        }
        if (flag == null && source.getRootAp().getPlugins() != null && source.getRootAp().getPlugins().size() > 0 || flag != null && flag.booleanValue()) {
            ConversionException conversionException = new ConversionException(source.getRootAp().toString(), ResManager.loadKDString((String)"\u5b58\u5728\u63d2\u4ef6", (String)"MetaTransformer_3", (String)"bos-print-business", (Object[])new Object[0]), "error", ResManager.loadKDString((String)"\u4e0d\u53ef\u8c03\u6574", (String)"MetaTransformer_1", (String)"bos-print-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6a21\u677f\u5b58\u5728\u63d2\u4ef6\uff0c\u76ee\u524d\u6682\u4e0d\u652f\u6301\u63d2\u4ef6\u7684\u8f6c\u6362", (String)"MetaTransformer_4", (String)"bos-print-business", (Object[])new Object[0]), 5);
            conversionExceptionList.add(conversionException);
            MetaTransformer.setError(conversionException, ctx);
            metaUpdatReport.setControlsNum(1);
            metaUpdatReport.setErrorControlsNum(1);
        }
        String json = source.getRootAp().getRefQueryDataSource();
        List mapList = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)json)) {
            mapList = (List)SerializeUtils.fromJsonString((String)json, List.class);
            Iterator iterator = mapList.iterator();
            while (iterator.hasNext()) {
                Map map = (Map)iterator.next();
                String number = (String)map.get("number");
                String entityId = MetadataDao.getIdByNumber((String)number, (MetaCategory)MetaCategory.Entity);
                map.put("entityId", entityId);
                map.put("formId", number);
                DataSourceInfo dataSourceInfo = PrtDataSourceUtil.buildDataSource(entityId);
                if (!entityId.equals(source.getEntityId()) && !StringUtils.equals((CharSequence)dataSourceInfo.getFormId(), (CharSequence)String.valueOf(ctx.get("dataBaseInfo")))) {
                    ctx.put("refDS", dataSourceInfo);
                    continue;
                }
                iterator.remove();
            }
        }
        String refJson = JSON.toJSONString(mapList);
        result.setRefDs(refJson);
        result.setName(ConversionUtils.getNameByLocaleString(source.getName()));
        String fromId = MetadataDao.getNumberById((String)result.getEntityId());
        result.setFormId(fromId);
        result.setType("PrintMetadata");
    }

    public static void setError(ConversionException conversionException, Map ctx) {
        List conversionExceptions = (List)ctx.get("error");
        conversionExceptions.add(conversionException);
    }

    private ConvertResult transformPaper(PrintMetadata source, kd.bos.print.api.metedata.PrintMetadata result) {
        PaperConverter paperConverter = new PaperConverter();
        return paperConverter.convert(source.getRootAp());
    }

    private int findDeatilRowIndex(List<BaseControl<?>> controls) {
        for (BaseControl<?> baseControl : controls) {
            DataRow dataRow;
            if (!(baseControl instanceof DataRow) || !"detail".equals((dataRow = (DataRow)baseControl).getRowType())) continue;
            return dataRow.getIndex();
        }
        return 0;
    }

    private boolean fixDataGridByStat(DataGrid dataGrid, Map context) {
        boolean hasStatRow = false;
        int deailRowIndex = this.findDeatilRowIndex(dataGrid.get());
        for (BaseControl baseControl : dataGrid.get()) {
            if (!(baseControl instanceof DataRow)) continue;
            DataRow dataRow = (DataRow)baseControl;
            if (dataRow.getRowType().contains("group")) {
                ConversionException conversionException = new ConversionException(baseControl.toString(), ResManager.loadKDString((String)"\u6570\u636e\u8868\u683c\u5206\u7ec4\u884c", (String)"MetaTransformer_5", (String)"bos-print-business", (Object[])new Object[0]), "manual", ResManager.loadKDString((String)"\u9700\u5728\u65b0\u6a21\u677f\u4e2d\u81ea\u884c\u6dfb\u52a0\u5206\u7ec4\u884c", (String)"MetaTransformer_6", (String)"bos-print-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5206\u7ec4\u884c\u4e0d\u652f\u6301\u5347\u7ea7", (String)"MetaTransformer_7", (String)"bos-print-business", (Object[])new Object[0]), 1);
                MetaTransformer.setError(conversionException, context);
            }
            if (baseControl.getIndex() > deailRowIndex) {
                hasStatRow = true;
                baseControl.setName(new LocaleString(ResManager.loadKDString((String)"\u5408\u8ba1\u884c", (String)"MetaTransformer_8", (String)"bos-print-business", (Object[])new Object[0])));
                dataRow.setRowType("Statistic");
                List controls = ((DataRow)baseControl).get();
                for (BaseControl baseControl1 : controls) {
                    if (!(baseControl1 instanceof DataCell)) continue;
                    DataCell dataCell = (DataCell)baseControl1;
                    if (CollectionUtils.isEmpty((Collection)dataCell.get()) && baseControl1.getBindField() != null && "text".equals(dataCell.getCellType())) {
                        baseControl1.setBindField(null);
                        dataCell.setStatType("");
                    } else if (dataCell.get() != null && dataCell.get().size() == 1) {
                        dataCell.setStatRange("");
                        dataCell.setStatType("");
                    }
                    dataCell.setCellType("stat");
                }
                continue;
            }
            if (baseControl.getIndex() < deailRowIndex) {
                baseControl.setName(new LocaleString(ResManager.loadKDString((String)"\u6807\u9898\u884c", (String)"MetaTransformer_9", (String)"bos-print-business", (Object[])new Object[0])));
                dataRow.setRowType("Normal");
                continue;
            }
            baseControl.setName(new LocaleString(ResManager.loadKDString((String)"\u6570\u636e\u884c", (String)"MetaTransformer_10", (String)"bos-print-business", (Object[])new Object[0])));
            dataRow.setRowType("Detail");
        }
        return hasStatRow;
    }

    private boolean duplicateEntry(String key, Set set) {
        int size = set.size();
        set.add(key);
        return set.size() <= size;
    }

    private Map transformControl(String newTplId, PrintMetadata source, kd.bos.print.api.metedata.PrintMetadata result) {
        List items = source.getItems();
        ArrayList<String> undoIds = new ArrayList(16);
        Class<?> metaClass = null;
        try {
            metaClass = Class.forName("kd.bos.metadata.form.PrintMetadata");
        }
        catch (ClassNotFoundException e) {
            throw new KDException((Throwable)e, new ErrorCode("print-exception", "%s"), new Object[]{"MetaTransformer transformControl class forName kd.bos.metadata.form.PrintMetadata not found"});
        }
        Map mapItems = null;
        HashMap<String, Object> context = new HashMap<String, Object>();
        DataSourceInfo dataSourceInfo = PrtDataSourceUtil.buildDataSource(source.getEntityId(), true);
        context.put("dataSourceInfo", dataSourceInfo);
        context.put("error", new ArrayList());
        context.put("entityId", source.getEntityId());
        context.put("sourceKey", source.getKey());
        context.put("paperId", source.getRootAp().getId());
        this.refDsProcess(source, context, dataSourceInfo);
        this.customDsProcess(source, result);
        int n = 0;
        try {
            Field nameField = metaClass.getDeclaredField("mapItems");
            if (nameField != null) {
                ReflectionUtils.makeAccessible((Field)nameField);
                HashSet controlCodeSet = new HashSet();
                mapItems = (Map)nameField.get(source);
                undoIds = this.fixDataGridCell(items, mapItems);
                for (BaseControl baseControl : items) {
                    if (this.duplicateEntry(baseControl.getKey(), controlCodeSet)) {
                        String key = baseControl.getKey() + "@" + n + "";
                        baseControl.setKey(key);
                        ++n;
                    }
                    if (baseControl instanceof SubDataGrid) {
                        ConversionException conversionException = new ConversionException(baseControl.toString(), ResManager.loadKDString((String)"\u5b50\u6570\u636e\u8868\u5355\u8f6c\u6362\u5f02\u5e38", (String)"MetaTransformer_11", (String)"bos-print-business", (Object[])new Object[0]), "manual", ResManager.loadKDString((String)"\u9700\u81ea\u884c\u8c03\u6574", (String)"MetaTransformer_12", (String)"bos-print-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5b50\u6570\u636e\u8868\u683c\u5347\u7ea7\u5b58\u5728\u5dee\u5f02\uff0c\u53ef\u5728\u753b\u5e03\u4e2d\u91cd\u65b0\u8c03\u6574", (String)"MetaTransformer_13", (String)"bos-print-business", (Object[])new Object[0]), 5);
                        MetaTransformer.setError(conversionException, context);
                    }
                    if (baseControl instanceof BaseGrid) {
                        BaseGrid baseGrid = (BaseGrid)baseControl;
                        this.setGridInfo((BaseGrid)baseControl, context);
                        if (baseControl.getBackColor() != null) {
                            this.fixGridBackColor(baseGrid);
                        }
                        if (baseControl instanceof DataGrid) {
                            DataGrid dataGrid = (DataGrid)baseControl;
                            boolean hasStatRow = this.fixDataGridByStat(dataGrid, context);
                            context.put("hasStatRow" + dataGrid.getKey(), hasStatRow);
                        }
                    }
                    if (!(baseControl instanceof LayoutRow) && !(baseControl instanceof DataRow)) continue;
                    this.setTranfromRow(baseControl);
                }
                context.put("mapItems", mapItems);
                context.put("hasSub", Boolean.FALSE);
                this.setDataBaseInfo(source, context);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException | NullPointerException e) {
            log.error(e.getMessage());
        }
        ArrayList<ConvertResult> pages = new ArrayList<ConvertResult>();
        List allPrtDataSourceFacades = PrtFacadeFactory.getAllTemplateUpgradeFacades();
        boolean hasInnerGird = false;
        for (BaseControl baseControl : items) {
            String bcPid = baseControl.getParentId();
            String apId = source.getRootAp().getId();
            ArrayList conversionExceptions = new ArrayList();
            if (baseControl instanceof BaseGrid && !bcPid.equals(apId) && !(baseControl instanceof SubDataGrid)) {
                this.fixInnerGrid(source, (BaseGrid)baseControl);
                if (!hasInnerGird) {
                    ConversionException conversionException = new ConversionException(baseControl.toString(), ResManager.loadKDString((String)"\u7f51\u683c\u5d4c\u5957", (String)"MetaTransformer_14", (String)"bos-print-business", (Object[])new Object[0]), "manual", ResManager.loadKDString((String)"\u65e0\u5f71\u54cd", (String)"MetaTransformer_15", (String)"bos-print-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8868\u683c\u5d4c\u5957\uff1a\u6240\u6709\u8868\u683c\u5bb9\u5668\u63d0\u53d6\u5230\u753b\u5e03\u5c42\u4f5c\u4e3a\u72ec\u7acb\u63a7\u4ef6", (String)"MetaTransformer_16", (String)"bos-print-business", (Object[])new Object[0]), 0);
                    MetaTransformer.setError(conversionException, context);
                    hasInnerGird = true;
                }
            }
            if (baseControl instanceof Image) {
                Image image = (Image)baseControl;
                image.setScript(newTplId);
            }
            try {
                ConvertResult obj;
                if (!this.isNeedUpdate(undoIds, baseControl.getId()) || (obj = (ConvertResult)this.genericConversionService.convert((Object)baseControl, context)) == null) continue;
                this.fixControl((Control)obj.getTarget());
                obj.getErrors().addAll(conversionExceptions);
                if (!CollectionUtils.isEmpty((Collection)allPrtDataSourceFacades)) {
                    HashMap<String, Object> params = new HashMap<String, Object>(4);
                    params.put("convertResult", obj);
                    params.put("context", context);
                    params.put("sourceControl", baseControl);
                    allPrtDataSourceFacades.stream().forEach(item -> item.afterCtrlConvert(params));
                }
                pages.add(obj);
            }
            catch (Exception e) {
                log.warn(e.getMessage());
            }
        }
        context.put("pages", pages);
        return context;
    }

    private void refDsProcess(PrintMetadata source, Map<String, Object> context, DataSourceInfo dataSourceInfo) {
        String json = source.getRootAp().getRefQueryDataSource();
        if (StringUtils.isNotBlank((CharSequence)json)) {
            List mapList = (List)SerializeUtils.fromJsonString((String)json, List.class);
            for (Map map : mapList) {
                String number = (String)map.get("number");
                String entityId = MetadataDao.getIdByNumber((String)number, (MetaCategory)MetaCategory.Entity);
                DataSourceInfo refDataSource = PrtDataSourceUtil.buildDataSource(entityId);
                if (StringUtils.equals((CharSequence)dataSourceInfo.getFormId(), (CharSequence)refDataSource.getFormId())) {
                    ConversionException conversionException = new ConversionException(source.getRootAp().toString(), ResManager.loadKDString((String)"\u5173\u8054\u6570\u636e\u6e90\u4e0d\u652f\u6301\u4e0e\u4e3b\u6570\u636e\u6e90\u76f8\u540c", (String)"MetaTransformer_18", (String)"bos-print-business", (Object[])new Object[0]), "manual", ResManager.loadKDString((String)"\u9700\u81ea\u884c\u8c03\u6574", (String)"MetaTransformer_12", (String)"bos-print-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5173\u8054\u6570\u636e\u6e90\u4e0d\u652f\u6301\u4e0e\u4e3b\u6570\u636e\u6e90\u76f8\u540c", (String)"MetaTransformer_18", (String)"bos-print-business", (Object[])new Object[0]), 5);
                    MetaTransformer.setError(conversionException, context);
                    continue;
                }
                context.put("refDS" + number, refDataSource);
            }
        }
    }

    private void customDsProcess(PrintMetadata source, kd.bos.print.api.metedata.PrintMetadata result) {
        String customDataSource = source.getRootAp().getCustomDataSource();
        if (customDataSource != null) {
            Map customMap = (Map)SerializeUtils.fromJsonString((String)customDataSource, Map.class);
            List oldCustoms = (List)customMap.get("dsentry");
            ArrayList newCustoms = new ArrayList(oldCustoms.size());
            int i = 1;
            for (Map oldCustom : oldCustoms) {
                oldCustom = (Map)SerializeUtils.fromJsonString((String)oldCustom.get("dsdata").toString(), Map.class);
                LinkedHashMap<String, Object> newCustom = new LinkedHashMap<String, Object>(5);
                newCustom.put("_Type_", "dslist");
                newCustom.put("name", oldCustom.get("name"));
                newCustom.put("seq", i++);
                newCustom.put("key", oldCustom.get("number"));
                List oldFiledItems = (List)oldCustom.get("queryfieldentry");
                if (oldFiledItems == null) {
                    return;
                }
                ArrayList newFieldItems = new ArrayList(oldFiledItems.size());
                int j = 1;
                for (Map oldFiledItem : oldFiledItems) {
                    String newDataType;
                    String datatype;
                    LinkedHashMap<String, Object> newFieldItem = new LinkedHashMap<String, Object>(5);
                    newFieldItem.put("seq", j++);
                    newFieldItem.put("_Type_", "fielditems");
                    if (oldFiledItem == null) continue;
                    switch (datatype = oldFiledItem.getOrDefault("datatype", "").toString()) {
                        case "integer": 
                        case "decimal": {
                            newDataType = "Number";
                            break;
                        }
                        case "date": {
                            newDataType = "Date";
                            break;
                        }
                        default: {
                            newDataType = "Text";
                        }
                    }
                    newFieldItem.put("fieldtype", newDataType);
                    newFieldItem.put("fieldkey", oldFiledItem.get("fieldname"));
                    newFieldItem.put("fieldname", oldFiledItem.get("displayname"));
                    newFieldItems.add(newFieldItem);
                }
                newCustom.put("fielditems", newFieldItems);
                newCustoms.add(newCustom);
            }
            result.setCustomDs(SerializeUtils.toJsonString(newCustoms));
        }
    }

    private boolean isNeedUpdate(List<String> undoids, String id) {
        for (String unid : undoids) {
            if (!unid.equals(id)) continue;
            return false;
        }
        return true;
    }

    private String getDS(String ds) {
        if (ConversionUtils.isJSONValid(ds)) {
            JSONObject jsonObject = JSON.parseObject((String)ds);
            String dataSource = jsonObject.getString("key");
            return dataSource;
        }
        return ds;
    }

    private List<String> fixDataGridCell(List<BaseControl<?>> items, Map<String, BaseControl<?>> mapItems) {
        ArrayList<String> ids = new ArrayList<String>();
        for (BaseControl<?> baseControl : items) {
            DataCell dataCell;
            BaseControl<?> row;
            if (!(baseControl instanceof DataCell) || !((row = mapItems.get((dataCell = (DataCell)baseControl).getParentId())) instanceof DataRow) || dataCell.get().size() <= 0) continue;
            if (dataCell.get().size() == 1) {
                DataRow dataRow = (DataRow)row;
                BaseControl<?> dataGrid = mapItems.get(dataRow.getParentId());
                boolean updateFlag = true;
                if (!"detail".equals(dataRow.getRowType()) && !"Statistic".equals(dataRow.getRowType()) && !"normal".equals(dataRow.getRowType())) continue;
                String dataCellds = null;
                String childrends = null;
                BaseControl innerControl = (BaseControl)dataCell.get().get(0);
                try {
                    dataCellds = this.getDS(dataGrid.getDataSource());
                    childrends = this.getDS(innerControl.getDataSource());
                }
                catch (NullPointerException ex) {
                    updateFlag = false;
                }
                boolean controlBindField = "normal".equals(dataRow.getRowType()) || "field".equals(innerControl.getBindType()) && StringUtils.equals((CharSequence)childrends, (CharSequence)dataCellds);
                boolean controlBindText = "text".equals(innerControl.getBindType());
                if (updateFlag && innerControl instanceof Amount && (controlBindField || controlBindText)) {
                    Amount amount = (Amount)innerControl;
                    this.resetDataGridCell(dataCell, (BaseControl)amount);
                    ids.add(amount.getId());
                    continue;
                }
                if (updateFlag && innerControl instanceof Text && this.isUpdate(innerControl) && (controlBindField || controlBindText)) {
                    Text text = (Text)innerControl;
                    this.resetDataGridCell(dataCell, (BaseControl)text);
                    ids.add(text.getId());
                    continue;
                }
                if (innerControl instanceof BaseContainer) continue;
                ids.add(innerControl.getId());
                continue;
            }
            List baseControls = dataCell.get();
            for (BaseControl bc : baseControls) {
                ids.add(bc.getId());
            }
        }
        return ids;
    }

    private boolean isUpdate(Object control) {
        if (control instanceof Barcode) {
            return false;
        }
        if (control instanceof Image) {
            return false;
        }
        if (control instanceof Label) {
            // empty if block
        }
        return true;
    }

    private void resetDataGridCell(DataCell dataCell, BaseControl baseControl) {
        dataCell.setDataSource(baseControl.getDataSource());
        dataCell.setBindField(baseControl.getBindField());
        dataCell.setBackColor(baseControl.getBackColor());
        dataCell.setBindType(baseControl.getBindType());
        dataCell.setBold(baseControl.isBold());
        dataCell.setFontName(baseControl.getFontName());
        dataCell.setName(baseControl.getName());
        dataCell.setFontSize(baseControl.getFontSize());
        dataCell.setBindText(baseControl.getBindText());
        dataCell.setShrink(baseControl.isShrink());
        dataCell.setUnderLine(baseControl.isUnderLine());
        dataCell.setWrapText(baseControl.isWrapText());
        dataCell.setItalic(baseControl.isItalic());
        dataCell.setHorAlignment(baseControl.getHorAlignment());
        dataCell.setVerAlignment(baseControl.getVerAlignment());
        if (baseControl instanceof Amount) {
            Amount amount = (Amount)baseControl;
            dataCell.setPreScript(JSONObject.toJSONString((Object)amount));
        } else if (baseControl instanceof Text) {
            Text text = (Text)baseControl;
            dataCell.setDivideModel(text.isDivideModel());
            dataCell.setDivideCharNums(text.getDivideCharNums());
            dataCell.setShowDivideLine(text.isShowDivideLine());
        }
        dataCell.setFormat(baseControl.getFormat());
    }

    private void fixGridBackColor(BaseGrid baseGrid) {
        List controls = baseGrid.get();
        for (BaseControl baseControl : controls) {
            BaseContainer baseContainer;
            List baseControls;
            if (!(baseControl instanceof BaseContainer) || (baseControls = (baseContainer = (BaseContainer)baseControl).get()).size() <= 0) continue;
            for (BaseControl cellControl : baseControls) {
                if (cellControl.getBackColor() != null) continue;
                cellControl.setBackColor(baseGrid.getBackColor());
            }
        }
    }

    private void fixControl(Control control) {
        LayoutGridRow layoutGridRow;
        if (control instanceof LayoutGridRow && "Statistic".equals((layoutGridRow = (LayoutGridRow)control).getRowType())) {
            layoutGridRow.setName(new LocaleValue((Object)ResManager.loadKDString((String)"\u5408\u8ba1\u884c", (String)"MetaTransformer_8", (String)"bos-print-business", (Object[])new Object[0])));
        }
    }

    private void setDataBaseInfo(PrintMetadata source, Map ctx) {
        String numberById = this.loadMainDs(source.getEntityId());
        ctx.put("dataBaseInfo", numberById);
    }

    private void setTranfromRow(BaseControl baseControl) {
        if (baseControl instanceof LayoutRow) {
            LayoutRow layoutRow = (LayoutRow)baseControl;
            LocaleString localeString = layoutRow.getHeight();
            Float h = ConversionUtils.getNumByLocaleString(localeString);
            if (h.floatValue() < 3.0f) {
                // empty if block
            }
            if (layoutRow.isAutoAdjustHeight()) {
                this.setCellTextOverFlowByRow(layoutRow.get(), "WrapLine");
            }
        } else {
            DataRow dataRow = (DataRow)baseControl;
            if (dataRow.isAutoAdjustHeight()) {
                this.setCellTextOverFlowByRow(dataRow.get(), "WrapLine");
            }
        }
    }

    private void setCellTextOverFlowByRow(List<BaseControl<?>> list, String textOverFlow) {
        for (BaseControl<?> baseControl : list) {
            baseControl.setScript(textOverFlow);
        }
    }

    private void setGridInfo(BaseGrid baseGrid, Map ctx) {
        List baseControls = baseGrid.get();
        ctx.put(baseGrid.getId(), this.findLastRow(baseControls));
    }

    private BaseControl findLastRow(List<BaseControl<?>> baseControls) {
        List<BaseControl<?>> rowList = baseControls.stream().filter(s -> s instanceof DataRow || s instanceof LayoutRow).collect(Collectors.toList());
        ConversionUtils.sortControls(rowList);
        return rowList.get(rowList.size() - 1);
    }

    @Override
    public MetaUpdateResult transform(String newTplId, PrintMetadata source, kd.bos.print.api.metedata.PrintMetadata result) {
        Map ctx = this.transformControl(newTplId, source, result);
        this.initNewMeta(source, result, ctx);
        Paper paper = (Paper)this.transformPaper(source, result).getTarget();
        paper.setKey(result.getKey());
        result.setPaper(paper);
        List transformControls = (List)ctx.get("pages");
        ArrayList pages = new ArrayList();
        ArrayList<Control> controlList = new ArrayList<Control>(transformControls.size());
        for (ConvertResult convertResult : transformControls) {
            Control control = (Control)convertResult.getTarget();
            controlList.add(control);
        }
        pages.add(controlList);
        result.setPages(pages);
        return this.metaUpdateResultHandler(source, transformControls, ctx);
    }

    private MetaUpdateResult metaUpdateResultHandler(PrintMetadata source, List<ConvertResult<Control>> convertResults, Map ctx) {
        MetaUpdateResult metaUpdateResult = new MetaUpdateResult();
        metaUpdateResult.setTplId(source.getId());
        metaUpdateResult.setTplCode(source.getRootAp().getKey());
        metaUpdateResult.setTplName(source.getRootAp().getName());
        this.setCompatibilityAndDesc(metaUpdateResult, convertResults, ctx);
        return metaUpdateResult;
    }

    private void setCompatibilityAndDesc(MetaUpdateResult metaUpdateResult, List<ConvertResult<Control>> convertResults, Map ctx) {
        StringBuilder desc = new StringBuilder();
        MetaUpdatReport metaUpdatReport = (MetaUpdatReport)ctx.get("report");
        metaUpdateResult.setMetaUpdatReport(metaUpdatReport);
        double papaerError = 0.0;
        double tplError = 0.0;
        int controlError = 0;
        HashMap<String, List<ConversionException>> fixTips = metaUpdatReport.getFixTips();
        List conversionExceptions = (List)ctx.get("error");
        for (ConversionException conversionException : conversionExceptions) {
            desc.append(conversionException.getMessage()).append(';');
            if (ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6570\u636e\u6e90", (String)"MetaTransformer_0", (String)"bos-print-business", (Object[])new Object[0]).equals(conversionException.getName()) || ResManager.loadKDString((String)"\u5b58\u5728\u63d2\u4ef6", (String)"MetaTransformer_3", (String)"bos-print-business", (Object[])new Object[0]).equals(conversionException.getName())) {
                tplError = 5.0;
                continue;
            }
            papaerError += (double)conversionException.getWeight();
        }
        papaerError += tplError;
        for (ConvertResult convertResult : convertResults) {
            Control control = (Control)convertResult.getTarget();
            List<ConversionException> errors = convertResult.getErrors();
            if (errors.size() <= 0) continue;
            desc.append(control).append(':');
            StringBuilder controlName = new StringBuilder();
            controlName.append((String)control.getName().getLocaleValue()).append('-').append(control.getKey()).append(':');
            ++controlError;
            for (ConversionException conversionException : errors) {
                List<ConversionException> list = fixTips.get(conversionException.getConversionExceptionType());
                controlName.append(conversionException.getMessage()).append(';');
                list.add(conversionException);
                desc.append(conversionException.getName()).append(";");
            }
        }
        fixTips.get("error").addAll(conversionExceptions);
        BigDecimal oneH = new BigDecimal(100);
        double d = 100.0 - papaerError - (double)controlError;
        BigDecimal total = BigDecimal.valueOf(d < 0.0 ? 0.0 : d);
        BigDecimal compatibility = total.divide(oneH, 2, RoundingMode.HALF_UP);
        BigDecimal rate = convertResults.size() == 0 ? BigDecimal.ONE : new BigDecimal(convertResults.size() - controlError).divide(new BigDecimal(convertResults.size()), 2, RoundingMode.HALF_UP);
        StringBuilder totals = new StringBuilder(ResManager.loadKDString((String)"\u76ee\u524d\u63a7\u4ef6\u8f6c\u6362\u7387\u4e3a\uff1a ", (String)"MetaTransformer_17", (String)"bos-print-business", (Object[])new Object[0]));
        metaUpdatReport.setControlsNum(convertResults.size() + 1);
        metaUpdatReport.setErrorControlsNum(controlError);
        totals.append(convertResults.size() - controlError).append('/').append(convertResults.size()).append('=').append(rate);
        metaUpdatReport.setScore(compatibility.toString());
        metaUpdatReport.setConversionRate(totals.toString());
        metaUpdateResult.setCompatibility(compatibility);
        metaUpdateResult.setDifferenceAnalysis(desc.toString());
        metaUpdatReport.setGeneralRemark(desc.toString());
    }

    private String loadMainDs(String entityId) {
        String numberById = MetadataDao.getNumberById((String)entityId);
        return numberById;
    }

    private void fixInnerGrid(PrintMetadata source, BaseGrid layoutGrid) {
        String pid = layoutGrid.getParentId();
        BaseControl baseControl = source.getItem(pid);
        Coordinate coordinate = this.findXY(source, layoutGrid.getParentId(), 0);
        Float x = ConversionUtils.getNumByLocaleString(layoutGrid.getX());
        Float y = ConversionUtils.getNumByLocaleString(layoutGrid.getY());
        layoutGrid.setX(new LocaleString(coordinate.getX().floatValue() + x.floatValue() + "mm"));
        layoutGrid.setY(new LocaleString(coordinate.getY().floatValue() + y.floatValue() + "mm"));
        if (!(layoutGrid instanceof SubDataGrid)) {
            layoutGrid.setParentId(source.getRootAp().getId());
        }
    }

    private Coordinate findXY(PrintMetadata source, String pid, int tag) {
        BaseControl baseControl = source.getItem(pid);
        String apId = source.getRootAp().getId();
        String x = baseControl.getX().getLocaleValue();
        String y = baseControl.getY().getLocaleValue();
        if (++tag > 200) {
            Coordinate realCoordinate = new Coordinate();
            realCoordinate.setX(Float.valueOf(-1.0f));
            realCoordinate.setY(Float.valueOf(-1.0f));
            return realCoordinate;
        }
        if (apId.equals(baseControl.getParentId())) {
            Coordinate realCoordinate = new Coordinate();
            realCoordinate.setX(ConversionUtils.getNumByString(x));
            realCoordinate.setY(ConversionUtils.getNumByString(y));
            return realCoordinate;
        }
        Coordinate realCoordinate = this.findXY(source, baseControl.getParentId(), tag);
        if (baseControl instanceof LayoutCell) {
            Coordinate relativeCoordinate = this.findrelativeXY(source, source.getItem(baseControl.getParentId()), baseControl.getIndex());
            realCoordinate.setX(Float.valueOf(realCoordinate.getX().floatValue() + relativeCoordinate.getX().floatValue()));
            realCoordinate.setY(Float.valueOf(realCoordinate.getY().floatValue() + relativeCoordinate.getY().floatValue()));
        }
        return realCoordinate;
    }

    private Coordinate findrelativeXY(PrintMetadata source, BaseControl baseControl, int index) {
        BaseGrid grid = (BaseGrid)source.getItem(baseControl.getParentId());
        List controls = grid.get();
        Coordinate coordinate = new Coordinate();
        Float relativeX = Float.valueOf(0.0f);
        Float relativeY = Float.valueOf(0.0f);
        for (BaseControl control : controls) {
            LayoutRow row;
            if (control instanceof LayoutColumn) {
                LayoutColumn col = (LayoutColumn)control;
                if (control.getIndex() < index) {
                    relativeX = Float.valueOf(relativeX.floatValue() + ConversionUtils.getNumByLocaleString(col.getWidth()).floatValue());
                }
            }
            if (control instanceof LayoutRow) {
                row = (LayoutRow)control;
                if (control.getIndex() < baseControl.getIndex()) {
                    relativeY = Float.valueOf(relativeY.floatValue() + ConversionUtils.getNumByLocaleString(row.getHeight()).floatValue());
                }
            }
            if (!(control instanceof DataRow)) continue;
            row = (DataRow)control;
            if (control.getIndex() >= baseControl.getIndex()) continue;
            relativeY = Float.valueOf(relativeY.floatValue() + ConversionUtils.getNumByLocaleString(row.getHeight()).floatValue());
        }
        coordinate.setX(relativeX);
        coordinate.setY(relativeY);
        return coordinate;
    }
}

