/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.metedata.transformer;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.report.CellStyle;
import kd.bos.exception.KDException;
import kd.bos.isv.ISVService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.PrintMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.print.api.utils.SerializeUtils;
import kd.bos.print.business.designer.TplType;
import kd.bos.print.business.metedata.bean.DesignMetadata;
import kd.bos.print.business.metedata.bean.MetaUpdateResult;
import kd.bos.print.business.metedata.service.AbstractTplService;
import kd.bos.print.business.metedata.service.PrintTplService;
import kd.bos.print.business.metedata.transformer.Transformer;
import kd.bos.print.business.metedata.transformer.TransformerFactory;
import kd.bos.print.business.utils.OldPrintTemplateUtil;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPools;

public class MetaUpdateTask
extends AbstractTask {
    public static final ExecutorService exec = ThreadPools.newCachedExecutorService((String)"update");
    private static final String PROJECT_NAME = "bos-print-business";
    private static final String UPDATE_KEY_SUFFIX = "_NEW";
    private AbstractTplService<DesignMetadata> tplService = new PrintTplService();
    private static final String PRINT_METEDATA = "bos_print_meta";
    private static String NEW_TPL_VERSION = "2";
    private static final String Key_List_Color_Enable = "#1BA854";
    private static final String Key_List_Color_DisEnable = "#999999";
    private static final String Key_Card_Color_Enable = " #ffffff";
    private static final String Key_Card_Color_DisEnable = "#f2f2f2";
    private static final Log log = LogFactory.getLog(MetaUpdateTask.class);

    private String getUpdateNameSuffix() {
        return ResManager.loadKDString((String)"%s_\u65b0", (String)"MetaUpdateTask_0", (String)PROJECT_NAME, (Object[])new Object[0]);
    }

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.feedbackProgress(0, ResManager.loadKDString((String)"\u6253\u5370\u5df2\u8fdb\u5165\u4efb\u52a1\u6267\u884c\u73af\u8282\u3002", (String)"PrintDataProgressFormPlugin_0", (String)"bos-form-mvc", (Object[])new Object[0]), null);
        HashMap<String, String> result = new HashMap<String, String>(2);
        List tplIds = (List)map.get("tplIds");
        List<MetaUpdateResult> metaUpdateResults = this.batchMetaUpdate(tplIds);
        String resultJson = JSONObject.toJSONString(metaUpdateResults);
        result.put("meta-update-result", resultJson);
        this.feedbackCustomdata(result);
        this.feedbackProgress(100, ResManager.loadKDString((String)"\u6253\u5370\u5df2\u8fdb\u5165\u4efb\u52a1\u6267\u884c\u73af\u8282\u3002", (String)"PrintDataProgressFormPlugin_0", (String)"bos-form-mvc", (Object[])new Object[0]), null);
    }

    private List<MetaUpdateResult> batchMetaUpdate(List<String> tplIds) {
        if (tplIds.size() > 100) {
            return this.asynBatchHandler(tplIds);
        }
        return this.synBatchHandler(tplIds);
    }

    private List<MetaUpdateResult> asynBatchHandler(List<String> tplIds) {
        MetaUpdateTask inst = new MetaUpdateTask();
        ArrayList<FutureTask<MetaUpdateResult>> taskList = new ArrayList<FutureTask<MetaUpdateResult>>(tplIds.size());
        for (int i = 0; i < tplIds.size(); ++i) {
            MetaUpdateTask metaUpdateTask = inst;
            ((Object)((Object)metaUpdateTask)).getClass();
            FutureTask<MetaUpdateResult> ft = new FutureTask<MetaUpdateResult>(metaUpdateTask.new ComputeTask(tplIds.get(i)));
            taskList.add(ft);
            exec.submit(ft);
        }
        double n = 0.0;
        double size = tplIds.size();
        ArrayList<MetaUpdateResult> metaUpdateResults = new ArrayList<MetaUpdateResult>();
        for (FutureTask futureTask : taskList) {
            n += 1.0;
            try {
                MetaUpdateResult metaUpdateResult = (MetaUpdateResult)futureTask.get();
                metaUpdateResults.add(metaUpdateResult);
                double progress = n / size * 100.0;
                int pro = (int)Math.round(progress);
                this.feedbackProgress(pro, ResManager.loadKDString((String)"\u6253\u5370\u5df2\u8fdb\u5165\u4efb\u52a1\u6267\u884c\u73af\u8282\u3002", (String)"PrintDataProgressFormPlugin_0", (String)"bos-form-mvc", (Object[])new Object[0]), null);
            }
            catch (InterruptedException | ExecutionException e) {
                log.error((Throwable)e);
            }
        }
        try {
            metaUpdateResults.sort(Comparator.comparing(MetaUpdateResult::getCompatibility).reversed());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return metaUpdateResults;
    }

    protected CellStyle genStyle(String key, int i, String foreColor) {
        CellStyle cellStyle = new CellStyle();
        cellStyle.setFieldKey(key);
        cellStyle.setRow(i);
        cellStyle.setForeColor(StringUtils.isBlank((CharSequence)foreColor) ? Key_List_Color_DisEnable : foreColor);
        return cellStyle;
    }

    private List<MetaUpdateResult> synBatchHandler(List<String> tplIds) {
        double n = 0.0;
        double size = tplIds.size();
        ArrayList<MetaUpdateResult> metaUpdateResults = new ArrayList<MetaUpdateResult>();
        for (String tplId : tplIds) {
            n += 1.0;
            PrintMetadata meta = OldPrintTemplateUtil.findOldPrintMetadata(tplId);
            if (meta == null) {
                MetaUpdateResult mResult = new MetaUpdateResult();
                mResult.setCompatibility(new BigDecimal(0));
                mResult.setTplId(tplId);
                mResult.setTplCode(tplId);
                mResult.setTplName(new LocaleString(""));
                mResult.setDifferenceAnalysis(ResManager.loadKDString((String)"\u8be5\u6a21\u677f\u5143\u6570\u636e\u4e3a\u7a7a\u3002", (String)"MetaUpdateTask_2", (String)PROJECT_NAME, (Object[])new Object[0]));
                metaUpdateResults.add(mResult);
            } else {
                try {
                    MetaUpdateResult metaUpdateResult = this.metaUpdate(tplId);
                    metaUpdateResults.add(metaUpdateResult);
                }
                catch (Exception ex) {
                    MetaUpdateResult mResult = new MetaUpdateResult();
                    mResult.setCompatibility(new BigDecimal(0));
                    mResult.setTplId(meta.getId());
                    mResult.setTplCode(meta.getRootAp().getKey());
                    mResult.setTplName(meta.getRootAp().getName());
                    mResult.setDifferenceAnalysis(ResManager.loadKDString((String)"\u6a21\u677f\u8f6c\u6362\u7cfb\u7edf\u9519\u8bef", (String)"MetaUpdateTask_1", (String)PROJECT_NAME, (Object[])new Object[0]));
                    metaUpdateResults.add(mResult);
                    log.error((Throwable)ex);
                }
            }
            double progress = n / size * 100.0;
            int pro = (int)Math.round(progress);
            this.feedbackProgress(pro, ResManager.loadKDString((String)"\u6253\u5370\u5df2\u8fdb\u5165\u4efb\u52a1\u6267\u884c\u73af\u8282\u3002", (String)"PrintDataProgressFormPlugin_0", (String)"bos-form-mvc", (Object[])new Object[0]), null);
        }
        try {
            metaUpdateResults.sort(Comparator.comparing(MetaUpdateResult::getCompatibility).reversed());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return metaUpdateResults;
    }

    public MetaUpdateResult metaUpdate(String tplId) {
        PrintMetadata meta = OldPrintTemplateUtil.findOldPrintMetadata(tplId);
        TransformerFactory transformerFactory = new TransformerFactory();
        Transformer transformer = null;
        String newTplId = DB.genStringId((String)"t_svc_printmeta");
        try {
            transformer = transformerFactory.newTransformer();
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        kd.bos.print.api.metedata.PrintMetadata printMetadata = new kd.bos.print.api.metedata.PrintMetadata();
        MetaUpdateResult metaUpdateResult = null;
        metaUpdateResult = Optional.ofNullable(transformer).map(m -> m.transform(newTplId, meta, printMetadata)).orElse(null);
        if (metaUpdateResult == null) {
            metaUpdateResult = new MetaUpdateResult();
        }
        String aa = SerializeUtils.toJsonString((Object)printMetadata);
        Map sTpldata = (Map)SerializeUtils.fromJsonString((String)aa, Map.class);
        String key = printMetadata.getKey() + UPDATE_KEY_SUFFIX;
        LocaleString name = new LocaleString(String.format(this.getUpdateNameSuffix(), printMetadata.getName().getLocaleValue()));
        Map mm = this.createNewPrintTemplate(newTplId, key, (ILocaleString)name, printMetadata.getEntityId(), printMetadata.getFormId(), sTpldata);
        metaUpdateResult.setNewTplId((String)mm.get("tplId"));
        if ("1".equals(mm.get("error"))) {
            metaUpdateResult.setTplId(meta.getId());
            metaUpdateResult.setTplCode(meta.getRootAp().getKey());
            metaUpdateResult.setTplName(meta.getRootAp().getName());
            metaUpdateResult.setCompatibility(new BigDecimal(0));
            metaUpdateResult.setDifferenceAnalysis(ResManager.loadKDString((String)"\u6a21\u677f\u5df2\u7ecf\u5347\u7ea7\u8fc7\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u5347\u7ea7", (String)"MetaUpdateTask_3", (String)PROJECT_NAME, (Object[])new Object[0]));
        }
        if (metaUpdateResult.getCompatibility() == null) {
            MetaUpdateResult metaUpdateResult1 = new MetaUpdateResult();
            metaUpdateResult1.setTplId(meta.getId());
            metaUpdateResult1.setTplCode(meta.getRootAp().getKey());
            metaUpdateResult1.setTplName(meta.getRootAp().getName());
            metaUpdateResult1.setCompatibility(new BigDecimal(0));
            metaUpdateResult1.setDifferenceAnalysis(ResManager.loadKDString((String)"\u6a21\u677f\u6ca1\u6709\u5185\u5bb9\uff0c\u8f6c\u6362\u5931\u8d25", (String)"MetaUpdateTask_4", (String)PROJECT_NAME, (Object[])new Object[0]));
            return metaUpdateResult1;
        }
        return metaUpdateResult;
    }

    private Map createNewPrintTemplate(String tplId, String key, ILocaleString name, String entityId, String formId, Map<String, Object> sTpldata) {
        Map<String, ILocaleString> paper;
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("error", "0");
        QFilter[] qFilters = new QFilter[]{new QFilter("number", "=", (Object)key)};
        boolean exists = QueryServiceHelper.exists((String)PRINT_METEDATA, (QFilter[])qFilters);
        if (exists) {
            QFilter[] qFilters1 = new QFilter[]{new QFilter("number", "=", (Object)key)};
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)PRINT_METEDATA, (String)"id", (QFilter[])qFilters1);
            String tplId1 = (String)dynamicObject.get("id");
            result.put("error", "1");
            result.put("tplId", tplId1);
            return result;
        }
        FormMetadata formMeta = (FormMetadata)MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Form);
        String bizAppId = formMeta.getBizappId();
        long creator = RequestContext.get().getCurrUserId();
        long orgId = RequestContext.get().getOrgId();
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        data.put("id", tplId);
        data.put("key", key);
        data.put("name", name);
        data.put("type", TplType.PrintTpl.toString());
        data.put("stplId", " ");
        data.put("entityId", entityId);
        data.put("formId", formId);
        data.put("bizappId", bizAppId);
        data.put("version", NEW_TPL_VERSION);
        data.put("refDs", null);
        data.put("customDs", null);
        if (sTpldata != null) {
            Object customDs;
            paper = (Map)sTpldata.get("paper");
            paper.put("key", (ILocaleString)key);
            paper.put("name", name);
            data.put("paper", paper);
            data.put("pages", sTpldata.get("pages"));
            data.put("stplId", sTpldata.get("id"));
            Object refDs = sTpldata.get("refDs");
            if (refDs != null) {
                data.put("refDs", refDs);
            }
            if ((customDs = sTpldata.get("customDs")) != null) {
                data.put("customDs", customDs);
            }
        } else {
            paper = new HashMap();
            paper.put("id", (ILocaleString)tplId);
            paper.put("key", (ILocaleString)key);
            paper.put("name", name);
            paper.put("type", (ILocaleString)"Paper");
            paper.put("paperType", (ILocaleString)"A4");
            paper.put("width", (ILocaleString)Integer.valueOf(210));
            paper.put("height", (ILocaleString)Integer.valueOf(297));
            paper.put("paperDirection", (ILocaleString)"vertical");
            paper.put("economicType", (ILocaleString)"");
            paper.put("marginTop", (ILocaleString)Integer.valueOf(20));
            paper.put("marginBottom", (ILocaleString)Integer.valueOf(20));
            paper.put("marginLeft", (ILocaleString)Integer.valueOf(17));
            paper.put("marginRight", (ILocaleString)Integer.valueOf(17));
            paper.put("inteFormat", (ILocaleString)"zh_CN");
            paper.put("backgroundImg", (ILocaleString)"");
            data.put("paper", paper);
            ArrayList<List> pages = new ArrayList<List>();
            pages.add(Collections.EMPTY_LIST);
            data.put("pages", pages);
        }
        DesignMetadata dMetadata = new DesignMetadata();
        dMetadata.setId(tplId);
        dMetadata.setMasterid(tplId);
        dMetadata.setNumber(key);
        dMetadata.setStplId((String)data.get("stplId"));
        dMetadata.setName(name.getLocaleValue());
        dMetadata.setlName(name);
        dMetadata.setFormId(formId);
        dMetadata.setCreator(creator);
        dMetadata.setModifier(creator);
        dMetadata.setType("B");
        dMetadata.setBizappid(bizAppId);
        dMetadata.setCreatetime(new Date());
        dMetadata.setModifytime(new Date());
        dMetadata.setOrg(orgId);
        dMetadata.setData(SerializationUtils.toJsonString(data));
        dMetadata.setStatus("C");
        dMetadata.setEnable("1");
        dMetadata.setVersion(NEW_TPL_VERSION);
        dMetadata.setIsv(ISVService.getISVInfo().getId());
        this.tplService.saveWithEnable(dMetadata);
        result.put("success", Boolean.TRUE);
        result.put("tplId", tplId);
        result.put("printV", "B");
        return result;
    }

    private class ComputeTask
    implements Callable<MetaUpdateResult> {
        private String tplId = "";

        public ComputeTask(String tplId) {
            this.tplId = tplId;
        }

        public String getTplId() {
            return this.tplId;
        }

        @Override
        public MetaUpdateResult call() throws Exception {
            MetaUpdateResult metaUpdateResult;
            PrintMetadata meta = OldPrintTemplateUtil.findOldPrintMetadata(this.tplId);
            try {
                metaUpdateResult = MetaUpdateTask.this.metaUpdate(this.tplId);
            }
            catch (Exception ex) {
                MetaUpdateResult metaUpdateResult2 = new MetaUpdateResult();
                metaUpdateResult2.setCompatibility(new BigDecimal(0));
                metaUpdateResult2.setTplId(meta.getId());
                metaUpdateResult2.setTplCode(meta.getRootAp().getKey());
                metaUpdateResult2.setTplName(meta.getRootAp().getName());
                metaUpdateResult2.setDifferenceAnalysis(ResManager.loadKDString((String)"\u6a21\u677f\u8f6c\u6362\u7cfb\u7edf\u9519\u8bef", (String)"MetaUpdateTask_1", (String)MetaUpdateTask.PROJECT_NAME, (Object[])new Object[0]));
                log.error((Throwable)ex);
                return metaUpdateResult2;
            }
            if (metaUpdateResult == null) {
                metaUpdateResult = new MetaUpdateResult();
                metaUpdateResult.setCompatibility(new BigDecimal(0));
                metaUpdateResult.setTplId(meta.getId());
                metaUpdateResult.setTplCode(meta.getRootAp().getKey());
                metaUpdateResult.setTplName(meta.getRootAp().getName());
                metaUpdateResult.setDifferenceAnalysis(ResManager.loadKDString((String)"\u6a21\u677f\u8f6c\u6362\u7cfb\u7edf\u9519\u8bef", (String)"MetaUpdateTask_1", (String)MetaUpdateTask.PROJECT_NAME, (Object[])new Object[0]));
            }
            return metaUpdateResult;
        }
    }
}

