/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.metedata.transformer.convert;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public final class ClassUtils {
    private static final Log log = LogFactory.getLog(ClassUtils.class);

    private ClassUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static List<Class> getAllInterfaceAchieveClass(Class clazz) {
        ArrayList<Class> list = new ArrayList<Class>();
        if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) {
            try {
                ArrayList<Class> allClass = ClassUtils.getAllClassByPath(clazz.getPackage().getName());
                for (int i = 0; i < allClass.size(); ++i) {
                    if (Modifier.isAbstract(allClass.get(i).getModifiers()) || !clazz.isAssignableFrom(allClass.get(i)) || clazz.equals(allClass.get(i))) continue;
                    list.add(allClass.get(i));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return list;
    }

    public static ArrayList<Class> getAllClassByPath(String packagename) {
        ArrayList<Class> list = new ArrayList<Class>();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String path = packagename.replace('.', '/');
        try {
            ArrayList<File> fileList = new ArrayList<File>();
            Enumeration<URL> enumeration = classLoader.getResources(path);
            while (enumeration.hasMoreElements()) {
                URL url = enumeration.nextElement();
                fileList.add(new File(url.getFile()));
            }
            for (int i = 0; i < fileList.size(); ++i) {
                list.addAll(ClassUtils.findClass((File)fileList.get(i), packagename));
            }
        }
        catch (IOException e) {
            log.warn((Throwable)e);
        }
        return list;
    }

    private static ArrayList<Class> findClass(File file, String packagename) {
        File[] files;
        ArrayList<Class> list = new ArrayList<Class>();
        if (!file.exists()) {
            return list;
        }
        for (File file2 : files = file.listFiles()) {
            if (file2.isDirectory()) {
                assert (!file2.getName().contains("."));
                ArrayList<Class> arrayList = ClassUtils.findClass(file2, packagename + "." + file2.getName());
                list.addAll(arrayList);
                continue;
            }
            if (!file2.getName().endsWith(".class")) continue;
            try {
                list.add(Class.forName(packagename + '.' + file2.getName().substring(0, file2.getName().length() - 6)));
            }
            catch (ClassNotFoundException e) {
                log.warn((Throwable)e);
            }
        }
        return list;
    }
}

