/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.metedata.transformer.convert;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.print.control.BaseControl;
import kd.bos.print.api.metedata.LocaleValue;
import kd.bos.print.api.metedata.control.prop.BorderProp;
import kd.bos.print.business.utils.PrintColorUtil;

public class ConversionUtils {
    private ConversionUtils() {
    }

    public static LocaleValue<String> getNameByLocaleString(LocaleString localeStringName) {
        LocaleValue localeValueName = new LocaleValue();
        try {
            for (Map.Entry key : localeStringName.entrySet()) {
                localeValueName.put((String)key.getKey(), key.getValue());
            }
        }
        catch (Exception ex) {
            return localeValueName;
        }
        return localeValueName;
    }

    public static Float getNumByLocaleString(LocaleString localeString) {
        String numStr = localeString.getLocaleValue();
        return ConversionUtils.getNumByString(numStr);
    }

    public static Float getNumByString(String numStr) {
        String[] nums = numStr.split("mm");
        String num = nums[0];
        try {
            return new Float(num);
        }
        catch (NumberFormatException e) {
            return Float.valueOf(0.0f);
        }
    }

    public static LocaleValue<Number> getLocaleNumByLocaleString(LocaleString localeString) {
        LocaleValue localeValueNum = new LocaleValue();
        for (Map.Entry key : localeString.entrySet()) {
            localeValueNum.put((String)key.getKey(), (Object)ConversionUtils.getNumByString((String)key.getValue()));
        }
        return localeValueNum;
    }

    public static final boolean isJSONValid(String jsonInString) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.readTree(jsonInString);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static LocaleValue<kd.bos.print.api.metedata.control.prop.Border> parseBorder(LocaleString localeString) {
        LocaleValue localeValueNum = new LocaleValue();
        for (Map.Entry key : localeString.entrySet()) {
            localeValueNum.put((String)key.getKey(), (Object)ConversionUtils.getNumByString((String)key.getValue()));
        }
        return new LocaleValue();
    }

    public static LocaleValue<kd.bos.print.api.metedata.control.prop.Border> parseStyel(Style style) {
        if (style == null) {
            return ConversionUtils.createBorder();
        }
        Border oldBorder = style.getBorder();
        kd.bos.print.api.metedata.control.prop.Border border = new kd.bos.print.api.metedata.control.prop.Border();
        BorderProp color = new BorderProp();
        BorderProp width = new BorderProp();
        BorderProp styles = new BorderProp();
        border.setColor(color);
        border.setWidth(width);
        border.setStyle(styles);
        try {
            ConversionUtils.pasreBorderString(border, oldBorder.getTop(), "top");
            ConversionUtils.pasreBorderString(border, oldBorder.getBottom(), "bottom");
            ConversionUtils.pasreBorderString(border, oldBorder.getLeft(), "left");
            ConversionUtils.pasreBorderString(border, oldBorder.getRight(), "right");
        }
        catch (Exception ex) {
            return ConversionUtils.createBorder();
        }
        return new LocaleValue((Object)border);
    }

    private static void pasreBorderString(kd.bos.print.api.metedata.control.prop.Border border, String value, String type) {
        if ("".equals(value)) {
            switch (type) {
                case "top": {
                    border.getStyle().setTop((Object)"solid");
                    border.getWidth().setTop((Object)0);
                    border.getColor().setTop((Object)"#212121");
                    break;
                }
                case "bottom": {
                    border.getStyle().setBottom((Object)"solid");
                    border.getWidth().setBottom((Object)0);
                    border.getColor().setBottom((Object)"#212121");
                    break;
                }
                case "left": {
                    border.getStyle().setLeft((Object)"solid");
                    border.getWidth().setLeft((Object)0);
                    border.getColor().setLeft((Object)"#212121");
                    break;
                }
                case "right": {
                    border.getStyle().setRight((Object)"solid");
                    border.getWidth().setRight((Object)0);
                    border.getColor().setRight((Object)"#212121");
                    break;
                }
            }
        } else {
            String[] configs = value.split("_");
            String color = configs[2];
            try {
                PrintColorUtil.stringToColor((String)color);
            }
            catch (Exception e) {
                color = "#212121";
            }
            border.getStyle().setInner((Object)"solid");
            border.getWidth().setInner((Object)ConversionUtils.conveterWidth(configs[0]));
            border.getColor().setInner((Object)color);
            switch (type) {
                case "top": {
                    border.getStyle().setTop((Object)configs[1]);
                    border.getWidth().setTop((Object)ConversionUtils.conveterWidth(configs[0]));
                    border.getColor().setTop((Object)color);
                    break;
                }
                case "bottom": {
                    border.getStyle().setBottom((Object)"solid");
                    border.getWidth().setBottom((Object)ConversionUtils.conveterWidth(configs[0]));
                    border.getColor().setBottom((Object)color);
                    break;
                }
                case "left": {
                    border.getStyle().setLeft((Object)"solid");
                    border.getWidth().setLeft((Object)ConversionUtils.conveterWidth(configs[0]));
                    border.getColor().setLeft((Object)color);
                    break;
                }
                case "right": {
                    border.getStyle().setRight((Object)"solid");
                    border.getWidth().setRight((Object)ConversionUtils.conveterWidth(configs[0]));
                    border.getColor().setRight((Object)color);
                    break;
                }
            }
        }
    }

    public static Number conveterWidth(String width) {
        Double num = Double.valueOf(width.replace("px", ""));
        num = num == 0.0 ? Double.valueOf(0.0) : (0.0 < num && num <= 1.0 ? Double.valueOf(0.5) : (num <= 2.0 ? Double.valueOf(1.0) : Double.valueOf(2.0)));
        return num;
    }

    public static LocaleValue<kd.bos.print.api.metedata.control.prop.Border> createBorder() {
        kd.bos.print.api.metedata.control.prop.Border border = new kd.bos.print.api.metedata.control.prop.Border();
        BorderProp color = new BorderProp();
        BorderProp width = new BorderProp();
        BorderProp style = new BorderProp();
        color.setBottom((Object)"#212121");
        color.setInner((Object)"#212121");
        color.setLeft((Object)"#212121");
        color.setRight((Object)"#212121");
        color.setTop((Object)"#212121");
        border.setColor(color);
        width.setBottom((Object)0);
        width.setInner((Object)0);
        width.setLeft((Object)0);
        width.setRight((Object)0);
        width.setTop((Object)0);
        border.setWidth(width);
        style.setBottom((Object)"solid");
        style.setInner((Object)"solid");
        style.setLeft((Object)"solid");
        style.setRight((Object)"solid");
        style.setTop((Object)"solid");
        border.setStyle(style);
        return new LocaleValue((Object)border);
    }

    public static void sortControls(List<BaseControl<?>> controls) {
        Collections.sort(controls, new Comparator<BaseControl>(){

            @Override
            public int compare(BaseControl o1, BaseControl o2) {
                int diff = o1.getIndex() - o2.getIndex();
                if (diff > 0) {
                    return 1;
                }
                if (diff < 0) {
                    return -1;
                }
                return 0;
            }
        });
    }

    public static String getExStack(Exception ex) {
        StackTraceElement[] ss = ex.getStackTrace();
        StackTraceElement stackTraceElement = ss[0];
        String json = JSONObject.toJSONString((Object)ss);
        json = ex.getMessage() + "::" + json;
        return json;
    }

    public static void setBindText(BaseControl targer) {
    }
}

