/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.metedata.transformer.convert;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.metadata.print.control.BaseControl;
import kd.bos.print.business.designer.datasource.DataSourceInfo;
import kd.bos.print.business.designer.datasource.DsType;
import kd.bos.print.business.metedata.transformer.convert.ConversionUtils;
import kd.bos.util.StringUtils;

public class DataSourceUtils {
    public static final Map<String, String> dsMapper = new HashMap<String, String>(4);

    public static String getFormatType(DataSourceInfo dataSourceInfo, BaseControl source) {
        if (ConversionUtils.isJSONValid(source.getDataSource())) {
            JSONObject jsonObject = JSON.parseObject((String)source.getDataSource());
            String ds = jsonObject.getString("key");
            String dsType = dsMapper.get(jsonObject.getString("type"));
            if (source.getBindField() != null && StringUtils.isNotEmpty((String)source.getBindField())) {
                if ("Main".equals(dsType)) {
                    Map map = DataSourceUtils.getMainDS(dataSourceInfo);
                    return DataSourceUtils.getFieldTextFormat(map, source);
                }
                if ("Entry".equals(dsType)) {
                    Map map = DataSourceUtils.getEntryDS(dataSourceInfo, ds);
                    return DataSourceUtils.getFieldTextFormat(map, source);
                }
                return null;
            }
        } else {
            Map map = DataSourceUtils.getMainDS(dataSourceInfo);
            if (map.get("Key").equals(source.getDataSource())) {
                return DataSourceUtils.getFieldTextFormat(map, source);
            }
            Map entryMap = DataSourceUtils.getEntryDS(dataSourceInfo, source.getDataSource());
            return DataSourceUtils.getFieldTextFormat(entryMap, source);
        }
        return null;
    }

    public static String getFieldTextFormat(Map map, BaseControl source) {
        Map field = DataSourceUtils.findField((List)map.get("Items"), source.getBindField());
        Map fieldMap = (Map)field.get("InitAttr");
        String TextFormat = (String)fieldMap.get("TextFormat");
        return TextFormat;
    }

    public static Map findField(List<Map> list, String field) {
        for (Map map : list) {
            if (!map.get("Key").equals(field)) continue;
            return map;
        }
        return Collections.emptyMap();
    }

    public static Map getMainDS(DataSourceInfo dataSourceInfo) {
        List list = dataSourceInfo.getDataSource();
        for (HashMap map : list) {
            DsType dsType;
            if (!(map.get("DsType") instanceof DsType) || !"Main".equals((dsType = (DsType)((Object)map.get("DsType"))).getCode())) continue;
            return map;
        }
        return Collections.emptyMap();
    }

    public static Map getEntryDS(DataSourceInfo dataSourceInfo, String entryKey) {
        Map mainMap = DataSourceUtils.getMainDS(dataSourceInfo);
        List items = (List)mainMap.get("Items");
        for (HashMap map : items) {
            if (!(map.get("DsType") instanceof DsType)) continue;
            DsType dsType = (DsType)((Object)map.get("DsType"));
            if (!map.get("Key").equals(entryKey) || !"Entry".equals(dsType.getCode())) continue;
            return map;
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u6570\u636e:%s\u6ca1\u6709\u627e\u5230", (String)"DataSourceUtils_0", (String)"bos-print-business", (Object[])new Object[0]), entryKey));
    }

    public static Map getEntryDS(DataSourceInfo dataSourceInfo, String entryKey, String entryType) {
        Map mainMap = DataSourceUtils.getMainDS(dataSourceInfo);
        List items = (List)mainMap.get("Items");
        for (HashMap map : items) {
            if (!(map.get("DsType") instanceof DsType)) continue;
            DsType dsType = (DsType)((Object)map.get("DsType"));
            if (!map.get("Key").equals(entryKey) || !entryType.equals(dsType.getCode())) continue;
            return map;
        }
        return null;
    }

    public static Map getWorkDS(DataSourceInfo dataSourceInfo) {
        Map mainMap = DataSourceUtils.getMainDS(dataSourceInfo);
        List items = (List)mainMap.get("Items");
        for (HashMap map : items) {
            String dsType;
            if (!(map.get("DsType") instanceof String) || !"Workflow".equals(dsType = (String)map.get("DsType"))) continue;
            List list = (List)map.get("Items");
            Map line = (Map)list.get(0);
            return line;
        }
        return null;
    }

    static {
        dsMapper.put("1", "Main");
        dsMapper.put("2", "Entry");
        dsMapper.put("3", "Subentry");
        dsMapper.put("9", "Ref");
    }
}

