/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.metedata.transformer.convert.support;

import java.util.HashMap;
import java.util.Map;
import kd.bos.metadata.print.control.Amount;
import kd.bos.print.api.metedata.control.Text;
import kd.bos.print.api.metedata.control.prop.UpperCase;
import kd.bos.print.business.metedata.transformer.convert.converter.ConvertResult;
import kd.bos.print.business.metedata.transformer.convert.support.TextConverter;

public class AmountToTextConverter<S extends Amount, T extends Text>
extends TextConverter<S, T> {
    @Override
    public Map<String, String> getConvertPairType() {
        HashMap<String, String> convertPair = new HashMap<String, String>(2);
        convertPair.put("sourceType", Amount.class.getName());
        convertPair.put("targetType", Text.class.getName());
        return convertPair;
    }

    @Override
    public ConvertResult<T> convert(S source) {
        ConvertResult<Text> convertResult = new ConvertResult<Text>();
        convertResult.setTarget(new Text());
        this.convert(source, convertResult);
        return convertResult;
    }

    @Override
    public ConvertResult<T> convert(S source, ConvertResult<T> convertResult) {
        Text target = (Text)convertResult.getTarget();
        super.convert(source, convertResult);
        this.setWriting(source, target);
        target.setTextFormat("Amount");
        return convertResult;
    }

    private void setWriting(S source, Text target) {
        if ("lowercase".equals(source.getLetterType())) {
            target.setUppercaseType(UpperCase.getNoUpper());
        } else {
            target.setUppercaseType(UpperCase.getZhUpper());
        }
        if (source.getSymbol().isEmpty()) {
            target.setCurrencyCode("-");
        } else {
            target.setCurrencyCode(source.getSymbol());
        }
        target.setPrecision(-1);
        target.setIgnoreTailZero(source.isIgnoreTailZero());
        target.setIgnoreZero(source.isIgnoreZero());
        target.setShowCurrencySymbol(source.isShowCySymbol());
        target.setShowCurrencyCode(source.isShowCyCode());
        if (source.isShowCyCode() || source.isShowCySymbol()) {
            target.setCurrencyCode("FROM_CURRENCY");
        }
    }
}

