/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.metedata.transformer.convert.support;

import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.print.control.BaseControl;
import kd.bos.print.api.metedata.LocaleValue;
import kd.bos.print.business.metedata.transformer.convert.ConversionException;
import kd.bos.print.business.metedata.transformer.convert.ConversionUtils;
import kd.bos.print.business.metedata.transformer.convert.converter.ConvertResult;
import kd.bos.print.business.metedata.transformer.convert.support.ControlConverter;
import kd.bos.util.StringUtils;

public abstract class BaseControlConverter<S extends BaseControl, T extends kd.bos.print.api.metedata.control.BaseControl>
extends ControlConverter<S, T> {
    protected ConvertResult<T> baseConvert(S source, ConvertResult<T> convertResult, Map ctx) {
        kd.bos.print.api.metedata.control.BaseControl target = (kd.bos.print.api.metedata.control.BaseControl)convertResult.getTarget();
        target.setHidden(source.isHidden());
        this.convertWidthHeight(source, target, ctx);
        target.setX(ConversionUtils.getLocaleNumByLocaleString(source.getX()));
        target.setY(ConversionUtils.getLocaleNumByLocaleString(source.getY()));
        target.setPrintAtPage("nature");
        if (source.getStyle() != null && this.checkWidth(source, convertResult)) {
            convertResult.addError(new ConversionException(source.toString(), ResManager.loadKDString((String)"\u8fb9\u6846\u8bbe\u7f6e\u3002", (String)"BaseControlConverter_0", (String)"bos-print-business", (Object[])new Object[0]), "manual", ResManager.loadKDString((String)"\u53ef\u8c03\u6574\u8fb9\u6846\u8bbe\u7f6e\u7684\u7ebf\u6761\u7c97\u7ec6", (String)"BaseControlConverter_1", (String)"bos-print-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8fb9\u6846\u8bbe\u7f6e\u8d85\u8fc7\u6700\u5927\u503c", (String)"BaseControlConverter_2", (String)"bos-print-business", (Object[])new Object[0]), 1));
        }
        return convertResult;
    }

    protected void convertWidthHeight(S source, kd.bos.print.api.metedata.control.BaseControl target, Map ctx) {
        if (target.getWidth() == null && source.getWidth() != null) {
            LocaleValue<Number> width = ConversionUtils.getLocaleNumByLocaleString(source.getWidth());
            target.setWidth(width);
        }
        if (target.getHeight() == null && source.getHeight() != null) {
            LocaleValue<Number> height = ConversionUtils.getLocaleNumByLocaleString(source.getHeight());
            target.setHeight(height);
        }
    }

    private boolean checkWidth(S source, ConvertResult<T> convertResult) {
        Border oldBorder = source.getStyle().getBorder();
        int i = 0;
        try {
            if (this.overMaxWidth(oldBorder.getTop())) {
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.overMaxWidth(oldBorder.getBottom())) {
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.overMaxWidth(oldBorder.getLeft())) {
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.overMaxWidth(oldBorder.getRight())) {
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return i > 0;
    }

    private boolean overMaxWidth(String value) {
        if (StringUtils.isNotEmpty((String)value)) {
            String[] configs = value.split("_");
            Double num = Double.valueOf(configs[0].replace("px", ""));
            return num > 2.0;
        }
        return false;
    }

    @Override
    public String getControlType() {
        return null;
    }
}

