/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.metedata.transformer.convert.support;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.metadata.print.control.BaseControl;
import kd.bos.metadata.print.control.DataGrid;
import kd.bos.metadata.print.control.Image;
import kd.bos.print.api.metedata.LocaleValue;
import kd.bos.print.api.metedata.control.BaseDsControl;
import kd.bos.print.api.metedata.control.Text;
import kd.bos.print.business.designer.datasource.DataSourceInfo;
import kd.bos.print.business.designer.datasource.DsType;
import kd.bos.print.business.metedata.transformer.convert.ConversionUtils;
import kd.bos.print.business.metedata.transformer.convert.ConvertConstants;
import kd.bos.print.business.metedata.transformer.convert.DataSourceUtils;
import kd.bos.print.business.metedata.transformer.convert.converter.ConvertResult;
import kd.bos.print.business.metedata.transformer.convert.support.BaseControlConverter;

public abstract class BaseDsControlConverter<S extends BaseControl, T extends BaseDsControl>
extends BaseControlConverter<S, T> {
    public static final Map<String, String> dsMapper = new HashMap<String, String>(4);
    private static final Map<String, String> sysDsMap = new HashMap<String, String>(7);

    private static String getSysFiled1() {
        return ResManager.loadKDString((String)"\u5f53\u524d\u9875\u7801", (String)"SystemDsBuilder_3", (String)"bos-print-business", (Object[])new Object[0]);
    }

    private static String getSysFiled2() {
        return ResManager.loadKDString((String)"\u603b\u9875\u7801", (String)"SystemDsBuilder_4", (String)"bos-print-business", (Object[])new Object[0]);
    }

    private static String getSysField3() {
        return ResManager.loadKDString((String)"\u9875\u7801\uff1a\u7b2cX/Y\u9875", (String)"SystemDsBuilder_5", (String)"bos-print-business", (Object[])new Object[0]);
    }

    private static String getSysField4() {
        return ResManager.loadKDString((String)"\u9875\u7801\uff1a\u7b2cX\u9875\uff0c\u5171Y\u9875", (String)"SystemDsBuilder_6", (String)"bos-print-business", (Object[])new Object[0]);
    }

    private static String getSysField5() {
        return ResManager.loadKDString((String)"\u6253\u5370\u65f6\u95f4", (String)"SystemDsBuilder_7", (String)"bos-print-business", (Object[])new Object[0]);
    }

    private static String getSysField6() {
        return ResManager.loadKDString((String)"\u6253\u5370\u4eba", (String)"SystemDsBuilder_8", (String)"bos-print-business", (Object[])new Object[0]);
    }

    private static String getSysField7() {
        return ResManager.loadKDString((String)"\u6570\u636e\u884c\u884c\u53f7", (String)"SystemDsBuilder_9", (String)"bos-print-business", (Object[])new Object[0]);
    }

    private static String getSysField8() {
        return ResManager.loadKDString((String)"=\"\u7b2c\" + getPageNumber() + \"/\" + getPageTotal() + \"\u9875\"", (String)"SystemDsBuilder_1", (String)"bos-print-business", (Object[])new Object[0]);
    }

    private static String getSysField9() {
        return ResManager.loadKDString((String)"=\"\u7b2c\" + getPageNumber() + \"\u9875\uff0c\u5171\" + getPageTotal() + \"\u9875\"", (String)"SystemDsBuilder_2", (String)"bos-print-business", (Object[])new Object[0]);
    }

    protected ConvertResult<T> dsConvert(S source, ConvertResult<T> convertResult, Map ctx) {
        BaseDsControl target = (BaseDsControl)convertResult.getTarget();
        if (source instanceof Image && ((BaseDsControl)convertResult.getTarget()).getBindField() != null) {
            target.setDataSource("");
            return convertResult;
        }
        if (source instanceof DataGrid) {
            DataSourceInfo dataSourceInfo = (DataSourceInfo)ctx.get("dataSourceInfo");
            List dlist = dataSourceInfo.getDataSource();
            Map mainDS = BaseDsControlConverter.find("DsType", "Main", dlist);
            if (source.getDataSource() != null) {
                if (ConversionUtils.isJSONValid(source.getDataSource())) {
                    JSONObject jsonObject = JSON.parseObject((String)source.getDataSource());
                    String ds = jsonObject.getString("key");
                    String dsType = dsMapper.get(jsonObject.getString("type"));
                    if ("Main".equals(dsType)) {
                        target.setDataSource(ds);
                    } else {
                        String mainds = (String)mainDS.get("Key");
                        ds = mainds + "." + jsonObject.getString("key");
                        target.setDataSource(ds);
                        Map entryMap = DataSourceUtils.getEntryDS(dataSourceInfo, jsonObject.getString("key"), dsType);
                        if (entryMap != null) {
                            String entryName = (String)entryMap.get("Name");
                            target.setBindText(new LocaleValue((Object)entryName));
                        }
                    }
                } else {
                    String ds = source.getDataSource();
                    target.setDataSource(ds);
                }
            } else if (source instanceof DataGrid) {
                throw new KDBizException("error datagrid datasource is null");
            }
        } else if (source.getDataSource() != null) {
            this.dsHandler(source, convertResult, ctx);
        } else {
            this.textHandler(source, convertResult, ctx);
        }
        return convertResult;
    }

    private Map findDsType(List<Map> items, String dsTyep) {
        Map dsTypeMap = null;
        try {
            for (Map map : items) {
                DsType dsType;
                Object source = map.get("DsType");
                if (!(source instanceof DsType) || !dsTyep.equals((dsType = (DsType)((Object)source)).getCode())) continue;
                dsTypeMap = map;
            }
        }
        catch (Exception ex) {
            return Collections.emptyMap();
        }
        return dsTypeMap;
    }

    private void getNewBindField(T target, String field, Map ctx) {
        Object mainValue;
        DataSourceInfo dataSourceInfo = (DataSourceInfo)ctx.get("dataSourceInfo");
        List dlist = dataSourceInfo.getDataSource();
        Map main = this.findDsType(dlist, "Main");
        if (main == null || (mainValue = main.get("Items")) == null) {
            return;
        }
        List items = (List)mainValue;
        Map map = BaseDsControlConverter.find("Key", field, items);
        target.setBindField(field);
        if (map == null) {
            target.setDsType(DsType.Entry.getCode());
        } else {
            target.setDsType(DsType.Main.getCode());
        }
    }

    private void dsHandler(S source, ConvertResult<T> convertResult, Map ctx) {
        BaseDsControl target = (BaseDsControl)convertResult.getTarget();
        String bindType = source.getBindType();
        if ("combination".equals(bindType)) {
            target.setBindText(new LocaleValue((Object)ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u7ec4\u5408", (String)"BaseDsControlConverter_0", (String)"bos-print-business", (Object[])new Object[0])));
            return;
        }
        if ("custom".equals(bindType)) {
            target.setBindText(new LocaleValue((Object)ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u81ea\u5b9a\u4e49", (String)"BaseDsControlConverter_1", (String)"bos-print-business", (Object[])new Object[0])));
            return;
        }
        if (ConversionUtils.isJSONValid(source.getDataSource())) {
            if ("field".equals(bindType) && source.getBindField() != null) {
                this.setDataSourceByJson(source, target, ctx);
            } else {
                this.dsConvertByText(source, target);
            }
        } else if (source.getBindField() != null) {
            target.setDsType("Main");
            String ds = source.getDataSource();
            this.setDsBindText(source, target, ctx);
            if ("workflow.approveline".equals(ds)) {
                DataSourceInfo dataSourceInfo = (DataSourceInfo)ctx.get("dataSourceInfo");
                Map map = DataSourceUtils.getWorkDS(dataSourceInfo);
                if (map == null) {
                    target.setBindText(new LocaleValue((Object)ResManager.loadKDString((String)"\u5de5\u4f5c\u6d41\u6ca1\u6709\u6570\u636e", (String)"BaseDsControlConverter_2", (String)"bos-print-business", (Object[])new Object[0])));
                } else {
                    List dlist = dataSourceInfo.getDataSource();
                    Map mainDS = null;
                    mainDS = BaseDsControlConverter.find("DsType", "Main", dlist);
                    target.setDsType("Approveline");
                    List list = (List)map.get("Items");
                    Map field = DataSourceUtils.findField(list, source.getBindField());
                    String mainds = (String)mainDS.get("Key");
                    String name = String.format(ResManager.loadKDString((String)"%1$s.\u5de5\u4f5c\u6d41.\u5ba1\u6279\u7ebf\u8def.%2$s", (String)"BaseDsControlConverter_5", (String)"bos-print-business", (Object[])new Object[0]), "=$" + mainDS.get("Name"), field.get("Name"));
                    target.setBindField(source.getBindField());
                    target.setDataSource(mainds + ".workflow.approveline");
                    target.setBindText(new LocaleValue((Object)name));
                }
            } else if (!source.getBindField().contains(".")) {
                this.getNewBindField(target, source.getBindField(), ctx);
            } else {
                target.setBindField(source.getBindField());
            }
        } else {
            this.dsConvertByText(source, target);
        }
    }

    private void textHandler(S source, ConvertResult<T> convertResult, Map ctx) {
        BaseDsControl target = (BaseDsControl)convertResult.getTarget();
        target.setBindText(ConversionUtils.getNameByLocaleString(Optional.ofNullable(source.getBindText()).orElse(ConvertConstants.LOCALE_STRING_BLANK)));
        this.dsConvertByText(source, target);
    }

    private void dsConvertBySysField(S source, T target, String viewText) {
        target.setDataSource("$DsKey=[System]");
        LocaleValue bindText = new LocaleValue((Object)String.format(ResManager.loadKDString((String)"=$\u7cfb\u7edf\u5b57\u6bb5.%s", (String)"BaseDsControlConverter_6", (String)"bos-print-business", (Object[])new Object[0]), viewText));
        target.setBindText(bindText);
        target.setDsType("Sys");
        String bindField = source.getBindText().getLocaleValue();
        if ("=getRowNumber(0)".equals(bindField)) {
            target.setBindField("=getRowNumber()");
        } else {
            target.setBindField(bindField);
        }
        if (target instanceof Text) {
            Text text = (Text)target;
            text.setViewText("=$" + viewText);
            if ("=now()".equals(bindField)) {
                text.setTextFormat("Date");
                text.setTimeFormat("-");
                text.setDateFormat("-");
            } else if ("=getUserName()".equals(bindField)) {
                text.setTextFormat("Text");
            } else {
                text.setTextFormat("Number");
                text.setPrecision(-1);
                text.setNegativeType("-");
            }
        }
    }

    private void setDataSourceByJson(S source, T target, Map ctx) {
        DataSourceInfo dataSourceInfo = (DataSourceInfo)ctx.get("dataSourceInfo");
        target.setBindField(source.getBindField());
        String bindText = "=$" + source.getName().getLocaleValue();
        target.setBindText(new LocaleValue((Object)bindText));
        JSONObject jsonObject = JSON.parseObject((String)source.getDataSource());
        String ds = jsonObject.getString("key");
        String dsType = dsMapper.get(jsonObject.getString("type"));
        List dlist = dataSourceInfo.getDataSource();
        Map mainDS = null;
        mainDS = BaseDsControlConverter.find("DsType", "Main", dlist);
        if (mainDS == null || mainDS.size() == 0) {
            mainDS = BaseDsControlConverter.find("DsType", "Report", dlist);
        }
        target.setDsType(dsType);
        target.setDataSource(ds);
        if ("Entry".equals(dsType) || "Subentry".equals(dsType)) {
            ds = this.getDS(ds, ctx);
            target.setDataSource(ds);
            Map entry = DataSourceUtils.getEntryDS(dataSourceInfo, jsonObject.getString("key"), dsType);
            String bindText1 = "=$" + mainDS.get("Name") + "." + entry.get("Name") + "." + source.getName().getLocaleValue();
            target.setBindText(new LocaleValue((Object)bindText1));
        } else if ("4".equals(jsonObject.getString("type"))) {
            Map mm = DataSourceUtils.getWorkDS(dataSourceInfo);
            if (mm == null) {
                target.setBindText(new LocaleValue((Object)ResManager.loadKDString((String)"\u672c\u6a21\u677f\u4e0d\u652f\u6301\u5de5\u4f5c\u6d41", (String)"BaseDsControlConverter_4", (String)"bos-print-business", (Object[])new Object[0])));
                target.setDataSource("");
                target.setBindField("");
            } else {
                String mainds = (String)mainDS.get("Key");
                target.setDataSource(mainds + ".workflow.approveline");
                target.setDsType("Approveline");
            }
        } else if ("Ref".equals(dsType)) {
            DataSourceInfo refDataSourceInfo = (DataSourceInfo)ctx.get("refDS" + ds);
            if (refDataSourceInfo != null) {
                target.setDataSource(ds);
                Map entryMap = DataSourceUtils.getMainDS(refDataSourceInfo);
                String entryName = (String)entryMap.get("Name");
                bindText = "=$" + entryName + "." + source.getName().getLocaleValue();
                target.setBindText(new LocaleValue((Object)bindText));
            } else {
                target.setBindField(null);
                target.setBindText(null);
                target.setDsType(null);
                target.setDataSource(null);
            }
        } else if ("Custom".equals(dsType)) {
            bindText = "=$" + jsonObject.get((Object)"name") + "." + source.getName().getLocaleValue();
            target.setBindText(new LocaleValue((Object)bindText));
        } else {
            bindText = "=$" + mainDS.get("Name") + "." + source.getName().getLocaleValue();
            target.setBindText(new LocaleValue((Object)bindText));
        }
    }

    private String getDS(String source, Map ctx) {
        String numberById = (String)ctx.get("dataBaseInfo");
        source = numberById + "." + source;
        return source;
    }

    private void dsConvertByText(S source, T target) {
        String viewText;
        target.setDsType("");
        target.setDataSource("");
        target.setBindField("");
        LocaleString bindText = Optional.ofNullable(source.getBindText()).orElse(ConvertConstants.LOCALE_STRING_BLANK);
        target.setBindText(ConversionUtils.getNameByLocaleString(bindText));
        if (source.getBindText() != null && (viewText = sysDsMap.get(source.getBindText().getLocaleValue())) != null) {
            this.dsConvertBySysField(source, target, viewText);
        }
    }

    private void setDsBindText(S source, T target, Map ctx) {
        DataSourceInfo dataSourceInfo = (DataSourceInfo)ctx.get("dataSourceInfo");
        List dlist = dataSourceInfo.getDataSource();
        Map mainDS = BaseDsControlConverter.find("DsType", "Main", dlist);
        String ds = source.getDataSource();
        String mainDsName = (String)mainDS.get("Name");
        StringBuilder fieldName = new StringBuilder("=$").append(mainDsName).append(".");
        if (ds.equals((String)mainDS.get("Key"))) {
            target.setDataSource(ds);
            target.setBindField(source.getBindField());
            if (!source.getBindField().contains(".")) {
                Map fmap = DataSourceUtils.findField((List)mainDS.get("Items"), source.getBindField());
                String fName = (String)fmap.get("Name");
                fieldName.append(fName);
            } else {
                fieldName.append(source.getName().toString());
            }
            target.setBindText(new LocaleValue((Object)fieldName.toString()));
            target.setDsType("Main");
        } else {
            String numberById = (String)ctx.get("dataBaseInfo");
            ds = numberById + "." + ds;
            target.setDataSource(ds);
            String entryName = null;
            Map entryMap = DataSourceUtils.getEntryDS(dataSourceInfo, source.getDataSource(), "Entry");
            if (entryMap == null) {
                entryMap = DataSourceUtils.getEntryDS(dataSourceInfo, source.getDataSource(), "Subentry");
                target.setDsType("Subentry");
                if (entryMap != null) {
                    entryName = (String)entryMap.get("Name");
                }
            } else {
                entryName = (String)entryMap.get("Name");
                target.setDsType("Entry");
            }
            if (entryMap != null) {
                fieldName.append(entryName).append(".");
                if (!source.getBindField().contains(".")) {
                    Map fmap = DataSourceUtils.findField((List)entryMap.get("Items"), source.getBindField());
                    String fName = (String)fmap.get("Name");
                    fieldName.append(fName);
                } else {
                    fieldName.append(source.getName().toString());
                }
                target.setBindText(new LocaleValue((Object)fieldName.toString()));
                target.setBindField(source.getBindField());
            }
        }
    }

    public static Map find(String k, String v, List<Map> items) {
        Optional<Map> item = items.stream().filter(s -> v.equals(s.get(k).toString())).findFirst();
        try {
            Map mm = item.get();
            return mm;
        }
        catch (Exception e) {
            return Collections.emptyMap();
        }
    }

    @Override
    public String getControlType() {
        return null;
    }

    static {
        dsMapper.put("1", "Main");
        dsMapper.put("2", "Entry");
        dsMapper.put("3", "Subentry");
        dsMapper.put("9", "Ref");
        dsMapper.put("5", "Custom");
        sysDsMap.put("=getPageNumber()", BaseDsControlConverter.getSysFiled1());
        sysDsMap.put("=getPageTotal()", BaseDsControlConverter.getSysFiled2());
        sysDsMap.put(BaseDsControlConverter.getSysField8(), BaseDsControlConverter.getSysField3());
        sysDsMap.put(BaseDsControlConverter.getSysField9(), BaseDsControlConverter.getSysField4());
        sysDsMap.put("=now()", BaseDsControlConverter.getSysField5());
        sysDsMap.put("=getUserName()", BaseDsControlConverter.getSysField6());
        sysDsMap.put("=getRowNumber(0)", BaseDsControlConverter.getSysField7());
    }
}

