/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.metedata.transformer.convert.support;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.entity.plugin.support.util.Assert;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.print.control.Amount;
import kd.bos.metadata.print.control.Barcode;
import kd.bos.metadata.print.control.BaseControl;
import kd.bos.metadata.print.control.DataCell;
import kd.bos.metadata.print.control.DataColumn;
import kd.bos.metadata.print.control.DataGrid;
import kd.bos.metadata.print.control.DataRow;
import kd.bos.metadata.print.control.Footer;
import kd.bos.metadata.print.control.Header;
import kd.bos.metadata.print.control.Image;
import kd.bos.metadata.print.control.Label;
import kd.bos.metadata.print.control.LayoutCell;
import kd.bos.metadata.print.control.LayoutColumn;
import kd.bos.metadata.print.control.LayoutGrid;
import kd.bos.metadata.print.control.LayoutRow;
import kd.bos.metadata.print.control.QRCode;
import kd.bos.metadata.print.control.Text;
import kd.bos.print.business.metedata.transformer.convert.ClassUtils;
import kd.bos.print.business.metedata.transformer.convert.converter.ConvertResult;
import kd.bos.print.business.metedata.transformer.convert.converter.GenericConverter;
import kd.bos.print.business.metedata.transformer.convert.support.AmountToTextConverter;
import kd.bos.print.business.metedata.transformer.convert.support.BarcodeConverter;
import kd.bos.print.business.metedata.transformer.convert.support.BaseControlConverter;
import kd.bos.print.business.metedata.transformer.convert.support.BaseDsControlConverter;
import kd.bos.print.business.metedata.transformer.convert.support.ConfigurableConversionService;
import kd.bos.print.business.metedata.transformer.convert.support.ControlConverter;
import kd.bos.print.business.metedata.transformer.convert.support.ImageConverter;
import kd.bos.print.business.metedata.transformer.convert.support.QRCodeConverter;
import kd.bos.print.business.metedata.transformer.convert.support.TextConverter;
import kd.bos.print.business.metedata.transformer.convert.support.container.DataColumnConverter;
import kd.bos.print.business.metedata.transformer.convert.support.container.DataGridCellConverter;
import kd.bos.print.business.metedata.transformer.convert.support.container.DataGridConverter;
import kd.bos.print.business.metedata.transformer.convert.support.container.DataRowConverter;
import kd.bos.print.business.metedata.transformer.convert.support.container.FooterConverter;
import kd.bos.print.business.metedata.transformer.convert.support.container.HeaderConverter;
import kd.bos.print.business.metedata.transformer.convert.support.container.LayoutColumnConverter;
import kd.bos.print.business.metedata.transformer.convert.support.container.LayoutGridCellConverter;
import kd.bos.print.business.metedata.transformer.convert.support.container.LayoutGridConverter;
import kd.bos.print.business.metedata.transformer.convert.support.container.LayoutGridRowConverter;
import kd.bos.print.business.metedata.transformer.convert.support.container.SubDataGridConverter;

public class GenericConversionService
implements ConfigurableConversionService {
    private final Map<String, GenericConverter> converterCache = new ConcurrentHashMap<String, GenericConverter>(32);
    private Map ctx;
    private static final Log log = LogFactory.getLog(GenericConversionService.class);

    public GenericConversionService() throws InstantiationException, IllegalAccessException {
        List<Class> classes = ClassUtils.getAllInterfaceAchieveClass(ControlConverter.class);
        this.addConverter(Footer.class.getName(), new FooterConverter());
        this.addConverter(Header.class.getName(), new HeaderConverter());
        this.addConverter(Text.class.getName(), new TextConverter());
        this.addConverter(QRCode.class.getName(), new QRCodeConverter());
        this.addConverter(Image.class.getName(), new ImageConverter());
        this.addConverter(Barcode.class.getName(), new BarcodeConverter());
        this.addConverter(Amount.class.getName(), new AmountToTextConverter());
        this.addConverter(DataColumn.class.getName(), new DataColumnConverter());
        this.addConverter(DataCell.class.getName(), new DataGridCellConverter());
        this.addConverter(DataGrid.class.getName(), new DataGridConverter());
        this.addConverter(DataRow.class.getName(), new DataRowConverter());
        this.addConverter(LayoutColumn.class.getName(), new LayoutColumnConverter());
        this.addConverter(LayoutCell.class.getName(), new LayoutGridCellConverter());
        this.addConverter(LayoutGrid.class.getName(), new LayoutGridConverter());
        this.addConverter(LayoutRow.class.getName(), new LayoutGridRowConverter());
        this.addConverter(Label.class.getName(), this.converterCache.get(Text.class.getName()));
    }

    @Override
    public boolean canConvert(Class<?> source, Class<?> target) {
        return false;
    }

    @Override
    public Object convert(Object source) {
        return this.convert(source, source.getClass());
    }

    @Override
    public Object convert(Object source, Map context) {
        this.ctx = context;
        return this.convert(source, source.getClass());
    }

    public Object convert(Object source, Class<?> sourceType) {
        if (sourceType == null) {
            Assert.isTrue((source == null ? 1 : 0) != 0, (String)"Source must be [null] if source type == [null]");
            return null;
        }
        if (source != null && !sourceType.isInstance(source)) {
            throw new IllegalArgumentException("Source to convert from must be an instance of [" + sourceType + "]; instead it was a [" + source.getClass().getName() + "]");
        }
        GenericConverter converter = this.getConverter(sourceType);
        if (converter == null) {
            return null;
        }
        return this.invokeConverter(converter, source);
    }

    public void addConverter(String key, GenericConverter converter) {
        this.converterCache.put(key, converter);
    }

    @Override
    public void addConverter(GenericConverter converter) {
        String key = converter.getConvertPairType().get("sourceType");
        this.addConverter(key, converter);
    }

    @Override
    public void removeConvertible(Class<?> var1, Class<?> var2) {
    }

    private ConvertResult invokeConverter(GenericConverter converter, Object source) {
        ConvertResult result = null;
        result = converter instanceof TextConverter || converter instanceof LayoutGridCellConverter || converter instanceof DataGridConverter || converter instanceof DataRowConverter || converter instanceof SubDataGridConverter ? converter.convert(source, this.ctx) : converter.convert(source);
        try {
            if (converter instanceof BaseControlConverter) {
                ((BaseControlConverter)converter).baseConvert((BaseControl)source, result, this.ctx);
            }
            if (converter instanceof ControlConverter) {
                ((ControlConverter)converter).ctConvert((BaseControl)source, result);
            }
            if (converter instanceof BaseDsControlConverter) {
                ((BaseDsControlConverter)converter).dsConvert((BaseControl)source, result, this.ctx);
            }
            return result;
        }
        catch (Throwable ex) {
            log.error(ex);
            return result;
        }
    }

    private String getKey(Class<?> sourceType) {
        return sourceType.getName();
    }

    protected GenericConverter getConverter(Class<?> sourceType) {
        String key = this.getKey(sourceType);
        GenericConverter converter = this.converterCache.get(key);
        return converter;
    }
}

