/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.metedata.transformer.convert.support;

import java.util.HashMap;
import java.util.Map;
import kd.bos.metadata.form.PrintFormAp;
import kd.bos.print.api.metedata.control.Paper;
import kd.bos.print.business.metedata.transformer.convert.ConversionUtils;
import kd.bos.print.business.metedata.transformer.convert.converter.ConvertResult;

public class PaperConverter {
    public Map<String, String> getConvertPairType() {
        HashMap<String, String> convertPair = new HashMap<String, String>(2);
        convertPair.put("sourceType", PrintFormAp.class.getName());
        convertPair.put("targetType", Paper.class.getName());
        return convertPair;
    }

    public ConvertResult convert(Object source) {
        PrintFormAp printFormAp = (PrintFormAp)source;
        Paper paper = new Paper();
        ConvertResult<Paper> convertResult = new ConvertResult<Paper>(paper);
        String ptype = printFormAp.getPaper();
        if ("iso-b4".equals(ptype)) {
            printFormAp.setPaper("B4");
        } else if ("iso-b5".equals(ptype)) {
            printFormAp.setPaper("B5");
        } else if ("iso-a5".equals(ptype)) {
            printFormAp.setPaper("A5");
        }
        if (this.isDefualtPaperType(printFormAp.getPaper())) {
            paper.setPaperType(printFormAp.getPaper());
        } else {
            paper.setPaperType("Custom");
        }
        paper.setType("Paper");
        paper.setId(printFormAp.getId());
        paper.setPaperDirection(printFormAp.getPaperDirection());
        paper.setName(ConversionUtils.getNameByLocaleString(printFormAp.getName()));
        paper.setHorizonEconomize(printFormAp.isHorEconomic());
        paper.setVerticalEconomize(printFormAp.isVerEconomic());
        this.setMarginAndWH(printFormAp, paper);
        return convertResult;
    }

    private boolean isDefualtPaperType(String paperType) {
        return "A3".equals(paperType) || "A4".equals(paperType) || "A5".equals(paperType) || "B4".equals(paperType) || "A5".equals(paperType);
    }

    public ConvertResult convert(Object source, ConvertResult convertResult) {
        return null;
    }

    private void setMarginAndWH(PrintFormAp printFormAp, Paper paper) {
        paper.setMarginBottom((Number)ConversionUtils.getNumByLocaleString(printFormAp.getMarginBottom()));
        paper.setMarginLeft((Number)ConversionUtils.getNumByLocaleString(printFormAp.getMarginLeft()));
        paper.setMarginRight((Number)ConversionUtils.getNumByLocaleString(printFormAp.getMarginRight()));
        paper.setMarginTop((Number)ConversionUtils.getNumByLocaleString(printFormAp.getMarginTop()));
        paper.setWidth((Number)ConversionUtils.getNumByLocaleString(printFormAp.getWidth()));
        paper.setHeight((Number)ConversionUtils.getNumByLocaleString(printFormAp.getHeight()));
    }
}

