/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.metedata.transformer.convert.support;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.print.control.BaseControl;
import kd.bos.metadata.print.control.BaseGrid;
import kd.bos.metadata.print.control.LayoutCell;
import kd.bos.metadata.print.control.Text;
import kd.bos.print.api.metedata.LocaleValue;
import kd.bos.print.api.metedata.control.prop.Padding;
import kd.bos.print.business.designer.datasource.DataSourceInfo;
import kd.bos.print.business.metedata.transformer.convert.ConversionUtils;
import kd.bos.print.business.metedata.transformer.convert.DataSourceUtils;
import kd.bos.print.business.metedata.transformer.convert.converter.ConvertResult;
import kd.bos.print.business.metedata.transformer.convert.support.BaseDsControlConverter;
import kd.bos.print.business.utils.PrintColorUtil;
import kd.bos.util.StringUtils;

public class TextConverter<S extends BaseControl, T extends kd.bos.print.api.metedata.control.Text>
extends BaseDsControlConverter<S, T> {
    protected Map map;
    private static final Log log = LogFactory.getLog(TextConverter.class);

    @Override
    public Map<String, String> getConvertPairType() {
        HashMap<String, String> convertPair = new HashMap<String, String>(2);
        convertPair.put("sourceType", Text.class.getName());
        convertPair.put("targetType", kd.bos.print.api.metedata.control.Text.class.getName());
        return convertPair;
    }

    @Override
    public ConvertResult<T> convert(S source) {
        return null;
    }

    @Override
    public ConvertResult<T> convert(S source, Map ctx) {
        ConvertResult<kd.bos.print.api.metedata.control.Text> convertResult = new ConvertResult<kd.bos.print.api.metedata.control.Text>();
        this.map = ctx;
        convertResult.setTarget(new kd.bos.print.api.metedata.control.Text());
        this.convert(source, convertResult);
        return convertResult;
    }

    @Override
    public ConvertResult<T> convert(S source, ConvertResult<T> convertResult) {
        kd.bos.print.api.metedata.control.Text target = (kd.bos.print.api.metedata.control.Text)convertResult.getTarget();
        String format = source.getFormat();
        if (format != null && StringUtils.isNotEmpty((String)format)) {
            this.setTextFormta(target, source);
        } else {
            this.getTextFormat(source, target);
        }
        this.setToolsSetting(target, (BaseControl)source);
        if (target.getTextFormat() == null) {
            target.setTextFormat("Text");
        }
        this.fixPid(source, (kd.bos.print.api.metedata.control.BaseControl)target, this.map);
        return convertResult;
    }

    @Override
    protected void convertWidthHeight(S source, kd.bos.print.api.metedata.control.BaseControl target, Map ctx) {
        Map obj = (Map)ctx.get("mapItems");
        String parentId = source.getParentId();
        BaseControl parentElement = (BaseControl)obj.get(parentId);
        boolean parentIsCell = parentElement instanceof LayoutCell;
        if (target.getWidth() == null && source.getWidth() != null) {
            BaseControl col = null;
            if (parentIsCell) {
                col = (BaseControl)obj.get(((LayoutCell)parentElement).getCol());
            }
            LocaleValue<Number> width = this.getNumberLocaleValue(source.getWidth(), col == null ? null : col.getWidth());
            target.setWidth(width);
        }
        if (target.getHeight() == null && source.getHeight() != null) {
            BaseControl row = null;
            if (parentIsCell) {
                row = (BaseControl)obj.get(((LayoutCell)parentElement).getRow());
            }
            LocaleValue<Number> height = this.getNumberLocaleValue(source.getHeight(), row == null ? null : row.getHeight());
            target.setHeight(height);
        }
    }

    private void fixPid(S source, kd.bos.print.api.metedata.control.BaseControl target, Map ctx) {
        String pid = source.getParentId();
        Map mapItems = (Map)ctx.get("mapItems");
        BaseControl pControl = (BaseControl)mapItems.get(pid);
        if (pControl instanceof BaseGrid) {
            source.setParentId((String)ctx.get("paperId"));
        }
    }

    private LocaleValue<Number> getNumberLocaleValue(LocaleString curLocale, LocaleString parentLocale) {
        LocaleValue<Number> curNumber = ConversionUtils.getLocaleNumByLocaleString(curLocale);
        if (parentLocale == null) {
            return curNumber;
        }
        LocaleValue<Number> parentNumber = ConversionUtils.getLocaleNumByLocaleString(parentLocale);
        for (Map.Entry entry : curNumber.entrySet()) {
            String key = (String)entry.getKey();
            Number number = (Number)entry.getValue();
            Number pNumber = (Number)parentNumber.get((Object)key);
            if (pNumber == null || !(pNumber.floatValue() < number.floatValue())) continue;
            curNumber.put(key, (Object)pNumber);
        }
        return curNumber;
    }

    private void getTextFormat(S source, kd.bos.print.api.metedata.control.Text target) {
        DataSourceInfo dataSourceInfo = (DataSourceInfo)this.map.get("dataSourceInfo");
        String textFormat = null;
        try {
            textFormat = DataSourceUtils.getFormatType(dataSourceInfo, source);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (textFormat != null) {
            if ("Number".equals(textFormat)) {
                target.setTextFormat("Number");
                target.setPrecision(-1);
                target.setNegativeType("-");
            }
        } else {
            target.setTextFormat("Text");
        }
    }

    private void setToolsSetting(kd.bos.print.api.metedata.control.Text target, BaseControl source) {
        target.setViewText("");
        this.setFontSetting(target, source);
        this.setStyleSetting(target, source);
        target.setHorAlignment(new LocaleValue((Object)source.getHorAlignment()));
        target.setVerAlignment(new LocaleValue((Object)source.getVerAlignment()));
        if (source instanceof Text) {
            Text text = (Text)source;
            target.setDivideModel(text.isDivideModel());
            target.setDivideCharNums(text.getDivideCharNums());
            target.setShowDivideLine(text.isShowDivideLine());
        } else if (source instanceof LayoutCell) {
            LayoutCell text = (LayoutCell)source;
            target.setDivideModel(text.isDivideModel());
            target.setDivideCharNums(text.getDivideCharNums());
            target.setShowDivideLine(text.isShowDivideLine());
        }
        this.setTextOverFlow(target, source);
    }

    private void setTextFormta(kd.bos.print.api.metedata.control.Text target, S source) {
        if (ConversionUtils.isJSONValid(source.getFormat())) {
            JSONObject jsonObject;
            try {
                jsonObject = JSON.parseObject((String)source.getFormat());
            }
            catch (JSONException e) {
                return;
            }
            String alias = jsonObject.getString("alias");
            if ("\u65e5\u671f".equals(alias)) {
                target.setTextFormat("Date");
                target.setDateFormat(jsonObject.getString("value"));
            } else if ("\u6570\u503c".equals(alias)) {
                try {
                    this.setNumberFormat(target, jsonObject.getString("value"));
                }
                catch (Exception ex) {
                    ex.getMessage();
                }
            } else if ("\u65f6\u95f4".equals(alias)) {
                target.setTextFormat("Time");
                target.setTimeFormat(jsonObject.getString("value"));
            } else {
                this.getTextFormat(source, target);
            }
        } else if (source.getFormat().contains("0.00")) {
            try {
                this.setNumberFormat(target, source.getFormat());
            }
            catch (Exception exception) {}
        } else {
            this.getTextFormat(source, target);
        }
    }

    private void setNumberFormat(kd.bos.print.api.metedata.control.Text target, String numFormat) {
        String zeroNum = numFormat.substring(numFormat.indexOf("0."), numFormat.indexOf(";"));
        int precision = zeroNum.length() - 2;
        target.setPrecision(precision);
        if (numFormat.contains("(") && numFormat.contains(")")) {
            target.setNegativeType("(,)");
        } else {
            target.setNegativeType("-");
        }
        if (numFormat.contains("#.##")) {
            target.setThousandSplit(true);
        } else {
            target.setThousandSplit(false);
        }
        if (numFormat.contains("^")) {
            target.setIgnoreTailZero(true);
        } else {
            target.setIgnoreTailZero(false);
        }
        target.setTextFormat("Number");
    }

    private void setTextOverFlow(kd.bos.print.api.metedata.control.Text target, BaseControl source) {
        if ("WrapLine".equals(source.getScript())) {
            target.setTextOverFlow("WrapLine");
        } else if (source.isShrink()) {
            target.setTextOverFlow("ShrinkWrap");
        } else {
            target.setTextOverFlow("Truncate");
        }
    }

    private void setStyleSetting(kd.bos.print.api.metedata.control.Text target, BaseControl source) {
        target.setBorder(ConversionUtils.parseStyel(source.getStyle()));
        target.setPadding(new LocaleValue((Object)this.creatDefualtPadding(2)));
    }

    private Padding creatDefualtPadding(Number number) {
        Padding padding = new Padding();
        padding.setTop(number);
        padding.setBottom(number);
        padding.setLeft(number);
        padding.setRight(number);
        return padding;
    }

    private String createDefalutColoer() {
        return "#212121";
    }

    private String createBackColor() {
        return "";
    }

    private void setFontSetting(kd.bos.print.api.metedata.control.Text target, BaseControl source) {
        try {
            target.setFontName(ConversionUtils.getNameByLocaleString(source.getFontName()));
            target.setFontSizeF(new LocaleValue((Object)Float.valueOf(new BigDecimal(source.getFontSize()).floatValue())));
            String foreColor = Optional.ofNullable(source.getForeColor()).orElseGet(() -> this.createDefalutColoer());
            try {
                PrintColorUtil.stringToColor((String)foreColor);
            }
            catch (Exception e) {
                foreColor = "#212121";
            }
            target.setForeColor(new LocaleValue((Object)foreColor));
        }
        catch (Exception ex) {
            log.warn((Throwable)ex);
        }
        String backColor = Optional.ofNullable(source.getBackColor()).orElseGet(() -> this.createBackColor());
        try {
            PrintColorUtil.stringToColor((String)backColor);
        }
        catch (Exception e) {
            backColor = "#FFFFFF";
        }
        target.setBackColor(new LocaleValue((Object)backColor));
        target.setBold(new LocaleValue((Object)source.isBold()));
        target.setItalic(new LocaleValue((Object)source.isItalic()));
        target.setUnderLine(new LocaleValue((Object)source.isUnderLine()));
    }

    @Override
    public String getControlType() {
        return "Text";
    }
}

