/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.metedata.transformer.convert.support.container;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.metadata.print.control.Amount;
import kd.bos.metadata.print.control.BaseControl;
import kd.bos.metadata.print.control.DataCell;
import kd.bos.metadata.print.control.DataRow;
import kd.bos.print.api.metedata.control.grid.datagrid.DataGridCell;
import kd.bos.print.api.metedata.control.prop.UpperCase;
import kd.bos.print.business.metedata.transformer.convert.ConversionException;
import kd.bos.print.business.metedata.transformer.convert.ConversionUtils;
import kd.bos.print.business.metedata.transformer.convert.converter.ConvertResult;
import kd.bos.print.business.metedata.transformer.convert.support.container.LayoutGridCellConverter;

public class DataGridCellConverter<S extends DataCell, T extends DataGridCell>
extends LayoutGridCellConverter<S, T> {
    @Override
    public Map<String, String> getConvertPairType() {
        HashMap<String, String> convertPair = new HashMap<String, String>(2);
        convertPair.put("sourceType", DataCell.class.getName());
        convertPair.put("targetType", DataGridCell.class.getName());
        return convertPair;
    }

    @Override
    public ConvertResult<T> convert(S source, Map ctx) {
        Map mapKeyItems = (Map)ctx.get("mapItems");
        ConvertResult<DataGridCell> convertResult = new ConvertResult<DataGridCell>();
        convertResult.setTarget(new DataGridCell());
        DataGridCell target = (DataGridCell)convertResult.getTarget();
        super.convert(source, convertResult, ctx);
        if (!source.getPreScript().isEmpty() && ConversionUtils.isJSONValid(source.getPreScript())) {
            Amount amount = (Amount)JSONObject.parseObject((String)source.getPreScript(), Amount.class);
            this.setWriting(amount, target);
        }
        if (this.isInDetailRow(source, mapKeyItems)) {
            this.dataRowCellHandler(source, mapKeyItems, convertResult);
        } else {
            this.normalRowCellHandler(source, mapKeyItems, convertResult);
        }
        if (source.isSumAfterFormat()) {
            // empty if block
        }
        return convertResult;
    }

    private boolean isInDetailRow(S source, Map<String, BaseControl<?>> mapKeyItems) {
        DataRow dataRow = (DataRow)mapKeyItems.get(source.getParentId());
        return "detail".equalsIgnoreCase(dataRow.getRowType());
    }

    private void normalRowCellHandler(S source, Map<String, BaseControl<?>> mapKeyItems, ConvertResult<T> convertResult) {
        DataGridCell target = (DataGridCell)convertResult.getTarget();
        if ("stat".equals(source.getCellType())) {
            target.setCellType("Statistic");
            this.setStatType(source, convertResult);
        } else {
            target.setCellType("Normal");
            target.setStatType("noStat");
        }
    }

    private void dataRowCellHandler(S source, Map<String, BaseControl<?>> mapKeyItems, ConvertResult<T> convertResult) {
        DataGridCell target = (DataGridCell)convertResult.getTarget();
        target.setCellType("Detail");
        target.setStatType("noStat");
        if ("field".equals(source.getCellType())) {
            String string = "=$" + source.getName().getLocaleValue();
        } else if ("stat".equals(source.getCellType())) {
            convertResult.addError(new ConversionException(source.toString(), ResManager.loadKDString((String)"\u683c\u5f0f\u5f02\u5e38", (String)"DataGridCellConverter_0", (String)"bos-print-business", (Object[])new Object[0]), "error", ResManager.loadKDString((String)"\u65e0", (String)"DataGridCellConverter_1", (String)"bos-print-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6570\u636e\u884c\u4e0d\u5141\u8bb8\u6709\u7edf\u8ba1\u6570\u636e\u4fe1\u606f", (String)"DataGridCellConverter_2", (String)"bos-print-business", (Object[])new Object[0]), 10));
        }
    }

    private void setWriting(Amount source, T target) {
        if ("lowercase".equals(source.getLetterType())) {
            target.setUppercaseType(UpperCase.getNoUpper());
        } else {
            target.setUppercaseType(UpperCase.getZhUpper());
        }
        if (source.getSymbol().isEmpty()) {
            target.setCurrencyCode("-");
        } else {
            target.setCurrencyCode(source.getSymbol());
        }
        target.setPrecision(-1);
        target.setIgnoreTailZero(source.isIgnoreTailZero());
        target.setIgnoreZero(source.isIgnoreZero());
        target.setShowCurrencySymbol(source.isShowCySymbol());
        target.setShowCurrencyCode(source.isShowCyCode());
        if (source.isShowCyCode() || source.isShowCySymbol()) {
            target.setCurrencyCode("FROM_CURRENCY");
        }
        target.setTextFormat("Amount");
    }

    private void setStatType(S source, ConvertResult<T> convertResult) {
        DataGridCell target = (DataGridCell)convertResult.getTarget();
        String statType = source.getStatType();
        String statRange = source.getStatRange();
        if (statType.isEmpty()) {
            statType = "sum";
        }
        if ("sum".equals(statType)) {
            if ("group".equals(statRange)) {
                target.setStatType("groupSum");
            } else if ("cumulation".equals(statRange)) {
                target.setStatType("sum");
            } else if ("area".equals(statRange)) {
                target.setStatType("pageSum");
            } else {
                target.setStatType("noStat");
            }
        } else {
            target.setStatType("noStat");
            if (!statType.isEmpty()) {
                convertResult.addError(new ConversionException(source.toString(), ResManager.loadKDString((String)"\u7edf\u8ba1\u65b9\u5f0f\u4e0d\u652f\u6301", (String)"DataGridCellConverter_3", (String)"bos-print-business", (Object[])new Object[0]), "error", ResManager.loadKDString((String)"\u4e0d\u53ef\u8c03\u6574", (String)"DataGridCellConverter_4", (String)"bos-print-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7edf\u8ba1\u65b9\u5f0f\u6682\u4e0d\u652f\u6301", (String)"DataGridCellConverter_5", (String)"bos-print-business", (Object[])new Object[0]), 10));
            }
        }
    }

    @Override
    public String getControlType() {
        return "DataCell";
    }
}

