/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.business.metedata.transformer.convert.support.container;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.print.control.BaseControl;
import kd.bos.metadata.print.control.BaseGrid;
import kd.bos.metadata.print.control.DataRow;
import kd.bos.print.api.metedata.LocaleValue;
import kd.bos.print.api.metedata.control.grid.datagrid.DataGrid;
import kd.bos.print.api.metedata.control.prop.Border;
import kd.bos.print.business.designer.datasource.DataSourceInfo;
import kd.bos.print.business.metedata.transformer.convert.ConversionUtils;
import kd.bos.print.business.metedata.transformer.convert.DataSourceUtils;
import kd.bos.print.business.metedata.transformer.convert.converter.ConvertResult;
import kd.bos.print.business.metedata.transformer.convert.support.BaseDsControlConverter;
import kd.bos.print.business.metedata.transformer.convert.support.container.LayoutGridConverter;

public class DataGridConverter<S extends BaseGrid, T extends DataGrid>
extends LayoutGridConverter<S, T> {
    private static final Log log = LogFactory.getLog(DataGridConverter.class);
    public static final Map<String, String> dsMappers = new HashMap<String, String>(4);

    @Override
    public Map<String, String> getConvertPairType() {
        HashMap<String, String> convertPair = new HashMap<String, String>(2);
        convertPair.put("sourceType", kd.bos.metadata.print.control.DataGrid.class.getName());
        convertPair.put("targetType", DataGrid.class.getName());
        return convertPair;
    }

    @Override
    public String getControlType() {
        return "DataGrid";
    }

    @Override
    public ConvertResult<T> convert(S source, Map ctx) {
        ConvertResult<DataGrid> convertResult = new ConvertResult<DataGrid>();
        convertResult.setTarget(new DataGrid());
        this.convert(source, convertResult, ctx);
        return convertResult;
    }

    public ConvertResult<T> convert(S source, ConvertResult<T> convertResult, Map ctx) {
        super.convert(source, convertResult);
        boolean hasStatRow = (Boolean)ctx.get("hasStatRow" + source.getKey());
        DataGrid target = (DataGrid)convertResult.getTarget();
        if (!hasStatRow) {
            LocaleValue borderLocaleValue = target.getBorder();
            Border border = (Border)borderLocaleValue.getLocaleValue();
            border.getWidth().setBottom((Object)0.5);
        }
        this.setDataConfig(source, target);
        try {
            this.setDataSource(source, target, ctx);
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
        }
        this.setAutoAdjustHeight(source, target);
        return convertResult;
    }

    private void setDataSource(S source, DataGrid target, Map ctx) {
        DataSourceInfo dataSourceInfo = (DataSourceInfo)ctx.get("dataSourceInfo");
        List dlist = dataSourceInfo.getDataSource();
        Map mainDS = BaseDsControlConverter.find("DsType", "Main", dlist);
        if (source.getDataSource() != null) {
            if (ConversionUtils.isJSONValid(source.getDataSource())) {
                JSONObject jsonObject = JSON.parseObject((String)source.getDataSource());
                String ds = jsonObject.getString("key");
                String dsType = dsMappers.get(jsonObject.getString("type"));
                if ("Main".equals(dsType)) {
                    target.setDataSource(ds);
                } else if ("Ref".equals(dsType)) {
                    DataSourceInfo refDataSourceInfo = (DataSourceInfo)ctx.get("refDS" + ds);
                    target.setDataSource(ds);
                    Map entryMap = DataSourceUtils.getMainDS(refDataSourceInfo);
                    String entryName = (String)entryMap.get("Name");
                    target.setDataSourceText(entryName);
                } else if ("Custom".equals(dsType)) {
                    target.setDataSource(ds);
                    target.setDataSourceText(jsonObject.getString("name"));
                } else {
                    String mainds = (String)mainDS.get("Key");
                    ds = mainds + "." + jsonObject.getString("key");
                    target.setDataSource(ds);
                    Map entryMap = DataSourceUtils.getEntryDS(dataSourceInfo, jsonObject.getString("key"), dsType);
                    if (entryMap != null) {
                        String entryName = (String)entryMap.get("Name");
                        target.setDataSourceText(entryName);
                    }
                }
            } else {
                String ds = source.getDataSource();
                String numberById = (String)ctx.get("dataBaseInfo");
                ds = numberById + "." + ds;
                String mainDsName = (String)mainDS.get("Name");
                Map entryMap = DataSourceUtils.getEntryDS(dataSourceInfo, source.getDataSource(), "Entry");
                if (entryMap == null) {
                    entryMap = DataSourceUtils.getEntryDS(dataSourceInfo, source.getDataSource(), "Subentry");
                }
                if (entryMap != null) {
                    String entryName = (String)entryMap.get("Name");
                    target.setDataSourceText(entryName);
                } else if ("workflow.approveline".equals(source.getDataSource())) {
                    target.setDataSourceText(String.format(ResManager.loadKDString((String)"%s.\u5de5\u4f5c\u6d41.\u5ba1\u6279\u8def\u7ebf", (String)"DataGridConverter_0", (String)"bos-print-business", (Object[])new Object[0]), mainDsName));
                }
                target.setDataSource(ds);
            }
        } else if (source instanceof kd.bos.metadata.print.control.DataGrid) {
            throw new KDBizException("error datagrid datasource is null");
        }
    }

    private void setAutoAdjustHeight(S source, DataGrid target) {
        List baseControls = source.get();
        boolean normalRowEveryPage = false;
        for (BaseControl baseControl : baseControls) {
            if (!(baseControl instanceof DataRow)) continue;
            DataRow dataRow = (DataRow)baseControl;
            if (dataRow.isNotBlankRow()) {
                target.setNotBlankRow(true);
            }
            if ("detail".equals(dataRow.getRowType())) {
                target.setAutoAdjustHeight(dataRow.isAutoAdjustHeight());
                continue;
            }
            if (!"Normal".equals(dataRow.getRowType()) || !dataRow.isDisplayEveryPage()) continue;
            normalRowEveryPage = true;
        }
        target.setNormalRowEveryPage(normalRowEveryPage);
    }

    private void setDataConfig(S source, DataGrid target) {
        List controls = source.get();
        for (BaseControl baseControl : controls) {
            if (!(baseControl instanceof DataRow) || !"Detail".equals(((DataRow)baseControl).getRowType())) continue;
            DataRow dataRow = (DataRow)baseControl;
            target.setNotBlankRow(dataRow.isNotBlankRow());
            if (!"template".equals(dataRow.getPrintType())) continue;
            target.setFixedRowAtPage(true);
            target.setFixedRowCount(dataRow.getRepeatTimes());
        }
    }

    static {
        dsMappers.put("1", "Main");
        dsMappers.put("2", "Entry");
        dsMappers.put("3", "Subentry");
        dsMappers.put("9", "Ref");
        dsMappers.put("5", "Custom");
    }
}

